/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing_Poincare;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Duffing_Poincare.Duffing_PoincareSimulation;
import users.ehu.jma.chaos.Duffing_Poincare.Duffing_PoincareView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duffing_Poincare
extends AbstractModel {
    public Duffing_PoincareSimulation _simulation = null;
    public Duffing_PoincareView _view = null;
    public Duffing_Poincare _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double phase = 0.0;
    public double gamma = 0.1;
    public double f = 0.3;
    public double Pi2;
    public double dt = this.Pi2 = Math.PI * 2;
    public double x0 = 1.0;
    public double v0 = 0.0;
    public double tol = 1.0E-5;
    public double x10 = -1.5;
    public double y10 = -1.0;
    public double x20 = 1.5;
    public double y20 = 1.0;
    public double x1 = this.x10;
    public double y1 = this.y10;
    public double x2 = this.x20;
    public double y2 = this.y20;
    public boolean transitory = false;
    public int skip = 10;
    public double phase0 = 0.0;
    public double phaseDegrees = 0.0;
    public boolean selecting = false;
    public boolean first = true;
    public double mx = 0.0;
    public double my = 0.0;
    public double mx1 = 0.0;
    public double my1 = 0.0;
    public double mx2 = 0.0;
    public double my2 = 0.0;
    public double wx1 = 0.0;
    public double wy1 = 0.0;
    public double wx2 = 0.0;
    public double wy2 = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Duffing_Poincare.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Duffing_Poincare duffing_Poincare = new Duffing_Poincare(stringArray);
    }

    public Duffing_Poincare() {
        this(null, null, null, null, null, false);
    }

    public Duffing_Poincare(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Duffing_Poincare(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Duffing_PoincareSimulation(this, string, frame, uRL, bl);
        this._view = (Duffing_PoincareView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.phase = 0.0;
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this.dt = this.phase0 = Math.toRadians(this.phaseDegrees);
        this._view.resetTraces();
        this.selecting = false;
        this.transitory = true;
        this._resetSolvers();
    }

    public void _initialization2() {
        this._view.getElement("Gamma").setProperty("format", "\u03b3 = 0.###");
        this._view.getElement("Phase0").setProperty("format", "\u03c6 = 0.###");
    }

    public void _evolution2() {
        if (this.transitory && this.t >= (double)this.skip * this.Pi2) {
            this.transitory = false;
            this.clear();
        }
        this.phase = this.phase0;
        this.dt = this.Pi2;
        this._resetSolvers();
    }

    public void clear() {
        this._view.getElement("Points").reset();
    }

    public void full_size() {
        this.x1 = this.x10;
        this.y1 = this.y10;
        this.x2 = this.x20;
        this.y2 = this.y20;
        this.clear();
    }

    public void startCapture() {
        this.first = true;
        this.selecting = true;
    }

    public void mouseMove() {
        if (this.selecting) {
            if (this.first) {
                this.mx2 = this.mx1 = this.mx;
                this.wx2 = this.mx1;
                this.wx1 = this.mx1;
                this.my2 = this.my1 = this.my;
                this.wy2 = this.my1;
                this.wy1 = this.my1;
                this.first = false;
            } else {
                this.mx2 = this.mx;
                this.my2 = this.my;
                this.wx1 = this.mx1 < this.mx2 ? this.mx1 : this.mx2;
                this.wx2 = this.mx1 < this.mx2 ? this.mx2 : this.mx1;
                this.wy1 = this.my1 < this.my2 ? this.my1 : this.my2;
                this.wy2 = this.my1 < this.my2 ? this.my2 : this.my1;
            }
        }
    }

    public void endCapture() {
        if (!this.selecting) {
            return;
        }
        this.selecting = false;
        if (this.mx1 == this.mx2 || this.my1 == this.my2) {
            return;
        }
        this.x1 = this.wx1;
        this.x2 = this.wx2;
        this.y1 = this.wy1;
        this.y2 = this.wy2;
        this.clear();
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Gamma_editable() {
        return this._isPaused();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Force_editable() {
        return this._isPaused();
    }

    public void _method_for_Force_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Phase0_editable() {
        return this._isPaused();
    }

    public void _method_for_Phase0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Skip_editable() {
        return this._isPaused();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.clear();
        this._simulation.enableLoop();
    }

    public boolean _method_for_FullSize_enabled() {
        return this.x1 != this.x10 || this.x2 != this.x20 || this.y1 != this.y10 || this.y2 != this.y20;
    }

    public void _method_for_FullSize_action() {
        this._simulation.disableLoop();
        this.full_size();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_pressaction() {
        this._simulation.disableLoop();
        this.startCapture();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_dragaction() {
        this._simulation.disableLoop();
        this.mouseMove();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_action() {
        this._simulation.disableLoop();
        this.endCapture();
        this._simulation.enableLoop();
    }

    public double _method_for_Window_sizex() {
        return this.wx2 - this.wx1;
    }

    public double _method_for_Window_sizey() {
        return this.wy2 - this.wy1;
    }

    public boolean _method_for_Window_visible() {
        return this.selecting && !this.first && (this.wx1 != this.wx2 || this.wy1 != this.wy2);
    }

    public boolean _method_for_Transitory_visible() {
        return this.transitory && this._isPlaying();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.phase = 0.0;
        this.gamma = 0.1;
        this.f = 0.3;
        this.dt = this.Pi2 = Math.PI * 2;
        this.x0 = 1.0;
        this.v0 = 0.0;
        this.tol = 1.0E-5;
        this.x10 = -1.5;
        this.y10 = -1.0;
        this.x20 = 1.5;
        this.y20 = 1.0;
        this.x1 = this.x10;
        this.y1 = this.y10;
        this.x2 = this.x20;
        this.y2 = this.y20;
        this.transitory = false;
        this.skip = 10;
        this.phase0 = 0.0;
        this.phaseDegrees = 0.0;
        this.selecting = false;
        this.first = true;
        this.mx = 0.0;
        this.my = 0.0;
        this.mx1 = 0.0;
        this.my1 = 0.0;
        this.mx2 = 0.0;
        this.my2 = 0.0;
        this.wx1 = 0.0;
        this.wy1 = 0.0;
        this.wx2 = 0.0;
        this.wy2 = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._initialization2();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _phase;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Duffing_Poincare.this.x;
            this.__state[n++] = Duffing_Poincare.this.v;
            this.__state[n++] = Duffing_Poincare.this.phase;
            this.__state[n++] = Duffing_Poincare.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(Duffing_Poincare.this.dt);
        }

        void step() {
            if (Duffing_Poincare.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Duffing_Poincare.this.tol);
            }
            if (Duffing_Poincare.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Duffing_Poincare.this.dt);
            }
            int n = 0;
            this.__state[n++] = Duffing_Poincare.this.x;
            this.__state[n++] = Duffing_Poincare.this.v;
            this.__state[n++] = Duffing_Poincare.this.phase;
            this.__state[n++] = Duffing_Poincare.this.t;
            this.__solver.step();
            n = 0;
            Duffing_Poincare.this.x = this.__state[n++];
            Duffing_Poincare.this.v = this.__state[n++];
            Duffing_Poincare.this.phase = this.__state[n++];
            Duffing_Poincare.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._phase = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._v, this._phase, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return -2.0 * Duffing_Poincare.this.gamma * d2 + d * (1.0 - d * d) + Duffing_Poincare.this.f * Math.cos(d3);
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return 1.0;
        }
    }
}

