/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing_Baker;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display2d.DataRaster;
import org.opensourcephysics.numerics.Dopri853;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Duffing_Baker.Duffing_BakerSimulation;
import users.ehu.jma.chaos.Duffing_Baker.Duffing_BakerView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duffing_Baker
extends AbstractModel {
    public Duffing_BakerSimulation _simulation = null;
    public Duffing_BakerView _view = null;
    public Duffing_Baker _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double phase = 0.0;
    public double gamma = 0.1;
    public double f = 0.3;
    public double Pi2;
    public double dt = this.Pi2 = Math.PI * 2;
    public int skip = 10;
    public double x0 = 1.0;
    public double v0 = 0.0;
    public double tol = 1.0E-5;
    public double x1 = -1.75;
    public double y1 = -1.25;
    public double cx = 3.5;
    public double cy = 2.5;
    public boolean transitory = false;
    public double phase0 = 0.0;
    public double phaseDegrees = 0.0;
    public int N = 3;
    public int N2 = 0;
    public int n = 0;
    public boolean colors = true;
    public int nColor = 0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Duffing_Baker.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Duffing_Baker duffing_Baker = new Duffing_Baker(stringArray);
    }

    public Duffing_Baker() {
        this(null, null, null, null, null, false);
    }

    public Duffing_Baker(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Duffing_Baker(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new Duffing_BakerSimulation(this, string, frame, uRL, bl);
        this._view = (Duffing_BakerView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.phase = 0.0;
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this.n = 0;
        this.N2 = this.N * this.N;
        this.dt = this.phase0 = Math.toRadians(this.phaseDegrees);
        this.transitory = true;
        this.clear();
        this._resetSolvers();
    }

    public void _evolution2() {
        if (this.transitory && this.t >= this.phase0 + (double)this.skip * this.Pi2) {
            this.transitory = false;
            this._view.Points.clear();
        }
        int n = this.nColor = this.colors ? this.n + 10 : 0;
        if (++this.n >= this.N2) {
            this.n = 0;
            this.phase = this.phase0;
            this._resetSolvers();
        }
        this.dt = this.Pi2 / (double)this.N2;
    }

    public void clear() {
        this.setColors();
        this._view.Points.clear();
    }

    public void setColors() {
        DataRaster dataRaster = this._view.Points;
        dataRaster.setColor(0, new Color(0, 0, 0));
        for (int i = 0; i < this.N2; ++i) {
            dataRaster.setColor(10 + i, new Color(Color.HSBtoRGB(1.0f / (float)this.N2 * (float)i, 1.0f, 1.0f)));
        }
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Gamma_editable() {
        return this._isPaused();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Force_editable() {
        return this._isPaused();
    }

    public void _method_for_Force_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Phase0_editable() {
        return this._isPaused();
    }

    public void _method_for_Phase0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Skip_editable() {
        return this._isPaused();
    }

    public void _method_for_Skip_action() {
        this._simulation.disableLoop();
        if (this.skip < 0) {
            this.skip = 0;
        }
        this._simulation.enableLoop();
    }

    public void _method_for_Colors_action() {
        this._simulation.disableLoop();
        this.clear();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this.clear();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.clear();
        this._simulation.enableLoop();
    }

    public void _method_for_Number_action() {
        this._simulation.disableLoop();
        this.N2 = this.N * this.N;
        this.clear();
        this._simulation.enableLoop();
    }

    public double _method_for_Sections_maximumX() {
        return this.x1 + (double)this.N * this.cx;
    }

    public double _method_for_Sections_minimumY() {
        return this.y1 - (double)(this.N - 1) * this.cy;
    }

    public double _method_for_Sections_maximumY() {
        return this.y1 + this.cy;
    }

    public double _method_for_Points_x() {
        return this.x + (double)(this.n % this.N) * this.cx;
    }

    public double _method_for_Points_y() {
        return this.v - (double)(this.n / this.N) * this.cy;
    }

    public double _method_for_Points_maximumX() {
        return this.x1 + (double)this.N * this.cx;
    }

    public double _method_for_Points_minimumY() {
        return this.y1 - (double)(this.N - 1) * this.cy;
    }

    public double _method_for_Points_maximumY() {
        return this.y1 + this.cy;
    }

    public double _method_for_Transitory_x() {
        return this.x1 + 0.5 * (this.cx * (double)this.N);
    }

    public double _method_for_Transitory_y() {
        return this.y1 - 0.5 * (this.cy * (double)(this.N - 2));
    }

    public boolean _method_for_Transitory_visible() {
        return this.transitory && this._isPlaying();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.phase = 0.0;
        this.gamma = 0.1;
        this.f = 0.3;
        this.dt = this.Pi2 = Math.PI * 2;
        this.skip = 10;
        this.x0 = 1.0;
        this.v0 = 0.0;
        this.tol = 1.0E-5;
        this.x1 = -1.75;
        this.y1 = -1.25;
        this.cx = 3.5;
        this.cy = 2.5;
        this.transitory = false;
        this.phase0 = 0.0;
        this.phaseDegrees = 0.0;
        this.N = 3;
        this.N2 = 0;
        this.n = 0;
        this.colors = true;
        this.nColor = 0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private Dopri853 __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _phase;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Duffing_Baker.this.x;
            this.__state[n++] = Duffing_Baker.this.v;
            this.__state[n++] = Duffing_Baker.this.phase;
            this.__state[n++] = Duffing_Baker.this.t;
            this.__solver = new Dopri853(this);
            this.__solver.initialize(Duffing_Baker.this.dt);
        }

        void step() {
            if (Duffing_Baker.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Duffing_Baker.this.tol);
            }
            if (Duffing_Baker.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Duffing_Baker.this.dt);
            }
            int n = 0;
            this.__state[n++] = Duffing_Baker.this.x;
            this.__state[n++] = Duffing_Baker.this.v;
            this.__state[n++] = Duffing_Baker.this.phase;
            this.__state[n++] = Duffing_Baker.this.t;
            this.__solver.step();
            n = 0;
            Duffing_Baker.this.x = this.__state[n++];
            Duffing_Baker.this.v = this.__state[n++];
            Duffing_Baker.this.phase = this.__state[n++];
            Duffing_Baker.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._phase = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._v, this._phase, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return -2.0 * Duffing_Baker.this.gamma * d2 + d * (1.0 - d * d) + Duffing_Baker.this.f * Math.cos(d3);
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return 1.0;
        }
    }
}

