/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlSplitPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.chaos.Duffing.Duffing;
import users.ehu.jma.chaos.Duffing.DuffingSimulation;

class DuffingView
extends EjsControl
implements View {
    private DuffingSimulation _simulation = null;
    private Duffing _model = null;
    public Component Main;
    public JPanel Left;
    public JTextField xx;
    public JTextField vv;
    public JTextField Gamma;
    public JTextField Force;
    public JTextField ddt;
    public JTextField Tolerance;
    public JTextField N;
    public JCheckBox ShowPhase;
    public JCheckBox Showxt;
    public JCheckBox ShowPoincare;
    public JCheckBox ShowV;
    public JButton startButton;
    public JButton continueButton;
    public JButton resetButton;
    public JSlider Zoom;
    public JSplitPane splitPanel;
    public PlottingPanel2D PhaseSpace;
    public InteractiveTrace Orbit;
    public InteractiveParticle Point;
    public PlottingPanel2D Evolution;
    public InteractiveTrace xt;
    public JDialog PoincareDialog;
    public PlottingPanel2D Section;
    public ElementSet PoincarePoints;
    public JPanel Buttons;
    public JTextField Phase0;
    public JTextField PoincareTolerance;
    public JButton Clear;
    public JButton Close;
    public JDialog VDialog;
    public PlottingPanel2D Energiak;
    public InteractivePoligon Vgraph;
    public InteractiveTrace Egraph;
    public InteractiveParticle PointE;

    public DuffingView(DuffingSimulation duffingSimulation, String string, Frame frame) {
        super(duffingSimulation, string, frame);
        this._simulation = duffingSimulation;
        this._model = (Duffing)duffingSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("phase", "apply(\"phase\")");
        this.addListener("gamma", "apply(\"gamma\")");
        this.addListener("f", "apply(\"f\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("v0", "apply(\"v0\")");
        this.addListener("phase00", "apply(\"phase00\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("y1", "apply(\"y1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("y2", "apply(\"y2\")");
        this.addListener("N", "apply(\"N\")");
        this.addListener("Pi2", "apply(\"Pi2\")");
        this.addListener("showPhase", "apply(\"showPhase\")");
        this.addListener("showxt", "apply(\"showxt\")");
        this.addListener("showV", "apply(\"showV\")");
        this.addListener("v1", "apply(\"v1\")");
        this.addListener("v2", "apply(\"v2\")");
        this.addListener("scale", "apply(\"scale\")");
        this.addListener("showPoincare", "apply(\"showPoincare\")");
        this.addListener("PoincareMax", "apply(\"PoincareMax\")");
        this.addListener("nPoincare", "apply(\"nPoincare\")");
        this.addListener("PoincareX", "apply(\"PoincareX\")");
        this.addListener("PoincareY", "apply(\"PoincareY\")");
        this.addListener("sign", "apply(\"sign\")");
        this.addListener("epsPoincare", "apply(\"epsPoincare\")");
        this.addListener("phase0", "apply(\"phase0\")");
        this.addListener("sx", "apply(\"sx\")");
        this.addListener("sy", "apply(\"sy\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("phase".equals(string)) {
            this._model.phase = this.getDouble("phase");
        }
        if ("gamma".equals(string)) {
            this._model.gamma = this.getDouble("gamma");
        }
        if ("f".equals(string)) {
            this._model.f = this.getDouble("f");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("v0".equals(string)) {
            this._model.v0 = this.getDouble("v0");
        }
        if ("phase00".equals(string)) {
            this._model.phase00 = this.getDouble("phase00");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("y1".equals(string)) {
            this._model.y1 = this.getDouble("y1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("y2".equals(string)) {
            this._model.y2 = this.getDouble("y2");
        }
        if ("N".equals(string)) {
            this._model.N = this.getInt("N");
        }
        if ("Pi2".equals(string)) {
            this._model.Pi2 = this.getDouble("Pi2");
        }
        if ("showPhase".equals(string)) {
            this._model.showPhase = this.getBoolean("showPhase");
        }
        if ("showxt".equals(string)) {
            this._model.showxt = this.getBoolean("showxt");
        }
        if ("showV".equals(string)) {
            this._model.showV = this.getBoolean("showV");
        }
        if ("v1".equals(string)) {
            this._model.v1 = this.getDouble("v1");
        }
        if ("v2".equals(string)) {
            this._model.v2 = this.getDouble("v2");
        }
        if ("scale".equals(string)) {
            this._model.scale = this.getDouble("scale");
        }
        if ("showPoincare".equals(string)) {
            this._model.showPoincare = this.getBoolean("showPoincare");
        }
        if ("PoincareMax".equals(string)) {
            this._model.PoincareMax = this.getInt("PoincareMax");
        }
        if ("nPoincare".equals(string)) {
            this._model.nPoincare = this.getInt("nPoincare");
        }
        if ("PoincareX".equals(string)) {
            dArray = (double[])this.getValue("PoincareX").getObject();
            n2 = dArray.length;
            if (n2 > this._model.PoincareX.length) {
                n2 = this._model.PoincareX.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.PoincareX[n] = dArray[n];
            }
        }
        if ("PoincareY".equals(string)) {
            dArray = (double[])this.getValue("PoincareY").getObject();
            n2 = dArray.length;
            if (n2 > this._model.PoincareY.length) {
                n2 = this._model.PoincareY.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.PoincareY[n] = dArray[n];
            }
        }
        if ("sign".equals(string)) {
            this._model.sign = this.getDouble("sign");
        }
        if ("epsPoincare".equals(string)) {
            this._model.epsPoincare = this.getDouble("epsPoincare");
        }
        if ("phase0".equals(string)) {
            this._model.phase0 = this.getDouble("phase0");
        }
        if ("sx".equals(string)) {
            this._model.sx = this.getDouble("sx");
        }
        if ("sy".equals(string)) {
            this._model.sy = this.getDouble("sy");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("v", this._model.v);
        this.setValue("phase", this._model.phase);
        this.setValue("gamma", this._model.gamma);
        this.setValue("f", this._model.f);
        this.setValue("dt", this._model.dt);
        this.setValue("x0", this._model.x0);
        this.setValue("v0", this._model.v0);
        this.setValue("phase00", this._model.phase00);
        this.setValue("tol", this._model.tol);
        this.setValue("x1", this._model.x1);
        this.setValue("y1", this._model.y1);
        this.setValue("x2", this._model.x2);
        this.setValue("y2", this._model.y2);
        this.setValue("N", this._model.N);
        this.setValue("Pi2", this._model.Pi2);
        this.setValue("showPhase", this._model.showPhase);
        this.setValue("showxt", this._model.showxt);
        this.setValue("showV", this._model.showV);
        this.setValue("v1", this._model.v1);
        this.setValue("v2", this._model.v2);
        this.setValue("scale", this._model.scale);
        this.setValue("showPoincare", this._model.showPoincare);
        this.setValue("PoincareMax", this._model.PoincareMax);
        this.setValue("nPoincare", this._model.nPoincare);
        this.setValue("PoincareX", this._model.PoincareX);
        this.setValue("PoincareY", this._model.PoincareY);
        this.setValue("sign", this._model.sign);
        this.setValue("epsPoincare", this._model.epsPoincare);
        this.setValue("phase0", this._model.phase0);
        this.setValue("sx", this._model.sx);
        this.setValue("sy", this._model.sy);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Duffing")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,0").setProperty("size", this._simulation.translateString("View.Main.size", "625,458")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:14,1,0,1").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.xx = (JTextField)this.addElement(new ControlNumberField(), "xx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "x0").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("editable", "%_model._method_for_xx_editable()%").setProperty("action", "_model._method_for_xx_action()").setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "Initial x")).getObject();
        this.vv = (JTextField)this.addElement(new ControlNumberField(), "vv").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "v0").setProperty("format", this._simulation.translateString("View.vv.format", "v = 0.##")).setProperty("editable", "%_model._method_for_vv_editable()%").setProperty("action", "_model._method_for_vv_action()").setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Initial velocity")).getObject();
        this.Gamma = (JTextField)this.addElement(new ControlNumberField(), "Gamma").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("editable", "%_model._method_for_Gamma_editable()%").setProperty("action", "_model._method_for_Gamma_action()").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Damping coefficient")).getObject();
        this.Force = (JTextField)this.addElement(new ControlNumberField(), "Force").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "f").setProperty("format", this._simulation.translateString("View.Force.format", "f = 0.###")).setProperty("editable", "%_model._method_for_Force_editable()%").setProperty("action", "_model._method_for_Force_action()").setProperty("tooltip", this._simulation.translateString("View.Force.tooltip", "Amplitude of external force")).getObject();
        this.ddt = (JTextField)this.addElement(new ControlNumberField(), "ddt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Interval between frames")).getObject();
        this.Tolerance = (JTextField)this.addElement(new ControlNumberField(), "Tolerance").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.Tolerance.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.Tolerance.tooltip", "Maximum error in integration")).getObject();
        this.N = (JTextField)this.addElement(new ControlNumberField(), "N").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("action", "_model._method_for_N_action()").setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of solution points")).getObject();
        this.ShowPhase = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowPhase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "showPhase").setProperty("text", this._simulation.translateString("View.ShowPhase.text", "Phase space")).setProperty("mnemonic", this._simulation.translateString("View.ShowPhase.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowPhase.tooltip", "Show the phase space (x,x')")).getObject();
        this.Showxt = (JCheckBox)this.addElement(new ControlCheckBox(), "Showxt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "showxt").setProperty("text", this._simulation.translateString("View.Showxt.text", "x(t)")).setProperty("mnemonic", this._simulation.translateString("View.Showxt.mnemonic", "x")).setProperty("tooltip", this._simulation.translateString("View.Showxt.tooltip", "Show solution x(t)")).getObject();
        this.ShowPoincare = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowPoincare").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "showPoincare").setProperty("text", this._simulation.translateString("View.ShowPoincare.text", "Poincar\u00e9")).setProperty("mnemonic", this._simulation.translateString("View.ShowPoincare.mnemonic", "p")).setProperty("actionon", "_model._method_for_ShowPoincare_actionon()").setProperty("tooltip", this._simulation.translateString("View.ShowPoincare.tooltip", "Compute Poincar\u00e9 section dr/dt=0")).getObject();
        this.ShowV = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowV").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "showV").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.ShowV.text", "Energy")).setProperty("mnemonic", this._simulation.translateString("View.ShowV.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show mechanical and potential energies")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.continueButton = (JButton)this.addElement(new ControlButton(), "continueButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_continueButton_action()").setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "scale").setProperty("minimum", "0.25").setProperty("maximum", "5.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.splitPanel = (JSplitPane)this.addElement(new ControlSplitPanel(), "splitPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("orientation", "VERTICAL").setProperty("expandable", "true").getObject();
        this.PhaseSpace = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "PhaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "splitPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_PhaseSpace_minimumX()%").setProperty("maximumX", "%_model._method_for_PhaseSpace_maximumX()%").setProperty("minimumY", "%_model._method_for_PhaseSpace_minimumY()%").setProperty("maximumY", "%_model._method_for_PhaseSpace_maximumY()%").setProperty("pressaction", "_model._method_for_PhaseSpace_pressaction()").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "v = x'")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "v = 0.###")).setProperty("visible", "showPhase").setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Click to erase")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "x").setProperty("y", "v").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Orbit_visible()%").setProperty("color", "blue").getObject();
        this.Point = (InteractiveParticle)this.addElement(new ControlParticle(), "Point").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "x").setProperty("y", "v").setProperty("sizex", ".05").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Point_dragaction()").setProperty("action", "_model._method_for_Point_action()").getObject();
        this.Evolution = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "splitPanel").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "5").setProperty("pressaction", "_model._method_for_Evolution_pressaction()").setProperty("title", this._simulation.translateString("View.Evolution.title", "x(t)")).setProperty("titleX", this._simulation.translateString("View.Evolution.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Evolution.titleY", "x")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "x = 0.###")).setProperty("visible", "showxt").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Click to erase")).getObject();
        this.xt = (InteractiveTrace)this.addElement(new ControlTrace(), "xt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "t").setProperty("y", "x").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_xt_visible()%").setProperty("color", "red").getObject();
        this.PoincareDialog = (JDialog)this.addElement(new ControlDialog(), "PoincareDialog").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.PoincareDialog.title", "Poincare section")).setProperty("layout", "border").setProperty("visible", "showPoincare").setProperty("location", "642,0").setProperty("size", this._simulation.translateString("View.PoincareDialog.size", "460,460")).getObject();
        this.Section = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Section").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "PoincareDialog").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Section_minimumX()%").setProperty("maximumX", "%_model._method_for_Section_maximumX()%").setProperty("minimumY", "%_model._method_for_Section_minimumY()%").setProperty("maximumY", "%_model._method_for_Section_maximumY()%").setProperty("title", this._simulation.translateString("View.Section.title", "Stroboscopic section")).setProperty("titleX", this._simulation.translateString("View.Section.titleX", "x")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Section.titleY", "v = x'")).setProperty("majorTicksY", "false").setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Section.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Section.yFormat", "v = 0.###")).getObject();
        this.PoincarePoints = (ElementSet)this.addElement(new ControlParticleSet(), "PoincarePoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Section").setProperty("elementnumber", "nPoincare").setProperty("x", "PoincareX").setProperty("y", "PoincareY").setProperty("sizex", "sx").setProperty("sizey", "sy").setProperty("visible", "%_model._method_for_PoincarePoints_visible()%").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "blue").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "PoincareDialog").setProperty("layout", "grid:1,4,0,0").getObject();
        this.Phase0 = (JTextField)this.addElement(new ControlNumberField(), "Phase0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phase00").setProperty("format", this._simulation.translateString("View.Phase0.format", "$\\phi$ = 0.###")).setProperty("editable", "%_model._method_for_Phase0_editable()%").setProperty("action", "_model._method_for_Phase0_action()").setProperty("tooltip", this._simulation.translateString("View.Phase0.tooltip", "Poincar\u00e9 section is omega t = phi")).getObject();
        this.PoincareTolerance = (JTextField)this.addElement(new ControlNumberField(), "PoincareTolerance").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "epsPoincare").setProperty("format", this._simulation.translateString("View.PoincareTolerance.format", "$\\epsilon$ = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.PoincareTolerance.tooltip", "Maximum error in Poincar\u00e9 section")).getObject();
        this.Clear = (JButton)this.addElement(new ControlButton(), "Clear").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("text", this._simulation.translateString("View.Clear.text", "Erase")).setProperty("image", this._simulation.translateString("View.Clear.image", "images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "e")).setProperty("enabled", "%_model._method_for_Clear_enabled()%").setProperty("action", "_model._method_for_Clear_action()").setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear screen")).getObject();
        this.Close = (JButton)this.addElement(new ControlButton(), "Close").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("text", this._simulation.translateString("View.Close.text", "Close")).setProperty("image", this._simulation.translateString("View.Close.image", "images/close.gif")).setProperty("mnemonic", this._simulation.translateString("View.Close.mnemonic", "c")).setProperty("action", "_model._method_for_Close_action()").setProperty("tooltip", this._simulation.translateString("View.Close.tooltip", "Close this window")).getObject();
        this.VDialog = (JDialog)this.addElement(new ControlDialog(), "VDialog").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.VDialog.title", "Energy")).setProperty("layout", "border").setProperty("visible", "showV").setProperty("location", "522,263").setProperty("size", this._simulation.translateString("View.VDialog.size", "506,300")).getObject();
        this.Energiak = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Energiak").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "VDialog").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Energiak_minimumX()%").setProperty("maximumX", "%_model._method_for_Energiak_maximumX()%").setProperty("minimumY", "%_model._method_for_Energiak_minimumY()%").setProperty("maximumY", "%_model._method_for_Energiak_maximumY()%").setProperty("pressaction", "_model._method_for_Energiak_pressaction()").setProperty("title", this._simulation.translateString("View.Energiak.title", "Mechanical energy")).setProperty("titleX", this._simulation.translateString("View.Energiak.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.Energiak.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Energiak.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Energiak.yFormat", "E = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Energiak.tooltip", "Click to clear")).getObject();
        this.Vgraph = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Vgraph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("min", "%_model._method_for_Vgraph_min()%").setProperty("max", "%_model._method_for_Vgraph_max()%").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-.25*s*s*(2.0-s*s)").setProperty("color", "red").setProperty("stroke", "2").setProperty("visible", "%_model._method_for_Vgraph_visible()%").setProperty("enabled", "false").getObject();
        this.Egraph = (InteractiveTrace)this.addElement(new ControlTrace(), "Egraph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("x", "x").setProperty("y", "%_model._method_for_Egraph_y()%").setProperty("maxpoints", "N").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Egraph_visible()%").setProperty("color", "blue").getObject();
        this.PointE = (InteractiveParticle)this.addElement(new ControlParticle(), "PointE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Energiak").setProperty("x", "x").setProperty("y", "%_model._method_for_PointE_y()%").setProperty("sizex", ".05").setProperty("sizey", ".02").setProperty("enabled", "false").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Duffing")).setProperty("visible", "true");
        this.getElement("Left").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("xx").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "Initial x"));
        this.getElement("vv").setProperty("format", this._simulation.translateString("View.vv.format", "v = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "Initial velocity"));
        this.getElement("Gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Damping coefficient"));
        this.getElement("Force").setProperty("format", this._simulation.translateString("View.Force.format", "f = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Force.tooltip", "Amplitude of external force"));
        this.getElement("ddt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Interval between frames"));
        this.getElement("Tolerance").setProperty("format", this._simulation.translateString("View.Tolerance.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.Tolerance.tooltip", "Maximum error in integration"));
        this.getElement("N").setProperty("format", this._simulation.translateString("View.N.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.N.tooltip", "Number of solution points"));
        this.getElement("ShowPhase").setProperty("text", this._simulation.translateString("View.ShowPhase.text", "Phase space")).setProperty("mnemonic", this._simulation.translateString("View.ShowPhase.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.ShowPhase.tooltip", "Show the phase space (x,x')"));
        this.getElement("Showxt").setProperty("text", this._simulation.translateString("View.Showxt.text", "x(t)")).setProperty("tooltip", this._simulation.translateString("View.Showxt.tooltip", "Show solution x(t)"));
        this.getElement("ShowPoincare").setProperty("text", this._simulation.translateString("View.ShowPoincare.text", "Poincar\u00e9")).setProperty("mnemonic", this._simulation.translateString("View.ShowPoincare.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.ShowPoincare.tooltip", "Compute Poincar\u00e9 section dr/dt=0"));
        this.getElement("ShowV").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.ShowV.text", "Energy")).setProperty("mnemonic", this._simulation.translateString("View.ShowV.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.ShowV.tooltip", "Show mechanical and potential energies"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("continueButton").setProperty("image", this._simulation.translateString("View.continueButton.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.continueButton.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.continueButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        this.getElement("Zoom").setProperty("minimum", "0.25").setProperty("maximum", "5.0").setProperty("orientation", "VERTICAL").setProperty("ticks", "20").setProperty("closest", "true").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("splitPanel").setProperty("orientation", "VERTICAL").setProperty("expandable", "true");
        this.getElement("PhaseSpace").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "v = x'")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "v = 0.###")).setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Click to erase"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Point").setProperty("sizex", ".05").setProperty("enabled", "true");
        this.getElement("Evolution").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.Evolution.title", "x(t)")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "x = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Click to erase"));
        this.getElement("xt").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("PoincareDialog").setProperty("title", this._simulation.translateString("View.PoincareDialog.title", "Poincare section"));
        this.getElement("Section").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Section.title", "Stroboscopic section")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Section.titleY", "v = x'")).setProperty("majorTicksY", "false").setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Section.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Section.yFormat", "v = 0.###"));
        this.getElement("PoincarePoints").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "blue");
        this.getElement("Buttons");
        this.getElement("Phase0").setProperty("format", this._simulation.translateString("View.Phase0.format", "$\\phi$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Phase0.tooltip", "Poincar\u00e9 section is omega t = phi"));
        this.getElement("PoincareTolerance").setProperty("format", this._simulation.translateString("View.PoincareTolerance.format", "$\\epsilon$ = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.PoincareTolerance.tooltip", "Maximum error in Poincar\u00e9 section"));
        this.getElement("Clear").setProperty("text", this._simulation.translateString("View.Clear.text", "Erase")).setProperty("image", this._simulation.translateString("View.Clear.image", "images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear screen"));
        this.getElement("Close").setProperty("text", this._simulation.translateString("View.Close.text", "Close")).setProperty("image", this._simulation.translateString("View.Close.image", "images/close.gif")).setProperty("mnemonic", this._simulation.translateString("View.Close.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Close.tooltip", "Close this window"));
        this.getElement("VDialog").setProperty("title", this._simulation.translateString("View.VDialog.title", "Energy"));
        this.getElement("Energiak").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Energiak.title", "Mechanical energy")).setProperty("titleY", this._simulation.translateString("View.Energiak.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Energiak.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Energiak.yFormat", "E = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Energiak.tooltip", "Click to clear"));
        this.getElement("Vgraph").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-.25*s*s*(2.0-s*s)").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("Egraph").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("PointE").setProperty("sizex", ".05").setProperty("sizey", ".02").setProperty("enabled", "false");
        super.reset();
    }
}

