/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Duffing;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Dopri853;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Duffing.DuffingSimulation;
import users.ehu.jma.chaos.Duffing.DuffingView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duffing
extends AbstractModel {
    public DuffingSimulation _simulation = null;
    public DuffingView _view = null;
    public Duffing _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double phase = 0.0;
    public double gamma = 0.0;
    public double f = 0.0;
    public double dt = 0.1;
    public double x0 = 1.5;
    public double v0 = 0.0;
    public double phase00 = 0.0;
    public double tol = 1.0E-5;
    public double x1 = -1.5;
    public double y1 = -1.0;
    public double x2 = 1.5;
    public double y2 = 1.0;
    public int N = 1000;
    public double Pi2 = Math.PI * 2;
    public boolean showPhase = true;
    public boolean showxt = true;
    public boolean showV = false;
    public double v1 = -0.3;
    public double v2 = 0.3;
    public double scale = 1.0;
    public boolean showPoincare = false;
    public int PoincareMax = 10000;
    public int nPoincare = 0;
    public double[] PoincareX;
    public double[] PoincareY;
    public double sign = 0.0;
    public double epsPoincare = 1.0E-4;
    public double phase0 = 0.0;
    public double sx = 0.0;
    public double sy = 0.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Duffing.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("images/erase.gif");
        hashSet.add("images/close.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Duffing duffing = new Duffing(stringArray);
    }

    public Duffing() {
        this(null, null, null, null, null, false);
    }

    public Duffing(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Duffing(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new DuffingSimulation(this, string, frame, uRL, bl);
        this._view = (DuffingView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.phase = 0.0;
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this.phase0 = this.phase00;
        this.nPoincare = 0;
        this._view.resetTraces();
        this._resetSolvers();
    }

    public void _constraints1() {
        if (this.showPoincare && this.nPoincare >= this.PoincareMax) {
            this._pause();
        }
        this.sx = (this.x2 - this.x1) / 150.0;
        this.sy = (this.y2 - this.y1) / 100.0;
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Gamma_editable() {
        return this._isPaused();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Force_editable() {
        return this._isPaused();
    }

    public void _method_for_Force_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_N_action() {
        this._simulation.disableLoop();
        if (this.N < 0) {
            this.N = 0;
        }
        this._simulation.enableLoop();
    }

    public void _method_for_ShowPoincare_actionon() {
        this._simulation.disableLoop();
        this.phase0 = Math.ceil(this.phase / this.Pi2) * this.Pi2 + this.phase00;
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_PhaseSpace_minimumX() {
        return this.x1 * this.scale;
    }

    public double _method_for_PhaseSpace_maximumX() {
        return this.x2 * this.scale;
    }

    public double _method_for_PhaseSpace_minimumY() {
        return this.y1 * this.scale;
    }

    public double _method_for_PhaseSpace_maximumY() {
        return this.y2 * this.scale;
    }

    public void _method_for_PhaseSpace_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("Orbit").reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Orbit_visible() {
        return this.N > 0;
    }

    public void _method_for_Point_dragaction() {
        this._simulation.disableLoop();
        this.x0 = this.x;
        this.v0 = this.v;
        this._simulation.enableLoop();
    }

    public void _method_for_Point_action() {
        this._simulation.disableLoop();
        this.x0 = this.x;
        this.v0 = this.v;
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("xt").reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_xt_visible() {
        return this.showxt && this.N > 0;
    }

    public double _method_for_Section_minimumX() {
        return this.x1 * this.scale;
    }

    public double _method_for_Section_maximumX() {
        return this.x2 * this.scale;
    }

    public double _method_for_Section_minimumY() {
        return this.y1 * this.scale;
    }

    public double _method_for_Section_maximumY() {
        return this.y2 * this.scale;
    }

    public boolean _method_for_PoincarePoints_visible() {
        return this.showPoincare && this.nPoincare > 0;
    }

    public boolean _method_for_Phase0_editable() {
        return this._isPaused();
    }

    public void _method_for_Phase0_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Clear_enabled() {
        return this.nPoincare > 0;
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.nPoincare = 0;
        this._simulation.enableLoop();
    }

    public void _method_for_Close_action() {
        this._simulation.disableLoop();
        this.showPoincare = false;
        this._simulation.enableLoop();
    }

    public double _method_for_Energiak_minimumX() {
        return this.x1 * this.scale;
    }

    public double _method_for_Energiak_maximumX() {
        return this.x2 * this.scale;
    }

    public double _method_for_Energiak_minimumY() {
        return this.v1 * this.scale;
    }

    public double _method_for_Energiak_maximumY() {
        return this.v2 * this.scale;
    }

    public void _method_for_Energiak_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("Egraph").reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Vgraph_min() {
        return this.x1 * this.scale;
    }

    public double _method_for_Vgraph_max() {
        return this.x2 * this.scale;
    }

    public boolean _method_for_Vgraph_visible() {
        return this.f == 0.0;
    }

    public double _method_for_Egraph_y() {
        return 0.5 * this.v * this.v - 0.25 * this.x * this.x * (2.0 - this.x * this.x);
    }

    public boolean _method_for_Egraph_visible() {
        return this.N > 0;
    }

    public double _method_for_PointE_y() {
        return 0.5 * this.v * this.v - 0.5 * this.x * this.x * (1.0 - 0.5 * this.x * this.x);
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.phase = 0.0;
        this.gamma = 0.0;
        this.f = 0.0;
        this.dt = 0.1;
        this.x0 = 1.5;
        this.v0 = 0.0;
        this.phase00 = 0.0;
        this.tol = 1.0E-5;
        this.x1 = -1.5;
        this.y1 = -1.0;
        this.x2 = 1.5;
        this.y2 = 1.0;
        this.N = 1000;
        this.Pi2 = Math.PI * 2;
        this.showPhase = true;
        this.showxt = true;
        this.showV = false;
        this.v1 = -0.3;
        this.v2 = 0.3;
        this.scale = 1.0;
        this.showPoincare = false;
        this.PoincareMax = 10000;
        this.nPoincare = 0;
        this.PoincareX = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareX[n] = 0.0;
        }
        this.PoincareY = new double[this.PoincareMax];
        for (n = 0; n < this.PoincareMax; ++n) {
            this.PoincareY[n] = 0.0;
        }
        this.sign = 0.0;
        this.epsPoincare = 1.0E-4;
        this.phase0 = 0.0;
        this.sx = 0.0;
        this.sy = 0.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.PoincareX = null;
        this.PoincareY = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _phase;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = Duffing.this.x;
            this.__state[n++] = Duffing.this.v;
            this.__state[n++] = Duffing.this.phase;
            this.__state[n++] = Duffing.this.t;
            this.__solver = new ODEBisectionEventSolver(this, Dopri853.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(Duffing.this.dt);
        }

        void step() {
            if (Duffing.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Duffing.this.tol);
            }
            if (Duffing.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Duffing.this.dt);
            }
            int n = 0;
            this.__state[n++] = Duffing.this.x;
            this.__state[n++] = Duffing.this.v;
            this.__state[n++] = Duffing.this.phase;
            this.__state[n++] = Duffing.this.t;
            this.__solver.step();
            n = 0;
            Duffing.this.x = this.__state[n++];
            Duffing.this.v = this.__state[n++];
            Duffing.this.phase = this.__state[n++];
            Duffing.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._phase = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._phase, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._v, this._phase, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return -2.0 * Duffing.this.gamma * d2 + d * (1.0 - d * d) + Duffing.this.f * Math.cos(d3);
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return 1.0;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Poincar\u00e9 section";
            }

            public double getTolerance() {
                return Duffing.this.epsPoincare;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._v = dArray[n++];
                _ODE_evolution1.this._phase = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._v, _ODE_evolution1.this._phase, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4) {
                return Duffing.this.nPoincare >= Duffing.this.PoincareMax ? 1.0 : Duffing.this.phase0 - d3;
            }

            public boolean action() {
                int n = 0;
                Duffing.this.x = _ODE_evolution1.this.__state[n++];
                Duffing.this.v = _ODE_evolution1.this.__state[n++];
                Duffing.this.phase = _ODE_evolution1.this.__state[n++];
                Duffing.this.t = _ODE_evolution1.this.__state[n++];
                Duffing.this.PoincareX[Duffing.this.nPoincare] = Duffing.this.x;
                Duffing.this.PoincareY[Duffing.this.nPoincare] = Duffing.this.v;
                Duffing.this.phase0 += Duffing.this.Pi2;
                ++Duffing.this.nPoincare;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing.this.v;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing.this.phase;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = Duffing.this.t;
                return false;
            }
        }
    }
}

