/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.chaos.Baker;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.chaos.Baker.BakerSimulation;
import users.ehu.jma.chaos.Baker.BakerView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Baker
extends AbstractModel {
    public BakerSimulation _simulation = null;
    public BakerView _view = null;
    public Baker _model = this;
    public int n = 0;
    public double x = 0.0;
    public double y = 0.0;
    public double xd = 0.0;
    public double yd = 0.0;
    public double deltaX = 0.0;
    public double deltaY = 1.0E-15;
    public int a = 6;
    public int b = 3;
    public double x0 = 0.1;
    public double y0 = 0.1;
    public double x10 = 0.0;
    public double y10 = 0.0;
    public double x20 = 1.0;
    public double y20 = 1.0;
    public double x1 = this.x10;
    public double y1 = this.y10;
    public double x2 = this.x20;
    public double y2 = this.y20;
    public boolean transitory = false;
    public int skip = 100;
    public boolean distance = false;
    public boolean selecting = false;
    public boolean first = true;
    public double mx = 0.0;
    public double my = 0.0;
    public double mx1 = 0.0;
    public double my1 = 0.0;
    public double mx2 = 0.0;
    public double my2 = 0.0;
    public double wx1 = 0.0;
    public double wy1 = 0.0;
    public double wx2 = 0.0;
    public double wy2 = 0.0;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/chaos/Baker.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/chaos/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Baker baker = new Baker(stringArray);
    }

    public Baker() {
        this(null, null, null, null, null, false);
    }

    public Baker(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Baker(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new BakerSimulation(this, string, frame, uRL, bl);
        this._view = (BakerView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.n = 0;
        this.x = this.x0;
        this.y = this.y0;
        this.xd = this.x0 + this.deltaX;
        this.yd = this.y0 + this.deltaY;
        this.selecting = false;
        this.transitory = true;
    }

    public void _evolution1() {
        ++this.n;
        this.y = (double)this.b * this.y;
        this.x = this.x / (double)this.a + Math.floor(this.y) / (double)this.b;
        this.y -= Math.floor(this.y);
        this.yd = (double)this.b * this.yd;
        this.xd = this.xd / (double)this.a + Math.floor(this.yd) / (double)this.b;
        this.yd -= Math.floor(this.yd);
        if (this.transitory && this.n >= this.skip) {
            this.transitory = false;
            this.clear();
        }
    }

    public void clear() {
        this._view.getElement("Points").reset();
    }

    public void full_size() {
        this.x1 = this.x10;
        this.y1 = this.y10;
        this.x2 = this.x20;
        this.y2 = this.y20;
        this.clear();
    }

    public void startCapture() {
        this.first = true;
        this.selecting = true;
    }

    public void mouseMove() {
        if (this.selecting) {
            if (this.first) {
                this.mx2 = this.mx1 = this.mx;
                this.wx2 = this.mx1;
                this.wx1 = this.mx1;
                this.my2 = this.my1 = this.my;
                this.wy2 = this.my1;
                this.wy1 = this.my1;
                this.first = false;
            } else {
                this.mx2 = this.mx;
                this.my2 = this.my;
                this.wx1 = this.mx1 < this.mx2 ? this.mx1 : this.mx2;
                this.wx2 = this.mx1 < this.mx2 ? this.mx2 : this.mx1;
                this.wy1 = this.my1 < this.my2 ? this.my1 : this.my2;
                this.wy2 = this.my1 < this.my2 ? this.my2 : this.my1;
            }
        }
    }

    public void endCapture() {
        if (!this.selecting) {
            return;
        }
        this.selecting = false;
        if (this.mx1 == this.mx2 || this.my1 == this.my2) {
            return;
        }
        this.x1 = this.wx1;
        this.x2 = this.wx2;
        this.y1 = this.wy1;
        this.y2 = this.wy2;
        this.clear();
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public boolean _method_for_aa_editable() {
        return this._isPaused();
    }

    public void _method_for_aa_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_bb_editable() {
        return this._isPaused();
    }

    public void _method_for_bb_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_dx_editable() {
        return this._isPaused();
    }

    public void _method_for_dx_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_dy_editable() {
        return this._isPaused();
    }

    public void _method_for_dy_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Skip_editable() {
        return this._isPaused();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._view.resetTraces();
        this.clear();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_continueButton_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this.clear();
        this._simulation.enableLoop();
    }

    public boolean _method_for_FullSize_enabled() {
        return this.x1 != this.x10 || this.x2 != this.x20 || this.y1 != this.y10 || this.y2 != this.y20;
    }

    public void _method_for_FullSize_action() {
        this._simulation.disableLoop();
        this.full_size();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_pressaction() {
        this._simulation.disableLoop();
        this.startCapture();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_dragaction() {
        this._simulation.disableLoop();
        this.mouseMove();
        this._simulation.enableLoop();
    }

    public void _method_for_Section_action() {
        this._simulation.disableLoop();
        this.endCapture();
        this._simulation.enableLoop();
    }

    public double _method_for_Window_sizex() {
        return this.wx2 - this.wx1;
    }

    public double _method_for_Window_sizey() {
        return this.wy2 - this.wy1;
    }

    public boolean _method_for_Window_visible() {
        return this.selecting && !this.first && (this.wx1 != this.wx2 || this.wy1 != this.wy2);
    }

    public boolean _method_for_Transitory_visible() {
        return this.transitory && this._isPlaying();
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("traceDist").reset();
        this._simulation.enableLoop();
    }

    public double[] _method_for_traceDist_y() {
        return new double[]{this.hypot(this.x - this.xd, this.y - this.yd)};
    }

    @Override
    public synchronized void reset() {
        this.n = 0;
        this.x = 0.0;
        this.y = 0.0;
        this.xd = 0.0;
        this.yd = 0.0;
        this.deltaX = 0.0;
        this.deltaY = 1.0E-15;
        this.a = 6;
        this.b = 3;
        this.x0 = 0.1;
        this.y0 = 0.1;
        this.x10 = 0.0;
        this.y10 = 0.0;
        this.x20 = 1.0;
        this.y20 = 1.0;
        this.x1 = this.x10;
        this.y1 = this.y10;
        this.x2 = this.x20;
        this.y2 = this.y20;
        this.transitory = false;
        this.skip = 100;
        this.distance = false;
        this.selecting = false;
        this.first = true;
        this.mx = 0.0;
        this.my = 0.0;
        this.mx1 = 0.0;
        this.my1 = 0.0;
        this.mx2 = 0.0;
        this.my2 = 0.0;
        this.wx1 = 0.0;
        this.wy1 = 0.0;
        this.wx2 = 0.0;
        this.wy2 = 0.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

