/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.spring;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlSpring;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.central_forces.spring.spring;
import users.ehu.jma.central_forces.spring.springSimulation;

class springView
extends EjsControl
implements View {
    private springSimulation _simulation = null;
    private spring _model = null;
    public Component Main;
    public DrawingPanel2D Evolution;
    public InteractiveParticle Rod;
    public InteractiveSpring Spring;
    public InteractiveParticle Particle;
    public InteractiveParticle Center;
    public PlottingPanel2D Drawing;
    public InteractiveTrace Orbit;
    public InteractiveParticle Rmax;
    public InteractiveParticle Rmin;
    public JPanel Down;
    public JPanel Values;
    public JTextField xx;
    public JTextField yy;
    public JTextField uu;
    public JTextField vv;
    public JTextField ddt;
    public JTextField bTol;
    public JTextField kk;
    public JTextField ll;
    public JCheckBox Graph;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JSlider Zoom;
    public JDialog GraphL;
    public PlottingPanel2D Graphs;
    public InteractivePoligon Effective;
    public InteractiveParticle Current;
    public InteractivePoligon EnergyLevel;

    public springView(springSimulation springSimulation2, String string, Frame frame) {
        super(springSimulation2, string, frame);
        this._simulation = springSimulation2;
        this._model = (spring)springSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("u", "apply(\"u\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("E", "apply(\"E\")");
        this.addListener("L", "apply(\"L\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("rmin", "apply(\"rmin\")");
        this.addListener("rmax", "apply(\"rmax\")");
        this.addListener("L0", "apply(\"L0\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("graph", "apply(\"graph\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("Emax", "apply(\"Emax\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("l", "apply(\"l\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("u".equals(string)) {
            this._model.u = this.getDouble("u");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("E".equals(string)) {
            this._model.E = this.getDouble("E");
        }
        if ("L".equals(string)) {
            this._model.L = this.getDouble("L");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("rmin".equals(string)) {
            this._model.rmin = this.getDouble("rmin");
        }
        if ("rmax".equals(string)) {
            this._model.rmax = this.getDouble("rmax");
        }
        if ("L0".equals(string)) {
            this._model.L0 = this.getDouble("L0");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("graph".equals(string)) {
            this._model.graph = this.getBoolean("graph");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("Emax".equals(string)) {
            this._model.Emax = this.getDouble("Emax");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("l".equals(string)) {
            this._model.l = this.getDouble("l");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("u", this._model.u);
        this.setValue("v", this._model.v);
        this.setValue("dt", this._model.dt);
        this.setValue("E", this._model.E);
        this.setValue("L", this._model.L);
        this.setValue("phi", this._model.phi);
        this.setValue("r", this._model.r);
        this.setValue("rmin", this._model.rmin);
        this.setValue("rmax", this._model.rmax);
        this.setValue("L0", this._model.L0);
        this.setValue("tol", this._model.tol);
        this.setValue("graph", this._model.graph);
        this.setValue("xmax", this._model.xmax);
        this.setValue("Emax", this._model.Emax);
        this.setValue("k", this._model.k);
        this.setValue("l", this._model.l);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Spring")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "3,1").setProperty("size", this._simulation.translateString("View.Main.size", "620,360")).getObject();
        this.Evolution = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Evolution_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Evolution_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Evolution_pressaction()").setProperty("square", "true").setProperty("background", "orange").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "You may use mouse to select initial position")).getObject();
        this.Rod = (InteractiveParticle)this.addElement(new ControlParticle(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "%_model._method_for_Rod_x()%").setProperty("y", "%_model._method_for_Rod_y()%").setProperty("sizex", "L0").setProperty("sizey", "0.05").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("angle", "phi").setProperty("color", "0,128,0,255").getObject();
        this.Spring = (InteractiveSpring)this.addElement(new ControlSpring(), "Spring").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "x").setProperty("sizey", "y").setProperty("enabledSecondary", "false").setProperty("enabled", "true").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", ".4").setProperty("sizey", ".4").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Particle_dragaction()").setProperty("style", "RECTANGLE").setProperty("elementposition", "CENTERED").setProperty("angle", "phi").getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "cyan").getObject();
        this.Drawing = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Drawing").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Drawing_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Drawing_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Drawing_pressaction()").setProperty("axesType", "Cartesian3").setProperty("titleX", this._simulation.translateString("View.Drawing.titleX", "x")).setProperty("majorTicksX", "false").setProperty("titleY", this._simulation.translateString("View.Drawing.titleY", "y")).setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("gutters", "0,0,0,0").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to erase")).getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("x", "x").setProperty("y", "y").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue").getObject();
        this.Rmax = (InteractiveParticle)this.addElement(new ControlParticle(), "Rmax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("sizex", "%_model._method_for_Rmax_sizex()%").setProperty("sizey", "%_model._method_for_Rmax_sizey()%").setProperty("enabled", "false").setProperty("secondaryColor", "orange").setProperty("color", "null").getObject();
        this.Rmin = (InteractiveParticle)this.addElement(new ControlParticle(), "Rmin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Drawing").setProperty("sizex", "%_model._method_for_Rmin_sizex()%").setProperty("sizey", "%_model._method_for_Rmin_sizey()%").setProperty("enabled", "false").setProperty("secondaryColor", "orange").setProperty("color", "null").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,6,0,1").getObject();
        this.xx = (JTextField)this.addElement(new ControlNumberField(), "xx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "x").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("editable", "%_model._method_for_xx_editable()%").setProperty("action", "_model._method_for_xx_action()").setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "x coordinate")).getObject();
        this.yy = (JTextField)this.addElement(new ControlNumberField(), "yy").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "y").setProperty("format", this._simulation.translateString("View.yy.format", "y = 0.##")).setProperty("editable", "%_model._method_for_yy_editable()%").setProperty("action", "_model._method_for_yy_action()").setProperty("tooltip", this._simulation.translateString("View.yy.tooltip", "y coordinate")).getObject();
        this.uu = (JTextField)this.addElement(new ControlNumberField(), "uu").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "u").setProperty("format", this._simulation.translateString("View.uu.format", "vx = 0.##")).setProperty("editable", "%_model._method_for_uu_editable()%").setProperty("action", "_model._method_for_uu_action()").setProperty("tooltip", this._simulation.translateString("View.uu.tooltip", "x component of velocity")).getObject();
        this.vv = (JTextField)this.addElement(new ControlNumberField(), "vv").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "v").setProperty("format", this._simulation.translateString("View.vv.format", "vy = 0.##")).setProperty("editable", "%_model._method_for_vv_editable()%").setProperty("action", "_model._method_for_vv_action()").setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "y component of velocity")).getObject();
        this.ddt = (JTextField)this.addElement(new ControlNumberField(), "ddt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Simulation step")).getObject();
        this.bTol = (JTextField)this.addElement(new ControlNumberField(), "bTol").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.bTol.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.bTol.tooltip", "Maximum relative error in integration")).getObject();
        this.kk = (JTextField)this.addElement(new ControlNumberField(), "kk").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "k").setProperty("format", this._simulation.translateString("View.kk.format", "k/m = 0.##")).setProperty("editable", "%_model._method_for_kk_editable()%").setProperty("action", "_model._method_for_kk_action()").setProperty("tooltip", this._simulation.translateString("View.kk.tooltip", "Spring constant / mass")).getObject();
        this.ll = (JTextField)this.addElement(new ControlNumberField(), "ll").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "l").setProperty("format", this._simulation.translateString("View.ll.format", "l = 0.##")).setProperty("editable", "%_model._method_for_ll_editable()%").setProperty("action", "_model._method_for_ll_action()").setProperty("tooltip", this._simulation.translateString("View.ll.tooltip", "Spring proper length")).getObject();
        this.Graph = (JCheckBox)this.addElement(new ControlCheckBox(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "graph").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.Graph.text", "Graph?")).setProperty("mnemonic", this._simulation.translateString("View.Graph.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.Graph.tooltip", "Display equivalent one-dimensional problem?")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "xmax").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.GraphL = (JDialog)this.addElement(new ControlDialog(), "GraphL").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.GraphL.title", "Equivalent problem")).setProperty("layout", "border").setProperty("visible", "graph").setProperty("location", "640,0").setProperty("size", this._simulation.translateString("View.GraphL.size", "300,300")).getObject();
        this.Graphs = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Graphs").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "GraphL").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumX", "%_model._method_for_Graphs_maximumX()%").setProperty("minimumY", "0").setProperty("maximumY", "Emax").setProperty("pressaction", "_model._method_for_Graphs_pressaction()").setProperty("titleX", this._simulation.translateString("View.Graphs.titleX", "r")).setProperty("titleY", this._simulation.translateString("View.Graphs.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Graphs.xFormat", "r = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graphs.yFormat", "E = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase")).getObject();
        this.Effective = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Effective").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("points", "100").setProperty("min", "0.05").setProperty("max", "%_model._method_for_Effective_max()%").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "0.5*L*L/(s*s)+0.5*k*(s-l)*(s-l)").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.Current = (InteractiveParticle)this.addElement(new ControlParticle(), "Current").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("x", "r").setProperty("y", "E").setProperty("enabled", "false").setProperty("secondaryColor", "blue").getObject();
        this.EnergyLevel = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "EnergyLevel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("points", "2").setProperty("min", "rmin").setProperty("max", "rmax").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "E").setProperty("color", "blue").setProperty("enabled", "false").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Spring")).setProperty("visible", "true");
        this.getElement("Evolution").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "orange").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "You may use mouse to select initial position"));
        this.getElement("Rod").setProperty("sizey", "0.05").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("color", "0,128,0,255");
        this.getElement("Spring").setProperty("x", "0").setProperty("y", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true");
        this.getElement("Particle").setProperty("sizex", ".4").setProperty("sizey", ".4").setProperty("enabled", "true").setProperty("style", "RECTANGLE").setProperty("elementposition", "CENTERED");
        this.getElement("Center").setProperty("x", "0").setProperty("y", "0").setProperty("enabled", "false").setProperty("style", "ELLIPSE").setProperty("color", "cyan");
        this.getElement("Drawing").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("axesType", "Cartesian3").setProperty("majorTicksX", "false").setProperty("majorTicksY", "false").setProperty("square", "true").setProperty("gutters", "0,0,0,0").setProperty("tooltip", this._simulation.translateString("View.Drawing.tooltip", "Click to erase"));
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Rmax").setProperty("enabled", "false").setProperty("secondaryColor", "orange").setProperty("color", "null");
        this.getElement("Rmin").setProperty("enabled", "false").setProperty("secondaryColor", "orange").setProperty("color", "null");
        this.getElement("Down");
        this.getElement("Values");
        this.getElement("xx").setProperty("format", this._simulation.translateString("View.xx.format", "x = 0.##")).setProperty("tooltip", this._simulation.translateString("View.xx.tooltip", "x coordinate"));
        this.getElement("yy").setProperty("format", this._simulation.translateString("View.yy.format", "y = 0.##")).setProperty("tooltip", this._simulation.translateString("View.yy.tooltip", "y coordinate"));
        this.getElement("uu").setProperty("format", this._simulation.translateString("View.uu.format", "vx = 0.##")).setProperty("tooltip", this._simulation.translateString("View.uu.tooltip", "x component of velocity"));
        this.getElement("vv").setProperty("format", this._simulation.translateString("View.vv.format", "vy = 0.##")).setProperty("tooltip", this._simulation.translateString("View.vv.tooltip", "y component of velocity"));
        this.getElement("ddt").setProperty("format", this._simulation.translateString("View.ddt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ddt.tooltip", "Simulation step"));
        this.getElement("bTol").setProperty("format", this._simulation.translateString("View.bTol.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.bTol.tooltip", "Maximum relative error in integration"));
        this.getElement("kk").setProperty("format", this._simulation.translateString("View.kk.format", "k/m = 0.##")).setProperty("tooltip", this._simulation.translateString("View.kk.tooltip", "Spring constant / mass"));
        this.getElement("ll").setProperty("format", this._simulation.translateString("View.ll.format", "l = 0.##")).setProperty("tooltip", this._simulation.translateString("View.ll.tooltip", "Spring proper length"));
        this.getElement("Graph").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.Graph.text", "Graph?")).setProperty("mnemonic", this._simulation.translateString("View.Graph.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.Graph.tooltip", "Display equivalent one-dimensional problem?"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        this.getElement("Zoom").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("GraphL").setProperty("title", this._simulation.translateString("View.GraphL.title", "Equivalent problem"));
        this.getElement("Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("minimumY", "0").setProperty("titleY", this._simulation.translateString("View.Graphs.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Graphs.xFormat", "r = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Graphs.yFormat", "E = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Graphs.tooltip", "Click to erase"));
        this.getElement("Effective").setProperty("points", "100").setProperty("min", "0.05").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "0.5*L*L/(s*s)+0.5*k*(s-l)*(s-l)").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("Current").setProperty("enabled", "false").setProperty("secondaryColor", "blue");
        this.getElement("EnergyLevel").setProperty("points", "2").setProperty("variable", "s").setProperty("functionx", "s").setProperty("color", "blue").setProperty("enabled", "false");
        super.reset();
    }
}

