/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.spring;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.spring.springSimulation;
import users.ehu.jma.central_forces.spring.springView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class spring
extends AbstractModel {
    public springSimulation _simulation = null;
    public springView _view = null;
    public spring _model = this;
    public double t = 0.0;
    public double x = 1.0;
    public double y = 0.0;
    public double u = 1.0;
    public double v = 1.0;
    public double dt = 0.05;
    public double E = 0.0;
    public double L = 1.0;
    public double phi = 0.0;
    public double r = 0.0;
    public double rmin = 0.730675;
    public double rmax = 2.0;
    public double L0 = 4.0;
    public double tol = 1.0E-6;
    public boolean graph = false;
    public double xmax = 2.2;
    public double Emax = 3.0;
    public double k = 1.75;
    public double l = 1.0;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/spring.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        spring spring2 = new spring(stringArray);
    }

    public spring() {
        this(null, null, null, null, null, false);
    }

    public spring(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public spring(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new springSimulation(this, string, frame, uRL, bl);
        this._view = (springView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.rmaxmin();
    }

    public void _constraints1() {
        this.phi = Math.atan2(this.y, this.x);
        this.r = this.hypot(this.x, this.y);
        this.L0 = Math.sqrt(2.0) * this.xmax;
    }

    public void rmaxmin() {
        this._view.resetTraces();
        double d = 0.01;
        double d2 = this.l;
        this.r = this.hypot(this.x, this.y);
        this.E = 0.5 * (this.u * this.u + this.v * this.v) + 0.5 * this.k * (this.r - this.l) * (this.r - this.l);
        this.L = this.x * this.v - this.y * this.u;
        if (this.L * this.L / (this.l * this.l * this.l) < 0.0) {
            while (-this.L * this.L / (d2 * d2 * d2) + this.k * (d2 - this.l) > 0.0) {
                d2 -= d;
            }
        } else {
            while (-this.L * this.L / (d2 * d2 * d2) + this.k * (d2 - this.l) < 0.0) {
                d2 += d;
            }
        }
        this.rmin = d2;
        while (0.5 * this.L * this.L / this.rmin / this.rmin + 0.5 * this.k * (this.rmin - this.l) * (this.rmin - this.l) < this.E) {
            this.rmin -= d;
        }
        this.rmax = d2;
        while (0.5 * this.L * this.L / this.rmax / this.rmax + 0.5 * this.k * (this.rmax - this.l) * (this.rmax - this.l) < this.E) {
            this.rmax += d;
        }
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public double _method_for_Evolution_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Evolution_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Rod_x() {
        return 0.5 * this.L0 * Math.cos(this.phi);
    }

    public double _method_for_Rod_y() {
        return 0.5 * this.L0 * Math.sin(this.phi);
    }

    public void _method_for_Particle_dragaction() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public double _method_for_Drawing_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Drawing_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Drawing_pressaction() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public double _method_for_Rmax_sizex() {
        return 2.0 * this.rmax;
    }

    public double _method_for_Rmax_sizey() {
        return 2.0 * this.rmax;
    }

    public double _method_for_Rmin_sizex() {
        return 2.0 * this.rmin;
    }

    public double _method_for_Rmin_sizey() {
        return 2.0 * this.rmin;
    }

    public boolean _method_for_xx_editable() {
        return this._isPaused();
    }

    public void _method_for_xx_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public boolean _method_for_yy_editable() {
        return this._isPaused();
    }

    public void _method_for_yy_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public boolean _method_for_uu_editable() {
        return this._isPaused();
    }

    public void _method_for_uu_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public boolean _method_for_vv_editable() {
        return this._isPaused();
    }

    public void _method_for_vv_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public boolean _method_for_kk_editable() {
        return this._isPaused();
    }

    public void _method_for_kk_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public boolean _method_for_ll_editable() {
        return this._isPaused();
    }

    public void _method_for_ll_action() {
        this._simulation.disableLoop();
        this.rmaxmin();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Graphs_maximumX() {
        return 1.5 * this.xmax;
    }

    public void _method_for_Graphs_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_Effective_max() {
        return 1.5 * this.xmax;
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.x = 1.0;
        this.y = 0.0;
        this.u = 1.0;
        this.v = 1.0;
        this.dt = 0.05;
        this.E = 0.0;
        this.L = 1.0;
        this.phi = 0.0;
        this.r = 0.0;
        this.rmin = 0.730675;
        this.rmax = 2.0;
        this.L0 = 4.0;
        this.tol = 1.0E-6;
        this.graph = false;
        this.xmax = 2.2;
        this.Emax = 3.0;
        this.k = 1.75;
        this.l = 1.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _y;
        private double _u;
        private double _v;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = spring.this.x;
            this.__state[n++] = spring.this.y;
            this.__state[n++] = spring.this.u;
            this.__state[n++] = spring.this.v;
            this.__state[n++] = spring.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(spring.this.dt);
        }

        void step() {
            if (spring.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(spring.this.tol);
            }
            if (spring.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(spring.this.dt);
            }
            int n = 0;
            this.__state[n++] = spring.this.x;
            this.__state[n++] = spring.this.y;
            this.__state[n++] = spring.this.u;
            this.__state[n++] = spring.this.v;
            this.__state[n++] = spring.this.t;
            this.__solver.step();
            n = 0;
            spring.this.x = this.__state[n++];
            spring.this.y = this.__state[n++];
            spring.this.u = this.__state[n++];
            spring.this.v = this.__state[n++];
            spring.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._u = dArray[n++];
            this._v = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._y, this._u, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._y, this._u, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._y, this._u, this._v, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._x, this._y, this._u, this._v, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d3;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return d4;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return -spring.this.k * d * (1.0 - spring.this.l / spring.this.hypot(d, d2));
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return -spring.this.k * d2 * (1.0 - spring.this.l / spring.this.hypot(d, d2));
        }
    }
}

