/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.scattering;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlTraceSet;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.TraceSet;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.central_forces.scattering.scattering;
import users.ehu.jma.central_forces.scattering.scatteringSimulation;

class scatteringView
extends EjsControl
implements View {
    private scatteringSimulation _simulation = null;
    private scattering _model = null;
    public Component Main;
    public DrawingPanel2D Evolution;
    public TraceSet Orbits;
    public ElementSet Particles;
    public InteractiveParticle Target;
    public JPanel Controls;
    public JPanel Values;
    public JTextField x0;
    public JTextField bmax;
    public JTextField v0;
    public JTextField k;
    public JTextField R;
    public JTextField n;
    public JTextField dt;
    public JTextField tol;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JButton Clear;

    public scatteringView(scatteringSimulation scatteringSimulation2, String string, Frame frame) {
        super(scatteringSimulation2, string, frame);
        this._simulation = scatteringSimulation2;
        this._model = (scattering)scatteringSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("n", "apply(\"n\")");
        this.addListener("nmax", "apply(\"nmax\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("u", "apply(\"u\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("stopped", "apply(\"stopped\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("R", "apply(\"R\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("bmax", "apply(\"bmax\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("v0", "apply(\"v0\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("rmax", "apply(\"rmax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("stop", "apply(\"stop\")");
        this.addListener("color", "apply(\"color\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        Object[] objectArray;
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("nmax".equals(string)) {
            this._model.nmax = this.getInt("nmax");
        }
        if ("x".equals(string)) {
            objectArray = (double[])this.getValue("x").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = objectArray[n];
            }
        }
        if ("y".equals(string)) {
            objectArray = (double[])this.getValue("y").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.y.length) {
                n2 = this._model.y.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y[n] = objectArray[n];
            }
        }
        if ("u".equals(string)) {
            objectArray = (double[])this.getValue("u").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.u.length) {
                n2 = this._model.u.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.u[n] = objectArray[n];
            }
        }
        if ("v".equals(string)) {
            objectArray = (double[])this.getValue("v").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.v.length) {
                n2 = this._model.v.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.v[n] = objectArray[n];
            }
        }
        if ("stopped".equals(string)) {
            objectArray = (boolean[])this.getValue("stopped").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.stopped.length) {
                n2 = this._model.stopped.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.stopped[n] = objectArray[n];
            }
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("R".equals(string)) {
            this._model.R = this.getDouble("R");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("bmax".equals(string)) {
            this._model.bmax = this.getDouble("bmax");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("v0".equals(string)) {
            this._model.v0 = this.getDouble("v0");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("rmax".equals(string)) {
            this._model.rmax = this.getDouble("rmax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("stop".equals(string)) {
            this._model.stop = this.getBoolean("stop");
        }
        if ("color".equals(string)) {
            objectArray = (Object[])this.getValue("color").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.color.length) {
                n2 = this._model.color.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.color[n] = objectArray[n];
            }
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("n", this._model.n);
        this.setValue("nmax", this._model.nmax);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("u", this._model.u);
        this.setValue("v", this._model.v);
        this.setValue("stopped", this._model.stopped);
        this.setValue("k", this._model.k);
        this.setValue("R", this._model.R);
        this.setValue("t", this._model.t);
        this.setValue("bmax", this._model.bmax);
        this.setValue("x0", this._model.x0);
        this.setValue("v0", this._model.v0);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("rmax", this._model.rmax);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("stop", this._model.stop);
        this.setValue("color", this._model.color);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Newtonian scattering")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "602,364")).getObject();
        this.Evolution = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("pressaction", "_model._method_for_Evolution_pressaction()").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Click to erase")).getObject();
        this.Orbits = (TraceSet)this.addElement(new ControlTraceSet(), "Orbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("elementnumber", "n").setProperty("x", "x").setProperty("y", "y").setProperty("connected", "true").setProperty("color", "color").getObject();
        this.Particles = (ElementSet)this.addElement(new ControlParticleSet(), "Particles").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("elementnumber", "n").setProperty("x", "x").setProperty("y", "y").setProperty("enabled", "false").setProperty("secondaryColor", "red").setProperty("color", "red").getObject();
        this.Target = (InteractiveParticle)this.addElement(new ControlParticle(), "Target").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("sizex", "%_model._method_for_Target_sizex()%").setProperty("sizey", "%_model._method_for_Target_sizey()%").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "blue").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Values = (JPanel)this.addElement(new ControlPanel(), "Values").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "grid:2,6,0,0").getObject();
        this.x0 = (JTextField)this.addElement(new ControlNumberField(), "x0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "x0").setProperty("format", this._simulation.translateString("View.x0.format", "x = 0.##")).setProperty("editable", "%_model._method_for_x0_editable()%").setProperty("action", "_model._method_for_x0_action()").setProperty("tooltip", this._simulation.translateString("View.x0.tooltip", "Initial abscissa")).getObject();
        this.bmax = (JTextField)this.addElement(new ControlNumberField(), "bmax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "bmax").setProperty("format", this._simulation.translateString("View.bmax.format", "bmax = 0.##")).setProperty("editable", "%_model._method_for_bmax_editable()%").setProperty("action", "_model._method_for_bmax_action()").setProperty("tooltip", this._simulation.translateString("View.bmax.tooltip", "Maximum impact parameter")).getObject();
        this.v0 = (JTextField)this.addElement(new ControlNumberField(), "v0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "v0").setProperty("format", this._simulation.translateString("View.v0.format", "v = 0.##")).setProperty("editable", "%_model._method_for_v0_editable()%").setProperty("tooltip", this._simulation.translateString("View.v0.tooltip", "Initial velocity")).getObject();
        this.k = (JTextField)this.addElement(new ControlNumberField(), "k").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "k").setProperty("format", this._simulation.translateString("View.k.format", "k = 0.##")).setProperty("editable", "%_model._method_for_k_editable()%").setProperty("tooltip", this._simulation.translateString("View.k.tooltip", "Force constant")).getObject();
        this.R = (JTextField)this.addElement(new ControlNumberField(), "R").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "R").setProperty("format", this._simulation.translateString("View.R.format", "R = 0.##")).setProperty("editable", "%_model._method_for_R_editable()%").setProperty("tooltip", this._simulation.translateString("View.R.tooltip", "Target radius")).getObject();
        this.n = (JTextField)this.addElement(new ControlNumberField(), "n").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "n").setProperty("format", this._simulation.translateString("View.n.format", "n = 0")).setProperty("editable", "%_model._method_for_n_editable()%").setProperty("action", "_model._method_for_n_action()").setProperty("tooltip", this._simulation.translateString("View.n.tooltip", "Number of particles")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("editable", "%_model._method_for_dt_editable()%").setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step length")).getObject();
        this.tol = (JTextField)this.addElement(new ControlNumberField(), "tol").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.tol.format", "tol = 0.0E0")).setProperty("editable", "%_model._method_for_tol_editable()%").setProperty("tooltip", this._simulation.translateString("View.tol.tooltip", "Maximum relative error in integration")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start/stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
        this.Clear = (JButton)this.addElement(new ControlButton(), "Clear").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Values").setProperty("image", this._simulation.translateString("View.Clear.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "c")).setProperty("action", "_model._method_for_Clear_action()").setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear screen")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Newtonian scattering")).setProperty("visible", "true");
        this.getElement("Evolution").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Evolution.tooltip", "Click to erase"));
        this.getElement("Orbits").setProperty("connected", "true");
        this.getElement("Particles").setProperty("enabled", "false").setProperty("secondaryColor", "red").setProperty("color", "red");
        this.getElement("Target").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "blue");
        this.getElement("Controls");
        this.getElement("Values");
        this.getElement("x0").setProperty("format", this._simulation.translateString("View.x0.format", "x = 0.##")).setProperty("tooltip", this._simulation.translateString("View.x0.tooltip", "Initial abscissa"));
        this.getElement("bmax").setProperty("format", this._simulation.translateString("View.bmax.format", "bmax = 0.##")).setProperty("tooltip", this._simulation.translateString("View.bmax.tooltip", "Maximum impact parameter"));
        this.getElement("v0").setProperty("format", this._simulation.translateString("View.v0.format", "v = 0.##")).setProperty("tooltip", this._simulation.translateString("View.v0.tooltip", "Initial velocity"));
        this.getElement("k").setProperty("format", this._simulation.translateString("View.k.format", "k = 0.##")).setProperty("tooltip", this._simulation.translateString("View.k.tooltip", "Force constant"));
        this.getElement("R").setProperty("format", this._simulation.translateString("View.R.format", "R = 0.##")).setProperty("tooltip", this._simulation.translateString("View.R.tooltip", "Target radius"));
        this.getElement("n").setProperty("format", this._simulation.translateString("View.n.format", "n = 0")).setProperty("tooltip", this._simulation.translateString("View.n.tooltip", "Number of particles"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step length"));
        this.getElement("tol").setProperty("format", this._simulation.translateString("View.tol.format", "tol = 0.0E0")).setProperty("tooltip", this._simulation.translateString("View.tol.tooltip", "Maximum relative error in integration"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start/stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        this.getElement("Clear").setProperty("image", this._simulation.translateString("View.Clear.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.Clear.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Clear.tooltip", "Clear screen"));
        super.reset();
    }
}

