/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.scattering;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.scattering.scatteringSimulation;
import users.ehu.jma.central_forces.scattering.scatteringView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class scattering
extends AbstractModel {
    public scatteringSimulation _simulation = null;
    public scatteringView _view = null;
    public scattering _model = this;
    public int n = 40;
    public int nmax = 100;
    public double[] x;
    public double[] y;
    public double[] u;
    public double[] v;
    public boolean[] stopped;
    public double k = 15.0;
    public double R = 0.5;
    public double t = 0.0;
    public double bmax = 2.0;
    public double x0 = -10.0;
    public double v0 = 5.0;
    public double xmin = -10.0;
    public double xmax = 2.0;
    public double ymin = -3.0;
    public double ymax = 3.0;
    public double rmax = 20.0;
    public double dt = 0.01;
    public double tol = 1.0E-6;
    public boolean stop = false;
    public Object[] color;
    private _ODE_evolution2 _ODEi_evolution2;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/scattering.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        scattering scattering2 = new scattering(stringArray);
    }

    public scattering() {
        this(null, null, null, null, null, false);
    }

    public scattering(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public scattering(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new scatteringSimulation(this, string, frame, uRL, bl);
        this._view = (scatteringView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution2.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.initial();
    }

    public void _evolution1() {
        this.stop = true;
        for (int i = 0; i < this.n; ++i) {
            double d = this.hypot(this.x[i], this.y[i]);
            if (this.stopped[i] || !(d < this.rmax)) continue;
            this.stop = false;
            break;
        }
        if (this.stop) {
            this._pause();
        }
    }

    public void _constraints1() {
        if (this.n < 1) {
            this.n = 1;
        }
        if (this.n > this.nmax) {
            this.n = this.nmax;
        }
        this.rmax = this.hypot(this.xmin, this.ymax) + 0.1;
    }

    public void initial() {
        this.t = 0.0;
        this._view.resetTraces();
        for (int i = 0; i < this.nmax; ++i) {
            this.x[i] = this.x0;
            double d = this.y[i] = this.n > 1 ? -this.bmax + 2.0 * this.bmax / (double)(this.n - 1) * (double)i : this.bmax;
            if (i < this.n) {
                this.stopped[i] = false;
                this.u[i] = this.v0;
                this.v[i] = 0.0;
                this.color[i] = Math.abs(this.y[i]) <= this.R / this.v0 * Math.sqrt(2.0 * (this.k / this.R - this.k / this.hypot(this.x0, this.y[i])) + this.v0 * this.v0) ? Color.red : Color.orange;
                continue;
            }
            this.stopped[i] = true;
            this.v[i] = 0.0;
            this.u[i] = 0.0;
        }
        this._resetSolvers();
    }

    public double vv(int n, double d) {
        return this.stopped[n] ? 0.0 : d;
    }

    public double ax(int n, double d, double d2) {
        if (this.stopped[n]) {
            return 0.0;
        }
        double d3 = this.hypot(d, d2);
        return -this.k * d / d3 / d3 / d3;
    }

    public double ay(int n, double d, double d2) {
        if (this.stopped[n]) {
            return 0.0;
        }
        double d3 = this.hypot(d, d2);
        return -this.k * d2 / d3 / d3 / d3;
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_Evolution_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Target_sizex() {
        return 2.0 * this.R;
    }

    public double _method_for_Target_sizey() {
        return 2.0 * this.R;
    }

    public boolean _method_for_x0_editable() {
        return this._isPaused();
    }

    public void _method_for_x0_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_bmax_editable() {
        return this._isPaused();
    }

    public void _method_for_bmax_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_v0_editable() {
        return this._isPaused();
    }

    public boolean _method_for_k_editable() {
        return this._isPaused();
    }

    public boolean _method_for_R_editable() {
        return this._isPaused();
    }

    public boolean _method_for_n_editable() {
        return this._isPaused();
    }

    public void _method_for_n_action() {
        this._simulation.disableLoop();
        this.initial();
        this._simulation.enableLoop();
    }

    public boolean _method_for_dt_editable() {
        return this._isPaused();
    }

    public boolean _method_for_tol_editable() {
        return this._isPaused();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this.initial();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.n = 40;
        this.nmax = 100;
        this.x = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.y[n] = 0.0;
        }
        this.u = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.u[n] = 0.0;
        }
        this.v = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.v[n] = 0.0;
        }
        this.stopped = new boolean[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.stopped[n] = false;
        }
        this.k = 15.0;
        this.R = 0.5;
        this.t = 0.0;
        this.bmax = 2.0;
        this.x0 = -10.0;
        this.v0 = 5.0;
        this.xmin = -10.0;
        this.xmax = 2.0;
        this.ymin = -3.0;
        this.ymax = 3.0;
        this.rmax = 20.0;
        this.dt = 0.01;
        this.tol = 1.0E-6;
        this.stop = false;
        this.color = new Object[this.nmax];
        this._ODEi_evolution2 = new _ODE_evolution2();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
        this._ODEi_evolution2.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.u = null;
        this.v = null;
        this.stopped = null;
        this.color = null;
        this._ODEi_evolution2 = null;
        System.gc();
    }

    private class _ODE_evolution2
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double[] _x;
        private double[] _y;
        private double[] _u;
        private double[] _v;
        private double _t;

        _ODE_evolution2() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + scattering.this.x.length + scattering.this.y.length + scattering.this.u.length + scattering.this.v.length];
            this._x = new double[scattering.this.x.length];
            this._y = new double[scattering.this.y.length];
            this._u = new double[scattering.this.u.length];
            this._v = new double[scattering.this.v.length];
        }

        private boolean arraysChanged() {
            if (scattering.this.x.length != this._x.length) {
                return true;
            }
            if (scattering.this.y.length != this._y.length) {
                return true;
            }
            if (scattering.this.u.length != this._u.length) {
                return true;
            }
            return scattering.this.v.length != this._v.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : scattering.this.x) {
            }
            for (double this.__state[n++] : scattering.this.y) {
            }
            for (double this.__state[n++] : scattering.this.u) {
            }
            for (double this.__state[n++] : scattering.this.v) {
            }
            this.__state[n++] = scattering.this.t;
            this.__solver = new ODEBisectionEventSolver(this, ODEMultistepSolver.class);
            this.__solver.addEvent(new _ODE_evolution2_Event1());
            this.__solver.initialize(scattering.this.dt);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (scattering.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(scattering.this.tol);
            }
            if (scattering.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(scattering.this.dt);
            }
            int n2 = 0;
            for (double this.__state[n2++] : scattering.this.x) {
            }
            for (double this.__state[n2++] : scattering.this.y) {
            }
            for (double this.__state[n2++] : scattering.this.u) {
            }
            for (double this.__state[n2++] : scattering.this.v) {
            }
            this.__state[n2++] = scattering.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = scattering.this.x.length;
            for (n = 0; n < n3; ++n) {
                scattering.this.x[n] = this.__state[n2++];
            }
            n3 = scattering.this.y.length;
            for (n = 0; n < n3; ++n) {
                scattering.this.y[n] = this.__state[n2++];
            }
            n3 = scattering.this.u.length;
            for (n = 0; n < n3; ++n) {
                scattering.this.u[n] = this.__state[n2++];
            }
            n3 = scattering.this.v.length;
            for (n = 0; n < n3; ++n) {
                scattering.this.v[n] = this.__state[n2++];
            }
            scattering.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = scattering.this.x.length;
            for (n = 0; n < n3; ++n) {
                this._x[n] = dArray[n2++];
            }
            n3 = scattering.this.y.length;
            for (n = 0; n < n3; ++n) {
                this._y[n] = dArray[n2++];
            }
            n3 = scattering.this.u.length;
            for (n = 0; n < n3; ++n) {
                this._u[n] = dArray[n2++];
            }
            n3 = scattering.this.v.length;
            for (n = 0; n < n3; ++n) {
                this._v[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = scattering.this.x.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution2_1(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = scattering.this.y.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution2_2(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = scattering.this.u.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution2_3(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = scattering.this.v.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution2_4(n, this._x, this._y, this._u, this._v, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution2_1(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return scattering.this.vv(n, dArray3[n]);
        }

        private double _ODE_evolution2_2(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return scattering.this.vv(n, dArray4[n]);
        }

        private double _ODE_evolution2_3(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return scattering.this.ax(n, dArray[n], dArray2[n]);
        }

        private double _ODE_evolution2_4(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return scattering.this.ay(n, dArray[n], dArray2[n]);
        }

        private class _ODE_evolution2_Event1
        implements StateEvent {
            private _ODE_evolution2_Event1() {
            }

            public String toString() {
                return "Collision";
            }

            public double getTolerance() {
                return 0.001;
            }

            public double evaluate(double[] dArray) {
                int n;
                int n2 = 0;
                int n3 = scattering.this.x.length;
                for (n = 0; n < n3; ++n) {
                    ((_ODE_evolution2)_ODE_evolution2.this)._x[n] = dArray[n2++];
                }
                n3 = scattering.this.y.length;
                for (n = 0; n < n3; ++n) {
                    ((_ODE_evolution2)_ODE_evolution2.this)._y[n] = dArray[n2++];
                }
                n3 = scattering.this.u.length;
                for (n = 0; n < n3; ++n) {
                    ((_ODE_evolution2)_ODE_evolution2.this)._u[n] = dArray[n2++];
                }
                n3 = scattering.this.v.length;
                for (n = 0; n < n3; ++n) {
                    ((_ODE_evolution2)_ODE_evolution2.this)._v[n] = dArray[n2++];
                }
                _ODE_evolution2.this._t = dArray[n2++];
                return this.userEvaluate(_ODE_evolution2.this._x, _ODE_evolution2.this._y, _ODE_evolution2.this._u, _ODE_evolution2.this._v, _ODE_evolution2.this._t);
            }

            public double userEvaluate(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
                double d2 = 0.001;
                for (int i = 0; i < scattering.this.n; ++i) {
                    double d3;
                    if (scattering.this.stopped[i] || !((d3 = scattering.this.hypot(dArray[i], dArray2[i])) < scattering.this.R) || !(d3 - scattering.this.R < d2)) continue;
                    d2 = d3 - scattering.this.R;
                }
                return d2;
            }

            public boolean action() {
                int n;
                int n2 = 0;
                int n3 = scattering.this.x.length;
                for (n = 0; n < n3; ++n) {
                    scattering.this.x[n] = _ODE_evolution2.this.__state[n2++];
                }
                n3 = scattering.this.y.length;
                for (n = 0; n < n3; ++n) {
                    scattering.this.y[n] = _ODE_evolution2.this.__state[n2++];
                }
                n3 = scattering.this.u.length;
                for (n = 0; n < n3; ++n) {
                    scattering.this.u[n] = _ODE_evolution2.this.__state[n2++];
                }
                n3 = scattering.this.v.length;
                for (n = 0; n < n3; ++n) {
                    scattering.this.v[n] = _ODE_evolution2.this.__state[n2++];
                }
                scattering.this.t = _ODE_evolution2.this.__state[n2++];
                for (n = 0; n < scattering.this.n; ++n) {
                    double d;
                    if (scattering.this.stopped[n] || !((d = scattering.this.hypot(scattering.this.x[n], scattering.this.y[n])) < scattering.this.R)) continue;
                    scattering.this.stopped[n] = true;
                    scattering.this.v[n] = 0.0;
                    scattering.this.u[n] = 0.0;
                }
                n2 = 0;
                for (double ((_ODE_evolution2)_ODE_evolution2.this).__state[n2++] : scattering.this.x) {
                }
                for (double ((_ODE_evolution2)_ODE_evolution2.this).__state[n2++] : scattering.this.y) {
                }
                for (double ((_ODE_evolution2)_ODE_evolution2.this).__state[n2++] : scattering.this.u) {
                }
                for (double ((_ODE_evolution2)_ODE_evolution2.this).__state[n2++] : scattering.this.v) {
                }
                ((_ODE_evolution2)_ODE_evolution2.this).__state[n2++] = scattering.this.t;
                return false;
            }
        }
    }
}

