/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.relative;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlSeparator;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import users.ehu.jma.central_forces.relative.relative;
import users.ehu.jma.central_forces.relative.relativeSimulation;

class relativeView
extends EjsControl
implements View {
    private relativeSimulation _simulation = null;
    private relative _model = null;
    public Component Main;
    public JPanel Up;
    public JSlider Zoom;
    public JPanel Labels;
    public JLabel cm;
    public JLabel rel;
    public JPanel Graphics;
    public DrawingPanel2D CM;
    public InteractiveArrow Runge2;
    public InteractivePoligon PolarOrbit1;
    public InteractivePoligon PolarOrbit2;
    public InteractiveParticle Center2;
    public InteractiveArrow Pos2;
    public InteractiveParticle Particle2;
    public InteractiveTrace Orb2;
    public InteractiveArrow Pos1;
    public InteractiveParticle Particle1;
    public InteractiveTrace Orb1;
    public JSeparator Separator;
    public DrawingPanel2D Relative;
    public InteractiveArrow Runge;
    public InteractivePoligon PolarOrbit;
    public InteractiveArrow RelativePos;
    public InteractiveParticle Particle;
    public InteractiveParticle Center;
    public InteractiveParticle CoM;
    public JPanel Down;
    public JPanel Left;
    public JPanel Buttons;
    public JTextField BE;
    public JTextField Br;
    public JTextField Bphi;
    public JTextField VVx;
    public JCheckBox Battractive;
    public JCheckBox Baway;
    public JCheckBox Borbits;
    public JTextField Becc;
    public JTextField Bdt;
    public JTextField Bphi0;
    public JTextField VVy;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JPanel Right;
    public JSlider alpha;

    public relativeView(relativeSimulation relativeSimulation2, String string, Frame frame) {
        super(relativeSimulation2, string, frame);
        this._simulation = relativeSimulation2;
        this._model = (relative)relativeSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("E", "apply(\"E\")");
        this.addListener("phi0", "apply(\"phi0\")");
        this.addListener("ecc", "apply(\"ecc\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("attractive", "apply(\"attractive\")");
        this.addListener("away", "apply(\"away\")");
        this.addListener("a", "apply(\"a\")");
        this.addListener("Vx", "apply(\"Vx\")");
        this.addListener("Vy", "apply(\"Vy\")");
        this.addListener("X", "apply(\"X\")");
        this.addListener("Y", "apply(\"Y\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("orbits", "apply(\"orbits\")");
        this.addListener("phimax", "apply(\"phimax\")");
        this.addListener("rmax", "apply(\"rmax\")");
        this.addListener("rmin", "apply(\"rmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("zr", "apply(\"zr\")");
        this.addListener("vectors", "apply(\"vectors\")");
        this.addListener("Npoints", "apply(\"Npoints\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("E".equals(string)) {
            this._model.E = this.getDouble("E");
        }
        if ("phi0".equals(string)) {
            this._model.phi0 = this.getDouble("phi0");
        }
        if ("ecc".equals(string)) {
            this._model.ecc = this.getDouble("ecc");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("attractive".equals(string)) {
            this._model.attractive = this.getBoolean("attractive");
        }
        if ("away".equals(string)) {
            this._model.away = this.getBoolean("away");
        }
        if ("a".equals(string)) {
            this._model.a = this.getDouble("a");
        }
        if ("Vx".equals(string)) {
            this._model.Vx = this.getDouble("Vx");
        }
        if ("Vy".equals(string)) {
            this._model.Vy = this.getDouble("Vy");
        }
        if ("X".equals(string)) {
            this._model.X = this.getDouble("X");
        }
        if ("Y".equals(string)) {
            this._model.Y = this.getDouble("Y");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("orbits".equals(string)) {
            this._model.orbits = this.getBoolean("orbits");
        }
        if ("phimax".equals(string)) {
            this._model.phimax = this.getDouble("phimax");
        }
        if ("rmax".equals(string)) {
            this._model.rmax = this.getDouble("rmax");
        }
        if ("rmin".equals(string)) {
            this._model.rmin = this.getDouble("rmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("zr".equals(string)) {
            this._model.zr = this.getDouble("zr");
        }
        if ("vectors".equals(string)) {
            this._model.vectors = this.getBoolean("vectors");
        }
        if ("Npoints".equals(string)) {
            this._model.Npoints = this.getInt("Npoints");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("r", this._model.r);
        this.setValue("phi", this._model.phi);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("E", this._model.E);
        this.setValue("phi0", this._model.phi0);
        this.setValue("ecc", this._model.ecc);
        this.setValue("k", this._model.k);
        this.setValue("attractive", this._model.attractive);
        this.setValue("away", this._model.away);
        this.setValue("a", this._model.a);
        this.setValue("Vx", this._model.Vx);
        this.setValue("Vy", this._model.Vy);
        this.setValue("X", this._model.X);
        this.setValue("Y", this._model.Y);
        this.setValue("dt", this._model.dt);
        this.setValue("orbits", this._model.orbits);
        this.setValue("phimax", this._model.phimax);
        this.setValue("rmax", this._model.rmax);
        this.setValue("rmin", this._model.rmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("zr", this._model.zr);
        this.setValue("vectors", this._model.vectors);
        this.setValue("Npoints", this._model.Npoints);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Relative motion and center-of-mass")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "720,480")).getObject();
        this.Up = (JPanel)this.addElement(new ControlPanel(), "Up").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "Up").setProperty("variable", "xmax").setProperty("minimum", ".1").setProperty("maximum", "10").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.Labels = (JPanel)this.addElement(new ControlPanel(), "Labels").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Up").setProperty("layout", "grid:1,2,0,0").getObject();
        this.cm = (JLabel)this.addElement(new ControlLabel(), "cm").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Labels").setProperty("text", this._simulation.translateString("View.cm.text", "Inertial frame")).setProperty("alignment", "CENTER").setProperty("background", "WHITE").setProperty("foreground", "0,128,0,255").getObject();
        this.rel = (JLabel)this.addElement(new ControlLabel(), "rel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Labels").setProperty("text", this._simulation.translateString("View.rel.text", "Relative motion")).setProperty("alignment", "CENTER").setProperty("background", "WHITE").setProperty("foreground", "RED").getObject();
        this.Graphics = (JPanel)this.addElement(new ControlPanel(), "Graphics").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "hbox").getObject();
        this.CM = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "CM").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphics").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_CM_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_CM_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_CM_pressaction()").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.CM.tooltip", "Click to erase")).getObject();
        this.Runge2 = (InteractiveArrow)this.addElement(new ControlArrow(), "Runge2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "%_model._method_for_Runge2_x()%").setProperty("y", "%_model._method_for_Runge2_y()%").setProperty("sizex", "%_model._method_for_Runge2_sizex()%").setProperty("sizey", "%_model._method_for_Runge2_sizey()%").setProperty("visible", "%_model._method_for_Runge2_visible()%").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta").getObject();
        this.PolarOrbit1 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "PolarOrbit1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("points", "100").setProperty("min", "%_model._method_for_PolarOrbit1_min()%").setProperty("max", "%_model._method_for_PolarOrbit1_max()%").setProperty("variable", "s").setProperty("functionx", "a/(1.+a)*Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "a/(1.+a)*Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "255,128,0,255").setProperty("visible", "%_model._method_for_PolarOrbit1_visible()%").setProperty("enabled", "false").getObject();
        this.PolarOrbit2 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "PolarOrbit2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("points", "100").setProperty("min", "%_model._method_for_PolarOrbit2_min()%").setProperty("max", "%_model._method_for_PolarOrbit2_max()%").setProperty("variable", "s").setProperty("functionx", "-1./(1.+a)*Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "-1./(1.+a)*Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("visible", "%_model._method_for_PolarOrbit2_visible()%").setProperty("enabled", "false").getObject();
        this.Center2 = (InteractiveParticle)this.addElement(new ControlParticle(), "Center2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "X").setProperty("y", "Y").setProperty("enabled", "%_model._method_for_Center2_enabled()%").setProperty("dragaction", "_model._method_for_Center2_dragaction()").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255").getObject();
        this.Pos2 = (InteractiveArrow)this.addElement(new ControlArrow(), "Pos2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "X").setProperty("y", "Y").setProperty("sizex", "%_model._method_for_Pos2_sizex()%").setProperty("sizey", "%_model._method_for_Pos2_sizey()%").setProperty("visible", "vectors").setProperty("enabled", "false").setProperty("color", "255,128,0,255").setProperty("secondaryColor", "255,128,0,255").getObject();
        this.Particle2 = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "%_model._method_for_Particle2_x()%").setProperty("y", "%_model._method_for_Particle2_y()%").setProperty("sizex", "zr").setProperty("sizey", "zr").setProperty("enabled", "false").setProperty("dragaction", "_model._method_for_Particle2_dragaction()").setProperty("action", "_model._method_for_Particle2_action()").setProperty("secondaryColor", "255,128,0,255").setProperty("color", "255,128,0,255").getObject();
        this.Orb2 = (InteractiveTrace)this.addElement(new ControlTrace(), "Orb2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "%_model._method_for_Orb2_x()%").setProperty("y", "%_model._method_for_Orb2_y()%").setProperty("maxpoints", "Npoints").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Orb2_visible()%").setProperty("color", "255,128,0,255").getObject();
        this.Pos1 = (InteractiveArrow)this.addElement(new ControlArrow(), "Pos1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "X").setProperty("y", "Y").setProperty("sizex", "%_model._method_for_Pos1_sizex()%").setProperty("sizey", "%_model._method_for_Pos1_sizey()%").setProperty("visible", "vectors").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue").getObject();
        this.Particle1 = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "%_model._method_for_Particle1_x()%").setProperty("y", "%_model._method_for_Particle1_y()%").setProperty("sizex", "zr").setProperty("sizey", "zr").setProperty("enabled", "false").setProperty("dragaction", "_model._method_for_Particle1_dragaction()").setProperty("action", "_model._method_for_Particle1_action()").setProperty("secondaryColor", "blue").setProperty("color", "blue").getObject();
        this.Orb1 = (InteractiveTrace)this.addElement(new ControlTrace(), "Orb1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "CM").setProperty("x", "%_model._method_for_Orb1_x()%").setProperty("y", "%_model._method_for_Orb1_y()%").setProperty("maxpoints", "Npoints").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "%_model._method_for_Orb1_visible()%").setProperty("color", "blue").getObject();
        this.Separator = (JSeparator)this.addElement(new ControlSeparator(), "Separator").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphics").setProperty("orientation", "VERTICAL").getObject();
        this.Relative = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Relative").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphics").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Relative_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Relative_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Relative_pressaction()").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Relative.tooltip", "Use mouse to choose relative position")).getObject();
        this.Runge = (InteractiveArrow)this.addElement(new ControlArrow(), "Runge").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("x", "%_model._method_for_Runge_x()%").setProperty("y", "%_model._method_for_Runge_y()%").setProperty("sizex", "%_model._method_for_Runge_sizex()%").setProperty("sizey", "%_model._method_for_Runge_sizey()%").setProperty("visible", "orbits").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta").getObject();
        this.PolarOrbit = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "PolarOrbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("points", "100").setProperty("min", "%_model._method_for_PolarOrbit_min()%").setProperty("max", "%_model._method_for_PolarOrbit_max()%").setProperty("variable", "s").setProperty("functionx", "Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("visible", "orbits").setProperty("enabled", "false").getObject();
        this.RelativePos = (InteractiveArrow)this.addElement(new ControlArrow(), "RelativePos").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("sizex", "x").setProperty("sizey", "y").setProperty("visible", "vectors").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", "zr").setProperty("sizey", "zr").setProperty("enabled", "true").setProperty("pressaction", "_model._method_for_Particle_pressaction()").setProperty("dragaction", "_model._method_for_Particle_dragaction()").setProperty("action", "_model._method_for_Particle_action()").setProperty("secondaryColor", "blue").setProperty("color", "blue").getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("sizex", "zr").setProperty("sizey", "zr").setProperty("enabled", "false").setProperty("secondaryColor", "255,128,0,255").setProperty("color", "255,128,0,255").getObject();
        this.CoM = (InteractiveParticle)this.addElement(new ControlParticle(), "CoM").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Relative").setProperty("x", "%_model._method_for_CoM_x()%").setProperty("y", "%_model._method_for_CoM_y()%").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "border").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("layout", "grid:2,7,0,0").getObject();
        this.BE = (JTextField)this.addElement(new ControlNumberField(), "BE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "E").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_BE_action()").setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy")).getObject();
        this.Br = (JTextField)this.addElement(new ControlNumberField(), "Br").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "r").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Br_action()").setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance")).getObject();
        this.Bphi = (JTextField)this.addElement(new ControlNumberField(), "Bphi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle")).getObject();
        this.VVx = (JTextField)this.addElement(new ControlNumberField(), "VVx").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "Vx").setProperty("format", this._simulation.translateString("View.VVx.format", "Vx = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_VVx_action()").setProperty("tooltip", this._simulation.translateString("View.VVx.tooltip", "x component of the center-of-mass velocity")).getObject();
        this.Battractive = (JCheckBox)this.addElement(new ControlCheckBox(), "Battractive").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "attractive").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Battractive.text", "Attractive")).setProperty("mnemonic", this._simulation.translateString("View.Battractive.mnemonic", "a")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Battractive_action()").setProperty("tooltip", this._simulation.translateString("View.Battractive.tooltip", "Is force attractive?")).getObject();
        this.Baway = (JCheckBox)this.addElement(new ControlCheckBox(), "Baway").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "vectors").setProperty("text", this._simulation.translateString("View.Baway.text", "Vectors")).setProperty("mnemonic", this._simulation.translateString("View.Baway.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.Baway.tooltip", "Draw position vectors?")).getObject();
        this.Borbits = (JCheckBox)this.addElement(new ControlCheckBox(), "Borbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "orbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Show orbit?")).getObject();
        this.Becc = (JTextField)this.addElement(new ControlNumberField(), "Becc").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "ecc").setProperty("format", this._simulation.translateString("View.Becc.format", "$\\epsilon$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Becc.tooltip", "Eccentricity")).getObject();
        this.Bdt = (JTextField)this.addElement(new ControlNumberField(), "Bdt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step")).getObject();
        this.Bphi0 = (JTextField)this.addElement(new ControlNumberField(), "Bphi0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phi0").setProperty("format", this._simulation.translateString("View.Bphi0.format", "per = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Bphi0_action()").setProperty("tooltip", this._simulation.translateString("View.Bphi0.tooltip", "Pericentron direction")).getObject();
        this.VVy = (JTextField)this.addElement(new ControlNumberField(), "VVy").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "Vy").setProperty("format", this._simulation.translateString("View.VVy.format", "Vy = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_VVy_action()").setProperty("tooltip", this._simulation.translateString("View.VVy.tooltip", "y component of the center-of-mass velocity")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
        this.Right = (JPanel)this.addElement(new ControlPanel(), "Right").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Down").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.Right.size", "100,0")).getObject();
        this.alpha = (JSlider)this.addElement(new ControlSlider(), "alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Right").setProperty("variable", "a").setProperty("minimum", "0.0").setProperty("maximum", "1.0").setProperty("format", this._simulation.translateString("View.alpha.format", "m2/m1 = 0.##")).setProperty("ticks", "9").setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "Quotient of masses in the range [0,1]")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Relative motion and center-of-mass")).setProperty("visible", "true");
        this.getElement("Up");
        this.getElement("Zoom").setProperty("minimum", ".1").setProperty("maximum", "10").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("Labels");
        this.getElement("cm").setProperty("text", this._simulation.translateString("View.cm.text", "Inertial frame")).setProperty("alignment", "CENTER").setProperty("background", "WHITE").setProperty("foreground", "0,128,0,255");
        this.getElement("rel").setProperty("text", this._simulation.translateString("View.rel.text", "Relative motion")).setProperty("alignment", "CENTER").setProperty("background", "WHITE").setProperty("foreground", "RED");
        this.getElement("Graphics");
        this.getElement("CM").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.CM.tooltip", "Click to erase"));
        this.getElement("Runge2").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta");
        this.getElement("PolarOrbit1").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "a/(1.+a)*Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "a/(1.+a)*Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "255,128,0,255").setProperty("enabled", "false");
        this.getElement("PolarOrbit2").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "-1./(1.+a)*Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "-1./(1.+a)*Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("enabled", "false");
        this.getElement("Center2").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255");
        this.getElement("Pos2").setProperty("enabled", "false").setProperty("color", "255,128,0,255").setProperty("secondaryColor", "255,128,0,255");
        this.getElement("Particle2").setProperty("enabled", "false").setProperty("secondaryColor", "255,128,0,255").setProperty("color", "255,128,0,255");
        this.getElement("Orb2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "255,128,0,255");
        this.getElement("Pos1").setProperty("enabled", "false").setProperty("color", "blue").setProperty("secondaryColor", "blue");
        this.getElement("Particle1").setProperty("enabled", "false").setProperty("secondaryColor", "blue").setProperty("color", "blue");
        this.getElement("Orb1").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Separator").setProperty("orientation", "VERTICAL");
        this.getElement("Relative").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Relative.tooltip", "Use mouse to choose relative position"));
        this.getElement("Runge").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta");
        this.getElement("PolarOrbit").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("enabled", "false");
        this.getElement("RelativePos").setProperty("enabled", "false").setProperty("color", "red").setProperty("secondaryColor", "red");
        this.getElement("Particle").setProperty("enabled", "true").setProperty("secondaryColor", "blue").setProperty("color", "blue");
        this.getElement("Center").setProperty("enabled", "false").setProperty("secondaryColor", "255,128,0,255").setProperty("color", "255,128,0,255");
        this.getElement("CoM").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "0,128,0,255");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Left");
        this.getElement("Buttons");
        this.getElement("BE").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.###")).setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy"));
        this.getElement("Br").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance"));
        this.getElement("Bphi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle"));
        this.getElement("VVx").setProperty("format", this._simulation.translateString("View.VVx.format", "Vx = 0.###")).setProperty("tooltip", this._simulation.translateString("View.VVx.tooltip", "x component of the center-of-mass velocity"));
        this.getElement("Battractive").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Battractive.text", "Attractive")).setProperty("tooltip", this._simulation.translateString("View.Battractive.tooltip", "Is force attractive?"));
        this.getElement("Baway").setProperty("text", this._simulation.translateString("View.Baway.text", "Vectors")).setProperty("mnemonic", this._simulation.translateString("View.Baway.mnemonic", "v")).setProperty("tooltip", this._simulation.translateString("View.Baway.tooltip", "Draw position vectors?"));
        this.getElement("Borbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Show orbit?"));
        this.getElement("Becc").setProperty("format", this._simulation.translateString("View.Becc.format", "$\\epsilon$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Becc.tooltip", "Eccentricity"));
        this.getElement("Bdt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step"));
        this.getElement("Bphi0").setProperty("format", this._simulation.translateString("View.Bphi0.format", "per = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bphi0.tooltip", "Pericentron direction"));
        this.getElement("VVy").setProperty("format", this._simulation.translateString("View.VVy.format", "Vy = 0.###")).setProperty("tooltip", this._simulation.translateString("View.VVy.tooltip", "y component of the center-of-mass velocity"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        this.getElement("Right").setProperty("size", this._simulation.translateString("View.Right.size", "100,0"));
        this.getElement("alpha").setProperty("minimum", "0.0").setProperty("maximum", "1.0").setProperty("format", this._simulation.translateString("View.alpha.format", "m2/m1 = 0.##")).setProperty("ticks", "9").setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "Quotient of masses in the range [0,1]"));
        super.reset();
    }
}

