/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.relative;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.relative.relativeSimulation;
import users.ehu.jma.central_forces.relative.relativeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class relative
extends AbstractModel {
    public relativeSimulation _simulation = null;
    public relativeView _view = null;
    public relative _model = this;
    public double t = 0.0;
    public double r = 1.0;
    public double phi = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double E = -0.5;
    public double phi0 = 0.0;
    public double ecc = 0.0;
    public double k = 1.0;
    public boolean attractive = true;
    public boolean away = false;
    public double a = 0.5;
    public double Vx = 0.0;
    public double Vy = 0.0;
    public double X = 0.0;
    public double Y = 0.0;
    public double dt = 0.1;
    public boolean orbits = true;
    public double phimax = 0.0;
    public double rmax = 0.0;
    public double rmin = 0.0;
    public double xmax = 4.0;
    public double zr = 0.2;
    public boolean vectors = true;
    public int Npoints = 1000;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/relative.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        relative relative2 = new relative(stringArray);
    }

    public relative() {
        this(null, null, null, null, null, false);
    }

    public relative(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public relative(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new relativeSimulation(this, string, frame, uRL, bl);
        this._view = (relativeView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.putphixy();
        this.Y = 0.0;
        this.X = 0.0;
    }

    public void _evolution1() {
        this.phi += this.dt / this.r / this.r;
        if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
        }
        this.r = 1.0 / (this.ecc * Math.cos(this.phi - this.phi0) + this.k);
        this.putxy();
        this.X += this.dt * this.Vx;
        this.Y += this.dt * this.Vy;
    }

    public void _constraints1() {
        if (!this.attractive && this.E <= 0.0) {
            this.E = 0.01;
        } else if (this.E < -0.5) {
            this.E = -0.5;
        }
        this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
    }

    public void _constraints2() {
        this.k = this.attractive ? 1.0 : -1.0;
        this.rmin = 1.0 / (this.ecc + this.k);
        if (this.r < this.rmin) {
            this.r = this.rmin;
        }
        if (this.E < 0.0) {
            this.rmax = 1.0 / (1.0 - this.ecc);
            if (this.r > this.rmax) {
                this.r = this.rmax;
            }
        } else {
            this.rmax = 5.0;
        }
        while (this.phi0 > Math.PI) {
            this.phi0 -= Math.PI * 2;
        }
        while (this.phi0 <= -Math.PI) {
            this.phi0 += Math.PI * 2;
        }
        this.phimax = this.attractive ? (this.E < 0.0 ? Math.PI : (this.E == 0.0 ? 3.0 : Math.acos(-1.0 / this.ecc) - 0.01)) : Math.acos(1.0 / this.ecc) - 0.01;
    }

    public void putxy() {
        this.x = this.r * Math.cos(this.phi);
        this.y = this.r * Math.sin(this.phi);
    }

    public void eraseOrbits() {
        this._view.getElement("Orb1").reset();
        this._view.getElement("Orb2").reset();
    }

    public void putphixy() {
        this.putphi();
        this.putxy();
    }

    public void putphir() {
        this.r = this.hypot(this.x, this.y);
        this.phi = Math.atan2(this.y, this.x);
        if (this.r < this.rmin || this.attractive && this.r > this.rmax) {
            this.E = -this.k / this.r + 0.5 / this.r / this.r;
            this.E = Math.max(this.E, -0.5);
            this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
        }
        if (this.E == -0.5 || this.r <= this.rmin) {
            this.phi0 = this.phi;
        } else {
            double d = Math.max(-1.0, Math.min(1.0, (1.0 / this.r - this.k) / this.ecc));
            d = Math.acos(d);
            this.phi0 = this.away ? this.phi - d : this.phi + d;
        }
        this.eraseOrbits();
    }

    public void pause() {
        this._pause();
        this.away = this.phi > this.phi0 || this.phi < this.phi0 - Math.PI;
    }

    public void putphi() {
        if (this.r <= 0.0) {
            this.r = 1.0;
        }
        if (this.r < this.rmin || this.attractive && this.r > this.rmax) {
            this.E = -this.k / this.r + 0.5 / this.r / this.r;
            this.E = Math.max(this.E, -0.5);
            this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
        }
        if (this.E == -0.5 || this.r <= this.rmin) {
            this.phi = this.phi0;
        } else {
            double d = Math.max(-1.0, Math.min(1.0, (1.0 / this.r - this.k) / this.ecc));
            d = Math.acos(d);
            this.phi0 = this.away ? this.phi + d : this.phi - d;
        }
        this.eraseOrbits();
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public double _method_for_CM_minimumX() {
        return -this.xmax;
    }

    public double _method_for_CM_minimumY() {
        return -this.xmax;
    }

    public void _method_for_CM_pressaction() {
        this._simulation.disableLoop();
        this.eraseOrbits();
        this._simulation.enableLoop();
    }

    public double _method_for_Runge2_x() {
        return -this.rmax * this.a / (1.0 + this.a) * Math.cos(this.phi0);
    }

    public double _method_for_Runge2_y() {
        return -this.rmax * this.a / (1.0 + this.a) * Math.sin(this.phi0);
    }

    public double _method_for_Runge2_sizex() {
        return (this.rmin + this.rmax + 0.5) * Math.cos(this.phi0);
    }

    public double _method_for_Runge2_sizey() {
        return (this.rmin + this.rmax + 0.5) * Math.sin(this.phi0);
    }

    public boolean _method_for_Runge2_visible() {
        return this.orbits && this.Vx == 0.0 && this.Vy == 0.0;
    }

    public double _method_for_PolarOrbit1_min() {
        return this.phi0 - this.phimax;
    }

    public double _method_for_PolarOrbit1_max() {
        return this.phi0 + this.phimax;
    }

    public boolean _method_for_PolarOrbit1_visible() {
        return this.orbits && this.Vx == 0.0 && this.Vy == 0.0;
    }

    public double _method_for_PolarOrbit2_min() {
        return this.phi0 - this.phimax;
    }

    public double _method_for_PolarOrbit2_max() {
        return this.phi0 + this.phimax;
    }

    public boolean _method_for_PolarOrbit2_visible() {
        return this.orbits && this.Vx == 0.0 && this.Vy == 0.0;
    }

    public boolean _method_for_Center2_enabled() {
        return this.Vx != 0.0 || this.Vy != 0.0;
    }

    public void _method_for_Center2_dragaction() {
        this._simulation.disableLoop();
        this.eraseOrbits();
        this._simulation.enableLoop();
    }

    public double _method_for_Pos2_sizex() {
        return this.a * this.x / (1.0 + this.a);
    }

    public double _method_for_Pos2_sizey() {
        return this.a * this.y / (1.0 + this.a);
    }

    public double _method_for_Particle2_x() {
        return this.X + this.a * this.x / (1.0 + this.a);
    }

    public double _method_for_Particle2_y() {
        return this.Y + this.a * this.y / (1.0 + this.a);
    }

    public void _method_for_Particle2_dragaction() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle2_action() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public double _method_for_Orb2_x() {
        return this.X + this.a * this.x / (1.0 + this.a);
    }

    public double _method_for_Orb2_y() {
        return this.Y + this.a * this.y / (1.0 + this.a);
    }

    public boolean _method_for_Orb2_visible() {
        return this.orbits && (this.Vx != 0.0 || this.Vy != 0.0);
    }

    public double _method_for_Pos1_sizex() {
        return -this.x / (1.0 + this.a);
    }

    public double _method_for_Pos1_sizey() {
        return -this.y / (1.0 + this.a);
    }

    public double _method_for_Particle1_x() {
        return this.X - this.x / (1.0 + this.a);
    }

    public double _method_for_Particle1_y() {
        return this.Y - this.y / (1.0 + this.a);
    }

    public void _method_for_Particle1_dragaction() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle1_action() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public double _method_for_Orb1_x() {
        return this.X - this.x / (1.0 + this.a);
    }

    public double _method_for_Orb1_y() {
        return this.Y - this.y / (1.0 + this.a);
    }

    public boolean _method_for_Orb1_visible() {
        return this.orbits && (this.Vx != 0.0 || this.Vy != 0.0);
    }

    public double _method_for_Relative_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Relative_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Relative_pressaction() {
        this._simulation.disableLoop();
        this.pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Runge_x() {
        return -this.rmax * Math.cos(this.phi0);
    }

    public double _method_for_Runge_y() {
        return -this.rmax * Math.sin(this.phi0);
    }

    public double _method_for_Runge_sizex() {
        return (this.rmin + this.rmax + 0.5) * Math.cos(this.phi0);
    }

    public double _method_for_Runge_sizey() {
        return (this.rmin + this.rmax + 0.5) * Math.sin(this.phi0);
    }

    public double _method_for_PolarOrbit_min() {
        return this.phi0 - this.phimax;
    }

    public double _method_for_PolarOrbit_max() {
        return this.phi0 + this.phimax;
    }

    public void _method_for_Particle_pressaction() {
        this._simulation.disableLoop();
        this.pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle_dragaction() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle_action() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public double _method_for_CoM_x() {
        return this.a * this.x / (1.0 + this.a);
    }

    public double _method_for_CoM_y() {
        return this.a * this.y / (1.0 + this.a);
    }

    public void _method_for_BE_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Br_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_VVx_action() {
        this._simulation.disableLoop();
        this.eraseOrbits();
        this._simulation.enableLoop();
    }

    public void _method_for_Battractive_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Bphi0_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_VVy_action() {
        this._simulation.disableLoop();
        this.eraseOrbits();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.r = 1.0;
        this.phi = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.E = -0.5;
        this.phi0 = 0.0;
        this.ecc = 0.0;
        this.k = 1.0;
        this.attractive = true;
        this.away = false;
        this.a = 0.5;
        this.Vx = 0.0;
        this.Vy = 0.0;
        this.X = 0.0;
        this.Y = 0.0;
        this.dt = 0.1;
        this.orbits = true;
        this.phimax = 0.0;
        this.rmax = 0.0;
        this.rmin = 0.0;
        this.xmax = 4.0;
        this.zr = 0.2;
        this.vectors = true;
        this.Npoints = 1000;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

