/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.precession;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.central_forces.precession.precession;
import users.ehu.jma.central_forces.precession.precessionSimulation;

class precessionView
extends EjsControl
implements View {
    private precessionSimulation _simulation = null;
    private precession _model = null;
    public Component Main;
    public JPanel Graphs;
    public PlottingPanel2D Dim1;
    public InteractiveParticle Axis0;
    public InteractivePoligon Effective;
    public InteractiveArrow EnergyLevel;
    public InteractiveArrow Min;
    public InteractiveArrow Max;
    public InteractiveParticle Particle1;
    public PlottingPanel2D Orb;
    public InteractiveParticle Center;
    public InteractiveTrace Orbit;
    public InteractiveParticle zmin;
    public InteractiveParticle zmax;
    public InteractiveParticle Particle;
    public JSlider Zoom;
    public JPanel Bottom;
    public JPanel Buttons;
    public JTextField sigmaParameter;
    public JTextField BE;
    public JTextField Br;
    public JCheckBox Borbits;
    public JCheckBox bLimits;
    public JCheckBox AreaVel;
    public JTextField Bdt;
    public JTextField bTol;
    public JTextField Bphi;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;

    public precessionView(precessionSimulation precessionSimulation2, String string, Frame frame) {
        super(precessionSimulation2, string, frame);
        this._simulation = precessionSimulation2;
        this._model = (precession)precessionSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("E", "apply(\"E\")");
        this.addListener("rv", "apply(\"rv\")");
        this.addListener("sigma", "apply(\"sigma\")");
        this.addListener("E0", "apply(\"E0\")");
        this.addListener("areavel", "apply(\"areavel\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("orbits", "apply(\"orbits\")");
        this.addListener("apsides", "apply(\"apsides\")");
        this.addListener("phimax", "apply(\"phimax\")");
        this.addListener("rmax", "apply(\"rmax\")");
        this.addListener("rmin", "apply(\"rmin\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("dtt", "apply(\"dtt\")");
        this.addListener("rr", "apply(\"rr\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("E".equals(string)) {
            this._model.E = this.getDouble("E");
        }
        if ("rv".equals(string)) {
            this._model.rv = this.getDouble("rv");
        }
        if ("sigma".equals(string)) {
            this._model.sigma = this.getDouble("sigma");
        }
        if ("E0".equals(string)) {
            this._model.E0 = this.getDouble("E0");
        }
        if ("areavel".equals(string)) {
            this._model.areavel = this.getBoolean("areavel");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("orbits".equals(string)) {
            this._model.orbits = this.getBoolean("orbits");
        }
        if ("apsides".equals(string)) {
            this._model.apsides = this.getBoolean("apsides");
        }
        if ("phimax".equals(string)) {
            this._model.phimax = this.getDouble("phimax");
        }
        if ("rmax".equals(string)) {
            this._model.rmax = this.getDouble("rmax");
        }
        if ("rmin".equals(string)) {
            this._model.rmin = this.getDouble("rmin");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("dtt".equals(string)) {
            this._model.dtt = this.getDouble("dtt");
        }
        if ("rr".equals(string)) {
            this._model.rr = this.getDouble("rr");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("r", this._model.r);
        this.setValue("phi", this._model.phi);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("E", this._model.E);
        this.setValue("rv", this._model.rv);
        this.setValue("sigma", this._model.sigma);
        this.setValue("E0", this._model.E0);
        this.setValue("areavel", this._model.areavel);
        this.setValue("dt", this._model.dt);
        this.setValue("orbits", this._model.orbits);
        this.setValue("apsides", this._model.apsides);
        this.setValue("phimax", this._model.phimax);
        this.setValue("rmax", this._model.rmax);
        this.setValue("rmin", this._model.rmin);
        this.setValue("tol", this._model.tol);
        this.setValue("dtt", this._model.dtt);
        this.setValue("rr", this._model.rr);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Non Newtonian central force")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "636,354")).getObject();
        this.Graphs = (JPanel)this.addElement(new ControlPanel(), "Graphs").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border:0,0").getObject();
        this.Dim1 = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Dim1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumX", "rr").setProperty("minimumY", "%_model._method_for_Dim1_minimumY()%").setProperty("maximumY", "3").setProperty("pressaction", "_model._method_for_Dim1_pressaction()").setProperty("title", this._simulation.translateString("View.Dim1.title", "Equivalent problem")).setProperty("axesType", "Cartesian2").setProperty("titleX", this._simulation.translateString("View.Dim1.titleX", "r")).setProperty("titleY", this._simulation.translateString("View.Dim1.titleY", "Energy")).setProperty("square", "false").setProperty("showCoordinates", "true").setProperty("xFormat", this._simulation.translateString("View.Dim1.xFormat", "r=0.###")).setProperty("yFormat", this._simulation.translateString("View.Dim1.yFormat", "E=0.###")).setProperty("tooltip", this._simulation.translateString("View.Dim1.tooltip", "You may use the mouse to change E and r")).getObject();
        this.Axis0 = (InteractiveParticle)this.addElement(new ControlParticle(), "Axis0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "100").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("color", "null").getObject();
        this.Effective = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Effective").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("points", "100").setProperty("min", ".1").setProperty("max", "rr").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-1/s+.5*(1+sigma)/s/s").setProperty("javaSyntax", "true").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.EnergyLevel = (InteractiveArrow)this.addElement(new ControlArrow(), "EnergyLevel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "rmin").setProperty("y", "E").setProperty("sizex", "%_model._method_for_EnergyLevel_sizex()%").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "blue").getObject();
        this.Min = (InteractiveArrow)this.addElement(new ControlArrow(), "Min").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "rmin").setProperty("sizex", "0").setProperty("sizey", "E").setProperty("visible", "apsides").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.Max = (InteractiveArrow)this.addElement(new ControlArrow(), "Max").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "rmax").setProperty("sizex", "0").setProperty("sizey", "E").setProperty("visible", "apsides").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").getObject();
        this.Particle1 = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "r").setProperty("y", "E").setProperty("z", "0.0").setProperty("sizex", "%_model._method_for_Particle1_sizex()%").setProperty("sizey", "%_model._method_for_Particle1_sizey()%").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Particle1_dragaction()").setProperty("action", "_model._method_for_Particle1_action()").setProperty("color", "magenta").getObject();
        this.Orb = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Orb").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Orb_minimumX()%").setProperty("maximumX", "%_model._method_for_Orb_maximumX()%").setProperty("minimumY", "%_model._method_for_Orb_minimumY()%").setProperty("maximumY", "%_model._method_for_Orb_maximumY()%").setProperty("pressaction", "_model._method_for_Orb_pressaction()").setProperty("title", this._simulation.translateString("View.Orb.title", "Orbit")).setProperty("axesType", "Cartesian3").setProperty("titleX", this._simulation.translateString("View.Orb.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.Orb.titleY", "y")).setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Orb.tooltip", "Click to erase the orbit")).getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Orb").setProperty("enabled", "false").setProperty("color", "black").getObject();
        this.Orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "Orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Orb").setProperty("x", "x").setProperty("y", "y").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "orbits").setProperty("color", "blue").getObject();
        this.zmin = (InteractiveParticle)this.addElement(new ControlParticle(), "zmin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Orb").setProperty("sizex", "%_model._method_for_zmin_sizex()%").setProperty("sizey", "%_model._method_for_zmin_sizey()%").setProperty("visible", "apsides").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null").getObject();
        this.zmax = (InteractiveParticle)this.addElement(new ControlParticle(), "zmax").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Orb").setProperty("sizex", "%_model._method_for_zmax_sizex()%").setProperty("sizey", "%_model._method_for_zmax_sizey()%").setProperty("visible", "apsides").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Orb").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_Particle_dragaction()").setProperty("action", "_model._method_for_Particle_action()").setProperty("color", "magenta").getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Graphs").setProperty("variable", "rr").setProperty("minimum", "1").setProperty("maximum", "15").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Maximum r displayed")).getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "grid:2,6,0,0").getObject();
        this.sigmaParameter = (JTextField)this.addElement(new ControlNumberField(), "sigmaParameter").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "sigma").setProperty("format", this._simulation.translateString("View.sigmaParameter.format", "$\\sigma$ = 0.#######")).setProperty("editable", "%_model._method_for_sigmaParameter_editable()%").setProperty("action", "_model._method_for_sigmaParameter_action()").setProperty("tooltip", this._simulation.translateString("View.sigmaParameter.tooltip", "Relative value of non-Newtonian term")).getObject();
        this.BE = (JTextField)this.addElement(new ControlNumberField(), "BE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "E").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.######")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_BE_action()").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy")).getObject();
        this.Br = (JTextField)this.addElement(new ControlNumberField(), "Br").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "r").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Br_action()").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance")).getObject();
        this.Borbits = (JCheckBox)this.addElement(new ControlCheckBox(), "Borbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "orbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Draw orbit?")).getObject();
        this.bLimits = (JCheckBox)this.addElement(new ControlCheckBox(), "bLimits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "apsides").setProperty("text", this._simulation.translateString("View.bLimits.text", "Apsides")).setProperty("mnemonic", this._simulation.translateString("View.bLimits.mnemonic", "a")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.bLimits.tooltip", "Show circles of maximum and minimum distance?")).getObject();
        this.AreaVel = (JCheckBox)this.addElement(new ControlCheckBox(), "AreaVel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "areavel").setProperty("text", this._simulation.translateString("View.AreaVel.text", "Use L")).setProperty("mnemonic", this._simulation.translateString("View.AreaVel.mnemonic", "u")).setProperty("tooltip", this._simulation.translateString("View.AreaVel.tooltip", "Use angular momentum conservation in animation?")).getObject();
        this.Bdt = (JTextField)this.addElement(new ControlNumberField(), "Bdt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step")).getObject();
        this.bTol = (JTextField)this.addElement(new ControlNumberField(), "bTol").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.bTol.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.bTol.tooltip", "Maximum relative error in integration")).getObject();
        this.Bphi = (JTextField)this.addElement(new ControlNumberField(), "Bphi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Non Newtonian central force")).setProperty("visible", "true");
        this.getElement("Graphs");
        this.getElement("Dim1").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumY", "3").setProperty("title", this._simulation.translateString("View.Dim1.title", "Equivalent problem")).setProperty("axesType", "Cartesian2").setProperty("titleY", this._simulation.translateString("View.Dim1.titleY", "Energy")).setProperty("square", "false").setProperty("showCoordinates", "true").setProperty("xFormat", this._simulation.translateString("View.Dim1.xFormat", "r=0.###")).setProperty("yFormat", this._simulation.translateString("View.Dim1.yFormat", "E=0.###")).setProperty("tooltip", this._simulation.translateString("View.Dim1.tooltip", "You may use the mouse to change E and r"));
        this.getElement("Axis0").setProperty("x", "0").setProperty("y", "0").setProperty("sizex", "100").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("color", "null");
        this.getElement("Effective").setProperty("points", "100").setProperty("min", ".1").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-1/s+.5*(1+sigma)/s/s").setProperty("javaSyntax", "true").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("EnergyLevel").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "blue");
        this.getElement("Min").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("Max").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255");
        this.getElement("Particle1").setProperty("z", "0.0").setProperty("enabled", "true").setProperty("color", "magenta");
        this.getElement("Orb").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Orb.title", "Orbit")).setProperty("axesType", "Cartesian3").setProperty("square", "true").setProperty("tooltip", this._simulation.translateString("View.Orb.tooltip", "Click to erase the orbit"));
        this.getElement("Center").setProperty("enabled", "false").setProperty("color", "black");
        this.getElement("Orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("zmin").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null");
        this.getElement("zmax").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null");
        this.getElement("Particle").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("enabled", "true").setProperty("color", "magenta");
        this.getElement("Zoom").setProperty("minimum", "1").setProperty("maximum", "15").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Maximum r displayed"));
        this.getElement("Bottom").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Buttons");
        this.getElement("sigmaParameter").setProperty("format", this._simulation.translateString("View.sigmaParameter.format", "$\\sigma$ = 0.#######")).setProperty("tooltip", this._simulation.translateString("View.sigmaParameter.tooltip", "Relative value of non-Newtonian term"));
        this.getElement("BE").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.######")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy"));
        this.getElement("Br").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance"));
        this.getElement("Borbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Draw orbit?"));
        this.getElement("bLimits").setProperty("text", this._simulation.translateString("View.bLimits.text", "Apsides")).setProperty("mnemonic", this._simulation.translateString("View.bLimits.mnemonic", "a")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.bLimits.tooltip", "Show circles of maximum and minimum distance?"));
        this.getElement("AreaVel").setProperty("text", this._simulation.translateString("View.AreaVel.text", "Use L")).setProperty("mnemonic", this._simulation.translateString("View.AreaVel.mnemonic", "u")).setProperty("tooltip", this._simulation.translateString("View.AreaVel.tooltip", "Use angular momentum conservation in animation?"));
        this.getElement("Bdt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step"));
        this.getElement("bTol").setProperty("format", this._simulation.translateString("View.bTol.format", "tol = 0.##E0")).setProperty("tooltip", this._simulation.translateString("View.bTol.tooltip", "Maximum relative error in integration"));
        this.getElement("Bphi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        super.reset();
    }
}

