/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.precession;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.precession.precessionSimulation;
import users.ehu.jma.central_forces.precession.precessionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class precession
extends AbstractModel {
    public precessionSimulation _simulation = null;
    public precessionView _view = null;
    public precession _model = this;
    public double t = 0.0;
    public double r = 1.0;
    public double phi = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double E = -0.3;
    public double rv = 0.0;
    public double sigma = 0.0;
    public double E0 = -0.3;
    public boolean areavel = true;
    public double dt = 0.1;
    public boolean orbits = true;
    public boolean apsides = true;
    public double phimax = 0.0;
    public double rmax = 1.0;
    public double rmin = 1.0;
    public double tol = 1.0E-6;
    public double dtt = 0.0;
    public double rr = 6.0;
    private _ODE_evolution2 _ODEi_evolution2;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/precession.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ehu/jma/central_forces/orbits.gif");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        precession precession2 = new precession(stringArray);
    }

    public precession() {
        this(null, null, null, null, null, false);
    }

    public precession(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public precession(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new precessionSimulation(this, string, frame, uRL, bl);
        this._view = (precessionView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution2.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.putphixy();
    }

    public void _evolution1() {
        this.dtt = this.areavel ? this.dt : this.dt / this.hypot(this.rv, 1.0 / this.r / this.r);
    }

    public void _evolution3() {
        if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
        }
        this.putxy();
    }

    public void _constraints1() {
        this.E0 = -0.5 / (1.0 + this.sigma);
        if (this.E < this.E0) {
            this.E = this.E0;
        }
        double d = 0.01;
        this.rmin = 1.0 + this.sigma;
        while (0.5 * (1.0 + this.sigma) / this.rmin / this.rmin - 1.0 / this.rmin < this.E) {
            this.rmin -= d;
        }
        if (this.E >= 0.0) {
            this.rmax = 10000.0;
        } else {
            this.rmax = 1.0 + this.sigma;
            while (0.5 * (1.0 + this.sigma) / this.rmax / this.rmax - 1.0 / this.rmax < this.E) {
                this.rmax += d;
            }
        }
    }

    public void putE() {
        if (this.E < -0.5 / (1.0 + this.sigma)) {
            this.E = -0.5 / (1.0 + this.sigma);
        }
        this.E = Math.max(this.E, 0.5 * (1.0 + this.sigma) / this.r / this.r - 1.0 / this.r);
        this.rv = Math.sqrt(2.0 * (this.E - 0.5 * (1.0 + this.sigma) / this.r / this.r + 1.0 / this.r));
    }

    public void putxy() {
        this.x = this.r * Math.cos(this.phi);
        this.y = this.r * Math.sin(this.phi);
    }

    public void putphixy() {
        this.putE();
        this.putxy();
    }

    public void putphir() {
        this.r = this.hypot(this.x, this.y);
        this.putE();
        this.phi = Math.atan2(this.y, this.x);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public double _method_for_Dim1_minimumY() {
        return this.E0 - 0.5;
    }

    public void _method_for_Dim1_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_EnergyLevel_sizex() {
        return this.rmax - this.rmin;
    }

    public double _method_for_Particle1_sizex() {
        return this.rr / 40.0;
    }

    public double _method_for_Particle1_sizey() {
        return (3.5 - this.E0) / 40.0;
    }

    public void _method_for_Particle1_dragaction() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle1_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_Orb_minimumX() {
        return -this.rr / 2.0;
    }

    public double _method_for_Orb_maximumX() {
        return this.rr / 2.0;
    }

    public double _method_for_Orb_minimumY() {
        return -this.rr / 2.0;
    }

    public double _method_for_Orb_maximumY() {
        return this.rr / 2.0;
    }

    public void _method_for_Orb_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_zmin_sizex() {
        return 2.0 * this.rmin;
    }

    public double _method_for_zmin_sizey() {
        return 2.0 * this.rmin;
    }

    public double _method_for_zmax_sizex() {
        return 2.0 * this.rmax;
    }

    public double _method_for_zmax_sizey() {
        return 2.0 * this.rmax;
    }

    public void _method_for_Particle_dragaction() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle_action() {
        this._simulation.disableLoop();
        this.putphir();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public boolean _method_for_sigmaParameter_editable() {
        return this._isPaused();
    }

    public void _method_for_sigmaParameter_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_BE_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Br_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.r = 1.0;
        this.phi = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.E = -0.3;
        this.rv = 0.0;
        this.sigma = 0.0;
        this.E0 = -0.3;
        this.areavel = true;
        this.dt = 0.1;
        this.orbits = true;
        this.apsides = true;
        this.phimax = 0.0;
        this.rmax = 1.0;
        this.rmin = 1.0;
        this.tol = 1.0E-6;
        this.dtt = 0.0;
        this.rr = 6.0;
        this._ODEi_evolution2 = new _ODE_evolution2();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
        this._ODEi_evolution2.step();
        this._evolution3();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution2 = null;
        System.gc();
    }

    private class _ODE_evolution2
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _r;
        private double _rv;
        private double _phi;
        private double _t;

        _ODE_evolution2() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = precession.this.r;
            this.__state[n++] = precession.this.rv;
            this.__state[n++] = precession.this.phi;
            this.__state[n++] = precession.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(precession.this.dtt);
        }

        void step() {
            if (precession.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(precession.this.tol);
            }
            if (precession.this.dtt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(precession.this.dtt);
            }
            int n = 0;
            this.__state[n++] = precession.this.r;
            this.__state[n++] = precession.this.rv;
            this.__state[n++] = precession.this.phi;
            this.__state[n++] = precession.this.t;
            this.__solver.step();
            n = 0;
            precession.this.r = this.__state[n++];
            precession.this.rv = this.__state[n++];
            precession.this.phi = this.__state[n++];
            precession.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._r = dArray[n++];
            this._rv = dArray[n++];
            this._phi = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution2_1(this._r, this._rv, this._phi, this._t);
            dArray2[n++] = this._ODE_evolution2_2(this._r, this._rv, this._phi, this._t);
            dArray2[n++] = this._ODE_evolution2_3(this._r, this._rv, this._phi, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution2_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution2_2(double d, double d2, double d3, double d4) {
            return (1.0 + precession.this.sigma) / (d * d * d) - 1.0 / d / d;
        }

        private double _ODE_evolution2_3(double d, double d2, double d3, double d4) {
            return 1.0 / (d * d);
        }
    }
}

