/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.periodic;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Dopri853;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.periodic.periodicSimulation;
import users.ehu.jma.central_forces.periodic.periodicView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class periodic
extends AbstractModel {
    public periodicSimulation _simulation = null;
    public periodicView _view = null;
    public periodic _model = this;
    public int nmax = 5;
    public int n = 3;
    public double[] x;
    public double[] y;
    public double[] u;
    public double[] v;
    public double t = 0.0;
    public double tol = 1.0E-10;
    public double dt = 0.01;
    public int orbits = 200;
    public int type = 0;
    public Object[] colors;
    public double xmax = 1.5;
    public int norbits = 24;
    private _ODE_evolution1 _ODEi_evolution1;
    String[] names = new String[]{"Moore", "Sim\u00f3 1", "Sim\u00f3 2", "Sim\u00f3 3", "Sim\u00f3 4", "Sim\u00f3 5", "Sim\u00f3 6", "Sim\u00f3 7", "Sim\u00f3 8", "Sim\u00f3 9", "Sim\u00f3 10", "Sim\u00f3 11", "Sim\u00f3 12", "Sim\u00f3 13", "Sim\u00f3 14", "Sim\u00f3 15", "Sim\u00f3 16", "Sim\u00f3 17", "Sim\u00f3 18", "Sim\u00f3 19", "Sim\u00f3 20", "Sim\u00f3 21", "Sim\u00f3 22", "Sim\u00f3 23"};
    int[] npart = new int[]{3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    double[] xdim = new double[]{0.65, 0.8, 0.8, 1.0, 0.65, 0.9, 1.0, 0.85, 1.1, 0.65, 0.8, 1.2, 0.9, 0.9, 1.0, 0.8, 0.8, 0.9, 0.75, 0.75, 0.65, 0.8, 0.65, 0.85};
    double[] xyuv = new double[]{-0.97000436, 0.24308753, -0.466203685, -0.43236573, 0.97000436, -0.24308753, -0.466203685, -0.43236573, 0.0, 0.0, 0.93240737, 0.86473146, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.38285684361842, 0.0, 0.0, 0.584872630814873, 0.0, -0.157029922281218, -1.87193524587868, 0.0, -1.38285684361842, 0.0, 0.0, -0.584872630814873, 0.0, 0.157029922281218, 1.87193524587868, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3084722916743, 0.0, 0.0, 0.411944964735883, -0.0533985772189845, -0.475560020307925, -1.09011640423887, -0.64931992050408, -1.20167513723633, 0.0, 0.0, 0.886694876272276, -0.053398577218983, 0.475560020307924, 1.09011640423887, -0.649319920504079, 0.0, 0.0, 0.0, 0.0, 1.00231488346205, 0.0, 0.0, -0.29379027773203, -0.528694094023631, 0.567125954067238, -0.175826619093917, 1.02361310165053, 0.05507330458521, 0.0, 0.0, -1.75343592556901, -0.528694094023634, -0.567125954067236, 0.175826619093916, 1.02361310165052, 0.0, 0.0, 0.0, 0.0, 1.2077101785817, 0.0, 0.0, 0.590541176087202, -0.530503227535756, 0.051543724217618, -3.50865335142232, 0.267232711784397, -0.146703723510176, 0.0, 0.0, -1.12500659965584, -0.530503227535764, -0.0515437242176267, 3.5086533514223, 0.267232711784241, 0.0, 0.0, 0.0, 0.0, 1.65766601254927, 0.0, 0.0, 0.593785277963254, 0.439775050426293, -0.169716862319624, -1.82278548762725, -0.12824800560005, -1.26860805670092, -0.267650773258184, -1.2715639365749, -0.168644633381599, -1.26860805670093, 0.267650773258185, 1.2715639365749, -0.168644633381582, 0.439775050426291, 0.169716862319622, 1.82278548762726, -0.128248005600023, 0.955063306934644, 0.0, 0.0, 0.224477866326988, 0.017138123273294, -0.799614781300969, 0.315099534183334, -0.816298861454279, -0.160691656488542, 0.268624002435672, -1.07570772248831, 2.33259087218768, 0.057619315003466, 0.477031466082465, 0.0519610447239324, -1.95999321288874, -0.869129088722862, 0.0539593127828328, 0.708647143581039, 0.219223335828347, 1.44868675914712, 0.0, 0.0, -0.921498443845218, 0.400382201553443, -0.345221534979449, -1.33515781276618, 0.80950945912197, -1.124725581127, 0.448292482373979, -0.919118216276916, -0.34876023719937, -1.124725581127, -0.448292482373982, 0.919118216276916, -0.348760237199364, 0.400382201553442, 0.345221534979452, 1.33515781276618, 0.809509459121982, 0.964424372298569, 0.0, 0.0, -0.138501846852103, -0.0464908629716353, 0.862620205201214, 0.18438340873985, 0.69976747831906, -0.435721323177649, -0.103616707577587, -2.4934538659574, -0.630516554893019, -0.435721323177649, 0.103616707577587, 2.4934538659574, -0.630516554892999, -0.0464908629716352, -0.862620205201214, -0.184383408739851, 0.699767478319061, 0.367302752558756, 0.0, 0.0, 2.13480823891351, 0.676023172122292, -0.185202363961882, -2.13811566358165, -0.731148298714056, -0.85967454840167, -0.389735175088206, 0.536585453050207, -0.336255820742697, -0.85967454840167, 0.389735175088206, -0.536585453050207, -0.336255820742696, 0.676023172122292, 0.185202363961882, 2.13811566358165, -0.731148298714056, 0.479973011541914, 0.0, 0.0, 1.64418280644252, 0.862931274392285, -0.261036578940572, -1.6851294569332, -0.726179532385241, -1.10291778016324, -0.28981014826966, -1.21994203708136, -0.0959118708360201, -1.10291778016324, 0.28981014826966, 1.21994203708136, -0.0959118708360197, 0.862931274392285, 0.261036578940572, 1.6851294569332, -0.726179532385241, 0.229752981150401, 0.0, 0.0, 1.82152669120022, 0.652919352041286, 0.943822318931204, 0.222393460422703, -0.499724468743892, -0.767795842616486, -0.199686600822279, -1.60766862056937, -0.411038876856216, -0.767795842616486, 0.199686600822279, 1.60766862056937, -0.411038876856216, 0.652919352041286, -0.943822318931204, -0.222393460422703, -0.499724468743892, 1.59207262037658, 0.0, 0.0, -0.46942218187551, 0.389466915571531, 0.36065915957754, -1.26264216272448, 0.60421490722545, -1.18550322575982, -0.211611493757751, -1.48942547710392, -0.369503816287694, -1.18550322575982, 0.211611493757751, 1.48942547710392, -0.369503816287694, 0.38946691557153, -0.36065915957754, 1.26264216272448, 0.604214907225449, 0.279485121988217, 0.0, 0.0, 1.85154361733484, 0.809587586714766, 0.523073055668605, -0.18075022943322, -1.0043912998909, -0.949330147708874, 0.288770486793459, -1.2727680433866, 0.0786194912234789, -0.949330147708874, -0.288770486793459, 1.2727680433866, 0.0786194912234788, 0.809587586714765, -0.523073055668605, 0.18075022943322, -1.0043912998909, 1.30006628836077, 0.0, 0.0, -1.03771382624752, 0.4053376209213, -0.790402927074579, -1.10617978939022, 0.0492495013395566, -1.05537076510169, 0.182038008157031, -1.6331196223237, 0.469607411784203, -1.05537076510169, -0.182038008157031, 1.6331196223237, 0.469607411784203, 0.4053376209213, 0.790402927074579, 1.10617978939022, 0.0492495013395571, 0.46103349847604, 0.0, 0.0, 0.823980459899597, 0.790972112297408, -0.50233441600913, -1.39616694584661, -0.827082667677868, -1.02148886153543, 0.194917542033323, -1.58325802530293, 0.415092437728069, -1.02148886153543, -0.194917542033323, 1.58325802530293, 0.415092437728069, 0.790972112297407, 0.50233441600913, 1.39616694584661, -0.827082667677868, -0.834708539203028, 0.0, 0.0, -0.780052021484255, 0.538501218059577, -0.740764150905026, 0.726353258991694, -0.292844106384734, -0.121146948458063, 0.270645434544015, -1.84254797086549, 0.682870117126862, -0.121146948458064, -0.270645434544015, 1.84254797086549, 0.682870117126862, 0.538501218059578, 0.740764150905026, -0.726353258991694, -0.292844106384734, 1.46609419062561, 0.0, 0.0, 0.957169879458415, 0.463756947083572, 0.456404943314326, -1.20309522086643, -0.567563747993467, -1.19680404239638, 0.291210084715472, -1.20313942009359, 0.0889788082642593, -1.19680404239638, -0.291210084715471, 1.20313942009359, 0.088978808264259, 0.463756947083572, -0.456404943314326, 1.20309522086643, -0.567563747993467, 1.27331797699375, 0.0, 0.0, 0.935906997601736, 0.167859951287217, 0.397113483819735, -1.55295316533167, -0.639769143573721, -0.804518939784093, -0.605280210045722, 0.576440530593894, 0.171815644772852, -0.804518939784093, 0.605280210045722, -0.576440530593894, 0.171815644772853, 0.167859951287217, -0.397113483819735, 1.55295316533167, -0.639769143573722, 0.454400905334618, 0.0, 0.0, 2.04850135744239, 0.801491528492255, -0.190675239435961, -1.96215212315072, -0.678912805484384, -1.02869198115956, 0.44656991113219, -0.942840944983148, -0.34533787323681, -1.02869198115956, -0.44656991113219, 0.942840944983148, -0.34533787323681, 0.801491528492255, 0.190675239435961, 1.96215212315072, -0.678912805484384, 0.304876860847547, 0.0, 0.0, 1.86942146977325, 0.591401737447669, -0.22788379413711, -2.1479413772137, -0.819937186134399, -0.743840167871443, 0.594118645844994, 0.458834364268103, -0.114773548752226, -0.743840167871443, -0.594118645844994, -0.458834364268103, -0.114773548752226, 0.591401737447669, 0.22788379413711, 2.1479413772137, -0.819937186134398, 0.0, 0.680143058705622, 0.386999249719695, 0.0, -0.976186915603812, 0.0557379964949676, -1.4789442006436, -0.237641042474749, -0.833723500796569, -0.395809525847778, 1.28544457578375, 0.704950366904967, 0.833723500796569, -0.395809525847778, 1.28544457578375, -0.704950366904967, 0.976186915603812, 0.0557379964949675, -1.4789442006436, 0.237641042474749, 1.21303547193979, 0.0, 0.0, -0.345565012495286, -0.491977378408856, 0.213119532619359, -1.67694933083659, -1.41924967902346, -0.114540357561042, 0.23231510036761, -1.45367306214402, 1.59203218527109, -0.114540357561039, -0.232315100367609, 1.453673062144, 1.5920321852711, -0.491977378408852, -0.213119532619361, 1.67694933083661, -1.41924967902345, 1.01608644852489, 0.0, 0.0, -1.27341955244126, -0.477139902874087, -0.519543510518068, -1.26481603440589, 1.49132267326896, -0.0309033213883552, -0.354523832495802, -0.703027919091853, -0.854612897048339, -0.0309033213883551, 0.354523832495804, 0.703027919091857, -0.854612897048337, -0.477139902874088, 0.519543510518067, 1.26481603440589, 1.49132267326897};
    int[] NN = new int[]{200, 150, 150, 150, 150, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120};
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/periodic.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        periodic periodic2 = new periodic(stringArray);
    }

    public periodic() {
        this(null, null, null, null, null, false);
    }

    public periodic(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public periodic(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new periodicSimulation(this, string, frame, uRL, bl);
        this._view = (periodicView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.start();
    }

    public double ax(int n, double[] dArray, double[] dArray2) {
        if (n >= this.n) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (n == i) continue;
            double d2 = this.hypot(dArray[n] - dArray[i], dArray2[n] - dArray2[i]);
            d += -(dArray[n] - dArray[i]) / (d2 * d2 * d2);
        }
        return d;
    }

    public double ay(int n, double[] dArray, double[] dArray2) {
        if (n >= this.n) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (n == i) continue;
            double d2 = this.hypot(dArray[n] - dArray[i], dArray2[n] - dArray2[i]);
            d += -(dArray2[n] - dArray2[i]) / (d2 * d2 * d2);
        }
        return d;
    }

    public void start() {
        this._clearView();
        this._view.resetTraces();
        this.colors[0] = new Color(255, 0, 0);
        this.colors[1] = new Color(0, 128, 0);
        this.colors[2] = new Color(0, 0, 255);
        this.colors[3] = new Color(0, 128, 128);
        this.colors[4] = new Color(128, 0, 128);
        this.set_name();
        this.t = 0.0;
        this.orbits = this.NN[this.type];
        this.n = this.npart[this.type];
        this.xmax = this.xdim[this.type];
        int n = 20 * this.type;
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = this.xyuv[n++];
            this.y[i] = this.xyuv[n++];
            this.u[i] = this.xyuv[n++];
            this.v[i] = this.xyuv[n++];
        }
        this._resetSolvers();
    }

    public void set_name() {
        this._view.getElement("NameLabel").setProperty("text", this.names[this.type]);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public double _method_for_Type_maximum() {
        return this.norbits - 1;
    }

    public void _method_for_Type_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Type_dragaction() {
        this._simulation.disableLoop();
        this.set_name();
        this._simulation.enableLoop();
    }

    public void _method_for_Type_action() {
        this._simulation.disableLoop();
        this.start();
        this._simulation.enableLoop();
    }

    public double _method_for_Graph_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Graph_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Graph_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public String _method_for_Graph_BRmessage() {
        return "t=" + this._format(this.t, "0.000");
    }

    public boolean _method_for_Orbits_visible() {
        return this.orbits > 0;
    }

    public void _method_for_Particles_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Particles_action() {
        this._simulation.disableLoop();
        this._resetSolvers();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.nmax = 5;
        this.n = 3;
        this.x = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.y[n] = 0.0;
        }
        this.u = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.u[n] = 0.0;
        }
        this.v = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.v[n] = 0.0;
        }
        this.t = 0.0;
        this.tol = 1.0E-10;
        this.dt = 0.01;
        this.orbits = 200;
        this.type = 0;
        this.colors = new Object[this.nmax];
        this.xmax = 1.5;
        this.norbits = 24;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.y = null;
        this.u = null;
        this.v = null;
        this.colors = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private Dopri853 __solver = null;
        private double[] __state = null;
        private double[] _x;
        private double[] _y;
        private double[] _u;
        private double[] _v;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + periodic.this.x.length + periodic.this.y.length + periodic.this.u.length + periodic.this.v.length];
            this._x = new double[periodic.this.x.length];
            this._y = new double[periodic.this.y.length];
            this._u = new double[periodic.this.u.length];
            this._v = new double[periodic.this.v.length];
        }

        private boolean arraysChanged() {
            if (periodic.this.x.length != this._x.length) {
                return true;
            }
            if (periodic.this.y.length != this._y.length) {
                return true;
            }
            if (periodic.this.u.length != this._u.length) {
                return true;
            }
            return periodic.this.v.length != this._v.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : periodic.this.x) {
            }
            for (double this.__state[n++] : periodic.this.y) {
            }
            for (double this.__state[n++] : periodic.this.u) {
            }
            for (double this.__state[n++] : periodic.this.v) {
            }
            this.__state[n++] = periodic.this.t;
            this.__solver = new Dopri853(this);
            this.__solver.initialize(periodic.this.dt);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (periodic.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(periodic.this.tol);
            }
            if (periodic.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(periodic.this.dt);
            }
            int n2 = 0;
            for (double this.__state[n2++] : periodic.this.x) {
            }
            for (double this.__state[n2++] : periodic.this.y) {
            }
            for (double this.__state[n2++] : periodic.this.u) {
            }
            for (double this.__state[n2++] : periodic.this.v) {
            }
            this.__state[n2++] = periodic.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = periodic.this.x.length;
            for (n = 0; n < n3; ++n) {
                periodic.this.x[n] = this.__state[n2++];
            }
            n3 = periodic.this.y.length;
            for (n = 0; n < n3; ++n) {
                periodic.this.y[n] = this.__state[n2++];
            }
            n3 = periodic.this.u.length;
            for (n = 0; n < n3; ++n) {
                periodic.this.u[n] = this.__state[n2++];
            }
            n3 = periodic.this.v.length;
            for (n = 0; n < n3; ++n) {
                periodic.this.v[n] = this.__state[n2++];
            }
            periodic.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = periodic.this.x.length;
            for (n = 0; n < n3; ++n) {
                this._x[n] = dArray[n2++];
            }
            n3 = periodic.this.y.length;
            for (n = 0; n < n3; ++n) {
                this._y[n] = dArray[n2++];
            }
            n3 = periodic.this.u.length;
            for (n = 0; n < n3; ++n) {
                this._u[n] = dArray[n2++];
            }
            n3 = periodic.this.v.length;
            for (n = 0; n < n3; ++n) {
                this._v[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = periodic.this.x.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_1(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = periodic.this.y.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_2(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = periodic.this.u.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_3(n, this._x, this._y, this._u, this._v, this._t);
            }
            n3 = periodic.this.v.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_4(n, this._x, this._y, this._u, this._v, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution1_1(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return dArray3[n];
        }

        private double _ODE_evolution1_2(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return dArray4[n];
        }

        private double _ODE_evolution1_3(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return periodic.this.ax(n, dArray, dArray2);
        }

        private double _ODE_evolution1_4(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
            return periodic.this.ay(n, dArray, dArray2);
        }
    }
}

