/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.kepler;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.central_forces.kepler.kepler;
import users.ehu.jma.central_forces.kepler.keplerSimulation;

class keplerView
extends EjsControl
implements View {
    private keplerSimulation _simulation = null;
    private kepler _model = null;
    public Component Main;
    public JPanel Graphs;
    public PlottingPanel2D Dim1;
    public InteractiveParticle Axis0;
    public InteractivePoligon Effective;
    public InteractivePoligon Orbit1;
    public InteractiveParticle Particle1;
    public DrawingPanel2D Dim2;
    public InteractiveArrow Runge;
    public InteractivePoligon PolarOrbit;
    public InteractiveParticle Particle;
    public InteractiveParticle Center;
    public JSlider Zoom;
    public JPanel Down;
    public JPanel Buttons;
    public JTextField BE;
    public JTextField Br;
    public JTextField Bphi;
    public JCheckBox Battractive;
    public JCheckBox Baway;
    public JCheckBox Borbits;
    public JTextField Besz;
    public JTextField Bdt;
    public JTextField Bphi0;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;

    public keplerView(keplerSimulation keplerSimulation2, String string, Frame frame) {
        super(keplerSimulation2, string, frame);
        this._simulation = keplerSimulation2;
        this._model = (kepler)keplerSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("r", "apply(\"r\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("E", "apply(\"E\")");
        this.addListener("phi0", "apply(\"phi0\")");
        this.addListener("ecc", "apply(\"ecc\")");
        this.addListener("k", "apply(\"k\")");
        this.addListener("attractive", "apply(\"attractive\")");
        this.addListener("away", "apply(\"away\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("orbits", "apply(\"orbits\")");
        this.addListener("phimax", "apply(\"phimax\")");
        this.addListener("rmax", "apply(\"rmax\")");
        this.addListener("rmin", "apply(\"rmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("r".equals(string)) {
            this._model.r = this.getDouble("r");
        }
        if ("phi".equals(string)) {
            this._model.phi = this.getDouble("phi");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("y".equals(string)) {
            this._model.y = this.getDouble("y");
        }
        if ("E".equals(string)) {
            this._model.E = this.getDouble("E");
        }
        if ("phi0".equals(string)) {
            this._model.phi0 = this.getDouble("phi0");
        }
        if ("ecc".equals(string)) {
            this._model.ecc = this.getDouble("ecc");
        }
        if ("k".equals(string)) {
            this._model.k = this.getDouble("k");
        }
        if ("attractive".equals(string)) {
            this._model.attractive = this.getBoolean("attractive");
        }
        if ("away".equals(string)) {
            this._model.away = this.getBoolean("away");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("orbits".equals(string)) {
            this._model.orbits = this.getBoolean("orbits");
        }
        if ("phimax".equals(string)) {
            this._model.phimax = this.getDouble("phimax");
        }
        if ("rmax".equals(string)) {
            this._model.rmax = this.getDouble("rmax");
        }
        if ("rmin".equals(string)) {
            this._model.rmin = this.getDouble("rmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("r", this._model.r);
        this.setValue("phi", this._model.phi);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("E", this._model.E);
        this.setValue("phi0", this._model.phi0);
        this.setValue("ecc", this._model.ecc);
        this.setValue("k", this._model.k);
        this.setValue("attractive", this._model.attractive);
        this.setValue("away", this._model.away);
        this.setValue("dt", this._model.dt);
        this.setValue("orbits", this._model.orbits);
        this.setValue("phimax", this._model.phimax);
        this.setValue("rmax", this._model.rmax);
        this.setValue("rmin", this._model.rmin);
        this.setValue("xmax", this._model.xmax);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Newtonian orbits and equivalent problem")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "-2,7").setProperty("size", this._simulation.translateString("View.Main.size", "636,354")).getObject();
        this.Graphs = (JPanel)this.addElement(new ControlPanel(), "Graphs").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "grid:1,2,0,0").getObject();
        this.Dim1 = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Dim1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("maximumX", "xmax").setProperty("minimumY", "-.6").setProperty("maximumY", "2").setProperty("pressaction", "_model._method_for_Dim1_pressaction()").setProperty("title", this._simulation.translateString("View.Dim1.title", "Equivalent problem")).setProperty("axesType", "Cartesian2").setProperty("titleX", this._simulation.translateString("View.Dim1.titleX", "r")).setProperty("titleY", this._simulation.translateString("View.Dim1.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Dim1.xFormat", "r=0.###")).setProperty("yFormat", this._simulation.translateString("View.Dim1.yFormat", "E=0.###")).setProperty("tooltip", this._simulation.translateString("View.Dim1.tooltip", "Use mouse to select position and energy")).getObject();
        this.Axis0 = (InteractiveParticle)this.addElement(new ControlParticle(), "Axis0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "%_model._method_for_Axis0_x()%").setProperty("y", "0").setProperty("sizex", "xmax").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null").getObject();
        this.Effective = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Effective").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("points", "100").setProperty("min", ".1").setProperty("max", "xmax").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-k/s+.5/s/s").setProperty("javaSyntax", "true").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false").getObject();
        this.Orbit1 = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "Orbit1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("points", "2").setProperty("min", "rmin").setProperty("max", "rmax").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "E").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("visible", "orbits").setProperty("enabled", "false").getObject();
        this.Particle1 = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim1").setProperty("x", "r").setProperty("y", "E").setProperty("z", "0.0").setProperty("sizex", "0.12").setProperty("sizey", "0.08").setProperty("enabled", "_isPaused").setProperty("dragaction", "_model._method_for_Particle1_dragaction()").setProperty("action", "_model._method_for_Particle1_action()").setProperty("color", "0,128,0,255").getObject();
        this.Dim2 = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Dim2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graphs").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_Dim2_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "%_model._method_for_Dim2_minimumY()%").setProperty("maximumY", "xmax").setProperty("pressaction", "_model._method_for_Dim2_pressaction()").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Dim2.tooltip", "Choose position with mouse")).getObject();
        this.Runge = (InteractiveArrow)this.addElement(new ControlArrow(), "Runge").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim2").setProperty("x", "%_model._method_for_Runge_x()%").setProperty("y", "%_model._method_for_Runge_y()%").setProperty("sizex", "%_model._method_for_Runge_sizex()%").setProperty("sizey", "%_model._method_for_Runge_sizey()%").setProperty("visible", "orbits").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta").getObject();
        this.PolarOrbit = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "PolarOrbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim2").setProperty("points", "100").setProperty("min", "%_model._method_for_PolarOrbit_min()%").setProperty("max", "%_model._method_for_PolarOrbit_max()%").setProperty("variable", "s").setProperty("functionx", "Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("visible", "orbits").setProperty("enabled", "false").getObject();
        this.Particle = (InteractiveParticle)this.addElement(new ControlParticle(), "Particle").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim2").setProperty("x", "x").setProperty("y", "y").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("enabled", "_isPaused").setProperty("pressaction", "_model._method_for_Particle_pressaction()").setProperty("dragaction", "_model._method_for_Particle_dragaction()").setProperty("action", "_model._method_for_Particle_action()").setProperty("color", "0,128,0,255").getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Dim2").setProperty("enabled", "false").setProperty("color", "black").getObject();
        this.Zoom = (JSlider)this.addElement(new ControlSlider(), "Zoom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Main").setProperty("variable", "xmax").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom")).getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,6,0,0").getObject();
        this.BE = (JTextField)this.addElement(new ControlNumberField(), "BE").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "E").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_BE_action()").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy")).getObject();
        this.Br = (JTextField)this.addElement(new ControlNumberField(), "Br").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "r").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Br_action()").setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance")).getObject();
        this.Bphi = (JTextField)this.addElement(new ControlNumberField(), "Bphi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle")).getObject();
        this.Battractive = (JCheckBox)this.addElement(new ControlCheckBox(), "Battractive").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "attractive").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Battractive.text", "Attractive")).setProperty("mnemonic", this._simulation.translateString("View.Battractive.mnemonic", "a")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Battractive_action()").setProperty("tooltip", this._simulation.translateString("View.Battractive.tooltip", "Attractive or repulsive force")).getObject();
        this.Baway = (JCheckBox)this.addElement(new ControlCheckBox(), "Baway").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "away").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.Baway.text", "Away")).setProperty("mnemonic", this._simulation.translateString("View.Baway.mnemonic", "w")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Baway_action()").setProperty("tooltip", this._simulation.translateString("View.Baway.tooltip", "Initially moving away")).getObject();
        this.Borbits = (JCheckBox)this.addElement(new ControlCheckBox(), "Borbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "orbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Show orbit?")).getObject();
        this.Besz = (JTextField)this.addElement(new ControlNumberField(), "Besz").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "ecc").setProperty("format", this._simulation.translateString("View.Besz.format", "$\\epsilon$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Besz.tooltip", "Eccentricity")).getObject();
        this.Bdt = (JTextField)this.addElement(new ControlNumberField(), "Bdt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step length")).getObject();
        this.Bphi0 = (JTextField)this.addElement(new ControlNumberField(), "Bphi0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "phi0").setProperty("format", this._simulation.translateString("View.Bphi0.format", "per = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_Bphi0_action()").setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Bphi0.tooltip", "Pericentron direction")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions.")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Newtonian orbits and equivalent problem")).setProperty("visible", "true");
        this.getElement("Graphs");
        this.getElement("Dim1").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "0").setProperty("minimumY", "-.6").setProperty("maximumY", "2").setProperty("title", this._simulation.translateString("View.Dim1.title", "Equivalent problem")).setProperty("axesType", "Cartesian2").setProperty("titleY", this._simulation.translateString("View.Dim1.titleY", "Energy")).setProperty("square", "false").setProperty("xFormat", this._simulation.translateString("View.Dim1.xFormat", "r=0.###")).setProperty("yFormat", this._simulation.translateString("View.Dim1.yFormat", "E=0.###")).setProperty("tooltip", this._simulation.translateString("View.Dim1.tooltip", "Use mouse to select position and energy"));
        this.getElement("Axis0").setProperty("y", "0").setProperty("sizey", "0").setProperty("enabled", "false").setProperty("secondaryColor", "0,128,0,255").setProperty("color", "null");
        this.getElement("Effective").setProperty("points", "100").setProperty("min", ".1").setProperty("variable", "s").setProperty("functionx", "s").setProperty("functiony", "-k/s+.5/s/s").setProperty("javaSyntax", "true").setProperty("color", "red").setProperty("stroke", "2").setProperty("enabled", "false");
        this.getElement("Orbit1").setProperty("points", "2").setProperty("variable", "s").setProperty("functionx", "s").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("enabled", "false");
        this.getElement("Particle1").setProperty("z", "0.0").setProperty("sizex", "0.12").setProperty("sizey", "0.08").setProperty("color", "0,128,0,255");
        this.getElement("Dim2").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("square", "true").setProperty("background", "white").setProperty("tooltip", this._simulation.translateString("View.Dim2.tooltip", "Choose position with mouse"));
        this.getElement("Runge").setProperty("enabled", "false").setProperty("color", "magenta").setProperty("secondaryColor", "magenta");
        this.getElement("PolarOrbit").setProperty("points", "100").setProperty("variable", "s").setProperty("functionx", "Math.cos(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("functiony", "Math.sin(s)/(ecc*Math.cos(s-phi0)+k)").setProperty("javaSyntax", "true").setProperty("color", "blue").setProperty("enabled", "false");
        this.getElement("Particle").setProperty("sizex", ".2").setProperty("sizey", ".2").setProperty("color", "0,128,0,255");
        this.getElement("Center").setProperty("enabled", "false").setProperty("color", "black");
        this.getElement("Zoom").setProperty("minimum", "1").setProperty("maximum", "10").setProperty("orientation", "VERTICAL").setProperty("tooltip", this._simulation.translateString("View.Zoom.tooltip", "Zoom"));
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Buttons");
        this.getElement("BE").setProperty("format", this._simulation.translateString("View.BE.format", "E = 0.###")).setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.BE.tooltip", "Mechanical energy"));
        this.getElement("Br").setProperty("format", this._simulation.translateString("View.Br.format", "r = 0.###")).setProperty("foreground", "0,128,0,255").setProperty("tooltip", this._simulation.translateString("View.Br.tooltip", "Polar distance"));
        this.getElement("Bphi").setProperty("format", this._simulation.translateString("View.Bphi.format", "$\\phi$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Bphi.tooltip", "Polar angle"));
        this.getElement("Battractive").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.Battractive.text", "Attractive")).setProperty("mnemonic", this._simulation.translateString("View.Battractive.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.Battractive.tooltip", "Attractive or repulsive force"));
        this.getElement("Baway").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.Baway.text", "Away")).setProperty("mnemonic", this._simulation.translateString("View.Baway.mnemonic", "w")).setProperty("tooltip", this._simulation.translateString("View.Baway.tooltip", "Initially moving away"));
        this.getElement("Borbits").setProperty("text", this._simulation.translateString("View.Borbits.text", "Orbit")).setProperty("mnemonic", this._simulation.translateString("View.Borbits.mnemonic", "o")).setProperty("tooltip", this._simulation.translateString("View.Borbits.tooltip", "Show orbit?"));
        this.getElement("Besz").setProperty("format", this._simulation.translateString("View.Besz.format", "$\\epsilon$ = 0.###")).setProperty("editable", "false").setProperty("tooltip", this._simulation.translateString("View.Besz.tooltip", "Eccentricity"));
        this.getElement("Bdt").setProperty("format", this._simulation.translateString("View.Bdt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Bdt.tooltip", "Integration step length"));
        this.getElement("Bphi0").setProperty("format", this._simulation.translateString("View.Bphi0.format", "per = 0.###")).setProperty("foreground", "magenta").setProperty("tooltip", this._simulation.translateString("View.Bphi0.tooltip", "Pericentron direction"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Single step the simulation"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Resets the initial conditions."));
        super.reset();
    }
}

