/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.central_forces.kepler;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.central_forces.kepler.keplerSimulation;
import users.ehu.jma.central_forces.kepler.keplerView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class kepler
extends AbstractModel {
    public keplerSimulation _simulation = null;
    public keplerView _view = null;
    public kepler _model = this;
    public double t = 0.0;
    public double r = 1.0;
    public double phi = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double E = -0.5;
    public double phi0 = 0.0;
    public double ecc = 0.0;
    public double k = 1.0;
    public boolean attractive = true;
    public boolean away = false;
    public double dt = 0.1;
    public boolean orbits = true;
    public double phimax = 0.0;
    public double rmax = 0.0;
    public double rmin = 0.0;
    public double xmax = 4.0;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/central_forces/kepler.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/central_forces/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        kepler kepler2 = new kepler(stringArray);
    }

    public kepler() {
        this(null, null, null, null, null, false);
    }

    public kepler(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public kepler(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new keplerSimulation(this, string, frame, uRL, bl);
        this._view = (keplerView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.putphixy();
    }

    public void _evolution1() {
        this.phi += this.dt / this.r / this.r;
        if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
        }
        this.r = 1.0 / (this.ecc * Math.cos(this.phi - this.phi0) + this.k);
        this.putxy();
    }

    public void _constraints1() {
        if (this.E < -0.5) {
            this.E = -0.5;
        }
        if (!this.attractive && this.E <= 0.0) {
            this.E = 0.01;
        }
        this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
        double d = this.k = this.attractive ? 1.0 : -1.0;
        while (this.phi0 > Math.PI) {
            this.phi0 -= Math.PI * 2;
        }
        while (this.phi0 <= -Math.PI) {
            this.phi0 += Math.PI * 2;
        }
        if (this._isPlaying()) {
            this.away = this.E > -0.5 && (this.phi > this.phi0 || this.phi < this.phi0 - Math.PI);
        }
    }

    public void _constraints2() {
        this.phimax = this.attractive ? (this.E < 0.0 ? Math.PI : (this.E == 0.0 ? 3.0 : Math.acos(-1.0 / this.ecc) - 0.1)) : Math.acos(1.0 / this.ecc) - 0.1;
    }

    public void _constraints3() {
        this.rmin = 1.0 / (this.ecc + this.k);
        if (this.r < this.rmin) {
            this.r = this.rmin;
        }
        if (this.E < 0.0) {
            this.rmax = 1.0 / (1.0 - this.ecc);
            if (this.r > this.rmax) {
                this.r = this.rmax;
            }
        } else {
            this.rmax = 50.0;
        }
    }

    public void putxy() {
        this.x = this.r * Math.cos(this.phi);
        this.y = this.r * Math.sin(this.phi);
    }

    public void pause() {
        this._pause();
    }

    public void putphi() {
        if (this.r <= 0.0) {
            this.r = 1.0;
        }
        if (this.r < this.rmin || this.attractive && this.r > this.rmax) {
            this.E = -this.k / this.r + 0.5 / this.r / this.r;
            this.E = Math.max(this.E, -0.5);
            this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
        }
        this.phi = this.E == -0.5 || this.r <= this.rmin ? this.phi0 : (this.away ? this.phi0 + Math.acos((1.0 / this.r - this.k) / this.ecc) : this.phi0 - Math.acos((1.0 / this.r - this.k) / this.ecc));
    }

    public void putphir() {
        this.r = this.hypot(this.x, this.y);
        this.phi = Math.atan2(this.y, this.x);
        if (this.r < this.rmin || this.attractive && this.r > this.rmax) {
            this.E = -this.k / this.r + 0.5 / this.r / this.r;
            this.E = Math.max(this.E, -0.5);
            this.ecc = Math.sqrt(1.0 + 2.0 * this.E);
        }
        this.phi0 = this.E == -0.5 || this.r <= this.rmin ? this.phi : (this.away ? this.phi - Math.acos((1.0 / this.r - this.k) / this.ecc) : this.phi + Math.acos((1.0 / this.r - this.k) / this.ecc));
    }

    public void putphixy() {
        this.putphi();
        this.putxy();
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_Dim1_pressaction() {
        this._simulation.disableLoop();
        this.pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Axis0_x() {
        return 0.5 * this.xmax;
    }

    public void _method_for_Particle1_dragaction() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle1_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public double _method_for_Dim2_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Dim2_minimumY() {
        return -this.xmax;
    }

    public void _method_for_Dim2_pressaction() {
        this._simulation.disableLoop();
        this.pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Runge_x() {
        return -this.rmax * Math.cos(this.phi0);
    }

    public double _method_for_Runge_y() {
        return -this.rmax * Math.sin(this.phi0);
    }

    public double _method_for_Runge_sizex() {
        return (this.rmin + this.rmax + 0.5) * Math.cos(this.phi0);
    }

    public double _method_for_Runge_sizey() {
        return (this.rmin + this.rmax + 0.5) * Math.sin(this.phi0);
    }

    public double _method_for_PolarOrbit_min() {
        return this.phi0 - this.phimax;
    }

    public double _method_for_PolarOrbit_max() {
        return this.phi0 + this.phimax;
    }

    public void _method_for_Particle_pressaction() {
        this._simulation.disableLoop();
        this.pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle_dragaction() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle_action() {
        this._simulation.disableLoop();
        this.putphir();
        this._simulation.enableLoop();
    }

    public void _method_for_BE_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Br_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Battractive_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Baway_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Bphi0_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.r = 1.0;
        this.phi = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.E = -0.5;
        this.phi0 = 0.0;
        this.ecc = 0.0;
        this.k = 1.0;
        this.attractive = true;
        this.away = false;
        this.dt = 0.1;
        this.orbits = true;
        this.phimax = 0.0;
        this.rmax = 0.0;
        this.rmin = 0.0;
        this.xmax = 4.0;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._evolution1();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        System.gc();
    }
}

