/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.rod;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.rod.rod;
import users.ehu.jma.analytical_mechanics.rod.rodSimulation;

class rodView
extends EjsControl
implements View {
    private rodSimulation _simulation = null;
    private rod _model = null;
    public Component Main;
    public JPanel Left;
    public JPanel Void;
    public JSlider Height;
    public JPanel Center;
    public JPanel Graph;
    public PlottingPanel2D Evolution;
    public InteractiveTrace HeightEvolution;
    public DrawingPanel2D Space;
    public InteractiveArrow Table;
    public InteractiveArrow Wall;
    public InteractiveArrow Rod;
    public InteractiveParticle Upper;
    public InteractiveParticle CenterPoint;
    public InteractiveTrace UpperTraj;
    public InteractiveTrace CenterTraj;
    public JPanel Times;
    public JLabel t1;
    public JLabel t2;
    public JPanel Bottom;
    public JPanel Controls;
    public JPanel Display;
    public JTextField h;
    public JTextField dt;
    public JCheckBox Pause;
    public JCheckBox ShowTrajectories;
    public JPanel Buttons;
    public JButton Start;
    public JButton Continue;
    public JButton Stop;
    public JButton Reset;

    public rodView(rodSimulation rodSimulation2, String string, Frame frame) {
        super(rodSimulation2, string, frame);
        this._simulation = rodSimulation2;
        this._model = (rod)rodSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("phi1", "apply(\"phi1\")");
        this.addListener("t1", "apply(\"t1\")");
        this.addListener("t2", "apply(\"t2\")");
        this.addListener("state", "apply(\"state\")");
        this.addListener("y0", "apply(\"y0\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("eps", "apply(\"eps\")");
        this.addListener("stopEvents", "apply(\"stopEvents\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("y1", "apply(\"y1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("y2", "apply(\"y2\")");
        this.addListener("x3", "apply(\"x3\")");
        this.addListener("y3", "apply(\"y3\")");
        this.addListener("t1Label", "apply(\"t1Label\")");
        this.addListener("t2Label", "apply(\"t2Label\")");
        this.addListener("formatString", "apply(\"formatString\")");
        this.addListener("showTraj", "apply(\"showTraj\")");
    }

    public void read() {
    }

    public void read(String string) {
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("phi1".equals(string)) {
            this._model.phi1 = this.getDouble("phi1");
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
        }
        if ("state".equals(string)) {
            double[] dArray = (double[])this.getValue("state").getObject();
            int n = dArray.length;
            if (n > this._model.state.length) {
                n = this._model.state.length;
            }
            for (int i = 0; i < n; ++i) {
                this._model.state[i] = dArray[i];
            }
        }
        if ("y0".equals(string)) {
            this._model.y0 = this.getDouble("y0");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("eps".equals(string)) {
            this._model.eps = this.getDouble("eps");
        }
        if ("stopEvents".equals(string)) {
            this._model.stopEvents = this.getBoolean("stopEvents");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("y1".equals(string)) {
            this._model.y1 = this.getDouble("y1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("y2".equals(string)) {
            this._model.y2 = this.getDouble("y2");
        }
        if ("x3".equals(string)) {
            this._model.x3 = this.getDouble("x3");
        }
        if ("y3".equals(string)) {
            this._model.y3 = this.getDouble("y3");
        }
        if ("t1Label".equals(string)) {
            this._model.t1Label = this.getString("t1Label");
        }
        if ("t2Label".equals(string)) {
            this._model.t2Label = this.getString("t2Label");
        }
        if ("formatString".equals(string)) {
            this._model.formatString = this.getString("formatString");
        }
        if ("showTraj".equals(string)) {
            this._model.showTraj = this.getBoolean("showTraj");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("phi1", this._model.phi1);
        this.setValue("t1", this._model.t1);
        this.setValue("t2", this._model.t2);
        this.setValue("state", this._model.state);
        this.setValue("y0", this._model.y0);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("eps", this._model.eps);
        this.setValue("stopEvents", this._model.stopEvents);
        this.setValue("x1", this._model.x1);
        this.setValue("y1", this._model.y1);
        this.setValue("x2", this._model.x2);
        this.setValue("y2", this._model.y2);
        this.setValue("x3", this._model.x3);
        this.setValue("y3", this._model.y3);
        this.setValue("t1Label", this._model.t1Label);
        this.setValue("t2Label", this._model.t2Label);
        this.setValue("formatString", this._model.formatString);
        this.setValue("showTraj", this._model.showTraj);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Falling rod")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "0,-4").setProperty("size", this._simulation.translateString("View.Main.size", "640,460")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Void = (JPanel)this.addElement(new ControlPanel(), "Void").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("layout", "border").setProperty("background", "239,239,255,255").getObject();
        this.Height = (JSlider)this.addElement(new ControlSlider(), "Height").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Left").setProperty("variable", "y0").setProperty("minimum", "0.01").setProperty("maximum", ".999").setProperty("orientation", "VERTICAL").setProperty("enabled", "_isPaused").setProperty("dragaction", "_model._method_for_Height_dragaction()").setProperty("action", "_model._method_for_Height_action()").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height of upper end")).getObject();
        this.Center = (JPanel)this.addElement(new ControlPanel(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Graph = (JPanel)this.addElement(new ControlPanel(), "Graph").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Center").setProperty("layout", "grid:2,1,0,0").getObject();
        this.Evolution = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", this._simulation.translateString("View.Evolution.title", "Evolution of the upper end height")).setProperty("titleX", this._simulation.translateString("View.Evolution.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Evolution.titleY", "y")).setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "y = 0.###")).getObject();
        this.HeightEvolution = (InteractiveTrace)this.addElement(new ControlTrace(), "HeightEvolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Evolution").setProperty("x", "t").setProperty("y", "y1").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2").getObject();
        this.Space = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "Space").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Graph").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "1.5").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Space.xFormat", "null")).setProperty("yFormat", this._simulation.translateString("View.Space.yFormat", "y = 0.###")).getObject();
        this.Table = (InteractiveArrow)this.addElement(new ControlArrow(), "Table").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9").getObject();
        this.Wall = (InteractiveArrow)this.addElement(new ControlArrow(), "Wall").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "-.03").setProperty("y", "0").setProperty("sizex", "0").setProperty("sizey", "1.1").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9").getObject();
        this.Rod = (InteractiveArrow)this.addElement(new ControlArrow(), "Rod").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("sizex", "%_model._method_for_Rod_sizex()%").setProperty("sizey", "%_model._method_for_Rod_sizey()%").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "black").setProperty("stroke", "5").getObject();
        this.Upper = (InteractiveParticle)this.addElement(new ControlParticle(), "Upper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("visible", "showTraj").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "red").getObject();
        this.CenterPoint = (InteractiveParticle)this.addElement(new ControlParticle(), "CenterPoint").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "y2").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("visible", "showTraj").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "blue").getObject();
        this.UpperTraj = (InteractiveTrace)this.addElement(new ControlTrace(), "UpperTraj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x1").setProperty("y", "y1").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "red").getObject();
        this.CenterTraj = (InteractiveTrace)this.addElement(new ControlTrace(), "CenterTraj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Space").setProperty("x", "x2").setProperty("y", "y2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "showTraj").setProperty("color", "blue").getObject();
        this.Times = (JPanel)this.addElement(new ControlPanel(), "Times").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Center").setProperty("layout", "grid:1,2,0,0").getObject();
        this.t1 = (JLabel)this.addElement(new ControlLabel(), "t1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", this._simulation.translateString("View.t1.text", "%t1Label%")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.t1.tooltip", "At this time the rod leaves the wall")).getObject();
        this.t2 = (JLabel)this.addElement(new ControlLabel(), "t2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Times").setProperty("text", this._simulation.translateString("View.t2.text", "%t2Label%")).setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.t2.tooltip", "At this time the rod reaches the horizontal")).getObject();
        this.Bottom = (JPanel)this.addElement(new ControlPanel(), "Bottom").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Bottom").setProperty("layout", "border").getObject();
        this.Display = (JPanel)this.addElement(new ControlPanel(), "Display").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Controls").setProperty("layout", "hbox").getObject();
        this.h = (JTextField)this.addElement(new ControlNumberField(), "h").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "y0").setProperty("format", this._simulation.translateString("View.h.format", "h = 0.###")).setProperty("editable", "_isPaused").setProperty("action", "_model._method_for_h_action()").setProperty("tooltip", this._simulation.translateString("View.h.tooltip", "Initial height of upper end")).getObject();
        this.dt = (JTextField)this.addElement(new ControlNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step")).getObject();
        this.Pause = (JCheckBox)this.addElement(new ControlCheckBox(), "Pause").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "stopEvents").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when the rod leaves the wall or reaches the horizontal")).getObject();
        this.ShowTrajectories = (JCheckBox)this.addElement(new ControlCheckBox(), "ShowTrajectories").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Display").setProperty("variable", "showTraj").setProperty("text", this._simulation.translateString("View.ShowTrajectories.text", "Trajectories")).setProperty("mnemonic", this._simulation.translateString("View.ShowTrajectories.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.ShowTrajectories.tooltip", "Show the trajectories of the upper end and the center point")).getObject();
        this.Buttons = (JPanel)this.addElement(new ControlPanel(), "Buttons").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "Controls").setProperty("layout", "grid:1,4,0,0").getObject();
        this.Start = (JButton)this.addElement(new ControlButton(), "Start").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.Start.image", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonic", this._simulation.translateString("View.Start.mnemonic", "g")).setProperty("enabled", "_isPaused").setProperty("action", "_model._method_for_Start_action()").setProperty("tooltip", this._simulation.translateString("View.Start.tooltip", "Start simulation from initial conditions")).getObject();
        this.Continue = (JButton)this.addElement(new ControlButton(), "Continue").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.Continue.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.Continue.mnemonic", "c")).setProperty("enabled", "%_model._method_for_Continue_enabled()%").setProperty("action", "_model._method_for_Continue_action()").setProperty("tooltip", this._simulation.translateString("View.Continue.tooltip", "Continue simulation")).getObject();
        this.Stop = (JButton)this.addElement(new ControlButton(), "Stop").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("image", this._simulation.translateString("View.Stop.image", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonic", this._simulation.translateString("View.Stop.mnemonic", "s")).setProperty("enabled", "_isPlaying").setProperty("action", "_model._method_for_Stop_action()").setProperty("tooltip", this._simulation.translateString("View.Stop.tooltip", "Stop simulation")).getObject();
        this.Reset = (JButton)this.addElement(new ControlButton(), "Reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Buttons").setProperty("text", this._simulation.translateString("View.Reset.text", "Reset")).setProperty("image", this._simulation.translateString("View.Reset.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Reset.mnemonic", "r")).setProperty("action", "_model._method_for_Reset_action()").setProperty("tooltip", this._simulation.translateString("View.Reset.tooltip", "Reciver initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Falling rod")).setProperty("visible", "true");
        this.getElement("Left");
        this.getElement("Void").setProperty("background", "239,239,255,255");
        this.getElement("Height").setProperty("minimum", "0.01").setProperty("maximum", ".999").setProperty("orientation", "VERTICAL").setProperty("background", "239,239,255,255").setProperty("tooltip", this._simulation.translateString("View.Height.tooltip", "Initial height of upper end"));
        this.getElement("Center");
        this.getElement("Graph");
        this.getElement("Evolution").setProperty("autoscaleX", "true").setProperty("autoscaleY", "false").setProperty("minimumY", "-.1").setProperty("maximumY", "1.1").setProperty("title", this._simulation.translateString("View.Evolution.title", "Evolution of the upper end height")).setProperty("titleY", this._simulation.translateString("View.Evolution.titleY", "y")).setProperty("xFormat", this._simulation.translateString("View.Evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.Evolution.yFormat", "y = 0.###"));
        this.getElement("HeightEvolution").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red").setProperty("stroke", "2");
        this.getElement("Space").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-.5").setProperty("maximumX", "1.5").setProperty("minimumY", "-.05").setProperty("maximumY", "1.05").setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.Space.xFormat", "null")).setProperty("yFormat", this._simulation.translateString("View.Space.yFormat", "y = 0.###"));
        this.getElement("Table").setProperty("x", "-2").setProperty("y", "-.03").setProperty("sizex", "5").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9");
        this.getElement("Wall").setProperty("x", "-.03").setProperty("y", "0").setProperty("sizex", "0").setProperty("sizey", "1.1").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "orange").setProperty("stroke", "9");
        this.getElement("Rod").setProperty("enabledSecondary", "false").setProperty("enabled", "true").setProperty("style", "SEGMENT").setProperty("color", "black").setProperty("stroke", "5");
        this.getElement("Upper").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "red");
        this.getElement("CenterPoint").setProperty("sizex", ".03").setProperty("sizey", ".03").setProperty("enabled", "false").setProperty("secondaryColor", "null").setProperty("color", "blue");
        this.getElement("UpperTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("CenterTraj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "blue");
        this.getElement("Times");
        this.getElement("t1").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.t1.tooltip", "At this time the rod leaves the wall"));
        this.getElement("t2").setProperty("alignment", "CENTER").setProperty("background", "white").setProperty("foreground", "blue").setProperty("tooltip", this._simulation.translateString("View.t2.tooltip", "At this time the rod reaches the horizontal"));
        this.getElement("Bottom");
        this.getElement("Controls");
        this.getElement("Display");
        this.getElement("h").setProperty("format", this._simulation.translateString("View.h.format", "h = 0.###")).setProperty("tooltip", this._simulation.translateString("View.h.tooltip", "Initial height of upper end"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.####")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step"));
        this.getElement("Pause").setProperty("text", this._simulation.translateString("View.Pause.text", "Events")).setProperty("mnemonic", this._simulation.translateString("View.Pause.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.Pause.tooltip", "Pause when the rod leaves the wall or reaches the horizontal"));
        this.getElement("ShowTrajectories").setProperty("text", this._simulation.translateString("View.ShowTrajectories.text", "Trajectories")).setProperty("tooltip", this._simulation.translateString("View.ShowTrajectories.tooltip", "Show the trajectories of the upper end and the center point"));
        this.getElement("Buttons");
        this.getElement("Start").setProperty("image", this._simulation.translateString("View.Start.image", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonic", this._simulation.translateString("View.Start.mnemonic", "g")).setProperty("tooltip", this._simulation.translateString("View.Start.tooltip", "Start simulation from initial conditions"));
        this.getElement("Continue").setProperty("image", this._simulation.translateString("View.Continue.image", "/org/opensourcephysics/resources/controls/images/continue.gif")).setProperty("mnemonic", this._simulation.translateString("View.Continue.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Continue.tooltip", "Continue simulation"));
        this.getElement("Stop").setProperty("image", this._simulation.translateString("View.Stop.image", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonic", this._simulation.translateString("View.Stop.mnemonic", "s")).setProperty("tooltip", this._simulation.translateString("View.Stop.tooltip", "Stop simulation"));
        this.getElement("Reset").setProperty("text", this._simulation.translateString("View.Reset.text", "Reset")).setProperty("image", this._simulation.translateString("View.Reset.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Reset.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.Reset.tooltip", "Reciver initial settings"));
        super.reset();
    }
}

