/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.rod;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.rod.rodSimulation;
import users.ehu.jma.analytical_mechanics.rod.rodView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class rod
extends AbstractModel {
    public rodSimulation _simulation = null;
    public rodView _view = null;
    public rod _model = this;
    public double t = 0.0;
    public double phi1 = 0.0;
    public double t1 = 0.0;
    public double t2 = 0.0;
    public double[] state;
    public double y0 = 0.99;
    public double dt = 0.025;
    public double tol = 1.0E-6;
    public double eps = 1.0E-6;
    public boolean stopEvents = false;
    public double x1 = 0.0;
    public double y1 = 0.0;
    public double x2 = 0.0;
    public double y2 = 0.0;
    public double x3 = 0.0;
    public double y3 = 0.0;
    public String t1Label = " ";
    public String t2Label = " ";
    public String formatString = "0.00";
    public boolean showTraj = false;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/rod.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        rod rod2 = new rod(stringArray);
    }

    public rod() {
        this(null, null, null, null, null, false);
    }

    public rod(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public rod(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new rodSimulation(this, string, frame, uRL, bl);
        this._view = (rodView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.state[2] = 0.0;
        this.t2 = 0.0;
        this.t1 = 0.0;
        this.t = 0.0;
        if (this.y0 < 0.01) {
            this.y0 = 0.01;
        } else if (this.y0 > 0.999) {
            this.y0 = 0.999;
        }
        this.state[1] = Math.acos(this.y0);
        this.state[0] = 0.5 * Math.sin(this.state[1]);
        this.phi1 = Math.acos(0.6666666666666666 * this.y0);
        this._view.resetTraces();
        this.t2Label = " ";
        this.t1Label = " ";
    }

    public void _evolution2() {
        if (this.state[0] < 0.0) {
            this.state[0] = 0.0;
        }
        if (this.state[0] > 1.5707963267948966) {
            this.state[0] = 1.5707963267948966;
        }
    }

    public void _constraints1() {
        if (this.t1 > 0.0 && this.t2 > 0.0) {
            this._pause();
        }
    }

    public void _constraints2() {
        double d = Math.cos(this.state[1]);
        double d2 = Math.sin(this.state[1]);
        this.x2 = this.state[0];
        this.y2 = 0.5 * d;
        this.x1 = this.x2 - 0.5 * d2;
        this.y1 = d;
        this.x3 = this.state[0] + 0.5 * d2;
    }

    public double[] der(double[] dArray) {
        double[] dArray2 = new double[3];
        double d = Math.cos(dArray[1]);
        double d2 = Math.sin(dArray[1]);
        dArray2[1] = dArray[2];
        dArray2[0] = this.t1 == 0.0 ? 0.5 * d * Math.sqrt(Math.abs(3.0 * (this.y0 - d))) : Math.pow(this.y0, 1.5) / 3.0;
        dArray2[2] = this.t1 == 0.0 ? 1.5 * d2 : 6.0 * d2 * (2.0 - d * dArray[2] * dArray[2]) / (8.0 - 6.0 * d * d);
        return dArray2;
    }

    public void _method_for_Height_dragaction() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Height_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public double _method_for_Rod_sizex() {
        return this.x3 - this.x1;
    }

    public double _method_for_Rod_sizey() {
        return this.y3 - this.y1;
    }

    public void _method_for_h_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Start_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Continue_enabled() {
        return this._isPaused() && this.t > 0.0 && this.t1 * this.t2 == 0.0;
    }

    public void _method_for_Continue_action() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_Stop_action() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_Reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.phi1 = 0.0;
        this.t1 = 0.0;
        this.t2 = 0.0;
        this.state = new double[3];
        for (int i = 0; i < 3; ++i) {
            this.state[i] = 0.0;
        }
        this.y0 = 0.99;
        this.dt = 0.025;
        this.tol = 1.0E-6;
        this.eps = 1.0E-6;
        this.stopEvents = false;
        this.x1 = 0.0;
        this.y1 = 0.0;
        this.x2 = 0.0;
        this.y2 = 0.0;
        this.x3 = 0.0;
        this.y3 = 0.0;
        this.t1Label = " ";
        this.t2Label = " ";
        this.formatString = "0.00";
        this.showTraj = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.state = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double[] _state;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + rod.this.state.length];
            this._state = new double[rod.this.state.length];
        }

        private boolean arraysChanged() {
            return rod.this.state.length != this._state.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : rod.this.state) {
            }
            this.__state[n++] = rod.this.t;
            this.__solver = new ODEBisectionEventSolver(this, EulerRichardson.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(rod.this.dt);
        }

        void step() {
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (rod.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(rod.this.dt);
            }
            int n = 0;
            for (double this.__state[n++] : rod.this.state) {
            }
            this.__state[n++] = rod.this.t;
            this.__solver.step();
            n = 0;
            int n2 = rod.this.state.length;
            for (int i = 0; i < n2; ++i) {
                rod.this.state[i] = this.__state[n++];
            }
            rod.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            int n2 = rod.this.state.length;
            for (int i = 0; i < n2; ++i) {
                this._state[i] = dArray[n++];
            }
            this._t = dArray[n++];
            n = 0;
            System.arraycopy(this._ODE_evolution1_1(this._state, this._t), 0, dArray2, n, rod.this.state.length);
            n += rod.this.state.length;
            dArray2[n++] = 1.0;
        }

        private double[] _ODE_evolution1_1(double[] dArray, double d) {
            return rod.this.der(dArray);
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Rod horizontal";
            }

            public double getTolerance() {
                return rod.this.eps;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                int n2 = rod.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    ((_ODE_evolution1)_ODE_evolution1.this)._state[i] = dArray[n++];
                }
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._state, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double[] dArray, double d) {
                return rod.this.t1 > 0.0 ? 1.5707963267948966 - dArray[1] : rod.this.phi1 - dArray[1];
            }

            public boolean action() {
                int n = 0;
                int n2 = rod.this.state.length;
                for (int i = 0; i < n2; ++i) {
                    rod.this.state[i] = _ODE_evolution1.this.__state[n++];
                }
                rod.this.t = _ODE_evolution1.this.__state[n++];
                if (rod.this.t1 > 0.0) {
                    rod.this.t2 = rod.this.t;
                    rod.this.t2Label = "t = " + rod.this._format(rod.this.t2, rod.this.formatString);
                    rod.this._pause();
                } else {
                    rod.this.t1 = rod.this.t;
                    rod.this.t1Label = "t = " + rod.this._format(rod.this.t1, rod.this.formatString) + "     y = " + rod.this._format(Math.cos(rod.this.state[1]), rod.this.formatString);
                    if (rod.this.stopEvents) {
                        rod.this._pause();
                    }
                }
                n = 0;
                for (double ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] : rod.this.state) {
                }
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = rod.this.t;
                return true;
            }
        }
    }
}

