/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.phase_space;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlTraceSet;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.TraceSet;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.phase_space.phase_space;
import users.ehu.jma.analytical_mechanics.phase_space.phase_spaceSimulation;

class phase_spaceView
extends EjsControl
implements View {
    private phase_spaceSimulation _simulation = null;
    private phase_space _model = null;
    public Component Main;
    public PlottingPanel2D PhaseSpace;
    public ElementSet Points;
    public TraceSet Trajectories;
    public InteractiveArrow mpi;
    public InteractiveArrow ppi;
    public JPanel Down;
    public JPanel Controls;
    public JTextField Gamma;
    public JTextField Kn;
    public JCheckBox Harmonics;
    public JCheckBox Cylinder;
    public JCheckBox Traj;
    public JTextField Kdt;
    public JButton startButton;
    public JButton stepButton;
    public JButton initialButton;
    public JButton Reset;

    public phase_spaceView(phase_spaceSimulation phase_spaceSimulation2, String string, Frame frame) {
        super(phase_spaceSimulation2, string, frame);
        this._simulation = phase_spaceSimulation2;
        this._model = (phase_space)phase_spaceSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("nmax", "apply(\"nmax\")");
        this.addListener("q", "apply(\"q\")");
        this.addListener("qd", "apply(\"qd\")");
        this.addListener("gamma", "apply(\"gamma\")");
        this.addListener("harmonic", "apply(\"harmonic\")");
        this.addListener("n", "apply(\"n\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("cylinder", "apply(\"cylinder\")");
        this.addListener("traj", "apply(\"traj\")");
        this.addListener("canContinue", "apply(\"canContinue\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("nmax".equals(string)) {
            this._model.nmax = this.getInt("nmax");
        }
        if ("q".equals(string)) {
            dArray = (double[])this.getValue("q").getObject();
            n2 = dArray.length;
            if (n2 > this._model.q.length) {
                n2 = this._model.q.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.q[n] = dArray[n];
            }
        }
        if ("qd".equals(string)) {
            dArray = (double[])this.getValue("qd").getObject();
            n2 = dArray.length;
            if (n2 > this._model.qd.length) {
                n2 = this._model.qd.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.qd[n] = dArray[n];
            }
        }
        if ("gamma".equals(string)) {
            this._model.gamma = this.getDouble("gamma");
        }
        if ("harmonic".equals(string)) {
            this._model.harmonic = this.getBoolean("harmonic");
        }
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("cylinder".equals(string)) {
            this._model.cylinder = this.getBoolean("cylinder");
        }
        if ("traj".equals(string)) {
            this._model.traj = this.getBoolean("traj");
        }
        if ("canContinue".equals(string)) {
            this._model.canContinue = this.getBoolean("canContinue");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("nmax", this._model.nmax);
        this.setValue("q", this._model.q);
        this.setValue("qd", this._model.qd);
        this.setValue("gamma", this._model.gamma);
        this.setValue("harmonic", this._model.harmonic);
        this.setValue("n", this._model.n);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("cylinder", this._model.cylinder);
        this.setValue("traj", this._model.traj);
        this.setValue("canContinue", this._model.canContinue);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Phase space")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "640,480")).getObject();
        this.PhaseSpace = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "PhaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("pressaction", "_model._method_for_PhaseSpace_pressaction()").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "d$\\phi$/dt")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "$\\phi$=0.### /")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "d$\\phi$/dt=0.###")).setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Click to erase")).getObject();
        this.Points = (ElementSet)this.addElement(new ControlParticleSet(), "Points").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("elementnumber", "n").setProperty("x", "q").setProperty("y", "qd").setProperty("sizex", "0.1").setProperty("sizey", "0.1").setProperty("enabled", "false").setProperty("secondaryColor", "red").getObject();
        this.Trajectories = (TraceSet)this.addElement(new ControlTraceSet(), "Trajectories").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("elementnumber", "n").setProperty("x", "q").setProperty("y", "qd").setProperty("visible", "traj").setProperty("color", "blue").getObject();
        this.mpi = (InteractiveArrow)this.addElement(new ControlArrow(), "mpi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "%_model._method_for_mpi_x()%").setProperty("y", "ymin").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_mpi_sizey()%").setProperty("visible", "cylinder").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green").getObject();
        this.ppi = (InteractiveArrow)this.addElement(new ControlArrow(), "ppi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "%_model._method_for_ppi_x()%").setProperty("y", "ymin").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_ppi_sizey()%").setProperty("visible", "cylinder").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,7,0,0").getObject();
        this.Gamma = (JTextField)this.addElement(new ControlNumberField(), "Gamma").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("action", "_model._method_for_Gamma_action()").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Double of the damping coefficient")).getObject();
        this.Kn = (JTextField)this.addElement(new ControlNumberField(), "Kn").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "n").setProperty("format", this._simulation.translateString("View.Kn.format", "N = 0")).setProperty("action", "_model._method_for_Kn_action()").setProperty("tooltip", this._simulation.translateString("View.Kn.tooltip", "Number of trajectories")).getObject();
        this.Harmonics = (JCheckBox)this.addElement(new ControlCheckBox(), "Harmonics").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "harmonic").setProperty("text", this._simulation.translateString("View.Harmonics.text", "Harmonic")).setProperty("mnemonic", this._simulation.translateString("View.Harmonics.mnemonic", "h")).setProperty("enabled", "%_model._method_for_Harmonics_enabled()%").setProperty("action", "_model._method_for_Harmonics_action()").setProperty("actionon", "_model._method_for_Harmonics_actionon()").setProperty("tooltip", this._simulation.translateString("View.Harmonics.tooltip", "Harmonic oscillator instead of pendulum")).getObject();
        this.Cylinder = (JCheckBox)this.addElement(new ControlCheckBox(), "Cylinder").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "cylinder").setProperty("text", this._simulation.translateString("View.Cylinder.text", "Cylinder")).setProperty("mnemonic", this._simulation.translateString("View.Cylinder.mnemonic", "c")).setProperty("enabled", "%_model._method_for_Cylinder_enabled()%").setProperty("action", "_model._method_for_Cylinder_action()").setProperty("tooltip", this._simulation.translateString("View.Cylinder.tooltip", "Angle goes only from -pi to pi")).getObject();
        this.Traj = (JCheckBox)this.addElement(new ControlCheckBox(), "Traj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "traj").setProperty("text", this._simulation.translateString("View.Traj.text", "Trajectories")).setProperty("mnemonic", this._simulation.translateString("View.Traj.mnemonic", "t")).setProperty("tooltip", this._simulation.translateString("View.Traj.tooltip", "Draw phase trajectories")).getObject();
        this.Kdt = (JTextField)this.addElement(new ControlNumberField(), "Kdt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Kdt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Kdt.tooltip", "Integration step")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation")).getObject();
        this.initialButton = (JButton)this.addElement(new ControlButton(), "initialButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("text", this._simulation.translateString("View.initialButton.text", "")).setProperty("image", this._simulation.translateString("View.initialButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("action", "_model._method_for_initialButton_action()").setProperty("tooltip", this._simulation.translateString("View.initialButton.tooltip", "Start from initial conditions")).getObject();
        this.Reset = (JButton)this.addElement(new ControlButton(), "Reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.Reset.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Reset.mnemonic", "r")).setProperty("action", "_model._method_for_Reset_action()").setProperty("tooltip", this._simulation.translateString("View.Reset.tooltip", "Recover initial settings")).getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Phase space")).setProperty("visible", "true");
        this.getElement("PhaseSpace").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "d$\\phi$/dt")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "$\\phi$=0.### /")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "d$\\phi$/dt=0.###")).setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Click to erase"));
        this.getElement("Points").setProperty("sizex", "0.1").setProperty("sizey", "0.1").setProperty("enabled", "false").setProperty("secondaryColor", "red");
        this.getElement("Trajectories").setProperty("color", "blue");
        this.getElement("mpi").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green");
        this.getElement("ppi").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Double of the damping coefficient"));
        this.getElement("Kn").setProperty("format", this._simulation.translateString("View.Kn.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.Kn.tooltip", "Number of trajectories"));
        this.getElement("Harmonics").setProperty("text", this._simulation.translateString("View.Harmonics.text", "Harmonic")).setProperty("mnemonic", this._simulation.translateString("View.Harmonics.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.Harmonics.tooltip", "Harmonic oscillator instead of pendulum"));
        this.getElement("Cylinder").setProperty("text", this._simulation.translateString("View.Cylinder.text", "Cylinder")).setProperty("mnemonic", this._simulation.translateString("View.Cylinder.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Cylinder.tooltip", "Angle goes only from -pi to pi"));
        this.getElement("Traj").setProperty("text", this._simulation.translateString("View.Traj.text", "Trajectories")).setProperty("tooltip", this._simulation.translateString("View.Traj.tooltip", "Draw phase trajectories"));
        this.getElement("Kdt").setProperty("format", this._simulation.translateString("View.Kdt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Kdt.tooltip", "Integration step"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation"));
        this.getElement("initialButton").setProperty("text", this._simulation.translateString("View.initialButton.text", "")).setProperty("image", this._simulation.translateString("View.initialButton.image", "/org/opensourcephysics/resources/controls/images/initial.gif")).setProperty("tooltip", this._simulation.translateString("View.initialButton.tooltip", "Start from initial conditions"));
        this.getElement("Reset").setProperty("image", this._simulation.translateString("View.Reset.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Reset.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.Reset.tooltip", "Recover initial settings"));
        super.reset();
    }
}

