/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.phase_space;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.phase_space.phase_spaceSimulation;
import users.ehu.jma.analytical_mechanics.phase_space.phase_spaceView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class phase_space
extends AbstractModel {
    public phase_spaceSimulation _simulation = null;
    public phase_spaceView _view = null;
    public phase_space _model = this;
    public double t = 0.0;
    public int nmax = 125;
    public double[] q;
    public double[] qd;
    public double gamma = 0.0;
    public boolean harmonic = false;
    public int n = 24;
    public double xmin = -4.0;
    public double xmax = 4.0;
    public double ymin = -3.0;
    public double ymax = 3.0;
    public double dt = 0.02;
    public double tol = 1.0E-6;
    public boolean cylinder = true;
    public boolean traj = true;
    public boolean canContinue = false;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/phase_space.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        phase_space phase_space2 = new phase_space(stringArray);
    }

    public phase_space() {
        this(null, null, null, null, null, false);
    }

    public phase_space(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public phase_space(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new phase_spaceSimulation(this, string, frame, uRL, bl);
        this._view = (phase_spaceView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        if (this.harmonic) {
            for (int i = 0; i < this.n; ++i) {
                double d = 2.0 * this.xmax / (double)this.n;
                this.q[i] = (double)(i + 1) * d;
                this.qd[i] = 0.0;
            }
        } else {
            double d;
            int n;
            for (n = 0; n < this.n / 3; ++n) {
                d = this.cylinder ? Math.PI * 3 / (double)this.n : 3.0 * this.xmax / (double)this.n;
                this.q[n] = (double)n * d;
                this.qd[n] = 0.0;
            }
            for (n = this.n / 3; n < 2 * this.n / 3; ++n) {
                d = 3.0 * this.ymax / (double)this.n;
                this.q[n] = this.cylinder ? -3.1315926535897933 : this.xmin;
                this.qd[n] = (double)(n - this.n / 3) * d;
            }
            for (n = 2 * this.n / 3; n < this.n; ++n) {
                d = 3.0 * this.ymax / (double)this.n;
                this.q[n] = this.cylinder ? 3.1315926535897933 : this.xmax;
                this.qd[n] = (double)(-(n - 2 * this.n / 3)) * d;
            }
        }
        this.canContinue = false;
        this._view.resetTraces();
    }

    public void _evolution2() {
        if (this.cylinder) {
            int n;
            this._view.getElement("Trajectories").setProperty("connected", "true");
            for (n = 0; n < this.n; ++n) {
                if (!(this.q[n] < -Math.PI) && !(this.q[n] > Math.PI)) continue;
                this._view.getElement("Trajectories").setProperty("connected", "false");
                break;
            }
            for (n = 0; n < this.n; ++n) {
                if (this.q[n] < -Math.PI) {
                    int n2 = n;
                    this.q[n2] = this.q[n2] + Math.PI * 2;
                    continue;
                }
                if (!(this.q[n] > Math.PI)) continue;
                int n3 = n;
                this.q[n3] = this.q[n3] - Math.PI * 2;
            }
        }
    }

    public void _constraints1() {
        if (this.n < 6) {
            this.n = 1;
        } else if (this.n > this.nmax) {
            this.n = this.nmax;
        }
    }

    public double vel(int n, double d, double d2) {
        return n >= this.n ? 0.0 : d2;
    }

    public double acc(int n, double d, double d2) {
        if (n >= this.n) {
            return 0.0;
        }
        return this.harmonic ? -this.gamma * d2 - d : -this.gamma * d2 - Math.sin(d);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_PhaseSpace_pressaction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public double _method_for_mpi_x() {
        return -Math.PI;
    }

    public double _method_for_mpi_sizey() {
        return this.ymax - this.ymin;
    }

    public double _method_for_ppi_x() {
        return Math.PI;
    }

    public double _method_for_ppi_sizey() {
        return this.ymax - this.ymin;
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Kn_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Harmonics_enabled() {
        return this._isPaused();
    }

    public void _method_for_Harmonics_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Harmonics_actionon() {
        this._simulation.disableLoop();
        this.cylinder = false;
        this._simulation.enableLoop();
    }

    public boolean _method_for_Cylinder_enabled() {
        return !this.harmonic && this._isPaused();
    }

    public void _method_for_Cylinder_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_initialButton_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_Reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nmax = 125;
        this.q = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.q[n] = 0.5;
        }
        this.qd = new double[this.nmax];
        for (n = 0; n < this.nmax; ++n) {
            this.qd[n] = 0.0;
        }
        this.gamma = 0.0;
        this.harmonic = false;
        this.n = 24;
        this.xmin = -4.0;
        this.xmax = 4.0;
        this.ymin = -3.0;
        this.ymax = 3.0;
        this.dt = 0.02;
        this.tol = 1.0E-6;
        this.cylinder = true;
        this.traj = true;
        this.canContinue = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.q = null;
        this.qd = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _q;
        private double[] _qd;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + phase_space.this.q.length + phase_space.this.qd.length];
            this._q = new double[phase_space.this.q.length];
            this._qd = new double[phase_space.this.qd.length];
        }

        private boolean arraysChanged() {
            if (phase_space.this.q.length != this._q.length) {
                return true;
            }
            return phase_space.this.qd.length != this._qd.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : phase_space.this.q) {
            }
            for (double this.__state[n++] : phase_space.this.qd) {
            }
            this.__state[n++] = phase_space.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(phase_space.this.dt);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (phase_space.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(phase_space.this.tol);
            }
            if (phase_space.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(phase_space.this.dt);
            }
            int n2 = 0;
            for (double this.__state[n2++] : phase_space.this.q) {
            }
            for (double this.__state[n2++] : phase_space.this.qd) {
            }
            this.__state[n2++] = phase_space.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = phase_space.this.q.length;
            for (n = 0; n < n3; ++n) {
                phase_space.this.q[n] = this.__state[n2++];
            }
            n3 = phase_space.this.qd.length;
            for (n = 0; n < n3; ++n) {
                phase_space.this.qd[n] = this.__state[n2++];
            }
            phase_space.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = phase_space.this.q.length;
            for (n = 0; n < n3; ++n) {
                this._q[n] = dArray[n2++];
            }
            n3 = phase_space.this.qd.length;
            for (n = 0; n < n3; ++n) {
                this._qd[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = phase_space.this.q.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_1(n, this._q, this._qd, this._t);
            }
            n3 = phase_space.this.qd.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_2(n, this._q, this._qd, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution1_1(int n, double[] dArray, double[] dArray2, double d) {
            return phase_space.this.vel(n, dArray[n], dArray2[n]);
        }

        private double _ODE_evolution1_2(int n, double[] dArray, double[] dArray2, double d) {
            return phase_space.this.acc(n, dArray[n], dArray2[n]);
        }
    }
}

