/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.pendulum;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.display3d.ControlCircleSet3D;
import org.colos.ejs.library.control.display3d.ControlDrawingPanel3D;
import org.colos.ejs.library.control.display3d.ControlElement3DCylinder;
import org.colos.ejs.library.control.display3d.ControlElement3DSegment;
import org.colos.ejs.library.control.display3d.ControlTrailSet3D;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlTraceSet;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.ElementCylinder;
import org.opensourcephysics.display3d.core.ElementSegment;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.TraceSet;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.pendulum.pendulum;
import users.ehu.jma.analytical_mechanics.pendulum.pendulumSimulation;

class pendulumView
extends EjsControl
implements View {
    private pendulumSimulation _simulation = null;
    private pendulum _model = null;
    public Component main;
    public JPanel drawingPanel;
    public PlottingPanel2D phaseSpace;
    public InteractiveArrow ppi;
    public InteractiveArrow mpi;
    public TraceSet porbits;
    public ElementSet ppoints;
    public InteractiveArrow Yaxis;
    public InteractiveArrow Xaxis;
    public DrawingPanel3D cylinder;
    public ElementCylinder phase;
    public ElementCylinder xaxis;
    public ElementSegment YAxis;
    public ElementSegment Ident;
    public Group orbits;
    public Group points;
    public JPanel controlPanel;
    public JPanel buttonsPanel;
    public JButton startButton;
    public JButton resetButton;
    public JButton clearButton;
    public JPanel parameterPanel;
    public JLabel dtLabel;
    public JTextField dt;

    public pendulumView(pendulumSimulation pendulumSimulation2, String string, Frame frame) {
        super(pendulumSimulation2, string, frame);
        this._simulation = pendulumSimulation2;
        this._model = (pendulum)pendulumSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("Norb", "apply(\"Norb\")");
        this.addListener("Nl", "apply(\"Nl\")");
        this.addListener("Norbmax", "apply(\"Norbmax\")");
        this.addListener("phi", "apply(\"phi\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("gl", "apply(\"gl\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("y", "apply(\"y\")");
        this.addListener("z", "apply(\"z\")");
        this.addListener("h", "apply(\"h\")");
        this.addListener("xmax", "apply(\"xmax\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("Norb".equals(string)) {
            this._model.Norb = this.getInt("Norb");
        }
        if ("Nl".equals(string)) {
            this._model.Nl = this.getInt("Nl");
        }
        if ("Norbmax".equals(string)) {
            this._model.Norbmax = this.getInt("Norbmax");
        }
        if ("phi".equals(string)) {
            dArray = (double[])this.getValue("phi").getObject();
            n2 = dArray.length;
            if (n2 > this._model.phi.length) {
                n2 = this._model.phi.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.phi[n] = dArray[n];
            }
        }
        if ("omega".equals(string)) {
            dArray = (double[])this.getValue("omega").getObject();
            n2 = dArray.length;
            if (n2 > this._model.omega.length) {
                n2 = this._model.omega.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.omega[n] = dArray[n];
            }
        }
        if ("gl".equals(string)) {
            this._model.gl = this.getDouble("gl");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            dArray = (double[])this.getValue("x").getObject();
            n2 = dArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = dArray[n];
            }
        }
        if ("y".equals(string)) {
            dArray = (double[])this.getValue("y").getObject();
            n2 = dArray.length;
            if (n2 > this._model.y.length) {
                n2 = this._model.y.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.y[n] = dArray[n];
            }
        }
        if ("z".equals(string)) {
            dArray = (double[])this.getValue("z").getObject();
            n2 = dArray.length;
            if (n2 > this._model.z.length) {
                n2 = this._model.z.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.z[n] = dArray[n];
            }
        }
        if ("h".equals(string)) {
            this._model.h = this.getDouble("h");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("Norb", this._model.Norb);
        this.setValue("Nl", this._model.Nl);
        this.setValue("Norbmax", this._model.Norbmax);
        this.setValue("phi", this._model.phi);
        this.setValue("omega", this._model.omega);
        this.setValue("gl", this._model.gl);
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("y", this._model.y);
        this.setValue("z", this._model.z);
        this.setValue("h", this._model.h);
        this.setValue("xmax", this._model.xmax);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.main = (Component)this.addElement(new ControlFrame(), "main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.main.title", "Mathematical pendulum")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "53,3").setProperty("size", this._simulation.translateString("View.main.size", "747,436")).getObject();
        this.drawingPanel = (JPanel)this.addElement(new ControlPanel(), "drawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "main").setProperty("layout", "border").getObject();
        this.phaseSpace = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "phaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "drawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "%_model._method_for_phaseSpace_minimumX()%").setProperty("maximumX", "xmax").setProperty("minimumY", "-1.5").setProperty("maximumY", "1.5").setProperty("title", this._simulation.translateString("View.phaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.phaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.phaseSpace.titleY", "d$\\phi$/dt")).setProperty("background", "WHITE").getObject();
        this.ppi = (InteractiveArrow)this.addElement(new ControlArrow(), "ppi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("x", "%_model._method_for_ppi_x()%").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "MAGENTA").setProperty("stroke", "2").getObject();
        this.mpi = (InteractiveArrow)this.addElement(new ControlArrow(), "mpi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("x", "%_model._method_for_mpi_x()%").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "MAGENTA").setProperty("stroke", "2").getObject();
        this.porbits = (TraceSet)this.addElement(new ControlTraceSet(), "porbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("elementnumber", "Norb").setProperty("x", "phi").setProperty("y", "z").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE").getObject();
        this.ppoints = (ElementSet)this.addElement(new ControlParticleSet(), "ppoints").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("elementnumber", "Norb").setProperty("x", "phi").setProperty("y", "z").setProperty("sizex", ".1").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "RED").getObject();
        this.Yaxis = (InteractiveArrow)this.addElement(new ControlArrow(), "Yaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "RED").setProperty("secondaryColor", "RED").setProperty("stroke", "3").getObject();
        this.Xaxis = (InteractiveArrow)this.addElement(new ControlArrow(), "Xaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phaseSpace").setProperty("x", "%_model._method_for_Xaxis_x()%").setProperty("sizex", "%_model._method_for_Xaxis_sizex()%").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3").getObject();
        this.cylinder = (DrawingPanel3D)this.addElement(new ControlDrawingPanel3D(), "cylinder").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "drawingPanel").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("minimumZ", "-1.0").setProperty("maximumZ", "1.0").setProperty("cameraAzimuth", "-0.9399999999999995").setProperty("cameraAltitude", "0.3800000000000001").setProperty("cameraFocusX", "0.0").setProperty("cameraFocusY", "0.0").setProperty("cameraFocusZ", "0.0").setProperty("cameraRotation", "0.0").setProperty("cameraDistanceToScreen", "4.5").setProperty("releaseAction", "_model._method_for_cylinder_releaseAction()").setProperty("decorationType", "NONE").setProperty("background", "WHITE").getObject();
        this.phase = (ElementCylinder)this.addElement(new ControlElement3DCylinder(), "phase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("sizeX", "1.96").setProperty("sizeY", "1.96").setProperty("sizeZ", "3").setProperty("visible", "true").setProperty("enabledPosition", "false").setProperty("closedTop", "false").setProperty("closedBottom", "false").setProperty("lineColor", "GRAY").setProperty("fillColor", "null").setProperty("drawingLines", "true").setProperty("drawingFill", "false").setProperty("resolution", "12,12,6").getObject();
        this.xaxis = (ElementCylinder)this.addElement(new ControlElement3DCylinder(), "xaxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("sizeX", "2").setProperty("sizeY", "2").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("closedTop", "false").setProperty("closedBottom", "false").setProperty("lineColor", "0,128,0,255").setProperty("lineWidth", "3").setProperty("resolution", "20,20,0,").getObject();
        this.YAxis = (ElementSegment)this.addElement(new ControlElement3DSegment(), "YAxis").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("x", "1").setProperty("y", "0").setProperty("z", "-1.5").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("sizeZ", "3").setProperty("enabledPosition", "false").setProperty("enabledSize", "false").setProperty("lineColor", "RED").setProperty("lineWidth", "5").getObject();
        this.Ident = (ElementSegment)this.addElement(new ControlElement3DSegment(), "Ident").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("x", "-1").setProperty("y", "0").setProperty("z", "-1.5").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("sizeZ", "3").setProperty("enabledPosition", "false").setProperty("enabledSize", "false").setProperty("lineColor", "MAGENTA").setProperty("lineWidth", "3").setProperty("resolution", "15,15,5").getObject();
        this.orbits = (Group)this.addElement(new ControlTrailSet3D(), "orbits").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("numberOfElements", "Norb").setProperty("inputX", "x").setProperty("inputY", "y").setProperty("inputZ", "z").setProperty("enabledPosition", "false").setProperty("lineColor", "BLUE").getObject();
        this.points = (Group)this.addElement(new ControlCircleSet3D(), "points").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "cylinder").setProperty("numberOfElements", "Norb").setProperty("x", "x").setProperty("y", "y").setProperty("z", "z").setProperty("sizeX", ".05").setProperty("sizeY", ".05").setProperty("sizeZ", ".05").setProperty("enabledPosition", "false").setProperty("fillColor", "RED").getObject();
        this.controlPanel = (JPanel)this.addElement(new ControlPanel(), "controlPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "main").setProperty("layout", "BORDER:0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.buttonsPanel = (JPanel)this.addElement(new ControlPanel(), "buttonsPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "controlPanel").setProperty("layout", "grid:1,0,0,0").getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset the initial conditions.")).getObject();
        this.clearButton = (JButton)this.addElement(new ControlButton(), "clearButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "buttonsPanel").setProperty("image", this._simulation.translateString("View.clearButton.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.clearButton.mnemonic", "e")).setProperty("action", "_model._method_for_clearButton_action()").setProperty("tooltip", this._simulation.translateString("View.clearButton.tooltip", "Erase the orbits.")).getObject();
        this.parameterPanel = (JPanel)this.addElement(new ControlPanel(), "parameterPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "controlPanel").setProperty("layout", "border").getObject();
        this.dtLabel = (JLabel)this.addElement(new ControlLabel(), "dtLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "parameterPanel").setProperty("text", this._simulation.translateString("View.dtLabel.text", "$\\Delta$t = ")).getObject();
        this.dt = (JTextField)this.addElement(new ControlParsedNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "parameterPanel").setProperty("variable", "h").setProperty("format", this._simulation.translateString("View.dt.format", "0.#######")).setProperty("size", this._simulation.translateString("View.dt.size", "40,20")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Time step.")).getObject();
    }

    public void reset() {
        this.getElement("main").setProperty("title", this._simulation.translateString("View.main.title", "Mathematical pendulum")).setProperty("visible", "true");
        this.getElement("drawingPanel");
        this.getElement("phaseSpace").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumY", "-1.5").setProperty("maximumY", "1.5").setProperty("title", this._simulation.translateString("View.phaseSpace.title", "Phase space")).setProperty("titleX", this._simulation.translateString("View.phaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.phaseSpace.titleY", "d$\\phi$/dt")).setProperty("background", "WHITE");
        this.getElement("ppi").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "MAGENTA").setProperty("stroke", "2");
        this.getElement("mpi").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "MAGENTA").setProperty("stroke", "2");
        this.getElement("porbits").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE");
        this.getElement("ppoints").setProperty("sizex", ".1").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("color", "RED");
        this.getElement("Yaxis").setProperty("y", "-1.5").setProperty("sizex", "0").setProperty("sizey", "3").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "RED").setProperty("secondaryColor", "RED").setProperty("stroke", "3");
        this.getElement("Xaxis").setProperty("sizey", "0").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "0,128,0,255").setProperty("secondaryColor", "0,128,0,255").setProperty("stroke", "3");
        this.getElement("cylinder").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("minimumZ", "-1.0").setProperty("maximumZ", "1.0").setProperty("cameraAzimuth", "-0.9399999999999995").setProperty("cameraAltitude", "0.3800000000000001").setProperty("cameraFocusX", "0.0").setProperty("cameraFocusY", "0.0").setProperty("cameraFocusZ", "0.0").setProperty("cameraRotation", "0.0").setProperty("cameraDistanceToScreen", "4.5").setProperty("decorationType", "NONE").setProperty("background", "WHITE");
        this.getElement("phase").setProperty("x", "0").setProperty("y", "0").setProperty("z", "0").setProperty("sizeX", "1.96").setProperty("sizeY", "1.96").setProperty("sizeZ", "3").setProperty("visible", "true").setProperty("enabledPosition", "false").setProperty("closedTop", "false").setProperty("closedBottom", "false").setProperty("lineColor", "GRAY").setProperty("fillColor", "null").setProperty("drawingLines", "true").setProperty("drawingFill", "false").setProperty("resolution", "12,12,6");
        this.getElement("xaxis").setProperty("sizeX", "2").setProperty("sizeY", "2").setProperty("sizeZ", "0").setProperty("enabledPosition", "false").setProperty("closedTop", "false").setProperty("closedBottom", "false").setProperty("lineColor", "0,128,0,255").setProperty("lineWidth", "3").setProperty("resolution", "20,20,0,");
        this.getElement("YAxis").setProperty("x", "1").setProperty("y", "0").setProperty("z", "-1.5").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("sizeZ", "3").setProperty("enabledPosition", "false").setProperty("enabledSize", "false").setProperty("lineColor", "RED").setProperty("lineWidth", "5");
        this.getElement("Ident").setProperty("x", "-1").setProperty("y", "0").setProperty("z", "-1.5").setProperty("sizeX", "0").setProperty("sizeY", "0").setProperty("sizeZ", "3").setProperty("enabledPosition", "false").setProperty("enabledSize", "false").setProperty("lineColor", "MAGENTA").setProperty("lineWidth", "3").setProperty("resolution", "15,15,5");
        this.getElement("orbits").setProperty("enabledPosition", "false").setProperty("lineColor", "BLUE");
        this.getElement("points").setProperty("sizeX", ".05").setProperty("sizeY", ".05").setProperty("sizeZ", ".05").setProperty("enabledPosition", "false").setProperty("fillColor", "RED");
        this.getElement("controlPanel").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("buttonsPanel");
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset the initial conditions."));
        this.getElement("clearButton").setProperty("image", this._simulation.translateString("View.clearButton.image", "/org/opensourcephysics/resources/controls/images/erase.gif")).setProperty("mnemonic", this._simulation.translateString("View.clearButton.mnemonic", "e")).setProperty("tooltip", this._simulation.translateString("View.clearButton.tooltip", "Erase the orbits."));
        this.getElement("parameterPanel");
        this.getElement("dtLabel").setProperty("text", this._simulation.translateString("View.dtLabel.text", "$\\Delta$t = "));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "0.#######")).setProperty("size", this._simulation.translateString("View.dt.size", "40,20")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Time step."));
        super.reset();
    }
}

