/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.pendulum;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.pendulum.pendulumSimulation;
import users.ehu.jma.analytical_mechanics.pendulum.pendulumView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class pendulum
extends AbstractModel {
    public pendulumSimulation _simulation = null;
    public pendulumView _view = null;
    public pendulum _model = this;
    public int Norb = 14;
    public int Nl = 4;
    public int Norbmax = 14;
    public double[] phi;
    public double[] omega;
    public double gl = 1.0;
    public double t = 0.0;
    public double[] x;
    public double[] y;
    public double[] z;
    public double h = 0.1;
    public double xmax = 4.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/pendulum.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        pendulum pendulum2 = new pendulum(stringArray);
    }

    public pendulum() {
        this(null, null, null, null, null, false);
    }

    public pendulum(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public pendulum(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new pendulumSimulation(this, string, frame, uRL, bl);
        this._view = (pendulumView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        int n;
        double d = 3.1315926535897933;
        int n2 = this.Nl;
        int n3 = this.Norb - 2 * n2;
        this.t = 0.0;
        for (n = 0; n < n3 / 2; ++n) {
            this.phi[n] = -d + 2.0 * d / (double)(n3 - 1) * (double)n;
        }
        for (n = 0; n < n2; ++n) {
            this.phi[n3 + n] = n < n2 / 2 ? this.xmax : -this.xmax;
            this.omega[n3 + n] = -1.5 + 3.0 * (double)n / (double)(n2 - 1);
        }
    }

    public void _constraints1() {
        for (int i = 0; i < this.Norb; ++i) {
            this.x[i] = Math.cos(this.phi[i]);
            this.y[i] = Math.sin(this.phi[i]);
            this.z[i] = 0.5 * this.omega[i];
        }
    }

    public double _method_for_phaseSpace_minimumX() {
        return -this.xmax;
    }

    public double _method_for_ppi_x() {
        return Math.PI;
    }

    public double _method_for_mpi_x() {
        return -Math.PI;
    }

    public double _method_for_Xaxis_x() {
        return -this.xmax;
    }

    public double _method_for_Xaxis_sizex() {
        return 2.0 * this.xmax;
    }

    public void _method_for_cylinder_releaseAction() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_clearButton_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.Norb = 14;
        this.Nl = 4;
        this.Norbmax = 14;
        this.phi = new double[this.Norbmax];
        for (n = 0; n < this.Norbmax; ++n) {
            this.phi[n] = 0.0;
        }
        this.omega = new double[this.Norbmax];
        for (n = 0; n < this.Norbmax; ++n) {
            this.omega[n] = 0.0;
        }
        this.gl = 1.0;
        this.t = 0.0;
        this.x = new double[this.Norbmax];
        for (n = 0; n < this.Norbmax; ++n) {
            this.x[n] = 0.0;
        }
        this.y = new double[this.Norbmax];
        for (n = 0; n < this.Norbmax; ++n) {
            this.y[n] = 0.0;
        }
        this.z = new double[this.Norbmax];
        for (n = 0; n < this.Norbmax; ++n) {
            this.z[n] = 0.0;
        }
        this.h = 0.1;
        this.xmax = 4.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.phi = null;
        this.omega = null;
        this.x = null;
        this.y = null;
        this.z = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _phi;
        private double[] _omega;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + pendulum.this.phi.length + pendulum.this.omega.length];
            this._phi = new double[pendulum.this.phi.length];
            this._omega = new double[pendulum.this.omega.length];
        }

        private boolean arraysChanged() {
            if (pendulum.this.phi.length != this._phi.length) {
                return true;
            }
            return pendulum.this.omega.length != this._omega.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : pendulum.this.phi) {
            }
            for (double this.__state[n++] : pendulum.this.omega) {
            }
            this.__state[n++] = pendulum.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(pendulum.this.h);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (1.0E-5 != this.__solver.getTolerance()) {
                this.__solver.setTolerance(1.0E-5);
            }
            if (pendulum.this.h != this.__solver.getStepSize()) {
                this.__solver.setStepSize(pendulum.this.h);
            }
            int n2 = 0;
            for (double this.__state[n2++] : pendulum.this.phi) {
            }
            for (double this.__state[n2++] : pendulum.this.omega) {
            }
            this.__state[n2++] = pendulum.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = pendulum.this.phi.length;
            for (n = 0; n < n3; ++n) {
                pendulum.this.phi[n] = this.__state[n2++];
            }
            n3 = pendulum.this.omega.length;
            for (n = 0; n < n3; ++n) {
                pendulum.this.omega[n] = this.__state[n2++];
            }
            pendulum.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = pendulum.this.phi.length;
            for (n = 0; n < n3; ++n) {
                this._phi[n] = dArray[n2++];
            }
            n3 = pendulum.this.omega.length;
            for (n = 0; n < n3; ++n) {
                this._omega[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = pendulum.this.phi.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_1(n, this._phi, this._omega, this._t);
            }
            n3 = pendulum.this.omega.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_2(n, this._phi, this._omega, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution1_1(int n, double[] dArray, double[] dArray2, double d) {
            return dArray2[n];
        }

        private double _ODE_evolution1_2(int n, double[] dArray, double[] dArray2, double d) {
            return -pendulum.this.gl * Math.sin(dArray[n]);
        }
    }
}

