/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.cone;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.cone.coneSimulation;
import users.ehu.jma.analytical_mechanics.cone.coneView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cone
extends AbstractModel {
    public coneSimulation _simulation = null;
    public coneView _view = null;
    public cone _model = this;
    public double t = 0.0;
    public double r = 1.0;
    public double phi = 0.0;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double E = 2.0;
    public double rp = 0.0;
    public double L = 3.0;
    public double r0 = 1.0;
    public double E0 = 0.0;
    public double alpha = 0.0;
    public double cosa = 0.0;
    public double sina = 0.0;
    public double dt = 0.2;
    public boolean orbits = false;
    public boolean limits = false;
    public boolean showGravity = true;
    public boolean showCone = true;
    public double phimax = 0.0;
    public double rmax = 1.0;
    public double rmin = 1.0;
    public double tol = 1.0E-6;
    public double xmax = 2.0;
    public double R = 5.0;
    public double a = 0.2;
    public double alphaDegrees = 45.0;
    public double alphaMin = 15.0;
    public double alphaMax = 75.0;
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/cone.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        cone cone2 = new cone(stringArray);
    }

    public cone() {
        this(null, null, null, null, null, false);
    }

    public cone(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public cone(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new coneSimulation(this, string, frame, uRL, bl);
        this._view = (coneView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        if (this.alphaDegrees < this.alphaMin) {
            this.alphaDegrees = this.alphaMin;
        } else if (this.alphaDegrees > this.alphaMax) {
            this.alphaDegrees = this.alphaMax;
        }
        this.alpha = Math.toRadians(this.alphaDegrees);
        this.cosa = Math.cos(this.alpha);
        this.sina = Math.sin(this.alpha);
        this.putphixy();
    }

    public void _evolution2() {
        if (this.phi > Math.PI) {
            this.phi -= Math.PI * 2;
        }
        this.putxy();
    }

    public void _constraints1() {
        this.r0 = Math.pow(this.cosa * this.sina * this.sina, -0.33333333333);
        this.E0 = 1.5 / (this.r0 * this.r0 * this.sina * this.sina);
        if (this.E < this.E0) {
            this.E = this.E0;
        }
        double d = 0.01;
        this.rmin = this.r0;
        while (0.5 / (this.rmin * this.rmin * this.sina * this.sina) + this.rmin * this.cosa < this.E) {
            this.rmin -= d;
        }
        this.rmax = this.r0;
        while (0.5 / (this.rmax * this.rmax * this.sina * this.sina) + this.rmax * this.cosa < this.E) {
            this.rmax += d;
        }
    }

    public void putxy() {
        this.x = this.r * this.sina * Math.cos(this.phi);
        this.y = this.r * this.sina * Math.sin(this.phi);
        this.z = this.r * this.cosa;
    }

    public void putE() {
        if (this.r <= 0.0) {
            this.r = this.r0;
        }
        this.E = Math.max(this.E, 0.5 / (this.r * this.r * this.sina * this.sina) + this.r * this.cosa);
        this.rp = Math.sqrt(2.0 * (this.E - 0.5 / (this.r * this.r * this.sina * this.sina) - this.r * this.cosa));
        this._view.resetTraces();
    }

    public void putphixy() {
        this.putE();
        this.putxy();
    }

    public double _method_for_Space_minimumX() {
        return -this.xmax;
    }

    public double _method_for_Space_minimumY() {
        return -this.xmax;
    }

    public double _method_for_Space_minimumZ() {
        return -this.xmax;
    }

    public double _method_for_Cone_z() {
        return 0.5 * this.R * this.cosa - 0.25;
    }

    public double _method_for_Cone_sizeX() {
        return 2.0 * this.R * this.sina;
    }

    public double _method_for_Cone_sizeY() {
        return 2.0 * this.R * this.sina;
    }

    public double _method_for_Cone_sizeZ() {
        return -this.R * this.cosa;
    }

    public double _method_for_Rminimum_z() {
        return this.rmin * this.cosa;
    }

    public double _method_for_Rminimum_sizeX() {
        return 2.0 * this.rmin * this.sina;
    }

    public double _method_for_Rminimum_sizeY() {
        return 2.0 * this.rmin * this.sina;
    }

    public double _method_for_Rmaximum_z() {
        return this.rmax * this.cosa;
    }

    public double _method_for_Rmaximum_sizeX() {
        return 2.0 * this.rmax * this.sina;
    }

    public double _method_for_Rmaximum_sizeY() {
        return 2.0 * this.rmax * this.sina;
    }

    public void _method_for_Dim1_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public double _method_for_Energy_sizex() {
        return this.rmax - this.rmin;
    }

    public void _method_for_Particle1_dragaction() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Particle1_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    public void _method_for_BE_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public void _method_for_Br_action() {
        this._simulation.disableLoop();
        this.putphixy();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Angle_editable() {
        return this._isPaused();
    }

    public void _method_for_Angle_action() {
        this._simulation.disableLoop();
        this._initialize();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_Reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_Clear_action() {
        this._simulation.disableLoop();
        this._view.resetTraces();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.t = 0.0;
        this.r = 1.0;
        this.phi = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.E = 2.0;
        this.rp = 0.0;
        this.L = 3.0;
        this.r0 = 1.0;
        this.E0 = 0.0;
        this.alpha = 0.0;
        this.cosa = 0.0;
        this.sina = 0.0;
        this.dt = 0.2;
        this.orbits = false;
        this.limits = false;
        this.showGravity = true;
        this.showCone = true;
        this.phimax = 0.0;
        this.rmax = 1.0;
        this.rmin = 1.0;
        this.tol = 1.0E-6;
        this.xmax = 2.0;
        this.R = 5.0;
        this.a = 0.2;
        this.alphaDegrees = 45.0;
        this.alphaMin = 15.0;
        this.alphaMax = 75.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double _r;
        private double _rp;
        private double _phi;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[4];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = cone.this.r;
            this.__state[n++] = cone.this.rp;
            this.__state[n++] = cone.this.phi;
            this.__state[n++] = cone.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(cone.this.dt);
        }

        void step() {
            if (cone.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(cone.this.tol);
            }
            if (cone.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(cone.this.dt);
            }
            int n = 0;
            this.__state[n++] = cone.this.r;
            this.__state[n++] = cone.this.rp;
            this.__state[n++] = cone.this.phi;
            this.__state[n++] = cone.this.t;
            this.__solver.step();
            n = 0;
            cone.this.r = this.__state[n++];
            cone.this.rp = this.__state[n++];
            cone.this.phi = this.__state[n++];
            cone.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._r = dArray[n++];
            this._rp = dArray[n++];
            this._phi = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._r, this._rp, this._phi, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._r, this._rp, this._phi, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._r, this._rp, this._phi, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4) {
            return d2;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4) {
            return 1.0 / (d * d * d * cone.this.sina * cone.this.sina) - cone.this.cosa;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4) {
            return 1.0 / (d * d * cone.this.sina * cone.this.sina);
        }
    }
}

