/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.adiabatic;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlArrowSet;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBoxMenuItem;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlLabel;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlParsedNumberField;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.adiabatic.adiabatic;
import users.ehu.jma.analytical_mechanics.adiabatic.adiabaticSimulation;

class adiabaticView
extends EjsControl
implements View {
    private adiabaticSimulation _simulation = null;
    private adiabatic _model = null;
    public Component Main;
    public JPanel center;
    public JPanel upper;
    public JPanel biesp;
    public PlottingPanel2D phase;
    public InteractiveTrace orbit;
    public PlottingPanel2D phase2;
    public ElementSet fillvectors;
    public InteractiveTrace orbit2;
    public InteractiveArrow position;
    public JPanel controls;
    public JTextField omega0;
    public JTextField alpha;
    public JTextField beta;
    public JTextField dt;
    public JTextField tolerance;
    public JCheckBoxMenuItem partial;
    public JCheckBoxMenuItem fillarea;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JPanel down;
    public JPanel numeric;
    public JLabel areaVal;
    public JLabel Eval;
    public JLabel omegaVal;
    public PlottingPanel2D evolution;
    public InteractiveTrace areatrace;
    public ElementSet endareas;

    public adiabaticView(adiabaticSimulation adiabaticSimulation2, String string, Frame frame) {
        super(adiabaticSimulation2, string, frame);
        this._simulation = adiabaticSimulation2;
        this._model = (adiabatic)adiabaticSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("v", "apply(\"v\")");
        this.addListener("Pi2", "apply(\"Pi2\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("area", "apply(\"area\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("alpha", "apply(\"alpha\")");
        this.addListener("m", "apply(\"m\")");
        this.addListener("beta", "apply(\"beta\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("v0", "apply(\"v0\")");
        this.addListener("omega0", "apply(\"omega0\")");
        this.addListener("nPoincare", "apply(\"nPoincare\")");
        this.addListener("nPoincareMax", "apply(\"nPoincareMax\")");
        this.addListener("areas", "apply(\"areas\")");
        this.addListener("periods", "apply(\"periods\")");
        this.addListener("sign", "apply(\"sign\")");
        this.addListener("lastOmega", "apply(\"lastOmega\")");
        this.addListener("lastE", "apply(\"lastE\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("partial", "apply(\"partial\")");
        this.addListener("fill", "apply(\"fill\")");
        this.addListener("wide", "apply(\"wide\")");
        this.addListener("nFillMax", "apply(\"nFillMax\")");
        this.addListener("nFill", "apply(\"nFill\")");
        this.addListener("fillX", "apply(\"fillX\")");
        this.addListener("fillY", "apply(\"fillY\")");
        this.addListener("showFill", "apply(\"showFill\")");
        this.addListener("fillVisible", "apply(\"fillVisible\")");
        this.addListener("Jformat", "apply(\"Jformat\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        Object[] objectArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("x".equals(string)) {
            this._model.x = this.getDouble("x");
        }
        if ("v".equals(string)) {
            this._model.v = this.getDouble("v");
        }
        if ("Pi2".equals(string)) {
            this._model.Pi2 = this.getDouble("Pi2");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("area".equals(string)) {
            this._model.area = this.getDouble("area");
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("alpha".equals(string)) {
            this._model.alpha = this.getDouble("alpha");
        }
        if ("m".equals(string)) {
            this._model.m = this.getDouble("m");
        }
        if ("beta".equals(string)) {
            this._model.beta = this.getDouble("beta");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("v0".equals(string)) {
            this._model.v0 = this.getDouble("v0");
        }
        if ("omega0".equals(string)) {
            this._model.omega0 = this.getDouble("omega0");
        }
        if ("nPoincare".equals(string)) {
            this._model.nPoincare = this.getInt("nPoincare");
        }
        if ("nPoincareMax".equals(string)) {
            this._model.nPoincareMax = this.getInt("nPoincareMax");
        }
        if ("areas".equals(string)) {
            objectArray = (double[])this.getValue("areas").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.areas.length) {
                n2 = this._model.areas.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.areas[n] = objectArray[n];
            }
        }
        if ("periods".equals(string)) {
            objectArray = (double[])this.getValue("periods").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.periods.length) {
                n2 = this._model.periods.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.periods[n] = objectArray[n];
            }
        }
        if ("sign".equals(string)) {
            this._model.sign = this.getDouble("sign");
        }
        if ("lastOmega".equals(string)) {
            this._model.lastOmega = this.getDouble("lastOmega");
        }
        if ("lastE".equals(string)) {
            this._model.lastE = this.getDouble("lastE");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("partial".equals(string)) {
            this._model.partial = this.getBoolean("partial");
        }
        if ("fill".equals(string)) {
            this._model.fill = this.getBoolean("fill");
        }
        if ("wide".equals(string)) {
            this._model.wide = this.getDouble("wide");
        }
        if ("nFillMax".equals(string)) {
            this._model.nFillMax = this.getInt("nFillMax");
        }
        if ("nFill".equals(string)) {
            this._model.nFill = this.getInt("nFill");
        }
        if ("fillX".equals(string)) {
            objectArray = (double[])this.getValue("fillX").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.fillX.length) {
                n2 = this._model.fillX.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.fillX[n] = objectArray[n];
            }
        }
        if ("fillY".equals(string)) {
            objectArray = (double[])this.getValue("fillY").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.fillY.length) {
                n2 = this._model.fillY.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.fillY[n] = objectArray[n];
            }
        }
        if ("showFill".equals(string)) {
            this._model.showFill = this.getBoolean("showFill");
        }
        if ("fillVisible".equals(string)) {
            objectArray = (boolean[])this.getValue("fillVisible").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.fillVisible.length) {
                n2 = this._model.fillVisible.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.fillVisible[n] = objectArray[n];
            }
        }
        if ("Jformat".equals(string)) {
            this._model.Jformat = this.getString("Jformat");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("v", this._model.v);
        this.setValue("Pi2", this._model.Pi2);
        this.setValue("dt", this._model.dt);
        this.setValue("area", this._model.area);
        this.setValue("omega", this._model.omega);
        this.setValue("alpha", this._model.alpha);
        this.setValue("m", this._model.m);
        this.setValue("beta", this._model.beta);
        this.setValue("x0", this._model.x0);
        this.setValue("v0", this._model.v0);
        this.setValue("omega0", this._model.omega0);
        this.setValue("nPoincare", this._model.nPoincare);
        this.setValue("nPoincareMax", this._model.nPoincareMax);
        this.setValue("areas", this._model.areas);
        this.setValue("periods", this._model.periods);
        this.setValue("sign", this._model.sign);
        this.setValue("lastOmega", this._model.lastOmega);
        this.setValue("lastE", this._model.lastE);
        this.setValue("tol", this._model.tol);
        this.setValue("partial", this._model.partial);
        this.setValue("fill", this._model.fill);
        this.setValue("wide", this._model.wide);
        this.setValue("nFillMax", this._model.nFillMax);
        this.setValue("nFill", this._model.nFill);
        this.setValue("fillX", this._model.fillX);
        this.setValue("fillY", this._model.fillY);
        this.setValue("showFill", this._model.showFill);
        this.setValue("fillVisible", this._model.fillVisible);
        this.setValue("Jformat", this._model.Jformat);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Adiabatic theorem")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "650,561")).getObject();
        this.center = (JPanel)this.addElement(new ControlPanel(), "center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("layout", "grid:2,1,0,0").getObject();
        this.upper = (JPanel)this.addElement(new ControlPanel(), "upper").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "center").setProperty("layout", "border").getObject();
        this.biesp = (JPanel)this.addElement(new ControlPanel(), "biesp").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "upper").setProperty("layout", "grid:1,2,0,0").getObject();
        this.phase = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "phase").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "biesp").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("xMarginPercentage", "5").setProperty("yMarginPercentage", "5").setProperty("pressaction", "_model._method_for_phase_pressaction()").setProperty("title", this._simulation.translateString("View.phase.title", "Phase orbit")).setProperty("titleX", this._simulation.translateString("View.phase.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.phase.titleY", "p")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.phase.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.phase.yFormat", "v = 0.###")).setProperty("tooltip", this._simulation.translateString("View.phase.tooltip", "Click to erase")).getObject();
        this.orbit = (InteractiveTrace)this.addElement(new ControlTrace(), "orbit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phase").setProperty("x", "x").setProperty("y", "v").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE").getObject();
        this.phase2 = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "phase2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "biesp").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("xMarginPercentage", "5").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.phase2.title", "Current cycle")).setProperty("titleX", this._simulation.translateString("View.phase2.titleX", "x")).setProperty("titleY", this._simulation.translateString("View.phase2.titleY", "p")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.phase2.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.phase2.yFormat", "v = 0.###")).getObject();
        this.fillvectors = (ElementSet)this.addElement(new ControlArrowSet(), "fillvectors").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phase2").setProperty("elementnumber", "nFillMax").setProperty("sizex", "fillX").setProperty("sizey", "fillY").setProperty("visible", "fillVisible").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "RED").setProperty("secondaryColor", "RED").getObject();
        this.orbit2 = (InteractiveTrace)this.addElement(new ControlTrace(), "orbit2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phase2").setProperty("x", "x").setProperty("y", "v").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE").getObject();
        this.position = (InteractiveArrow)this.addElement(new ControlArrow(), "position").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "phase2").setProperty("sizex", "x").setProperty("sizey", "v").setProperty("enabledSecondary", "false").setProperty("enabled", "false").getObject();
        this.controls = (JPanel)this.addElement(new ControlPanel(), "controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "upper").setProperty("layout", "grid:10,1,0,0").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.omega0 = (JTextField)this.addElement(new ControlParsedNumberField(), "omega0").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "omega0").setProperty("format", this._simulation.translateString("View.omega0.format", "$\\omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.omega0.tooltip", "Initial omega")).getObject();
        this.alpha = (JTextField)this.addElement(new ControlParsedNumberField(), "alpha").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "alpha").setProperty("format", this._simulation.translateString("View.alpha.format", "$\\alpha$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "alpha coefficient")).getObject();
        this.beta = (JTextField)this.addElement(new ControlParsedNumberField(), "beta").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "beta").setProperty("format", this._simulation.translateString("View.beta.format", "$\\beta$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.beta.tooltip", "Beta exponent")).getObject();
        this.dt = (JTextField)this.addElement(new ControlParsedNumberField(), "dt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step")).getObject();
        this.tolerance = (JTextField)this.addElement(new ControlParsedNumberField(), "tolerance").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "tol").setProperty("format", this._simulation.translateString("View.tolerance.format", "tol = 0.##E00")).setProperty("tooltip", this._simulation.translateString("View.tolerance.tooltip", "Maximum relative error")).getObject();
        this.partial = (JCheckBoxMenuItem)this.addElement(new ControlCheckBoxMenuItem(), "partial").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "partial").setProperty("text", this._simulation.translateString("View.partial.text", "Partial")).setProperty("accelerator", this._simulation.translateString("View.partial.accelerator", "p")).setProperty("actionoff", "_model._method_for_partial_actionoff()").setProperty("tooltip", this._simulation.translateString("View.partial.tooltip", "Show partial area")).getObject();
        this.fillarea = (JCheckBoxMenuItem)this.addElement(new ControlCheckBoxMenuItem(), "fillarea").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "showFill").setProperty("text", this._simulation.translateString("View.fillarea.text", "Fill")).setProperty("accelerator", this._simulation.translateString("View.fillarea.accelerator", "f")).setProperty("actionon", "_model._method_for_fillarea_actionon()").setProperty("actionoff", "_model._method_for_fillarea_actionoff()").setProperty("tooltip", this._simulation.translateString("View.fillarea.tooltip", "Fill area")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "controls").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings")).getObject();
        this.down = (JPanel)this.addElement(new ControlPanel(), "down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "center").setProperty("layout", "border").getObject();
        this.numeric = (JPanel)this.addElement(new ControlPanel(), "numeric").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "down").setProperty("layout", "grid:1,3,0,0").getObject();
        this.areaVal = (JLabel)this.addElement(new ControlLabel(), "areaVal").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "numeric").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.areaVal.tooltip", "Proportional change of J")).getObject();
        this.Eval = (JLabel)this.addElement(new ControlLabel(), "Eval").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "numeric").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.Eval.tooltip", "Proportional change of the energy")).getObject();
        this.omegaVal = (JLabel)this.addElement(new ControlLabel(), "omegaVal").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "numeric").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.omegaVal.tooltip", "Proportional change of omega")).getObject();
        this.evolution = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "evolution").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "down").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "0").setProperty("maximumX", "10").setProperty("minimumY", "0").setProperty("maximumY", "1").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("title", this._simulation.translateString("View.evolution.title", "Area")).setProperty("titleX", this._simulation.translateString("View.evolution.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.evolution.titleY", "A")).setProperty("xFormat", this._simulation.translateString("View.evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.evolution.yFormat", "A = 0.###")).getObject();
        this.areatrace = (InteractiveTrace)this.addElement(new ControlTrace(), "areatrace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "evolution").setProperty("x", "t").setProperty("y", "area").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "0,128,128,255").getObject();
        this.endareas = (ElementSet)this.addElement(new ControlParticleSet(), "endareas").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "evolution").setProperty("elementnumber", "nPoincare").setProperty("x", "periods").setProperty("y", "areas").setProperty("sizex", "wide").setProperty("sizey", ".05").setProperty("visible", "%_model._method_for_endareas_visible()%").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("secondaryColor", "RED").setProperty("color", "RED").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Adiabatic theorem")).setProperty("visible", "true");
        this.getElement("center");
        this.getElement("upper");
        this.getElement("biesp");
        this.getElement("phase").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("xMarginPercentage", "5").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.phase.title", "Phase orbit")).setProperty("titleY", this._simulation.translateString("View.phase.titleY", "p")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.phase.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.phase.yFormat", "v = 0.###")).setProperty("tooltip", this._simulation.translateString("View.phase.tooltip", "Click to erase"));
        this.getElement("orbit").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE");
        this.getElement("phase2").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "-1").setProperty("maximumX", "1").setProperty("minimumY", "-1").setProperty("maximumY", "1").setProperty("xMarginPercentage", "5").setProperty("yMarginPercentage", "5").setProperty("title", this._simulation.translateString("View.phase2.title", "Current cycle")).setProperty("titleY", this._simulation.translateString("View.phase2.titleY", "p")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.phase2.xFormat", "x = 0.###")).setProperty("yFormat", this._simulation.translateString("View.phase2.yFormat", "v = 0.###"));
        this.getElement("fillvectors").setProperty("enabledSecondary", "false").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "RED").setProperty("secondaryColor", "RED");
        this.getElement("orbit2").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "BLUE");
        this.getElement("position").setProperty("enabledSecondary", "false").setProperty("enabled", "false");
        this.getElement("controls").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("omega0").setProperty("format", this._simulation.translateString("View.omega0.format", "$\\omega$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.omega0.tooltip", "Initial omega"));
        this.getElement("alpha").setProperty("format", this._simulation.translateString("View.alpha.format", "$\\alpha$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.alpha.tooltip", "alpha coefficient"));
        this.getElement("beta").setProperty("format", this._simulation.translateString("View.beta.format", "$\\beta$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.beta.tooltip", "Beta exponent"));
        this.getElement("dt").setProperty("format", this._simulation.translateString("View.dt.format", "$\\Delta$t = 0.###")).setProperty("tooltip", this._simulation.translateString("View.dt.tooltip", "Integration step"));
        this.getElement("tolerance").setProperty("format", this._simulation.translateString("View.tolerance.format", "tol = 0.##E00")).setProperty("tooltip", this._simulation.translateString("View.tolerance.tooltip", "Maximum relative error"));
        this.getElement("partial").setProperty("text", this._simulation.translateString("View.partial.text", "Partial")).setProperty("accelerator", this._simulation.translateString("View.partial.accelerator", "p")).setProperty("tooltip", this._simulation.translateString("View.partial.tooltip", "Show partial area"));
        this.getElement("fillarea").setProperty("text", this._simulation.translateString("View.fillarea.text", "Fill")).setProperty("accelerator", this._simulation.translateString("View.fillarea.accelerator", "f")).setProperty("tooltip", this._simulation.translateString("View.fillarea.tooltip", "Fill area"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.resetButton.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset initial settings"));
        this.getElement("down");
        this.getElement("numeric");
        this.getElement("areaVal").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.areaVal.tooltip", "Proportional change of J"));
        this.getElement("Eval").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.Eval.tooltip", "Proportional change of the energy"));
        this.getElement("omegaVal").setProperty("alignment", "CENTER").setProperty("tooltip", this._simulation.translateString("View.omegaVal.tooltip", "Proportional change of omega"));
        this.getElement("evolution").setProperty("autoscaleX", "true").setProperty("autoscaleY", "true").setProperty("minimumX", "0").setProperty("maximumX", "10").setProperty("minimumY", "0").setProperty("maximumY", "1").setProperty("xMarginPercentage", "10").setProperty("yMarginPercentage", "10").setProperty("title", this._simulation.translateString("View.evolution.title", "Area")).setProperty("titleY", this._simulation.translateString("View.evolution.titleY", "A")).setProperty("xFormat", this._simulation.translateString("View.evolution.xFormat", "t = 0.###")).setProperty("yFormat", this._simulation.translateString("View.evolution.yFormat", "A = 0.###"));
        this.getElement("areatrace").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("enabled", "false").setProperty("color", "0,128,128,255");
        this.getElement("endareas").setProperty("sizey", ".05").setProperty("enabled", "false").setProperty("style", "RECTANGLE").setProperty("secondaryColor", "RED").setProperty("color", "RED");
        super.reset();
    }
}

