/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.adiabatic;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEBisectionEventSolver;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.StateEvent;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.adiabatic.adiabaticSimulation;
import users.ehu.jma.analytical_mechanics.adiabatic.adiabaticView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class adiabatic
extends AbstractModel {
    public adiabaticSimulation _simulation = null;
    public adiabaticView _view = null;
    public adiabatic _model = this;
    public double t = 0.0;
    public double x = 0.0;
    public double v = 0.0;
    public double Pi2 = Math.PI * 2;
    public double dt = 0.025;
    public double area = 0.0;
    public double omega = 0.0;
    public double alpha = 0.025;
    public double m = 0.5;
    public double beta = 1.0;
    public double x0 = 1.0;
    public double v0 = 0.0;
    public double omega0 = 1.0;
    public int nPoincare = 0;
    public int nPoincareMax = 10000;
    public double[] areas;
    public double[] periods;
    public double sign = 0.0;
    public double lastOmega = 0.0;
    public double lastE = 0.0;
    public double tol = 1.0E-6;
    public boolean partial = true;
    public boolean fill = false;
    public double wide = 0.0;
    public int nFillMax = 10000;
    public int nFill = 0;
    public double[] fillX;
    public double[] fillY;
    public boolean showFill = false;
    public boolean[] fillVisible;
    public String Jformat = "0.00E00";
    private _ODE_evolution1 _ODEi_evolution1;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/adiabatic.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        adiabatic adiabatic2 = new adiabatic(stringArray);
    }

    public adiabatic() {
        this(null, null, null, null, null, false);
    }

    public adiabatic(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public adiabatic(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new adiabaticSimulation(this, string, frame, uRL, bl);
        this._view = (adiabaticView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.t = 0.0;
        this.x = this.x0;
        this.v = this.v0;
        this.area = 0.0;
        this.omega = this.omega0;
        this.nPoincare = 0;
        this.sign = this.v0 > 0.0 ? 1.0 : (this.v0 < 0.0 ? -1.0 : (this.x0 > 0.0 ? -1.0 : 1.0));
        this._view.getElement("areaVal").setProperty("text", "");
        this._view.getElement("Eval").setProperty("text", "");
        this._view.getElement("omegaVal").setProperty("text", "");
        this._view.resetTraces();
        this._resetSolvers();
    }

    public void _evolution2() {
        if (this.nFill + 1 < this.nFillMax) {
            this.fillVisible[this.nFill] = this.showFill;
            this.fillX[this.nFill] = this.x;
            this.fillY[this.nFill++] = this.v;
        }
    }

    public void _constraints1() {
        this.wide = Double.valueOf(this._view.getElement("evolution").getProperty("maximumX")) / 50.0;
    }

    public void _constraints2() {
        if (this.beta < 1.0) {
            this.beta = 1.0;
        }
    }

    public void _method_for_phase_pressaction() {
        this._simulation.disableLoop();
        this._view.getElement("orbit").reset();
        this._simulation.enableLoop();
    }

    public void _method_for_partial_actionoff() {
        this._simulation.disableLoop();
        this._view.getElement("areatrace").reset();
        this._simulation.enableLoop();
    }

    public void _method_for_fillarea_actionon() {
        this._simulation.disableLoop();
        for (int i = 0; i < this.nFill; ++i) {
            this.fillVisible[i] = true;
        }
        this._simulation.enableLoop();
    }

    public void _method_for_fillarea_actionoff() {
        this._simulation.disableLoop();
        for (int i = 0; i < this.nFillMax; ++i) {
            this.fillVisible[i] = false;
        }
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._initialize();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_endareas_visible() {
        return this.nPoincare > 0;
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.x = 0.0;
        this.v = 0.0;
        this.Pi2 = Math.PI * 2;
        this.dt = 0.025;
        this.area = 0.0;
        this.omega = 0.0;
        this.alpha = 0.025;
        this.m = 0.5;
        this.beta = 1.0;
        this.x0 = 1.0;
        this.v0 = 0.0;
        this.omega0 = 1.0;
        this.nPoincare = 0;
        this.nPoincareMax = 10000;
        this.areas = new double[this.nPoincareMax];
        for (n = 0; n < this.nPoincareMax; ++n) {
            this.areas[n] = 0.0;
        }
        this.periods = new double[this.nPoincareMax];
        for (n = 0; n < this.nPoincareMax; ++n) {
            this.periods[n] = 0.0;
        }
        this.sign = 0.0;
        this.lastOmega = 0.0;
        this.lastE = 0.0;
        this.tol = 1.0E-6;
        this.partial = true;
        this.fill = false;
        this.wide = 0.0;
        this.nFillMax = 10000;
        this.nFill = 0;
        this.fillX = new double[this.nFillMax];
        for (n = 0; n < this.nFillMax; ++n) {
            this.fillX[n] = 0.0;
        }
        this.fillY = new double[this.nFillMax];
        for (n = 0; n < this.nFillMax; ++n) {
            this.fillY[n] = 0.0;
        }
        this.showFill = false;
        this.fillVisible = new boolean[this.nFillMax];
        for (n = 0; n < this.nFillMax; ++n) {
            this.fillVisible[n] = this.showFill;
        }
        this.Jformat = "0.00E00";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
    }

    @Override
    public void _freeMemory() {
        this.areas = null;
        this.periods = null;
        this.fillX = null;
        this.fillY = null;
        this.fillVisible = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEBisectionEventSolver __solver = null;
        private double[] __state = null;
        private double _x;
        private double _v;
        private double _omega;
        private double _area;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void resetSolver() {
            int n = 0;
            this.__state[n++] = adiabatic.this.x;
            this.__state[n++] = adiabatic.this.v;
            this.__state[n++] = adiabatic.this.omega;
            this.__state[n++] = adiabatic.this.area;
            this.__state[n++] = adiabatic.this.t;
            this.__solver = new ODEBisectionEventSolver(this, ODEMultistepSolver.class);
            this.__solver.addEvent(new _ODE_evolution1_Event1());
            this.__solver.initialize(adiabatic.this.dt);
        }

        void step() {
            if (adiabatic.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(adiabatic.this.tol);
            }
            if (adiabatic.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(adiabatic.this.dt);
            }
            int n = 0;
            this.__state[n++] = adiabatic.this.x;
            this.__state[n++] = adiabatic.this.v;
            this.__state[n++] = adiabatic.this.omega;
            this.__state[n++] = adiabatic.this.area;
            this.__state[n++] = adiabatic.this.t;
            this.__solver.step();
            n = 0;
            adiabatic.this.x = this.__state[n++];
            adiabatic.this.v = this.__state[n++];
            adiabatic.this.omega = this.__state[n++];
            adiabatic.this.area = this.__state[n++];
            adiabatic.this.t = this.__state[n++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._x = dArray[n++];
            this._v = dArray[n++];
            this._omega = dArray[n++];
            this._area = dArray[n++];
            this._t = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._x, this._v, this._omega, this._area, this._t);
            dArray2[n++] = this._ODE_evolution1_2(this._x, this._v, this._omega, this._area, this._t);
            dArray2[n++] = this._ODE_evolution1_3(this._x, this._v, this._omega, this._area, this._t);
            dArray2[n++] = this._ODE_evolution1_4(this._x, this._v, this._omega, this._area, this._t);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return d2 / adiabatic.this.m;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return -d3 * d3 * d * adiabatic.this.m;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return adiabatic.this.alpha * adiabatic.this.beta * Math.pow(d5, adiabatic.this.beta - 1.0);
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return d2 * d2;
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            public String toString() {
                return "Sections";
            }

            public double getTolerance() {
                return adiabatic.this.tol * 10.0;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                _ODE_evolution1.this._x = dArray[n++];
                _ODE_evolution1.this._v = dArray[n++];
                _ODE_evolution1.this._omega = dArray[n++];
                _ODE_evolution1.this._area = dArray[n++];
                _ODE_evolution1.this._t = dArray[n++];
                return this.userEvaluate(_ODE_evolution1.this._x, _ODE_evolution1.this._v, _ODE_evolution1.this._omega, _ODE_evolution1.this._area, _ODE_evolution1.this._t);
            }

            public double userEvaluate(double d, double d2, double d3, double d4, double d5) {
                return adiabatic.this.sign * d2;
            }

            public boolean action() {
                int n = 0;
                adiabatic.this.x = _ODE_evolution1.this.__state[n++];
                adiabatic.this.v = _ODE_evolution1.this.__state[n++];
                adiabatic.this.omega = _ODE_evolution1.this.__state[n++];
                adiabatic.this.area = _ODE_evolution1.this.__state[n++];
                adiabatic.this.t = _ODE_evolution1.this.__state[n++];
                if (adiabatic.this.sign > 0.0) {
                    adiabatic.this.periods[adiabatic.this.nPoincare] = adiabatic.this.t;
                    adiabatic.this.areas[adiabatic.this.nPoincare] = adiabatic.this.area;
                    double d = adiabatic.this.omega;
                    double d2 = 0.5 * adiabatic.this.m * adiabatic.this.omega * adiabatic.this.omega * adiabatic.this.x * adiabatic.this.x;
                    if (adiabatic.this.nPoincare > 0) {
                        adiabatic.this._view.getElement("areaVal").setProperty("text", "\u0394J/J = " + adiabatic.this._format(adiabatic.this.area / adiabatic.this.areas[adiabatic.this.nPoincare - 1] - 1.0, adiabatic.this.Jformat));
                        adiabatic.this._view.getElement("omegaVal").setProperty("text", "\u0394\u03c9/\u03c9 = " + adiabatic.this._format(d / adiabatic.this.lastOmega - 1.0, adiabatic.this.Jformat));
                        adiabatic.this._view.getElement("Eval").setProperty("text", "\u0394E/E = " + adiabatic.this._format(d2 / adiabatic.this.lastE - 1.0, adiabatic.this.Jformat));
                    }
                    adiabatic.this.lastOmega = d;
                    adiabatic.this.lastE = d2;
                    adiabatic.this.area = 0.0;
                    adiabatic.this.nFill = 0;
                    for (int i = 0; i < adiabatic.this.nFillMax; ++i) {
                        adiabatic.this.fillVisible[i] = false;
                    }
                    ++adiabatic.this.nPoincare;
                    adiabatic.this._view.getElement("orbit2").reset();
                    if (!adiabatic.this.partial) {
                        adiabatic.this._view.getElement("areatrace").reset();
                    }
                }
                adiabatic.this.sign = -adiabatic.this.sign;
                n = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = adiabatic.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = adiabatic.this.v;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = adiabatic.this.omega;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = adiabatic.this.area;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n++] = adiabatic.this.t;
                return true;
            }
        }
    }
}

