/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.action;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlAnalyticCurve;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlPoligon;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.action.action;
import users.ehu.jma.analytical_mechanics.action.actionSimulation;

class actionView
extends EjsControl
implements View {
    private actionSimulation _simulation = null;
    private action _model = null;
    public Component Main;
    public JPanel Left;
    public JTextField Bomega;
    public JTextField Bt1;
    public JTextField Bt2;
    public JTextField Bx1;
    public JTextField Bx2;
    public JTextField BN;
    public JTextField Baction;
    public JTextField Bmin;
    public JCheckBox Bphysical;
    public JButton Physical;
    public JButton Start;
    public PlottingPanel2D Configuration;
    public InteractivePoligon PhysicalSol;
    public InteractivePoligon Trajectory;
    public InteractiveParticle LeftEnd;
    public InteractiveParticle RightEnd;

    public actionView(actionSimulation actionSimulation2, String string, Frame frame) {
        super(actionSimulation2, string, frame);
        this._simulation = actionSimulation2;
        this._model = (action)actionSimulation2.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("N", "apply(\"N\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("x", "apply(\"x\")");
        this.addListener("omega", "apply(\"omega\")");
        this.addListener("action", "apply(\"action\")");
        this.addListener("actionmin", "apply(\"actionmin\")");
        this.addListener("t1", "apply(\"t1\")");
        this.addListener("t2", "apply(\"t2\")");
        this.addListener("x1", "apply(\"x1\")");
        this.addListener("x2", "apply(\"x2\")");
        this.addListener("mov", "apply(\"mov\")");
        this.addListener("tmin", "apply(\"tmin\")");
        this.addListener("tmax", "apply(\"tmax\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("cur", "apply(\"cur\")");
        this.addListener("eps", "apply(\"eps\")");
        this.addListener("physical", "apply(\"physical\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        Object[] objectArray;
        if ("N".equals(string)) {
            this._model.N = this.getInt("N");
        }
        if ("t".equals(string)) {
            objectArray = (double[])this.getValue("t").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.t.length) {
                n2 = this._model.t.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.t[n] = objectArray[n];
            }
        }
        if ("x".equals(string)) {
            objectArray = (double[])this.getValue("x").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.x.length) {
                n2 = this._model.x.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.x[n] = objectArray[n];
            }
        }
        if ("omega".equals(string)) {
            this._model.omega = this.getDouble("omega");
        }
        if ("action".equals(string)) {
            this._model.action = this.getDouble("action");
        }
        if ("actionmin".equals(string)) {
            this._model.actionmin = this.getDouble("actionmin");
        }
        if ("t1".equals(string)) {
            this._model.t1 = this.getDouble("t1");
        }
        if ("t2".equals(string)) {
            this._model.t2 = this.getDouble("t2");
        }
        if ("x1".equals(string)) {
            this._model.x1 = this.getDouble("x1");
        }
        if ("x2".equals(string)) {
            this._model.x2 = this.getDouble("x2");
        }
        if ("mov".equals(string)) {
            objectArray = (boolean[])this.getValue("mov").getObject();
            n2 = objectArray.length;
            if (n2 > this._model.mov.length) {
                n2 = this._model.mov.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.mov[n] = objectArray[n];
            }
        }
        if ("tmin".equals(string)) {
            this._model.tmin = this.getDouble("tmin");
        }
        if ("tmax".equals(string)) {
            this._model.tmax = this.getDouble("tmax");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("cur".equals(string)) {
            this._model.cur = this.getInt("cur");
        }
        if ("eps".equals(string)) {
            this._model.eps = this.getDouble("eps");
        }
        if ("physical".equals(string)) {
            this._model.physical = this.getBoolean("physical");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("N", this._model.N);
        this.setValue("t", this._model.t);
        this.setValue("x", this._model.x);
        this.setValue("omega", this._model.omega);
        this.setValue("action", this._model.action);
        this.setValue("actionmin", this._model.actionmin);
        this.setValue("t1", this._model.t1);
        this.setValue("t2", this._model.t2);
        this.setValue("x1", this._model.x1);
        this.setValue("x2", this._model.x2);
        this.setValue("mov", this._model.mov);
        this.setValue("tmin", this._model.tmin);
        this.setValue("tmax", this._model.tmax);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("cur", this._model.cur);
        this.setValue("eps", this._model.eps);
        this.setValue("physical", this._model.physical);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Action of the harmonic oscillator")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "640,440")).getObject();
        this.Left = (JPanel)this.addElement(new ControlPanel(), "Left").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "west").setProperty("parent", "Main").setProperty("layout", "grid:11,1,0,0").setProperty("size", this._simulation.translateString("View.Left.size", "104,0")).setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Bomega = (JTextField)this.addElement(new ControlNumberField(), "Bomega").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "omega").setProperty("value", "1.0").setProperty("format", this._simulation.translateString("View.Bomega.format", "$\\omega$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bomega.tooltip", "Frequency")).getObject();
        this.Bt1 = (JTextField)this.addElement(new ControlNumberField(), "Bt1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "t1").setProperty("format", this._simulation.translateString("View.Bt1.format", "t1 = 0.##")).setProperty("action", "_model._method_for_Bt1_action()").setProperty("tooltip", this._simulation.translateString("View.Bt1.tooltip", "Initial time")).getObject();
        this.Bt2 = (JTextField)this.addElement(new ControlNumberField(), "Bt2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "t2").setProperty("format", this._simulation.translateString("View.Bt2.format", "t2  = 0.##")).setProperty("action", "_model._method_for_Bt2_action()").setProperty("tooltip", this._simulation.translateString("View.Bt2.tooltip", "Final time")).getObject();
        this.Bx1 = (JTextField)this.addElement(new ControlNumberField(), "Bx1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "x1").setProperty("format", this._simulation.translateString("View.Bx1.format", "x1  = 0.##")).setProperty("action", "_model._method_for_Bx1_action()").setProperty("tooltip", this._simulation.translateString("View.Bx1.tooltip", "Initial position")).getObject();
        this.Bx2 = (JTextField)this.addElement(new ControlNumberField(), "Bx2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "x2").setProperty("format", this._simulation.translateString("View.Bx2.format", "x2 = 0.##")).setProperty("action", "_model._method_for_Bx2_action()").setProperty("tooltip", this._simulation.translateString("View.Bx2.tooltip", "Final position")).getObject();
        this.BN = (JTextField)this.addElement(new ControlNumberField(), "BN").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "N").setProperty("format", this._simulation.translateString("View.BN.format", "N = 0")).setProperty("action", "_model._method_for_BN_action()").setProperty("tooltip", this._simulation.translateString("View.BN.tooltip", "Number of points in the mathematical trajectory")).getObject();
        this.Baction = (JTextField)this.addElement(new ControlNumberField(), "Baction").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "action").setProperty("format", this._simulation.translateString("View.Baction.format", "I = 0.##")).setProperty("editable", "false").setProperty("foreground", "blue").setProperty("font", "Dialog,BOLD,12").setProperty("tooltip", this._simulation.translateString("View.Baction.tooltip", "Action")).getObject();
        this.Bmin = (JTextField)this.addElement(new ControlNumberField(), "Bmin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "actionmin").setProperty("format", this._simulation.translateString("View.Bmin.format", "Imin  = 0.##")).setProperty("editable", "false").setProperty("foreground", "red").setProperty("font", "Dialog,BOLD,12").setProperty("tooltip", this._simulation.translateString("View.Bmin.tooltip", "Action along the physical solution")).getObject();
        this.Bphysical = (JCheckBox)this.addElement(new ControlCheckBox(), "Bphysical").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("variable", "physical").setProperty("text", this._simulation.translateString("View.Bphysical.text", "Physical")).setProperty("mnemonic", this._simulation.translateString("View.Bphysical.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.Bphysical.tooltip", "Always show the physical solution (in red).")).getObject();
        this.Physical = (JButton)this.addElement(new ControlButton(), "Physical").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("text", this._simulation.translateString("View.Physical.text", "Solution")).setProperty("mnemonic", this._simulation.translateString("View.Physical.mnemonic", "s")).setProperty("action", "_model._method_for_Physical_action()").setProperty("tooltip", this._simulation.translateString("View.Physical.tooltip", "Show the physical trajectory.")).getObject();
        this.Start = (JButton)this.addElement(new ControlButton(), "Start").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Left").setProperty("image", this._simulation.translateString("View.Start.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Start.mnemonic", "r")).setProperty("action", "_model._method_for_Start_action()").setProperty("tooltip", this._simulation.translateString("View.Start.tooltip", "Reset the initial conditions.")).getObject();
        this.Configuration = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "Configuration").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "tmin").setProperty("maximumX", "tmax").setProperty("minimumY", "xmin").setProperty("maximumY", "xmax").setProperty("title", this._simulation.translateString("View.Configuration.title", "Configuration")).setProperty("titleX", this._simulation.translateString("View.Configuration.titleX", "t")).setProperty("titleY", this._simulation.translateString("View.Configuration.titleY", "x")).setProperty("xFormat", this._simulation.translateString("View.Configuration.xFormat", "t=0.### /")).setProperty("yFormat", this._simulation.translateString("View.Configuration.yFormat", "x=0.###")).setProperty("tooltip", this._simulation.translateString("View.Configuration.tooltip", "Use mouse to move trajectory points")).getObject();
        this.PhysicalSol = (InteractivePoligon)this.addElement(new ControlAnalyticCurve(), "PhysicalSol").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Configuration").setProperty("points", "100").setProperty("min", "t1").setProperty("max", "t2").setProperty("variable", "tt").setProperty("functionx", "tt").setProperty("functiony", "-(1./Math.sin((t1 - t2)*omega)*(x2*Math.sin((tt - t1)*omega) - x1*Math.sin((tt - t2)*omega)))").setProperty("functionz", "0").setProperty("color", "red").setProperty("visible", "physical").setProperty("enabled", "false").getObject();
        this.Trajectory = (InteractivePoligon)this.addElement(new ControlPoligon(), "Trajectory").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Configuration").setProperty("maxpoints", "%_model._method_for_Trajectory_maxpoints()%").setProperty("x", "t").setProperty("y", "x").setProperty("enabled", "false").setProperty("enabledSecondary", "true").setProperty("indexSelected", "cur").setProperty("fixed", "mov").setProperty("closed", "false").setProperty("secondaryColor", "blue").setProperty("color", "null").setProperty("stroke", "3").getObject();
        this.LeftEnd = (InteractiveParticle)this.addElement(new ControlParticle(), "LeftEnd").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Configuration").setProperty("x", "t1").setProperty("y", "x1").setProperty("enabled", "true").getObject();
        this.RightEnd = (InteractiveParticle)this.addElement(new ControlParticle(), "RightEnd").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Configuration").setProperty("x", "t2").setProperty("y", "x2").setProperty("enabled", "true").setProperty("dragaction", "_model._method_for_RightEnd_dragaction()").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Action of the harmonic oscillator")).setProperty("visible", "true");
        this.getElement("Left").setProperty("size", this._simulation.translateString("View.Left.size", "104,0")).setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Bomega").setProperty("value", "1.0").setProperty("format", this._simulation.translateString("View.Bomega.format", "$\\omega$ = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bomega.tooltip", "Frequency"));
        this.getElement("Bt1").setProperty("format", this._simulation.translateString("View.Bt1.format", "t1 = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bt1.tooltip", "Initial time"));
        this.getElement("Bt2").setProperty("format", this._simulation.translateString("View.Bt2.format", "t2  = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bt2.tooltip", "Final time"));
        this.getElement("Bx1").setProperty("format", this._simulation.translateString("View.Bx1.format", "x1  = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bx1.tooltip", "Initial position"));
        this.getElement("Bx2").setProperty("format", this._simulation.translateString("View.Bx2.format", "x2 = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Bx2.tooltip", "Final position"));
        this.getElement("BN").setProperty("format", this._simulation.translateString("View.BN.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.BN.tooltip", "Number of points in the mathematical trajectory"));
        this.getElement("Baction").setProperty("format", this._simulation.translateString("View.Baction.format", "I = 0.##")).setProperty("editable", "false").setProperty("foreground", "blue").setProperty("font", "Dialog,BOLD,12").setProperty("tooltip", this._simulation.translateString("View.Baction.tooltip", "Action"));
        this.getElement("Bmin").setProperty("format", this._simulation.translateString("View.Bmin.format", "Imin  = 0.##")).setProperty("editable", "false").setProperty("foreground", "red").setProperty("font", "Dialog,BOLD,12").setProperty("tooltip", this._simulation.translateString("View.Bmin.tooltip", "Action along the physical solution"));
        this.getElement("Bphysical").setProperty("text", this._simulation.translateString("View.Bphysical.text", "Physical")).setProperty("mnemonic", this._simulation.translateString("View.Bphysical.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.Bphysical.tooltip", "Always show the physical solution (in red)."));
        this.getElement("Physical").setProperty("text", this._simulation.translateString("View.Physical.text", "Solution")).setProperty("mnemonic", this._simulation.translateString("View.Physical.mnemonic", "s")).setProperty("tooltip", this._simulation.translateString("View.Physical.tooltip", "Show the physical trajectory."));
        this.getElement("Start").setProperty("image", this._simulation.translateString("View.Start.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("mnemonic", this._simulation.translateString("View.Start.mnemonic", "r")).setProperty("tooltip", this._simulation.translateString("View.Start.tooltip", "Reset the initial conditions."));
        this.getElement("Configuration").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.Configuration.title", "Configuration")).setProperty("xFormat", this._simulation.translateString("View.Configuration.xFormat", "t=0.### /")).setProperty("yFormat", this._simulation.translateString("View.Configuration.yFormat", "x=0.###")).setProperty("tooltip", this._simulation.translateString("View.Configuration.tooltip", "Use mouse to move trajectory points"));
        this.getElement("PhysicalSol").setProperty("points", "100").setProperty("variable", "tt").setProperty("functionx", "tt").setProperty("functiony", "-(1./Math.sin((t1 - t2)*omega)*(x2*Math.sin((tt - t1)*omega) - x1*Math.sin((tt - t2)*omega)))").setProperty("functionz", "0").setProperty("color", "red").setProperty("enabled", "false");
        this.getElement("Trajectory").setProperty("enabled", "false").setProperty("enabledSecondary", "true").setProperty("closed", "false").setProperty("secondaryColor", "blue").setProperty("color", "null").setProperty("stroke", "3");
        this.getElement("LeftEnd").setProperty("enabled", "true");
        this.getElement("RightEnd").setProperty("enabled", "true");
        super.reset();
    }
}

