/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.action;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.action.actionSimulation;
import users.ehu.jma.analytical_mechanics.action.actionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class action
extends AbstractModel {
    public actionSimulation _simulation = null;
    public actionView _view = null;
    public action _model = this;
    public int N = 15;
    public double[] t;
    public double[] x;
    public double omega = 1.0;
    public double action = 0.0;
    public double actionmin = 0.0;
    public double t1 = 0.0;
    public double t2 = 1.5707963267948966 / this.omega;
    public double x1 = 0.0;
    public double x2 = 1.0;
    public boolean[] mov;
    public double tmin = -1.0;
    public double tmax = 2.0;
    public double xmin = -1.0;
    public double xmax = 2.0;
    public int cur = 0;
    public double eps = 1.0E-4;
    public boolean physical = true;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/action.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        action action2 = new action(stringArray);
    }

    public action() {
        this(null, null, null, null, null, false);
    }

    public action(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public action(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new actionSimulation(this, string, frame, uRL, bl);
        this._view = (actionView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.mov[0] = true;
        this.mov[this.N] = true;
        this.putphys();
    }

    public void _constraints1() {
        this.t[0] = this.t1;
        this.t[this.N] = this.t2;
        this.x[0] = this.x1;
        this.x[this.N] = this.x2;
    }

    public void _constraints2() {
        this.actionmin = -(this.omega * (-2.0 * this.x1 * this.x2 + (this.x1 * this.x1 + this.x2 * this.x2) * Math.cos((this.t1 - this.t2) * this.omega)) / Math.sin((this.t1 - this.t2) * this.omega)) / 2.0;
        this.action = this.computeAction();
    }

    public void _constraints3() {
        for (int i = 1; i < this.N; ++i) {
            if (!(this.t[i] <= this.t[i - 1])) continue;
            this.t[i] = this.t[i - 1] + this.eps;
        }
    }

    public double computeAction() {
        double d = 0.0;
        for (int i = 0; i < this.N; ++i) {
            double d2 = this.t[i];
            double d3 = this.t[i + 1];
            double d4 = this.x[i];
            double d5 = this.x[i + 1];
            d += -(d4 - d5) * (d4 - d5) / (2.0 * (d2 - d3)) + (d2 - d3) * (d4 * d4 + d4 * d5 + d5 * d5) * this.omega * this.omega / 6.0;
        }
        return d;
    }

    public void setPoints() {
        for (int i = this.N - 1; i >= 0; --i) {
            if (!(this.t[i] >= this.t[i + 1])) continue;
            this.t[i] = this.t[i + 1] - this.eps;
        }
    }

    public double phsol(double d) {
        return -(1.0 / Math.sin((this.t1 - this.t2) * this.omega) * (this.x2 * Math.sin((d - this.t1) * this.omega) - this.x1 * Math.sin((d - this.t2) * this.omega)));
    }

    public void putphys() {
        this.t[0] = this.t1;
        this.t[this.N] = this.t2;
        this.x[0] = this.x1;
        this.x[this.N] = this.x2;
        for (int i = 1; i < this.N; ++i) {
            this.t[i] = (this.t2 - this.t1) / (double)this.N * (double)i + this.t1;
            this.x[i] = this.phsol(this.t[i]);
        }
    }

    public void _method_for_Bt1_action() {
        this._simulation.disableLoop();
        this.setPoints();
        this._simulation.enableLoop();
    }

    public void _method_for_Bt2_action() {
        this._simulation.disableLoop();
        this.setPoints();
        this._simulation.enableLoop();
    }

    public void _method_for_Bx1_action() {
        this._simulation.disableLoop();
        this.setPoints();
        this._simulation.enableLoop();
    }

    public void _method_for_Bx2_action() {
        this._simulation.disableLoop();
        this.setPoints();
        this._simulation.enableLoop();
    }

    public void _method_for_BN_action() {
        this._simulation.disableLoop();
        this.putphys();
        this._simulation.enableLoop();
    }

    public void _method_for_Physical_action() {
        this._simulation.disableLoop();
        this.putphys();
        this._simulation.enableLoop();
    }

    public void _method_for_Start_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public int _method_for_Trajectory_maxpoints() {
        return this.N + 1;
    }

    public void _method_for_RightEnd_dragaction() {
        this._simulation.disableLoop();
        this.setPoints();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.N = 15;
        this.t = new double[this.N + 1];
        for (n = 0; n < this.N + 1; ++n) {
            this.t[n] = 0.0;
        }
        this.x = new double[this.N + 1];
        for (n = 0; n < this.N + 1; ++n) {
            this.x[n] = 0.0;
        }
        this.omega = 1.0;
        this.action = 0.0;
        this.actionmin = 0.0;
        this.t1 = 0.0;
        this.t2 = 1.5707963267948966 / this.omega;
        this.x1 = 0.0;
        this.x2 = 1.0;
        this.mov = new boolean[this.N + 1];
        for (n = 0; n < this.N + 1; ++n) {
            this.mov[n] = false;
        }
        this.tmin = -1.0;
        this.tmax = 2.0;
        this.xmin = -1.0;
        this.xmax = 2.0;
        this.cur = 0;
        this.eps = 1.0E-4;
        this.physical = true;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
        this._constraints2();
        this._constraints3();
    }

    @Override
    public void _freeMemory() {
        this.t = null;
        this.x = null;
        this.mov = null;
        System.gc();
    }
}

