/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.Liouville;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.displayejs.ControlArrow;
import org.colos.ejs.library.control.displayejs.ControlParticle;
import org.colos.ejs.library.control.displayejs.ControlParticleSet;
import org.colos.ejs.library.control.displayejs.ControlSpring;
import org.colos.ejs.library.control.displayejs.ControlTrace;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlComboBox;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlNumberField;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlPlottingPanel;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.drawing.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;
import users.ehu.jma.analytical_mechanics.Liouville.Liouville;
import users.ehu.jma.analytical_mechanics.Liouville.LiouvilleSimulation;

class LiouvilleView
extends EjsControl
implements View {
    private LiouvilleSimulation _simulation = null;
    private Liouville _model = null;
    public Component Main;
    public PlottingPanel2D PhaseSpace;
    public ElementSet PointSet;
    public InteractiveTrace Trajectory;
    public InteractiveParticle Center;
    public InteractiveParticle Origin;
    public InteractiveArrow mpi;
    public InteractiveArrow ppi;
    public JPanel Down;
    public JPanel Controls;
    public JTextField Kq;
    public JTextField Kqd;
    public JTextField Gamma;
    public JCheckBox Harmonics;
    public JTextField Kn;
    public JTextField Kd;
    public JComboBox Type;
    public JTextField Kdt;
    public JCheckBox Cylinder;
    public JCheckBox Traj;
    public JCheckBox showSpace;
    public JButton startButton;
    public JButton stepButton;
    public JButton resetButton;
    public JDialog Pendulum;
    public DrawingPanel2D DrawingPanel;
    public InteractiveArrow String;
    public InteractiveParticle pendulumMass;
    public InteractiveSpring spring;
    public InteractiveParticle shoMass;

    public LiouvilleView(LiouvilleSimulation liouvilleSimulation, String string, Frame frame) {
        super(liouvilleSimulation, string, frame);
        this._simulation = liouvilleSimulation;
        this._model = (Liouville)liouvilleSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        this.createControl();
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("t", "apply(\"t\")");
        this.addListener("nmax", "apply(\"nmax\")");
        this.addListener("q", "apply(\"q\")");
        this.addListener("qd", "apply(\"qd\")");
        this.addListener("gamma", "apply(\"gamma\")");
        this.addListener("q0", "apply(\"q0\")");
        this.addListener("qd0", "apply(\"qd0\")");
        this.addListener("harmonic", "apply(\"harmonic\")");
        this.addListener("x0", "apply(\"x0\")");
        this.addListener("y0", "apply(\"y0\")");
        this.addListener("n", "apply(\"n\")");
        this.addListener("xmin", "apply(\"xmin\")");
        this.addListener("xmax", "apply(\"xmax\")");
        this.addListener("ymin", "apply(\"ymin\")");
        this.addListener("ymax", "apply(\"ymax\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("tol", "apply(\"tol\")");
        this.addListener("type", "apply(\"type\")");
        this.addListener("d", "apply(\"d\")");
        this.addListener("n0", "apply(\"n0\")");
        this.addListener("cylinder", "apply(\"cylinder\")");
        this.addListener("traj", "apply(\"traj\")");
        this.addListener("npoints", "apply(\"npoints\")");
        this.addListener("showSpace", "apply(\"showSpace\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("nmax".equals(string)) {
            this._model.nmax = this.getInt("nmax");
        }
        if ("q".equals(string)) {
            dArray = (double[])this.getValue("q").getObject();
            n2 = dArray.length;
            if (n2 > this._model.q.length) {
                n2 = this._model.q.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.q[n] = dArray[n];
            }
        }
        if ("qd".equals(string)) {
            dArray = (double[])this.getValue("qd").getObject();
            n2 = dArray.length;
            if (n2 > this._model.qd.length) {
                n2 = this._model.qd.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.qd[n] = dArray[n];
            }
        }
        if ("gamma".equals(string)) {
            this._model.gamma = this.getDouble("gamma");
        }
        if ("q0".equals(string)) {
            this._model.q0 = this.getDouble("q0");
        }
        if ("qd0".equals(string)) {
            this._model.qd0 = this.getDouble("qd0");
        }
        if ("harmonic".equals(string)) {
            this._model.harmonic = this.getBoolean("harmonic");
        }
        if ("x0".equals(string)) {
            this._model.x0 = this.getDouble("x0");
        }
        if ("y0".equals(string)) {
            this._model.y0 = this.getDouble("y0");
        }
        if ("n".equals(string)) {
            this._model.n = this.getInt("n");
        }
        if ("xmin".equals(string)) {
            this._model.xmin = this.getDouble("xmin");
        }
        if ("xmax".equals(string)) {
            this._model.xmax = this.getDouble("xmax");
        }
        if ("ymin".equals(string)) {
            this._model.ymin = this.getDouble("ymin");
        }
        if ("ymax".equals(string)) {
            this._model.ymax = this.getDouble("ymax");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("tol".equals(string)) {
            this._model.tol = this.getDouble("tol");
        }
        if ("type".equals(string)) {
            this._model.type = this.getString("type");
        }
        if ("d".equals(string)) {
            this._model.d = this.getDouble("d");
        }
        if ("n0".equals(string)) {
            this._model.n0 = this.getInt("n0");
        }
        if ("cylinder".equals(string)) {
            this._model.cylinder = this.getBoolean("cylinder");
        }
        if ("traj".equals(string)) {
            this._model.traj = this.getBoolean("traj");
        }
        if ("npoints".equals(string)) {
            this._model.npoints = this.getInt("npoints");
        }
        if ("showSpace".equals(string)) {
            this._model.showSpace = this.getBoolean("showSpace");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("t", this._model.t);
        this.setValue("nmax", this._model.nmax);
        this.setValue("q", this._model.q);
        this.setValue("qd", this._model.qd);
        this.setValue("gamma", this._model.gamma);
        this.setValue("q0", this._model.q0);
        this.setValue("qd0", this._model.qd0);
        this.setValue("harmonic", this._model.harmonic);
        this.setValue("x0", this._model.x0);
        this.setValue("y0", this._model.y0);
        this.setValue("n", this._model.n);
        this.setValue("xmin", this._model.xmin);
        this.setValue("xmax", this._model.xmax);
        this.setValue("ymin", this._model.ymin);
        this.setValue("ymax", this._model.ymax);
        this.setValue("dt", this._model.dt);
        this.setValue("tol", this._model.tol);
        this.setValue("type", this._model.type);
        this.setValue("d", this._model.d);
        this.setValue("n0", this._model.n0);
        this.setValue("cylinder", this._model.cylinder);
        this.setValue("traj", this._model.traj);
        this.setValue("npoints", this._model.npoints);
        this.setValue("showSpace", this._model.showSpace);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.Main = (Component)this.addElement(new ControlFrame(), "Main").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Main.title", "Liouville's theorem")).setProperty("layout", "border").setProperty("visible", "true").setProperty("size", this._simulation.translateString("View.Main.size", "666,480")).getObject();
        this.PhaseSpace = (PlottingPanel2D)this.addElement(new ControlPlottingPanel(), "PhaseSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Main").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "xmin").setProperty("maximumX", "xmax").setProperty("minimumY", "ymin").setProperty("maximumY", "ymax").setProperty("pressaction", "_model._method_for_PhaseSpace_pressaction()").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase-space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "d$\\phi$/dt")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "$\\phi$=0.### /")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "d$\\phi$/dt=0.###")).setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Use mouse to change center's position")).getObject();
        this.PointSet = (ElementSet)this.addElement(new ControlParticleSet(), "PointSet").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("elementnumber", "%_model._method_for_PointSet_elementnumber()%").setProperty("x", "q").setProperty("y", "qd").setProperty("sizex", "0.01").setProperty("sizey", "0.01").setProperty("enabled", "false").getObject();
        this.Trajectory = (InteractiveTrace)this.addElement(new ControlTrace(), "Trajectory").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "q0").setProperty("y", "qd0").setProperty("active", "traj").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("visible", "traj").setProperty("color", "red").getObject();
        this.Center = (InteractiveParticle)this.addElement(new ControlParticle(), "Center").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "q0").setProperty("y", "qd0").setProperty("enabled", "true").setProperty("action", "_model._method_for_Center_action()").setProperty("color", "red").getObject();
        this.Origin = (InteractiveParticle)this.addElement(new ControlParticle(), "Origin").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("enabled", "false").setProperty("color", "black").getObject();
        this.mpi = (InteractiveArrow)this.addElement(new ControlArrow(), "mpi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "%_model._method_for_mpi_x()%").setProperty("y", "ymin").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_mpi_sizey()%").setProperty("visible", "cylinder").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green").getObject();
        this.ppi = (InteractiveArrow)this.addElement(new ControlArrow(), "ppi").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "PhaseSpace").setProperty("x", "%_model._method_for_ppi_x()%").setProperty("y", "ymin").setProperty("sizex", "0").setProperty("sizey", "%_model._method_for_ppi_sizey()%").setProperty("visible", "cylinder").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green").getObject();
        this.Down = (JPanel)this.addElement(new ControlPanel(), "Down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "Main").setProperty("layout", "border").setProperty("borderType", "LOWERED_ETCHED").getObject();
        this.Controls = (JPanel)this.addElement(new ControlPanel(), "Controls").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Down").setProperty("layout", "grid:2,7,0,0").getObject();
        this.Kq = (JTextField)this.addElement(new ControlNumberField(), "Kq").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "q0").setProperty("format", this._simulation.translateString("View.Kq.format", "$\\phi$ = 0.##")).setProperty("action", "_model._method_for_Kq_action()").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Kq.tooltip", "Center point's angular position")).getObject();
        this.Kqd = (JTextField)this.addElement(new ControlNumberField(), "Kqd").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "qd0").setProperty("format", this._simulation.translateString("View.Kqd.format", "d$\\phi$/dt = 0.##")).setProperty("action", "_model._method_for_Kqd_action()").setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Kqd.tooltip", "Center point's angular velocity")).getObject();
        this.Gamma = (JTextField)this.addElement(new ControlNumberField(), "Gamma").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("action", "_model._method_for_Gamma_action()").setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Double of the damping coefficient")).getObject();
        this.Harmonics = (JCheckBox)this.addElement(new ControlCheckBox(), "Harmonics").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "harmonic").setProperty("text", this._simulation.translateString("View.Harmonics.text", "SHO")).setProperty("mnemonic", this._simulation.translateString("View.Harmonics.mnemonic", "h")).setProperty("action", "_model._method_for_Harmonics_action()").setProperty("tooltip", this._simulation.translateString("View.Harmonics.tooltip", "Simple harmonic oscillator instead of pendulum")).getObject();
        this.Kn = (JTextField)this.addElement(new ControlNumberField(), "Kn").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "n").setProperty("format", this._simulation.translateString("View.Kn.format", "N = 0")).setProperty("action", "_model._method_for_Kn_action()").setProperty("tooltip", this._simulation.translateString("View.Kn.tooltip", "Number of points along a diameter")).getObject();
        this.Kd = (JTextField)this.addElement(new ControlNumberField(), "Kd").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "d").setProperty("format", this._simulation.translateString("View.Kd.format", "d = 0.##")).setProperty("action", "_model._method_for_Kd_action()").setProperty("tooltip", this._simulation.translateString("View.Kd.tooltip", "Set diameter")).getObject();
        this.Type = (JComboBox)this.addElement(new ControlComboBox(), "Type").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("options", this._simulation.translateString("View.Type.options", "Square;Hollow;Disk;Circle")).setProperty("variable", "%type%").setProperty("action", "_model._method_for_Type_action()").setProperty("tooltip", this._simulation.translateString("View.Type.tooltip", "Geometrical form")).getObject();
        this.Kdt = (JTextField)this.addElement(new ControlNumberField(), "Kdt").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "dt").setProperty("format", this._simulation.translateString("View.Kdt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Kdt.tooltip", "Integration step length")).getObject();
        this.Cylinder = (JCheckBox)this.addElement(new ControlCheckBox(), "Cylinder").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "cylinder").setProperty("text", this._simulation.translateString("View.Cylinder.text", "Cylinder")).setProperty("mnemonic", this._simulation.translateString("View.Cylinder.mnemonic", "c")).setProperty("enabled", "%_model._method_for_Cylinder_enabled()%").setProperty("action", "_model._method_for_Cylinder_action()").setProperty("tooltip", this._simulation.translateString("View.Cylinder.tooltip", "The angle goes from -pi to pi")).getObject();
        this.Traj = (JCheckBox)this.addElement(new ControlCheckBox(), "Traj").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "traj").setProperty("text", this._simulation.translateString("View.Traj.text", "Trajectory")).setProperty("mnemonic", this._simulation.translateString("View.Traj.mnemonic", "a")).setProperty("action", "_model._method_for_Traj_action()").setProperty("tooltip", this._simulation.translateString("View.Traj.tooltip", "Draw center point's phase-trajectory")).getObject();
        this.showSpace = (JCheckBox)this.addElement(new ControlCheckBox(), "showSpace").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "showSpace").setProperty("text", this._simulation.translateString("View.showSpace.text", "Space View")).setProperty("mnemonic", this._simulation.translateString("View.showSpace.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.showSpace.tooltip", "Show pendulum true evolution?")).getObject();
        this.startButton = (JButton)this.addElement(new ControlTwoStateButton(), "startButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("variable", "_isPaused").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and Stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("actionOn", "_model._method_for_startButton_actionOn()").setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s")).setProperty("actionOff", "_model._method_for_startButton_actionOff()").getObject();
        this.stepButton = (JButton)this.addElement(new ControlButton(), "stepButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("action", "_model._method_for_stepButton_action()").setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation.")).getObject();
        this.resetButton = (JButton)this.addElement(new ControlButton(), "resetButton").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "Controls").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("action", "_model._method_for_resetButton_action()").setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset the simulation.")).getObject();
        this.Pendulum = (JDialog)this.addElement(new ControlDialog(), "Pendulum").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.Pendulum.title", "Space view")).setProperty("layout", "border").setProperty("visible", "showSpace").setProperty("location", "610,0").setProperty("size", this._simulation.translateString("View.Pendulum.size", "300,300")).getObject();
        this.DrawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "DrawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "Pendulum").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.1").setProperty("maximumX", "1.1").setProperty("minimumY", "-1.1").setProperty("maximumY", "1.1").getObject();
        this.String = (InteractiveArrow)this.addElement(new ControlArrow(), "String").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "DrawingPanel").setProperty("sizex", "x0").setProperty("sizey", "y0").setProperty("visible", "%_model._method_for_String_visible()%").setProperty("enabled", "false").setProperty("style", "SEGMENT").getObject();
        this.pendulumMass = (InteractiveParticle)this.addElement(new ControlParticle(), "pendulumMass").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "DrawingPanel").setProperty("x", "x0").setProperty("y", "y0").setProperty("visible", "%_model._method_for_pendulumMass_visible()%").setProperty("enabled", "true").setProperty("color", "red").getObject();
        this.spring = (InteractiveSpring)this.addElement(new ControlSpring(), "spring").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "DrawingPanel").setProperty("x", "-1.1").setProperty("y", "0").setProperty("sizex", "%_model._method_for_spring_sizex()%").setProperty("sizey", "0").setProperty("visible", "harmonic").setProperty("enabled", "false").getObject();
        this.shoMass = (InteractiveParticle)this.addElement(new ControlParticle(), "shoMass").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "DrawingPanel").setProperty("x", "x0").setProperty("y", "0").setProperty("visible", "harmonic").setProperty("enabled", "true").getObject();
    }

    public void reset() {
        this.getElement("Main").setProperty("title", this._simulation.translateString("View.Main.title", "Liouville's theorem")).setProperty("visible", "true");
        this.getElement("PhaseSpace").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("title", this._simulation.translateString("View.PhaseSpace.title", "Phase-space")).setProperty("titleX", this._simulation.translateString("View.PhaseSpace.titleX", "$\\phi$")).setProperty("titleY", this._simulation.translateString("View.PhaseSpace.titleY", "d$\\phi$/dt")).setProperty("square", "true").setProperty("xFormat", this._simulation.translateString("View.PhaseSpace.xFormat", "$\\phi$=0.### /")).setProperty("yFormat", this._simulation.translateString("View.PhaseSpace.yFormat", "d$\\phi$/dt=0.###")).setProperty("tooltip", this._simulation.translateString("View.PhaseSpace.tooltip", "Use mouse to change center's position"));
        this.getElement("PointSet").setProperty("sizex", "0.01").setProperty("sizey", "0.01").setProperty("enabled", "false");
        this.getElement("Trajectory").setProperty("norepeat", "true").setProperty("connected", "true").setProperty("color", "red");
        this.getElement("Center").setProperty("enabled", "true").setProperty("color", "red");
        this.getElement("Origin").setProperty("enabled", "false").setProperty("color", "black");
        this.getElement("mpi").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green");
        this.getElement("ppi").setProperty("sizex", "0").setProperty("enabled", "false").setProperty("style", "SEGMENT").setProperty("color", "green");
        this.getElement("Down").setProperty("borderType", "LOWERED_ETCHED");
        this.getElement("Controls");
        this.getElement("Kq").setProperty("format", this._simulation.translateString("View.Kq.format", "$\\phi$ = 0.##")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Kq.tooltip", "Center point's angular position"));
        this.getElement("Kqd").setProperty("format", this._simulation.translateString("View.Kqd.format", "d$\\phi$/dt = 0.##")).setProperty("foreground", "red").setProperty("tooltip", this._simulation.translateString("View.Kqd.tooltip", "Center point's angular velocity"));
        this.getElement("Gamma").setProperty("format", this._simulation.translateString("View.Gamma.format", "$\\gamma$ = 0.###")).setProperty("tooltip", this._simulation.translateString("View.Gamma.tooltip", "Double of the damping coefficient"));
        this.getElement("Harmonics").setProperty("text", this._simulation.translateString("View.Harmonics.text", "SHO")).setProperty("mnemonic", this._simulation.translateString("View.Harmonics.mnemonic", "h")).setProperty("tooltip", this._simulation.translateString("View.Harmonics.tooltip", "Simple harmonic oscillator instead of pendulum"));
        this.getElement("Kn").setProperty("format", this._simulation.translateString("View.Kn.format", "N = 0")).setProperty("tooltip", this._simulation.translateString("View.Kn.tooltip", "Number of points along a diameter"));
        this.getElement("Kd").setProperty("format", this._simulation.translateString("View.Kd.format", "d = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Kd.tooltip", "Set diameter"));
        this.getElement("Type").setProperty("options", this._simulation.translateString("View.Type.options", "Square;Hollow;Disk;Circle")).setProperty("tooltip", this._simulation.translateString("View.Type.tooltip", "Geometrical form"));
        this.getElement("Kdt").setProperty("format", this._simulation.translateString("View.Kdt.format", "$\\Delta$t = 0.##")).setProperty("tooltip", this._simulation.translateString("View.Kdt.tooltip", "Integration step length"));
        this.getElement("Cylinder").setProperty("text", this._simulation.translateString("View.Cylinder.text", "Cylinder")).setProperty("mnemonic", this._simulation.translateString("View.Cylinder.mnemonic", "c")).setProperty("tooltip", this._simulation.translateString("View.Cylinder.tooltip", "The angle goes from -pi to pi"));
        this.getElement("Traj").setProperty("text", this._simulation.translateString("View.Traj.text", "Trajectory")).setProperty("mnemonic", this._simulation.translateString("View.Traj.mnemonic", "a")).setProperty("tooltip", this._simulation.translateString("View.Traj.tooltip", "Draw center point's phase-trajectory"));
        this.getElement("showSpace").setProperty("text", this._simulation.translateString("View.showSpace.text", "Space View")).setProperty("mnemonic", this._simulation.translateString("View.showSpace.mnemonic", "p")).setProperty("tooltip", this._simulation.translateString("View.showSpace.tooltip", "Show pendulum true evolution?"));
        this.getElement("startButton").setProperty("tooltip", this._simulation.translateString("View.startButton.tooltip", "Start and Stop the simulation.")).setProperty("imageOn", this._simulation.translateString("View.startButton.imageOn", "/org/opensourcephysics/resources/controls/images/play.gif")).setProperty("mnemonicOn", this._simulation.translateString("View.startButton.mnemonicOn", "g")).setProperty("imageOff", this._simulation.translateString("View.startButton.imageOff", "/org/opensourcephysics/resources/controls/images/pause.gif")).setProperty("mnemonicOff", this._simulation.translateString("View.startButton.mnemonicOff", "s"));
        this.getElement("stepButton").setProperty("image", this._simulation.translateString("View.stepButton.image", "/org/opensourcephysics/resources/controls/images/stepforward.gif")).setProperty("tooltip", this._simulation.translateString("View.stepButton.tooltip", "Step the simulation."));
        this.getElement("resetButton").setProperty("image", this._simulation.translateString("View.resetButton.image", "/org/opensourcephysics/resources/controls/images/reset.gif")).setProperty("tooltip", this._simulation.translateString("View.resetButton.tooltip", "Reset the simulation."));
        this.getElement("Pendulum").setProperty("title", this._simulation.translateString("View.Pendulum.title", "Space view"));
        this.getElement("DrawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.1").setProperty("maximumX", "1.1").setProperty("minimumY", "-1.1").setProperty("maximumY", "1.1");
        this.getElement("String").setProperty("enabled", "false").setProperty("style", "SEGMENT");
        this.getElement("pendulumMass").setProperty("enabled", "true").setProperty("color", "red");
        this.getElement("spring").setProperty("x", "-1.1").setProperty("y", "0").setProperty("sizey", "0").setProperty("enabled", "false");
        this.getElement("shoMass").setProperty("y", "0").setProperty("enabled", "true");
        super.reset();
    }
}

