/*
 * Decompiled with CFR 0.152.
 */
package users.ehu.jma.analytical_mechanics.Liouville;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.tools.ResourceLoader;
import users.ehu.jma.analytical_mechanics.Liouville.LiouvilleSimulation;
import users.ehu.jma.analytical_mechanics.Liouville.LiouvilleView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Liouville
extends AbstractModel {
    public LiouvilleSimulation _simulation = null;
    public LiouvilleView _view = null;
    public Liouville _model = this;
    public double t = 0.0;
    public int nmax = 31;
    public double[] q;
    public double[] qd;
    public double gamma = 0.0;
    public double q0 = 1.0;
    public double qd0 = 0.0;
    public boolean harmonic = false;
    public double x0 = 0.0;
    public double y0 = 0.0;
    public int n = 17;
    public double xmin = -4.0;
    public double xmax = 4.0;
    public double ymin = -3.0;
    public double ymax = 3.0;
    public double dt = 0.05;
    public double tol = 1.0E-6;
    public String type = "Square";
    public double d = 0.3;
    public int n0 = 2;
    public boolean cylinder = true;
    public boolean traj = false;
    public int npoints = 256;
    public boolean showSpace = false;
    private _ODE_evolution1 _ODEi_evolution1;
    public final double HYPOTMIN = 1.0E-4;

    public static String _getEjsModel() {
        return "users/ehu/jma/analytical_mechanics/Liouville.xml";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        OSPRuntime.javaLookAndFeel = true;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        ResourceLoader.addSearchPath("users/ehu/jma/analytical_mechanics/");
        boolean bl = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            Simulation.setPathToLibrary("C:/prog/Ejs/bin/");
        }
        Liouville liouville = new Liouville(stringArray);
    }

    public Liouville() {
        this(null, null, null, null, null, false);
    }

    public Liouville(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Liouville(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new LiouvilleSimulation(this, string, frame, uRL, bl);
        this._view = (LiouvilleView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        this.set_type();
    }

    public void _evolution2() {
        if (this.cylinder) {
            this._view.getElement("Trajectory").setProperty("connected", this.q[this.n0] < -Math.PI || this.q[this.n0] > Math.PI ? "false" : "true");
            for (int i = 0; i < this.npoints; ++i) {
                if (this.q[i] < -Math.PI) {
                    int n = i;
                    this.q[n] = this.q[n] + Math.PI * 2;
                    continue;
                }
                if (!(this.q[i] > Math.PI)) continue;
                int n = i;
                this.q[n] = this.q[n] - Math.PI * 2;
            }
        }
    }

    public void _evolution3() {
        this.q0 = this.q[this.n0];
        this.qd0 = this.qd[this.n0];
        this.x0 = Math.sin(this.q0);
        this.y0 = -Math.cos(this.q0);
    }

    public void _constraints1() {
        if (this.n <= 0) {
            this.n = 1;
        }
        if (this.n % 2 == 0) {
            ++this.n;
        }
        if (this.type.equals("Square") || this.type.equals("Disk")) {
            if (this.n > this.nmax) {
                this.n = this.nmax;
            }
            this.npoints = this.n * this.n;
            this.n0 = this.npoints / 2;
        } else if (this.type.equals("Hollow")) {
            if (4 * this.n - 3 > this.nmax * this.nmax) {
                this.n = (this.nmax * this.nmax + 3) / 4;
            }
            this.n0 = 4 * (this.n - 1);
            this.npoints = this.n0 + 1;
        } else {
            if (2 * this.n - 1 > this.nmax * this.nmax) {
                this.n = (this.nmax * this.nmax + 1) / 2;
            }
            this.n0 = 2 * (this.n - 1);
            this.npoints = this.n0 + 1;
        }
        this.x0 = Math.sin(this.q[this.n0]);
        this.y0 = -Math.cos(this.q[this.n0]);
    }

    public void set_type() {
        this._pause();
        this.t = 0.0;
        this.n = Math.min(this.n, this.nmax);
        this._view.getElement("Trajectory").reset();
        if (this.type.equals("Square")) {
            this.set_sqdi(false);
        } else if (this.type.equals("Disk")) {
            this.set_sqdi(true);
        } else if (this.type.equals("Hollow")) {
            this.set_void();
        } else if (this.type.equals("Circle")) {
            this.set_circ();
        }
    }

    public void set_sqdi(boolean bl) {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            int n = this.n / 2;
            double d = this.d / (double)n;
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    if (bl && this.hypot((double)(i - n) * d, (double)(j - n) * d) > this.d) {
                        this.q[i * this.n + j] = 0.0;
                        this.qd[i * this.n + j] = 0.0;
                        continue;
                    }
                    this.q[i * this.n + j] = this.q0 + (double)(i - n) * d;
                    this.qd[i * this.n + j] = this.qd0 + (double)(j - n) * d;
                }
            }
        }
    }

    public void set_void() {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            int n = this.n / 2;
            double d = this.d / (double)n;
            for (int i = 0; i < this.n - 1; ++i) {
                this.q[i] = this.q0 + (double)(i - n) * d;
                this.qd[i] = this.qd0 + (double)(this.n - 1 - n) * d;
                this.q[i + this.n - 1] = this.q0 + (double)(this.n - 1 - n) * d;
                this.qd[i + this.n - 1] = this.qd0 - (double)(i - n) * d;
                this.q[i + 2 * (this.n - 1)] = this.q0 - (double)(i - n) * d;
                this.qd[i + 2 * (this.n - 1)] = this.qd0 - (double)n * d;
                this.q[i + 3 * (this.n - 1)] = this.q0 - (double)n * d;
                this.qd[i + 3 * (this.n - 1)] = this.qd0 + (double)(i - n) * d;
            }
        }
    }

    public void set_circ() {
        this.q[this.n0] = this.q0;
        this.qd[this.n0] = this.qd0;
        if (this.n >= 3) {
            double d = this.d;
            double d2 = Math.PI / (double)(this.n - 1);
            for (int i = 0; i < 2 * this.n - 2; ++i) {
                this.q[i] = this.q0 + d * Math.cos((double)i * d2);
                this.qd[i] = this.qd0 + d * Math.sin((double)i * d2);
            }
        }
    }

    public double vel(int n, double d, double d2) {
        return n >= this.npoints ? 0.0 : d2;
    }

    public double acc(int n, double d, double d2) {
        if (n >= this.npoints) {
            return 0.0;
        }
        return this.harmonic ? -this.gamma * d2 - d : -this.gamma * d2 - Math.sin(d);
    }

    public double hypot(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        return (d /= d2) < 1.0E-4 ? d2 + 0.5 * d * d / d2 : d2 * Math.sqrt(1.0 + d * d);
    }

    public void _method_for_PhaseSpace_pressaction() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public int _method_for_PointSet_elementnumber() {
        return this.n * this.n;
    }

    public void _method_for_Center_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public double _method_for_mpi_x() {
        return -Math.PI;
    }

    public double _method_for_mpi_sizey() {
        return this.ymax - this.ymin;
    }

    public double _method_for_ppi_x() {
        return Math.PI;
    }

    public double _method_for_ppi_sizey() {
        return this.ymax - this.ymin;
    }

    public void _method_for_Kq_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kqd_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Gamma_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Harmonics_action() {
        this._simulation.disableLoop();
        if (this.harmonic) {
            this.cylinder = false;
        }
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kn_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Kd_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Type_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public boolean _method_for_Cylinder_enabled() {
        return !this.harmonic;
    }

    public void _method_for_Cylinder_action() {
        this._simulation.disableLoop();
        this.set_type();
        this._simulation.enableLoop();
    }

    public void _method_for_Traj_action() {
        this._simulation.disableLoop();
        this._view.getElement("Trajectory").reset();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOn() {
        this._simulation.disableLoop();
        this._play();
        this._simulation.enableLoop();
    }

    public void _method_for_startButton_actionOff() {
        this._simulation.disableLoop();
        this._pause();
        this._simulation.enableLoop();
    }

    public void _method_for_stepButton_action() {
        this._simulation.disableLoop();
        this._step();
        this._simulation.enableLoop();
    }

    public void _method_for_resetButton_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public boolean _method_for_String_visible() {
        return !this.harmonic;
    }

    public boolean _method_for_pendulumMass_visible() {
        return !this.harmonic;
    }

    public double _method_for_spring_sizex() {
        return this.x0 + 1.1;
    }

    @Override
    public synchronized void reset() {
        int n;
        this.t = 0.0;
        this.nmax = 31;
        this.q = new double[this.nmax * this.nmax];
        for (n = 0; n < this.nmax * this.nmax; ++n) {
            this.q[n] = 0.5;
        }
        this.qd = new double[this.nmax * this.nmax];
        for (n = 0; n < this.nmax * this.nmax; ++n) {
            this.qd[n] = 0.0;
        }
        this.gamma = 0.0;
        this.q0 = 1.0;
        this.qd0 = 0.0;
        this.harmonic = false;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.n = 17;
        this.xmin = -4.0;
        this.xmax = 4.0;
        this.ymin = -3.0;
        this.ymax = 3.0;
        this.dt = 0.05;
        this.tol = 1.0E-6;
        this.type = "Square";
        this.d = 0.3;
        this.n0 = 2;
        this.cylinder = true;
        this.traj = false;
        this.npoints = 256;
        this.showSpace = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
        this._evolution3();
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.q = null;
        this.qd = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    private class _ODE_evolution1
    implements ODE {
        private ODEMultistepSolver __solver = null;
        private double[] __state = null;
        private double[] _q;
        private double[] _qd;
        private double _t;

        _ODE_evolution1() {
            this.initArrays();
            this.resetSolver();
        }

        private void initArrays() {
            this.__state = new double[1 + Liouville.this.q.length + Liouville.this.qd.length];
            this._q = new double[Liouville.this.q.length];
            this._qd = new double[Liouville.this.qd.length];
        }

        private boolean arraysChanged() {
            if (Liouville.this.q.length != this._q.length) {
                return true;
            }
            return Liouville.this.qd.length != this._qd.length;
        }

        void resetSolver() {
            if (this.arraysChanged()) {
                this.initArrays();
            }
            int n = 0;
            for (double this.__state[n++] : Liouville.this.q) {
            }
            for (double this.__state[n++] : Liouville.this.qd) {
            }
            this.__state[n++] = Liouville.this.t;
            this.__solver = new ODEMultistepSolver(this);
            this.__solver.initialize(Liouville.this.dt);
        }

        void step() {
            int n;
            if (this.arraysChanged()) {
                this.resetSolver();
            }
            if (Liouville.this.tol != this.__solver.getTolerance()) {
                this.__solver.setTolerance(Liouville.this.tol);
            }
            if (Liouville.this.dt != this.__solver.getStepSize()) {
                this.__solver.setStepSize(Liouville.this.dt);
            }
            int n2 = 0;
            for (double this.__state[n2++] : Liouville.this.q) {
            }
            for (double this.__state[n2++] : Liouville.this.qd) {
            }
            this.__state[n2++] = Liouville.this.t;
            this.__solver.step();
            n2 = 0;
            int n3 = Liouville.this.q.length;
            for (n = 0; n < n3; ++n) {
                Liouville.this.q[n] = this.__state[n2++];
            }
            n3 = Liouville.this.qd.length;
            for (n = 0; n < n3; ++n) {
                Liouville.this.qd[n] = this.__state[n2++];
            }
            Liouville.this.t = this.__state[n2++];
        }

        public double[] getState() {
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            int n2 = 0;
            int n3 = Liouville.this.q.length;
            for (n = 0; n < n3; ++n) {
                this._q[n] = dArray[n2++];
            }
            n3 = Liouville.this.qd.length;
            for (n = 0; n < n3; ++n) {
                this._qd[n] = dArray[n2++];
            }
            this._t = dArray[n2++];
            n2 = 0;
            n3 = Liouville.this.q.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_1(n, this._q, this._qd, this._t);
            }
            n3 = Liouville.this.qd.length;
            for (n = 0; n < n3; ++n) {
                dArray2[n2++] = this._ODE_evolution1_2(n, this._q, this._qd, this._t);
            }
            dArray2[n2++] = 1.0;
        }

        private double _ODE_evolution1_1(int n, double[] dArray, double[] dArray2, double d) {
            return Liouville.this.vel(n, dArray[n], dArray2[n]);
        }

        private double _ODE_evolution1_2(int n, double[] dArray, double[] dArray2, double d) {
            return Liouville.this.acc(n, dArray[n], dArray2[n]);
        }
    }
}

