/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JApplet;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Launcher;

class LaunchableClassMap
extends TreeMap {
    ClassLoader classLoader;
    String[] jarNames;
    boolean allLoaded = false;

    LaunchableClassMap(String[] stringArray) {
        this.jarNames = stringArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string = OSPRuntime.getLaunchJarDirectory();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = XML.getResolvedPath(stringArray[n], string);
            try {
                arrayList.add(new URL("file:" + string2));
            }
            catch (MalformedURLException malformedURLException) {
                OSPLog.info(malformedURLException + " " + string2);
            }
            ++n;
        }
        this.classLoader = URLClassLoader.newInstance(arrayList.toArray(new URL[0]));
    }

    Class smartLoadClass(String string) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClass().getClassLoader().loadClass(string);
        }
    }

    void loadAllLaunchables() {
        if (this.allLoaded) {
            return;
        }
        JApplet jApplet = OSPRuntime.applet;
        int n = 0;
        while (n < this.jarNames.length) {
            Object object;
            Object object2;
            Object object3;
            JarFile jarFile = null;
            try {
                if (jApplet == null) {
                    jarFile = new JarFile(this.jarNames[n]);
                } else {
                    object3 = XML.getResolvedPath(this.jarNames[n], jApplet.getCodeBase().toExternalForm());
                    object2 = new URL("jar:" + (String)object3 + "!/");
                    object = (JarURLConnection)((URL)object2).openConnection();
                    jarFile = ((JarURLConnection)object).getJarFile();
                }
            }
            catch (IOException iOException) {
                OSPLog.info(String.valueOf(iOException.getClass().getName()) + ": " + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                OSPLog.info(String.valueOf(securityException.getClass().getName()) + ": " + securityException.getMessage());
            }
            if (jarFile != null) {
                object3 = jarFile.entries();
                while (object3.hasMoreElements()) {
                    object2 = (JarEntry)object3.nextElement();
                    object = ((ZipEntry)object2).getName();
                    if (!((String)object).endsWith(".class") || ((String)object).indexOf("$") != -1) continue;
                    object = ((String)object).substring(0, ((String)object).indexOf(".class"));
                    int n2 = ((String)object).indexOf("/");
                    while (n2 != -1) {
                        object = String.valueOf(((String)object).substring(0, n2)) + "." + ((String)object).substring(n2 + 1);
                        n2 = ((String)object).indexOf("/");
                    }
                    if (this.get(object) != null) continue;
                    try {
                        Class clazz = this.smartLoadClass((String)object);
                        if (!Launcher.isLaunchable(clazz)) continue;
                        this.put(object, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        OSPLog.info(noClassDefFoundError.toString());
                    }
                }
            }
            ++n;
        }
        this.allLoaded = true;
    }

    boolean includesJar(String string) {
        int n = 0;
        while (n < this.jarNames.length) {
            if (this.jarNames[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Class getClass(String string) {
        Class clazz = (Class)this.get(string);
        if (clazz != null || this.allLoaded) {
            return clazz;
        }
        try {
            clazz = this.smartLoadClass(string);
            if (Launcher.isLaunchable(clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            OSPLog.info(noClassDefFoundError.toString());
        }
        return null;
    }
}

