/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.tools.DataToolTable;
import org.opensourcephysics.tools.ToolsRes;

public class DataToolPropsTable
extends JTable {
    static final Color LIGHT_RED = new Color(255, 204, 204);
    DataToolTable dataTable;
    PropsTableModel propsModel;
    DataToolTable.LabelRenderer labelRenderer;
    PropsRenderer propsRenderer;
    MarkerEditor markerEditor = new MarkerEditor();
    JDialog styleDialog;
    Dataset markerDataset = new Dataset();
    Dataset lineDataset = new Dataset();
    JButton closeButton;
    String[] shapeNames;
    int[] shapeNumbers;
    JLabel shapeLabel;
    JLabel sizeLabel;
    JLabel patternLabel;
    JLabel sampleLabel;
    JCheckBox markerVisCheckbox;
    JCheckBox lineVisCheckbox;
    JButton markerColorButton;
    JButton lineColorButton;
    JTextField patternField;
    JTextField sampleField;
    DecimalFormat sampleFormat;
    JDialog colorPopup;
    JSpinner shapeSpinner;
    JSpinner sizeSpinner;
    int shapeSpinnerWidth;
    int markerRow = 0;
    int lineRow = 1;
    int styleRow = 2;
    int axisRow = 3;

    public DataToolPropsTable(DataToolTable dataToolTable) {
        this.dataTable = dataToolTable;
        this.propsModel = new PropsTableModel();
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                DataToolPropsTable.this.refreshTable();
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DataToolPropsTable.this.refreshTable();
            }
        });
        this.setModel(this.propsModel);
        this.setGridColor(Color.blue);
        this.setTableHeader(null);
        this.labelRenderer = this.dataTable.labelRenderer;
        this.propsRenderer = new PropsRenderer();
        this.setAutoResizeMode(0);
        this.refreshCellWidths();
    }

    private String[] getPropLabels() {
        return new String[]{ToolsRes.getString("DataToolPropsTable.Label.Markers"), ToolsRes.getString("DataToolPropsTable.Label.Lines"), ToolsRes.getString("DataToolPropsTable.Label.Style"), ToolsRes.getString("DataToolPropsTable.Label.Axis")};
    }

    public void refreshTable() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                DataToolPropsTable.this.tableChanged(new TableModelEvent(DataToolPropsTable.this.propsModel, -1));
                DataToolPropsTable.this.refreshCellWidths();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void refreshCellWidths() {
        int n = 0;
        while (n < this.getColumnCount()) {
            String string = this.getColumnName(n);
            TableColumn tableColumn = this.getColumn(string);
            string = this.dataTable.getColumnName(n);
            TableColumn tableColumn2 = this.dataTable.getColumn(string);
            tableColumn.setMaxWidth(tableColumn2.getWidth());
            tableColumn.setMinWidth(tableColumn2.getWidth());
            tableColumn.setWidth(tableColumn2.getWidth());
            ++n;
        }
    }

    public void refreshGUI() {
        int n = 40;
        String[] stringArray = this.getPropLabels();
        int n2 = 0;
        while (n2 < stringArray.length) {
            JLabel jLabel = new JLabel(stringArray[n2]);
            n = Math.max(n, jLabel.getMinimumSize().width);
            ++n2;
        }
        this.dataTable.setLabelColumnWidth(n + 5);
        this.tableChanged(null);
        this.refreshTable();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.dataTable.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return this.labelRenderer;
        }
        return this.propsRenderer;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n == this.styleRow) {
            return this.markerEditor;
        }
        return this.getDefaultEditor(Boolean.class);
    }

    protected JDialog getStyleDialog() {
        if (this.styleDialog == null) {
            Serializable serializable;
            Serializable serializable2;
            JComponent jComponent;
            final Frame frame = JOptionPane.getFrameForComponent(this.dataTable);
            this.styleDialog = new JDialog(frame, false);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolPropsTable.this.styleDialog.setVisible(false);
                    DataToolPropsTable.this.markerEditor.stopCellEditing();
                }
            });
            this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post")};
            this.shapeNumbers = new int[]{1, 2, 6, 7, 8};
            SpinnerListModel spinnerListModel = new SpinnerListModel(this.shapeNames);
            this.shapeSpinner = new JSpinner(spinnerListModel){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(DataToolPropsTable.this.shapeSpinnerWidth, dimension.height + 6);
                }
            };
            this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
            this.shapeSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    String string = DataToolPropsTable.this.shapeSpinner.getValue().toString();
                    int n = 0;
                    while (n < DataToolPropsTable.this.shapeNames.length) {
                        DataToolTable.WorkingDataset workingDataset;
                        if (DataToolPropsTable.this.shapeNames[n].equals(string) && (workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(DataToolPropsTable.this.styleDialog.getName())) != null) {
                            workingDataset.setMarkerShape(DataToolPropsTable.this.shapeNumbers[n]);
                            DataToolPropsTable.this.markerDataset.setMarkerShape(DataToolPropsTable.this.shapeNumbers[n]);
                            DataToolPropsTable.this.styleDialog.repaint();
                            frame.repaint();
                        }
                        ++n;
                    }
                }
            });
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(2, 1, 6, 1);
            this.sizeSpinner = new JSpinner(spinnerNumberModel){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    return new Dimension(DataToolPropsTable.this.shapeSpinnerWidth, dimension.height + 6);
                }
            };
            this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
            this.sizeSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)DataToolPropsTable.this.sizeSpinner.getValue();
                    DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(DataToolPropsTable.this.styleDialog.getName());
                    if (workingDataset != null) {
                        workingDataset.setMarkerSize(n);
                        DataToolPropsTable.this.markerDataset.setMarkerSize(n);
                        DataToolPropsTable.this.styleDialog.repaint();
                        frame.repaint();
                    }
                }
            });
            this.markerVisCheckbox = new JCheckBox(ToolsRes.getString("DataToolPropsTable.Dialog.Checkbox.Visible"));
            this.markerVisCheckbox.setHorizontalAlignment(0);
            this.markerVisCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(DataToolPropsTable.this.styleDialog.getName());
                    if (workingDataset != null) {
                        workingDataset.setMarkersVisible(DataToolPropsTable.this.markerVisCheckbox.isSelected());
                        DataToolPropsTable.this.styleDialog.repaint();
                        frame.repaint();
                    }
                }
            });
            this.lineVisCheckbox = new JCheckBox(ToolsRes.getString("DataToolPropsTable.Dialog.Checkbox.Visible"));
            this.lineVisCheckbox.setHorizontalAlignment(0);
            this.lineVisCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(DataToolPropsTable.this.styleDialog.getName());
                    if (workingDataset != null) {
                        workingDataset.setConnected(DataToolPropsTable.this.lineVisCheckbox.isSelected());
                        DataToolPropsTable.this.styleDialog.repaint();
                        frame.repaint();
                    }
                }
            });
            DrawingPanel drawingPanel = new DrawingPanel();
            drawingPanel.setShowCoordinates(false);
            drawingPanel.setPreferredSize(new Dimension(44, 24));
            drawingPanel.setBorder(BorderFactory.createEtchedBorder());
            drawingPanel.setBackground(Color.white);
            drawingPanel.setAntialiasShapeOn(true);
            this.markerDataset.append(0.0, 1.0);
            drawingPanel.addDrawable(this.markerDataset);
            DrawingPanel drawingPanel2 = new DrawingPanel();
            drawingPanel2.setShowCoordinates(false);
            drawingPanel2.setPreferredSize(new Dimension(44, 24));
            drawingPanel2.setBorder(BorderFactory.createEtchedBorder());
            drawingPanel2.setBackground(Color.white);
            drawingPanel2.setAntialiasShapeOn(true);
            this.lineDataset.append(-1.0, 1.0);
            this.lineDataset.append(1.0, -1.0);
            this.lineDataset.setMarkerShape(0);
            this.lineDataset.setConnected(true);
            drawingPanel2.addDrawable(this.lineDataset);
            this.shapeLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Shape"));
            this.sizeLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Size"));
            this.patternLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Pattern"));
            this.sampleLabel = new JLabel(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Sample"));
            this.patternField = new JTextField(6);
            this.patternField.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = 1.23456789;
                    try {
                        DataToolPropsTable.this.sampleFormat.applyPattern(DataToolPropsTable.this.patternField.getText());
                        DataToolPropsTable.this.sampleField.setText(DataToolPropsTable.this.sampleFormat.format(d));
                        String string = DataToolPropsTable.this.styleDialog.getName();
                        DataToolPropsTable.this.dataTable.setFormatPattern(string, DataToolPropsTable.this.patternField.getText());
                        DataToolPropsTable.this.dataTable.refreshTable();
                    }
                    catch (RuntimeException runtimeException) {
                        DataToolPropsTable.this.patternField.setBackground(LIGHT_RED);
                    }
                }
            });
            this.patternField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        DataToolPropsTable.this.patternField.setBackground(Color.white);
                    } else {
                        DataToolPropsTable.this.patternField.setBackground(Color.yellow);
                    }
                }
            });
            this.patternField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    DataToolPropsTable.this.patternField.setBackground(Color.white);
                    DataToolPropsTable.this.patternField.getAction().actionPerformed(null);
                }
            });
            this.sampleField = new JTextField(6);
            this.sampleField.setEditable(false);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (numberFormat instanceof DecimalFormat) {
                this.sampleFormat = (DecimalFormat)numberFormat;
            }
            final JColorChooser jColorChooser = new JColorChooser();
            jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Color color = jColorChooser.getColor();
                    DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(DataToolPropsTable.this.styleDialog.getName());
                    if (workingDataset != null) {
                        if (DataToolPropsTable.this.colorPopup.getName().equals("marker")) {
                            workingDataset.setColor(color, workingDataset.getLineColor());
                        } else {
                            workingDataset.setColor(workingDataset.getEdgeColor(), color);
                        }
                        DataToolPropsTable.this.markerDataset.setMarkerColor(workingDataset.getFillColor(), workingDataset.getEdgeColor());
                        DataToolPropsTable.this.lineDataset.setLineColor(workingDataset.getLineColor());
                        DataToolPropsTable.this.colorPopup.setVisible(false);
                        DataToolPropsTable.this.styleDialog.repaint();
                        frame.repaint();
                    }
                }
            });
            this.colorPopup = new JDialog(frame, false);
            this.colorPopup.setUndecorated(true);
            this.colorPopup.getContentPane().add(jColorChooser.getChooserPanels()[0]);
            this.colorPopup.pack();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    DataToolPropsTable.this.colorPopup.setName(jButton == DataToolPropsTable.this.markerColorButton ? "marker" : "line");
                    Point point = jButton.getLocationOnScreen();
                    DataToolPropsTable.this.colorPopup.setLocation(point.x, point.y + jButton.getSize().height);
                    DataToolPropsTable.this.colorPopup.setVisible(true);
                }
            };
            this.markerColorButton = new JButton(ToolsRes.getString("DataToolPropsTable.Dialog.Button.Color"));
            this.markerColorButton.addActionListener(actionListener);
            this.lineColorButton = new JButton(ToolsRes.getString("DataToolPropsTable.Dialog.Button.Color"));
            this.lineColorButton.addActionListener(actionListener);
            JPanel jPanel = new JPanel(new BorderLayout());
            Box box = Box.createVerticalBox();
            jPanel.add(box);
            Box box2 = Box.createVerticalBox();
            box.add(box2);
            box2.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Markers")));
            JPanel jPanel2 = new JPanel(new GridLayout());
            box2.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(drawingPanel);
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.markerColorButton);
            jPanel2.add(jPanel4);
            jPanel2.add(this.markerVisCheckbox);
            JPanel jPanel5 = new JPanel(new GridLayout());
            box2.add(jPanel5);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(this.sizeLabel);
            jPanel6.add(this.sizeSpinner);
            jPanel5.add(jPanel6);
            JPanel jPanel7 = new JPanel();
            jPanel7.add(this.shapeLabel);
            jPanel7.add(this.shapeSpinner);
            jPanel5.add(jPanel7);
            Box box3 = Box.createVerticalBox();
            box.add(box3);
            box3.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Lines")));
            JPanel jPanel8 = new JPanel(new GridLayout());
            box3.add(jPanel8);
            JPanel jPanel9 = new JPanel();
            jPanel9.add(drawingPanel2);
            jPanel8.add(jPanel9);
            JPanel jPanel10 = new JPanel();
            jPanel10.add(this.lineColorButton);
            jPanel8.add(jPanel10);
            jPanel8.add(this.lineVisCheckbox);
            if (this.sampleFormat != null) {
                jComponent = Box.createVerticalBox();
                box.add(jComponent);
                jComponent.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("DataToolPropsTable.Dialog.Label.Format")));
                serializable2 = new JPanel(new GridLayout());
                jComponent.add((Component)serializable2);
                JPanel jPanel11 = new JPanel();
                jPanel11.add(this.patternLabel);
                jPanel11.add(this.patternField);
                ((Container)serializable2).add(jPanel11);
                serializable = new JPanel();
                ((Container)serializable).add(this.sampleLabel);
                ((Container)serializable).add(this.sampleField);
                ((Container)serializable2).add((Component)serializable);
            }
            jComponent = new JPanel();
            jComponent.add(this.closeButton);
            box.add(jComponent);
            this.styleDialog.setContentPane(jPanel);
            this.styleDialog.pack();
            serializable2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (((Dimension)serializable2).width - this.styleDialog.getWidth()) / 2;
            serializable = this.getLocationOnScreen();
            int n2 = Math.max(0, ((Point)serializable).y - this.styleDialog.getHeight());
            this.styleDialog.setLocation(n, n2);
        }
        return this.styleDialog;
    }

    class MarkerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MarkerEditor() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JDialog jDialog = DataToolPropsTable.this.getStyleDialog();
            String string = DataToolPropsTable.this.getColumnName(n2);
            DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(string);
            DataToolPropsTable.this.markerDataset.setMarkerColor(workingDataset.getFillColor(), workingDataset.getEdgeColor());
            DataToolPropsTable.this.markerDataset.setMarkerSize(workingDataset.getMarkerSize());
            DataToolPropsTable.this.markerDataset.setMarkerShape(workingDataset.markerType);
            DataToolPropsTable.this.lineDataset.setLineColor(workingDataset.getLineColor());
            DataToolPropsTable.this.closeButton.setText(ToolsRes.getString("Button.OK"));
            jDialog.setName(null);
            DataToolPropsTable.this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
            DataToolPropsTable.this.sizeSpinner.setValue(new Integer(workingDataset.getMarkerSize()));
            DataToolPropsTable.this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
            DataToolPropsTable.this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post")};
            DataToolPropsTable.this.shapeSpinnerWidth = 50;
            int n3 = 0;
            while (n3 < DataToolPropsTable.this.shapeNames.length) {
                JLabel jLabel = new JLabel(DataToolPropsTable.this.shapeNames[n3]);
                DataToolPropsTable.this.shapeSpinnerWidth = Math.max(DataToolPropsTable.this.shapeSpinnerWidth, jLabel.getMinimumSize().width);
                ++n3;
            }
            DataToolPropsTable.this.shapeSpinnerWidth += 10;
            SpinnerListModel spinnerListModel = new SpinnerListModel(DataToolPropsTable.this.shapeNames){

                public Object getNextValue() {
                    Object object = super.getNextValue();
                    if (object == null && this.getList().size() > 0) {
                        object = this.getList().get(0);
                    }
                    return object;
                }

                public Object getPreviousValue() {
                    Object object = super.getPreviousValue();
                    int n = this.getList().size();
                    if (object == null && n > 0) {
                        object = this.getList().get(n - 1);
                    }
                    return object;
                }
            };
            DataToolPropsTable.this.shapeSpinner.setModel(spinnerListModel);
            int n4 = 0;
            while (n4 < DataToolPropsTable.this.shapeNumbers.length) {
                if (DataToolPropsTable.this.shapeNumbers[n4] == workingDataset.markerType) {
                    DataToolPropsTable.this.shapeSpinner.setValue(DataToolPropsTable.this.shapeNames[n4]);
                }
                ++n4;
            }
            DataToolPropsTable.this.markerVisCheckbox.setSelected(workingDataset.isMarkersVisible());
            DataToolPropsTable.this.lineVisCheckbox.setSelected(workingDataset.isConnected());
            jDialog.setName(string);
            String string2 = ToolsRes.getString("DataToolPropsTable.Dialog.Title");
            jDialog.setTitle(String.valueOf(string2) + " \"" + jDialog.getName() + "\"");
            jDialog.pack();
            Dimension dimension = jDialog.getSize();
            dimension.width += 6;
            jDialog.setSize(dimension);
            jDialog.setVisible(true);
            return null;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    class PropsRenderer
    implements TableCellRenderer {
        JPanel panel = new JPanel(new GridLayout());
        JCheckBox checkbox = new JCheckBox();
        DrawingPanel plot = new DrawingPanel();
        Dataset markerset = new Dataset();
        Dataset lineset = new Dataset();

        public PropsRenderer() {
            this.checkbox.setHorizontalAlignment(0);
            this.checkbox.setBackground(Color.white);
            this.plot.setBackground(Color.white);
            this.plot.setAntialiasShapeOn(true);
            this.markerset.append(0.0, 1.0);
            this.lineset.append(-1.0, 2.0);
            this.lineset.append(1.0, 0.0);
            this.lineset.setMarkerShape(0);
            this.lineset.setConnected(true);
            this.plot.addDrawable(this.markerset);
            this.plot.addDrawable(this.lineset);
            this.checkbox.setBackground(Color.white);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            int n3;
            this.panel.remove(this.checkbox);
            this.panel.remove(this.plot);
            int n4 = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            int n5 = n4 == 0 ? 1 : 0;
            int n6 = n3 = n4 < 2 ? 2 : 1;
            Color color = n2 == n5 ? DataToolTable.xAxisColor : (n2 == n3 ? DataToolTable.yAxisColor : Color.white);
            this.panel.setBackground(n != DataToolPropsTable.this.axisRow ? Color.white : color);
            if (object == null) {
                return this.panel;
            }
            if (object instanceof String && (serializable = DataToolPropsTable.this.getDefaultRenderer(String.class).getTableCellRendererComponent(DataToolPropsTable.this, object, false, false, 0, 0)) instanceof JLabel) {
                JLabel jLabel = (JLabel)serializable;
                jLabel.setHorizontalAlignment(0);
                jLabel.setBackground(color);
                return jLabel;
            }
            if (object instanceof DataToolTable.WorkingDataset) {
                serializable = (DataToolTable.WorkingDataset)object;
                this.markerset.setMarkerColor(((Dataset)serializable).getFillColor(), ((Dataset)serializable).getEdgeColor());
                this.markerset.setMarkerSize(((Dataset)serializable).getMarkerSize());
                this.markerset.setMarkerShape(((DataToolTable.WorkingDataset)serializable).markerType);
                this.lineset.setLineColor(((Dataset)serializable).getLineColor());
                Boolean bl3 = (Boolean)DataToolPropsTable.this.propsModel.getValueAt(DataToolPropsTable.this.markerRow, n2);
                Boolean bl4 = (Boolean)DataToolPropsTable.this.propsModel.getValueAt(DataToolPropsTable.this.lineRow, n2);
                this.plot.clear();
                if (bl3.booleanValue()) {
                    this.plot.addDrawable(this.markerset);
                }
                if (bl4.booleanValue()) {
                    this.plot.addDrawable(this.lineset);
                }
                this.panel.add(this.plot);
                this.panel.setToolTipText(ToolsRes.getString("DataToolPropsTable.Style.Tooltip"));
            } else {
                this.checkbox.setSelected((Boolean)object);
                this.checkbox.setEnabled(DataToolPropsTable.this.propsModel.isCellEditable(n, n2));
                this.panel.add(this.checkbox);
                if (n == DataToolPropsTable.this.markerRow) {
                    this.panel.setToolTipText(ToolsRes.getString("DataToolPropsTable.Markers.Tooltip"));
                } else {
                    this.panel.setToolTipText(ToolsRes.getString("DataToolPropsTable.Lines.Tooltip"));
                }
            }
            return this.panel;
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        PropsTableModel() {
        }

        public String getColumnName(int n) {
            return DataToolPropsTable.this.dataTable.getColumnName(n);
        }

        public int getRowCount() {
            return 4;
        }

        public int getColumnCount() {
            return DataToolPropsTable.this.dataTable.getColumnCount();
        }

        public Object getValueAt(int n, int n2) {
            int n3;
            int n4 = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            if (n2 == n4) {
                return DataToolPropsTable.this.getPropLabels()[n];
            }
            int n5 = n3 = n4 == 0 ? 1 : 0;
            if (n == DataToolPropsTable.this.axisRow) {
                if (n2 == n3) {
                    return ToolsRes.getString("DataToolPropsTable.Axis.Horizontal");
                }
                return ToolsRes.getString("DataToolPropsTable.Axis.Vertical");
            }
            if (n2 == n3) {
                return null;
            }
            String string = this.getColumnName(n2);
            DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(string);
            if (n == DataToolPropsTable.this.markerRow) {
                if (n2 == 0 || n2 == 1 && n4 == 0) {
                    return Boolean.FALSE;
                }
                return new Boolean(workingDataset.isMarkersVisible());
            }
            if (n == DataToolPropsTable.this.lineRow) {
                if (n2 == 0 || n2 == 1 && n4 == 0) {
                    return Boolean.FALSE;
                }
                return new Boolean(workingDataset.isConnected());
            }
            return DataToolPropsTable.this.dataTable.getWorkingData(string);
        }

        public boolean isCellEditable(int n, int n2) {
            int n3;
            if (n == DataToolPropsTable.this.axisRow) {
                return false;
            }
            int n4 = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
            int n5 = n3 = n4 == 0 ? 1 : 0;
            return n2 != n4 && (n2 != n3 || n == DataToolPropsTable.this.styleRow);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                String string = this.getColumnName(n2);
                DataToolTable.WorkingDataset workingDataset = DataToolPropsTable.this.dataTable.getWorkingData(string);
                if (n == DataToolPropsTable.this.markerRow) {
                    workingDataset.setMarkersVisible(bl);
                } else if (n == DataToolPropsTable.this.lineRow) {
                    workingDataset.setConnected(bl);
                }
                int n3 = DataToolPropsTable.this.dataTable.convertColumnIndexToView(0);
                int n4 = n3 == 0 ? 1 : 0;
                String string2 = this.getColumnName(n4);
                if (workingDataset.getXSource() == null || !workingDataset.getXSource().getYColumnName().equals(string2)) {
                    workingDataset.setXSource(DataToolPropsTable.this.dataTable.getWorkingData(string2).getYSource());
                }
                DataToolPropsTable.this.firePropertyChange("display", null, string);
            }
        }
    }
}

