/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.tools.ArrayTableModel;

public class ArrayTable
extends JTable {
    ArrayTableModel tableModel;
    ArrayIndexRenderer indexRenderer;

    public ArrayTable(int[] nArray) {
        this.tableModel = new ArrayTableModel(nArray);
        this.init();
    }

    public ArrayTable(int[][] nArray) {
        this.tableModel = new ArrayTableModel(nArray);
        this.init();
    }

    public ArrayTable(double[] dArray) {
        this.tableModel = new ArrayTableModel(dArray);
        this.init();
    }

    public ArrayTable(double[][] dArray) {
        this.tableModel = new ArrayTableModel(dArray);
        this.init();
    }

    public ArrayTable(String[] stringArray) {
        this.tableModel = new ArrayTableModel(stringArray);
        this.init();
    }

    public ArrayTable(String[][] stringArray) {
        this.tableModel = new ArrayTableModel(stringArray);
        this.init();
    }

    public ArrayTable(boolean[] blArray) {
        this.tableModel = new ArrayTableModel(blArray);
        this.init();
    }

    public ArrayTable(boolean[][] blArray) {
        this.tableModel = new ArrayTableModel(blArray);
        this.init();
    }

    protected void init() {
        TableColumn tableColumn;
        String string;
        this.setModel(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ArrayTable.this.firePropertyChange("cell", null, tableModelEvent);
            }
        });
        this.setColumnSelectionAllowed(true);
        this.indexRenderer = new ArrayIndexRenderer();
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.indexRenderer);
        this.setAutoResizeMode(0);
        this.setGridColor(Color.BLACK);
        int n = 24;
        if (this.getColumnCount() > 0) {
            string = this.getColumnName(0);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(2 * n);
            tableColumn.setWidth(n);
        }
        n = 60;
        int n2 = 1;
        int n3 = this.getColumnCount();
        while (n2 < n3) {
            string = this.getColumnName(n2);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(3 * n);
            tableColumn.setWidth(n);
            ++n2;
        }
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        final Action action2 = this.getActionMap().get(inputMap.get(keyStroke));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                action2.actionPerformed(actionEvent);
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getRowCount();
                int n2 = jTable.getSelectedRow();
                int n3 = jTable.getSelectedColumn();
                while (!jTable.isCellEditable(n2, n3)) {
                    if (n3 == 0) {
                        n3 = 1;
                    } else {
                        ++n2;
                    }
                    if (n2 == n) {
                        n2 = 0;
                    }
                    if (n2 == jTable.getSelectedRow() && n3 == jTable.getSelectedColumn()) break;
                }
                jTable.changeSelection(n2, n3, false, false);
            }
        };
        this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getSelectedRow();
                int n2 = jTable.getSelectedColumn();
                jTable.editCellAt(n, n2, actionEvent);
                Component component = jTable.getEditorComponent();
                if (component instanceof JTextField) {
                    JTextField jTextField = (JTextField)component;
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
    }

    public void refreshTable() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                ArrayTable.this.tableChanged(new TableModelEvent(ArrayTable.this.tableModel, -1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setEditable(boolean bl) {
        this.tableModel.setEditable(bl);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return this.indexRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    static class ArrayIndexRenderer
    extends JLabel
    implements TableCellRenderer {
        public ArrayIndexRenderer() {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(Color.LIGHT_GRAY);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(0);
            }
            this.setText(object.toString());
            this.setPreferredSize(new Dimension(20, 18));
            return this;
        }
    }
}

