/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Butcher5;
import org.opensourcephysics.numerics.ODE;

public class Adams5
extends Butcher5 {
    private double[] fn;
    private double[] fn1;
    private double[] fn2;
    private double[] fn3;
    private double[] fn4;
    private double[] temp_state;
    private double[] temp_rate;
    private int counter = 0;

    public Adams5(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.fn = new double[this.numEqn];
        this.fn1 = new double[this.numEqn];
        this.fn2 = new double[this.numEqn];
        this.fn3 = new double[this.numEqn];
        this.fn4 = new double[this.numEqn];
        this.temp_state = new double[this.numEqn];
        this.temp_rate = new double[this.numEqn];
        this.counter = 0;
    }

    public double step() {
        double[] dArray = this.ode.getState();
        if (dArray == null) {
            return this.stepSize;
        }
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(dArray, this.fn);
        if (this.counter < 4) {
            this.stepSize = super.step();
            ++this.counter;
        } else {
            int n = 0;
            while (n < this.numEqn) {
                this.temp_state[n] = dArray[n] + this.stepSize * (1901.0 * this.fn[n] - 2774.0 * this.fn1[n] + 2616.0 * this.fn2[n] - 1274.0 * this.fn3[n] + 251.0 * this.fn4[n]) / 720.0;
                ++n;
            }
            this.ode.getRate(this.temp_state, this.temp_rate);
            n = 0;
            while (n < this.numEqn) {
                dArray[n] = dArray[n] + this.stepSize * (251.0 * this.temp_rate[n] + 646.0 * this.fn[n] - 264.0 * this.fn1[n] + 106.0 * this.fn2[n] - 19.0 * this.fn3[n]) / 720.0;
                ++n;
            }
        }
        System.arraycopy(this.fn3, 0, this.fn4, 0, this.numEqn);
        System.arraycopy(this.fn2, 0, this.fn3, 0, this.numEqn);
        System.arraycopy(this.fn1, 0, this.fn2, 0, this.numEqn);
        System.arraycopy(this.fn, 0, this.fn1, 0, this.numEqn);
        return this.stepSize;
    }
}

