/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing.basic;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing.basic.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Element
implements org.opensourcephysics.drawing.core.Group {
    private ArrayList<org.opensourcephysics.drawing.core.Element> elementList = new ArrayList();

    @Override
    public void addElement(org.opensourcephysics.drawing.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to group (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
        }
        ((Element)element).setGroup(this);
    }

    public void addElements(Collection<org.opensourcephysics.drawing.core.Element> collection) {
        if (collection != null) {
            for (org.opensourcephysics.drawing.core.Element element : collection) {
                this.addElement(element);
            }
        }
    }

    @Override
    public void removeElement(org.opensourcephysics.drawing.core.Element element) {
        this.elementList.remove(element);
        ((Element)element).setGroup(null);
    }

    @Override
    public void removeAllElements() {
        for (org.opensourcephysics.drawing.core.Element element : this.elementList) {
            ((Element)element).setGroup(null);
        }
        this.elementList.clear();
    }

    @Override
    public synchronized List<org.opensourcephysics.drawing.core.Element> getElements() {
        return (List)this.elementList.clone();
    }

    private synchronized List<Element> getTheElements() {
        return (List)this.elementList.clone();
    }

    @Override
    public org.opensourcephysics.drawing.core.Element getElement(int n) {
        try {
            return this.elementList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        for (Element element : this.getTheElements()) {
            element.draw(drawingPanel, graphics);
        }
    }

    @Override
    public void setNeedToProject(boolean bl) {
        for (Element element : this.getTheElements()) {
            element.setNeedToProject(bl);
        }
    }

    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        dArray[1] = Double.POSITIVE_INFINITY;
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray2[1] = Double.NEGATIVE_INFINITY;
        dArray2[0] = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        for (Element element : this.getTheElements()) {
            element.getExtrema(dArray3, dArray4);
            int n = 0;
            while (n < 2) {
                if (dArray[n] > dArray3[n]) {
                    dArray[n] = dArray3[n];
                }
                if (dArray[n] > dArray4[n]) {
                    dArray[n] = dArray4[n];
                }
                if (dArray2[n] < dArray3[n]) {
                    dArray2[n] = dArray3[n];
                }
                if (dArray2[n] < dArray4[n]) {
                    dArray2[n] = dArray4[n];
                }
                ++n;
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        for (Element element : this.getTheElements()) {
            Interactive interactive = element.findInteractive(drawingPanel, n, n2);
            if (interactive == null) continue;
            return interactive;
        }
        return null;
    }
}

