/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing.basic;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing.basic.Group;
import org.opensourcephysics.drawing.basic.InteractionTarget;
import org.opensourcephysics.drawing.basic.Style;
import org.opensourcephysics.drawing.core.interaction.InteractionEvent;
import org.opensourcephysics.drawing.core.interaction.InteractionListener;

public abstract class Element
implements org.opensourcephysics.drawing.core.Element,
Interactive {
    public static final int DIMENSION = 2;
    protected static final double[] STD_ORIGIN = new double[]{0.0, 0.0};
    protected static final double[] STD_END = new double[]{1.0, 1.0};
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private String name = "unnamed";
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    private AffineTransform transformation = new AffineTransform();
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    private org.opensourcephysics.drawing.core.DrawingPanel panel;
    private double[] minima = new double[2];
    private double[] maxima = new double[2];
    private AffineTransform totalTransformation = new AffineTransform();
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    public final void setDataObject(Object object) {
        this.dataObject = object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public final void setPanel(org.opensourcephysics.drawing.core.DrawingPanel drawingPanel) {
        this.panel = drawingPanel;
        this.needsToProject = true;
    }

    public final org.opensourcephysics.drawing.core.DrawingPanel getPanel() {
        Element element = this;
        while (element.group != null) {
            element = element.group;
        }
        return element.panel;
    }

    /*
     * Unable to fully structure code
     */
    protected final Group getTopGroup() {
        var1_1 = this.group;
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.group;
lbl5:
            // 2 sources

            ** while (var1_1.group != null)
        }
lbl6:
        // 1 sources

        return var1_1;
    }

    protected final void setGroup(Group group) {
        this.group = group;
        this.elementChanged = true;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setX(double d) {
        this.x = d;
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x;
    }

    public final void setY(double d) {
        this.y = d;
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y;
    }

    public final void setZ(double d) {
    }

    public final double getZ() {
        return 0.0;
    }

    public final void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.elementChanged = true;
    }

    public final void setPosition(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.elementChanged = true;
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y};
    }

    public void setSizeX(double d) {
        this.sizeX = d;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double d) {
        this.sizeY = d;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public final void setSizeZ(double d) {
    }

    public final double getSizeZ() {
        return 0.0;
    }

    public void setSizeXY(double d, double d2) {
        this.sizeX = d;
        this.sizeY = d2;
        this.elementChanged = true;
    }

    public void setSize(double[] dArray) {
        this.sizeX = dArray[0];
        this.sizeY = dArray[1];
        this.elementChanged = true;
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY};
    }

    protected void getExtrema(double[] dArray, double[] dArray2) {
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray2[1] = 1.0;
        dArray2[0] = 1.0;
        this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
        this.getTotalTransform().transform(dArray2, 0, dArray2, 0, 1);
    }

    protected final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY);
    }

    public final double getXMin() {
        if (this.hasChanged()) {
            this.getExtrema(this.minima, this.maxima);
        }
        return this.minima[0];
    }

    public final double getXMax() {
        if (this.hasChanged()) {
            this.getExtrema(this.minima, this.maxima);
        }
        return this.maxima[0];
    }

    public final double getYMin() {
        if (this.hasChanged()) {
            this.getExtrema(this.minima, this.maxima);
        }
        return this.minima[1];
    }

    public final double getYMax() {
        if (this.hasChanged()) {
            this.getExtrema(this.minima, this.maxima);
        }
        return this.maxima[1];
    }

    public final boolean isMeasured() {
        return true;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group group = this.group;
        while (group != null) {
            if (!group.visible) {
                return false;
            }
            group = group.group;
        }
        return this.visible;
    }

    public final org.opensourcephysics.drawing.core.Style getStyle() {
        return this.style;
    }

    final Style getRealStyle() {
        return this.style;
    }

    protected void styleChanged(int n) {
    }

    public final boolean hasChanged() {
        Element element = this;
        while (element != null) {
            if (element.elementChanged) {
                return true;
            }
            element = element.group;
        }
        return false;
    }

    protected final void setElementChanged() {
        this.elementChanged = true;
    }

    public final void setTransformation(Object object) throws ClassCastException {
        if (object == null) {
            this.transformation.setToIdentity();
        } else {
            this.transformation.setTransform((AffineTransform)object);
        }
        this.elementChanged = true;
    }

    public final Object getTransformation() {
        return new AffineTransform(this.transformation);
    }

    protected final AffineTransform getTotalTransform() {
        if (this.elementChanged) {
            this.totalTransformation = AffineTransform.getTranslateInstance(this.x, this.y);
            this.totalTransformation.concatenate(this.transformation);
            this.totalTransformation.scale(this.sizeX, this.sizeY);
            this.elementChanged = false;
            this.setNeedToProject(true);
        }
        if (this.group == null) {
            return this.totalTransformation;
        }
        AffineTransform affineTransform = new AffineTransform(this.group.getTotalTransform());
        affineTransform.concatenate(this.totalTransformation);
        return affineTransform;
    }

    protected final AffineTransform getPixelTransform(DrawingPanel drawingPanel) {
        AffineTransform affineTransform = new AffineTransform(drawingPanel.getPixelTransform());
        affineTransform.concatenate(this.getTotalTransform());
        return affineTransform;
    }

    public final double[] toSpaceFrame(double[] dArray) {
        this.transformation.transform(dArray, 0, dArray, 0, 1);
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.sizeX;
            dArray[1] = dArray[1] * group.sizeY;
            group.transformation.transform(dArray, 0, dArray, 0, 1);
            dArray[0] = dArray[0] + group.x;
            dArray[1] = dArray[1] + group.y;
            group = group.group;
        }
        return dArray;
    }

    public final double[] toBodyFrame(double[] dArray) throws NoninvertibleTransformException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            element.transformation.inverseTransform(dArray, 0, dArray, 0, 1);
            if (element != this) {
                if (element.sizeX != 0.0) {
                    dArray[0] = dArray[0] / element.sizeX;
                }
                if (element.sizeY != 0.0) {
                    dArray[1] = dArray[1] / element.sizeY;
                }
            }
            --n;
        }
        return dArray;
    }

    public abstract void draw(DrawingPanel var1, Graphics var2);

    public void setNeedToProject(boolean bl) {
        this.needsToProject = bl;
    }

    protected final boolean needsToProject() {
        return this.needsToProject;
    }

    public void setEnabled(boolean bl) {
        this.targetPosition.setEnabled(bl);
        this.targetSize.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    public final org.opensourcephysics.drawing.core.interaction.InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public final void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public final void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    public final void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }

    public abstract Interactive findInteractive(DrawingPanel var1, int var2, int var3);

    protected final double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            return new double[]{this.sizeX != 0.0 ? 1 : 0, this.sizeY != 0.0 ? 1 : 0};
        }
        return null;
    }

    private final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
        }
        return dArray;
    }

    public final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.getTopGroup();
        switch (interactionTarget.getType()) {
            case 0: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXY(group.x + dArray[0] - dArray2[0], group.y + dArray[1] - dArray2[1]);
                    break;
                }
                double[] dArray3 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.sizeX;
                dArray4[1] = dArray4[1] * this.sizeY;
                this.transformation.transform(dArray4, 0, dArray4, 0, 1);
                this.setXY(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1]);
                break;
            }
            case 1: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray5 = (double[])dArray.clone();
                    dArray5[0] = dArray5[0] - group.x;
                    dArray5[1] = dArray5[1] - group.y;
                    try {
                        group.transformation.inverseTransform(dArray5, 0, dArray5, 0, 1);
                    }
                    catch (Exception exception) {}
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.x;
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.y;
                    group.setSize(dArray5);
                    break;
                }
                double[] dArray7 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.x;
                dArray7[1] = dArray7[1] - this.y;
                try {
                    this.transformation.inverseTransform(dArray7, 0, dArray7, 0, 1);
                }
                catch (Exception exception) {}
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                if (dArray8[0] != 0.0) {
                    dArray7[0] = dArray7[0] / dArray8[0];
                }
                if (dArray8[1] != 0.0) {
                    dArray7[1] = dArray7[1] / dArray8[1];
                }
                this.setSize(dArray7);
            }
        }
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            try {
                element.transformation.inverseTransform(dArray, 0, dArray, 0, 1);
            }
            catch (Exception exception) {}
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] / element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] / element.sizeY;
            }
            --n;
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] * element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] * element.sizeY;
            }
            if (element.transformation != null) {
                element.transformation.transform(dArray, 0, dArray, 0, 1);
            }
            dArray[0] = dArray[0] + this.x;
            dArray[1] = dArray[1] + this.y;
        } while ((element = element.group) != null && element.group != null);
    }
}

