/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementPoints
extends Element
implements org.opensourcephysics.display3d.core.ElementPoints {
    private double[][] coordinates = new double[0][0];
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] transformedCoordinates = new double[0][0];
    private double[] origin = new double[3];
    private double[] pixel = new double[3];
    private double[] originpixel = new double[3];
    protected Object3D[] pointObjects = null;

    public void setData(double[][] dArray) {
        int n;
        int n2;
        if (this.coordinates.length != dArray.length) {
            n2 = dArray.length;
            this.coordinates = new double[n2][3];
            this.transformedCoordinates = new double[n2][3];
            this.aPoints = new int[n2];
            this.bPoints = new int[n2];
            this.pointObjects = new Object3D[n2];
            n = 0;
            while (n < n2) {
                this.pointObjects[n] = new Object3D(this, n);
                ++n;
            }
        }
        n2 = 0;
        n = dArray.length;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, this.coordinates[n2], 0, 3);
            ++n2;
        }
        this.setElementChanged(true);
    }

    public double[][] getData() {
        double[][] dArray = new double[this.coordinates.length][3];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray[n], 0, 3);
            ++n;
        }
        return dArray;
    }

    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray3, 0, 3);
            this.sizeAndToSpaceFrame(dArray3);
            d = Math.min(d, dArray3[0]);
            d2 = Math.max(d2, dArray3[0]);
            d3 = Math.min(d3, dArray3[1]);
            d4 = Math.max(d4, dArray3[1]);
            d5 = Math.min(d5, dArray3[2]);
            d6 = Math.max(d6, dArray3[2]);
            ++n;
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        return this.pointObjects;
    }

    void draw(Graphics2D graphics2D, int n) {
        Color color = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.pointObjects[n].getDistance());
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(color);
        graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n], this.bPoints[n]);
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n], this.bPoints[n]);
            ++n;
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.originpixel[0] - (double)n) < 5.0 && Math.abs(this.originpixel[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    void transformAndProject() {
        this.origin[2] = 0.0;
        this.origin[1] = 0.0;
        this.origin[0] = 0.0;
        this.sizeAndToSpaceFrame(this.origin);
        this.getPanel().project(this.origin, this.originpixel);
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, this.transformedCoordinates[n], 0, 3);
            this.sizeAndToSpaceFrame(this.transformedCoordinates[n]);
            this.getPanel().project(this.transformedCoordinates[n], this.pixel);
            this.aPoints[n] = (int)this.pixel[0];
            this.bPoints[n] = (int)this.pixel[1];
            this.pointObjects[n].setDistance(this.pixel[2]);
            ++n;
        }
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    void project() {
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            this.getPanel().project(this.transformedCoordinates[n], this.pixel);
            this.aPoints[n] = (int)this.pixel[0];
            this.bPoints[n] = (int)this.pixel[1];
            this.pointObjects[n].setDistance(this.pixel[2]);
            ++n;
        }
        this.setNeedToProject(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends Element.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementPoints();
        }
    }
}

