/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.ElementImage;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element
implements org.opensourcephysics.display3d.core.ElementImage {
    private String imageFile = null;
    private double angle = 0.0;
    private Resource resource = null;
    private Image image = null;
    private double[] coordinates = new double[3];
    private double[] size = new double[3];
    private double[] pixel = new double[3];
    private double[] pixelSize = new double[2];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();

    public void setImageFile(String string) {
        this.imageFile = string;
        if (string != null) {
            this.resource = ResourceLoader.getResource(string);
            if (this.resource != null) {
                this.image = this.resource.getImage();
            }
        }
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImage(Image image) {
        this.imageFile = null;
        this.image = image;
    }

    public void setRotationAngle(double d) {
        this.angle = d;
    }

    public double getRotationAngle() {
        return this.angle;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        return this.objects;
    }

    void draw(Graphics2D graphics2D, int n) {
        this.drawIt(graphics2D);
    }

    void drawQuickly(Graphics2D graphics2D) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawIt(graphics2D);
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.targetPosition.isEnabled() && Math.abs(this.pixel[0] - (double)n) < 5.0 && Math.abs(this.pixel[1] - (double)n2) < 5.0) {
            return this.targetPosition;
        }
        return null;
    }

    private void projectPoints() {
        this.coordinates[2] = 0.0;
        this.coordinates[1] = 0.0;
        this.coordinates[0] = 0.0;
        this.sizeAndToSpaceFrame(this.coordinates);
        this.getPanel().project(this.coordinates, this.pixel);
        this.objects[0].setDistance(this.pixel[2]);
        this.size[0] = this.getSizeX();
        this.size[1] = this.getSizeY();
        this.size[2] = this.getSizeZ();
        this.getPanel().projectSize(this.coordinates, this.size, this.pixelSize);
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    private void drawIt(Graphics2D graphics2D) {
        if (this.image == null) {
            return;
        }
        if (this.angle != 0.0) {
            AffineTransform affineTransform = graphics2D.getTransform();
            this.transform.setTransform(affineTransform);
            this.transform.rotate(-this.angle, this.pixel[0], this.pixel[1]);
            graphics2D.setTransform(this.transform);
            graphics2D.drawImage(this.image, (int)(this.pixel[0] - this.pixelSize[0] / 2.0), (int)(this.pixel[1] - this.pixelSize[1] / 2.0), (int)this.pixelSize[0], (int)this.pixelSize[1], null);
            graphics2D.setTransform(affineTransform);
        } else {
            graphics2D.drawImage(this.image, (int)(this.pixel[0] - this.pixelSize[0] / 2.0), (int)(this.pixel[1] - this.pixelSize[1] / 2.0), (int)this.pixelSize[0], (int)this.pixelSize[1], null);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementImage.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementImage();
        }
    }
}

