/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.simple3d.Group;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Style;
import org.opensourcephysics.numerics.Transformation;

public abstract class Element
implements org.opensourcephysics.display3d.core.Element {
    static final int SENSIBILITY = 5;
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private double sizeZ = 1.0;
    private String name = "";
    private Transformation transformation = null;
    private Style style = new Style(this);
    private Group group = null;
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    private DrawingPanel3D panel;
    private ArrayList listeners = new ArrayList();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    final DrawingPanel3D getPanel() {
        Element element = this;
        while (element.group != null) {
            element = element.group;
        }
        return element.panel;
    }

    void setPanel(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        this.elementChanged = true;
    }

    final Group getGroup() {
        return this.group;
    }

    /*
     * Unable to fully structure code
     */
    final Group getTopGroup() {
        var1_1 = this.group;
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getGroup();
lbl5:
            // 2 sources

            ** while (var1_1.getGroup() != null)
        }
lbl6:
        // 1 sources

        return var1_1;
    }

    void setGroup(Group group) {
        this.group = group;
        this.elementChanged = true;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public void setX(double d) {
        this.x = d;
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = d;
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y;
    }

    public void setZ(double d) {
        this.z = d;
        this.elementChanged = true;
    }

    public final double getZ() {
        return this.z;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.elementChanged = true;
    }

    public void setXYZ(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        if (dArray.length > 2) {
            this.z = dArray[2];
        }
        this.elementChanged = true;
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = -0.5;
        dArray2[0] = 0.5;
        dArray[1] = -0.5;
        dArray2[1] = 0.5;
        dArray[2] = -0.5;
        dArray2[2] = 0.5;
        this.sizeAndToSpaceFrame(dArray);
        this.sizeAndToSpaceFrame(dArray2);
    }

    public void setSizeX(double d) {
        this.sizeX = d;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double d) {
        this.sizeY = d;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeZ(double d) {
        this.sizeZ = d;
        this.elementChanged = true;
    }

    public final double getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        this.sizeX = d;
        this.sizeY = d2;
        this.sizeZ = d3;
        this.elementChanged = true;
    }

    public void setSizeXYZ(double[] dArray) {
        this.sizeX = dArray[0];
        this.sizeY = dArray[1];
        if (dArray.length > 2) {
            this.sizeZ = dArray[2];
        }
        this.elementChanged = true;
    }

    final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ);
    }

    final boolean hasChanged() {
        Element element = this;
        while (element != null) {
            if (element.elementChanged) {
                return true;
            }
            element = element.group;
        }
        return false;
    }

    boolean getElementChanged() {
        return this.elementChanged;
    }

    final void setElementChanged(boolean bl) {
        this.elementChanged = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group group = this.group;
        while (group != null) {
            if (!group.visible) {
                return false;
            }
            group = group.group;
        }
        return this.visible;
    }

    public final org.opensourcephysics.display3d.core.Style getStyle() {
        return this.style;
    }

    final Style getRealStyle() {
        return this.style;
    }

    final void styleChanged(int n) {
        this.elementChanged = true;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return null;
        }
        return (Transformation)this.transformation.clone();
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.elementChanged = true;
    }

    public double[] toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.sizeX;
            dArray[1] = dArray[1] * group.sizeY;
            dArray[2] = dArray[2] * group.sizeZ;
            if (group.transformation != null) {
                group.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + group.x;
            dArray[1] = dArray[1] + group.y;
            dArray[2] = dArray[2] + group.z;
            group = group.group;
        }
        return dArray;
    }

    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element != this) {
                if (element.sizeX != 0.0) {
                    dArray[0] = dArray[0] / element.sizeX;
                }
                if (element.sizeY != 0.0) {
                    dArray[1] = dArray[1] / element.sizeY;
                }
                if (element.sizeZ != 0.0) {
                    dArray[2] = dArray[2] / element.sizeZ;
                }
            }
            --n;
        }
        return dArray;
    }

    final void sizeAndToSpaceFrame(double[] dArray) {
        dArray[0] = dArray[0] * this.sizeX;
        dArray[1] = dArray[1] * this.sizeY;
        dArray[2] = dArray[2] * this.sizeZ;
        this.toSpaceFrame(dArray);
    }

    abstract Object3D[] getObjects3D();

    abstract void draw(Graphics2D var1, int var2);

    abstract void drawQuickly(Graphics2D var1);

    void setNeedToProject(boolean bl) {
        this.needsToProject = bl;
    }

    final boolean needsToProject() {
        return this.needsToProject;
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    final void invokeActions(InteractionEvent interactionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((InteractionListener)iterator.next()).interactionPerformed(interactionEvent);
        }
    }

    protected InteractionTarget getTargetHit(int n, int n2) {
        return null;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            double[] dArray = new double[]{1.0, 1.0, 1.0};
            if (this.sizeX == 0.0) {
                dArray[0] = 0.0;
            }
            if (this.sizeY == 0.0) {
                dArray[1] = 0.0;
            }
            if (this.sizeZ == 0.0) {
                dArray[2] = 0.0;
            }
            return dArray;
        }
        return null;
    }

    final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.sizeAndToSpaceFrame(dArray);
        }
        return dArray;
    }

    final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.getTopGroup();
        switch (interactionTarget.getType()) {
            case 0: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXYZ(group.x + dArray[0] - dArray2[0], group.y + dArray[1] - dArray2[1], group.z + dArray[2] - dArray2[2]);
                    break;
                }
                double[] dArray3 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.sizeX;
                dArray4[1] = dArray4[1] * this.sizeY;
                dArray4[2] = dArray4[2] * this.sizeZ;
                if (this.transformation != null) {
                    this.transformation.direct(dArray4);
                }
                this.setXYZ(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
                break;
            }
            case 1: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray5 = new double[]{dArray[0], dArray[1], dArray[2]};
                    dArray5[0] = dArray5[0] - group.x;
                    dArray5[1] = dArray5[1] - group.y;
                    dArray5[2] = dArray5[2] - group.z;
                    if (group.transformation != null) {
                        group.transformation.inverse(dArray5);
                    }
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.sizeX;
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.sizeY;
                    dArray5[2] = dArray6[2] != 0.0 ? dArray5[2] / dArray6[2] : group.sizeZ;
                    group.setSizeXYZ(dArray5);
                    break;
                }
                double[] dArray7 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.x;
                dArray7[1] = dArray7[1] - this.y;
                dArray7[2] = dArray7[2] - this.z;
                if (this.transformation != null) {
                    this.transformation.inverse(dArray7);
                }
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                int n = 0;
                while (n < 3) {
                    if (dArray8[n] != 0.0) {
                        int n2 = n;
                        dArray7[n2] = dArray7[n2] / dArray8[n];
                    }
                    ++n;
                }
                this.setSizeXYZ(dArray7);
            }
        }
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.x;
            dArray[1] = dArray[1] - element.y;
            dArray[2] = dArray[2] - element.z;
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] / element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] / element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] / element.sizeZ;
            }
            --n;
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.sizeX != 0.0) {
                dArray[0] = dArray[0] * element.sizeX;
            }
            if (element.sizeY != 0.0) {
                dArray[1] = dArray[1] * element.sizeY;
            }
            if (element.sizeZ != 0.0) {
                dArray[2] = dArray[2] * element.sizeZ;
            }
            if (element.transformation != null) {
                element.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + element.x;
            dArray[1] = dArray[1] + element.y;
            dArray[2] = dArray[2] + element.z;
        } while ((element = element.group) != null && element.group != null);
    }

    public void loadUnmutableObjects(XMLControl xMLControl) {
        this.style = (Style)xMLControl.getObject("style");
        this.style.setElement(this);
        this.elementChanged = true;
    }
}

