/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.display3d.simple3d.Resolution;
import org.opensourcephysics.display3d.simple3d.utils.VectorAlgebra;

public class ElementSpring
extends Element
implements org.opensourcephysics.display3d.core.ElementSpring {
    private double radius = 0.1;
    private int lastLoops;
    private int lastPPL;
    private double[][] points = new double[0][3];

    public ElementSpring() {
        this.getStyle().setResolution(new Resolution(8, 15, 1));
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
        this.getStyle().setLineColor(Color.black);
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isElementChanged()) {
            this.computePoints();
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glDisable(2896);
        GLTools.setColor(gL, this.getStyle().getLineColor());
        gL.glLineWidth(this.getStyle().getLineWidth());
        gL.glPushMatrix();
        this.transform(gL);
        this.preLinesGL(gLAutoDrawable);
        gL.glBegin(3);
        int n = 0;
        while (n < this.points.length) {
            gL.glVertex3dv(this.points[n], 0);
            ++n;
        }
        gL.glEnd();
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    public void setRadius(double d) {
        this.radius = d;
        this.setElementChanged(true);
    }

    public double getRadius() {
        return this.radius;
    }

    private void computePoints() {
        int n;
        int n2 = 0;
        int n3 = 0;
        org.opensourcephysics.display3d.core.Resolution resolution = this.getStyle().getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                default: 
            }
            n2 = Math.max(resolution.getN1(), 0);
            n3 = Math.max(resolution.getN2(), 1);
        }
        if ((n = n2 * n3 + 3) + 1 != this.points.length) {
            this.points = new double[n + 1][3];
        }
        double[] dArray = new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()};
        double[] dArray2 = VectorAlgebra.normalTo(dArray);
        double[] dArray3 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(dArray, dArray2));
        double d = Math.PI * 2 / (double)n3;
        int n4 = n3 / 2;
        int n5 = 0;
        while (n5 <= n) {
            int n6 = n5 < n4 ? 0 : (n5 < n3 ? n5 - n4 : (n5 > n - n4 ? 0 : (n5 > n - n3 ? n - n5 - n4 : n4)));
            double d2 = (double)n5 * d;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            this.points[n5][0] = (double)n5 * this.getSizeX() / (double)n + (double)n6 * this.radius * (d3 * dArray2[0] + d4 * dArray3[0]) / (double)n4;
            this.points[n5][1] = (double)n5 * this.getSizeY() / (double)n + (double)n6 * this.radius * (d3 * dArray2[1] + d4 * dArray3[1]) / (double)n4;
            this.points[n5][2] = (double)n5 * this.getSizeZ() / (double)n + (double)n6 * this.radius * (d3 * dArray2[2] + d4 * dArray3[2]) / (double)n4;
            ++n5;
        }
    }

    public int getBlendPriority() {
        return 2;
    }
}

