/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.utils.GLTools;

public class ElementPolygon
extends Element
implements org.opensourcephysics.display3d.core.ElementPolygon {
    private boolean closed = true;
    private double[][] data;

    void draw(GLAutoDrawable gLAutoDrawable) {
        int n;
        if (!this.isVisible()) {
            return;
        }
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gL);
        if (this.getStyle().isDrawingFill() && this.closed) {
            GLTools.setColor(gL, this.getStyle().getFillColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getFillColor().getComponents(null), 0);
            this.preFillGL(gLAutoDrawable);
            gL.glBegin(9);
            n = 0;
            while (n < this.data.length) {
                gL.glVertex3dv(this.data[n], 0);
                ++n;
            }
            gL.glEnd();
        }
        if (this.getStyle().isDrawingLines()) {
            GLTools.setColor(gL, this.getStyle().getLineColor());
            gL.glEnable(2896);
            gL.glMaterialfv(1032, 5634, this.getStyle().getLineColor().getComponents(null), 0);
            gL.glLineWidth(this.getStyle().getLineWidth());
            this.preLinesGL(gLAutoDrawable);
            gL.glBegin(this.closed ? 2 : 3);
            n = 0;
            while (n < this.data.length) {
                gL.glVertex3dv(this.data[n], 0);
                ++n;
            }
            gL.glEnd();
        }
        gL.glPopMatrix();
        this.setElementChanged(false);
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public double[][] getData() {
        return this.data;
    }

    public int getBlendPriority() {
        if (this.getStyle().isDrawingLines()) {
            return 1;
        }
        return 0;
    }
}

