/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.jogl.DrawingPanel3D;
import org.opensourcephysics.display3d.jogl.Group;
import org.opensourcephysics.display3d.jogl.InteractionTarget;
import org.opensourcephysics.display3d.jogl.Style;
import org.opensourcephysics.display3d.jogl.utils.Rotation;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.numerics.Vec3D;

public abstract class Element
implements org.opensourcephysics.display3d.core.Element {
    private Vec3D position = new Vec3D();
    private Vec3D size = new Vec3D();
    private Rotation rotation = new Rotation();
    private String name;
    private boolean visible = true;
    private Group group;
    protected org.opensourcephysics.display3d.core.Style style = new Style(this);
    private Transformation transformation;
    private DrawingPanel3D panel;
    private ArrayList listeners = new ArrayList();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);
    private boolean elementChanged;

    abstract void draw(GLAutoDrawable var1);

    void drawQuickly(GLAutoDrawable gLAutoDrawable) {
        boolean bl = this.getStyle().isDrawingFill();
        boolean bl2 = this.getStyle().isDrawingLines();
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
        this.draw(gLAutoDrawable);
        this.getStyle().setDrawingFill(bl);
        this.getStyle().setDrawingLines(bl2);
    }

    public double getX() {
        return this.position.x;
    }

    public double getY() {
        return this.position.y;
    }

    public double getZ() {
        return this.position.z;
    }

    public void setX(double d) {
        this.position.x = d;
        this.setElementChanged(true);
    }

    public void setY(double d) {
        this.position.y = d;
        this.setElementChanged(true);
    }

    public void setZ(double d) {
        this.position.z = d;
        this.setElementChanged(true);
    }

    public void setXYZ(double[] dArray) {
        this.position.x = dArray[0];
        this.position.y = dArray[1];
        if (dArray.length >= 3) {
            this.position.z = dArray[2];
        }
        this.setElementChanged(true);
    }

    public void setXYZ(double d, double d2, double d3) {
        this.position.x = d;
        this.position.y = d2;
        this.position.z = d3;
        this.setElementChanged(true);
    }

    public void setPosition(Vec3D vec3D) {
        this.position = vec3D;
    }

    public Vec3D getPosition() {
        return this.position;
    }

    public double getSizeX() {
        return this.size.x;
    }

    public double getSizeY() {
        return this.size.y;
    }

    public double getSizeZ() {
        return this.size.z;
    }

    public void setSizeX(double d) {
        this.size.x = d;
        this.setElementChanged(true);
    }

    public void setSizeY(double d) {
        this.size.y = d;
        this.setElementChanged(true);
    }

    public void setSizeZ(double d) {
        this.size.z = d;
        this.setElementChanged(true);
    }

    public void setSizeXYZ(double[] dArray) {
        this.size.x = dArray[0];
        this.size.y = dArray[1];
        if (dArray.length >= 3) {
            this.size.z = dArray[2];
        }
        this.setElementChanged(true);
    }

    public void setSizeXYZ(double d, double d2, double d3) {
        this.size.x = d;
        this.size.y = d2;
        this.size.z = d3;
        this.setElementChanged(true);
    }

    public Vec3D getSize() {
        return this.size;
    }

    void getExtrema(double[] dArray, double[] dArray2) {
        dArray[0] = this.getX() - this.getSizeX() / 2.0;
        dArray2[0] = dArray[0] + this.getSizeX();
        dArray[1] = this.getY() - this.getSizeY() / 2.0;
        dArray2[1] = dArray[1] + this.getSizeY();
        dArray[2] = this.getZ() - this.getSizeZ() / 2.0;
        dArray2[2] = dArray[2] + this.getSizeZ();
    }

    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        switch (n) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    /*
     * Unable to fully structure code
     */
    final Group getTopGroup() {
        var1_1 = this.group;
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getGroup();
lbl5:
            // 2 sources

            ** while (var1_1.getGroup() != null)
        }
lbl6:
        // 1 sources

        return var1_1;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget interactionTarget) {
        if (interactionTarget == this.targetPosition) {
            return new double[]{0.0, 0.0, 0.0};
        }
        if (interactionTarget == this.targetSize) {
            double[] dArray = new double[]{1.0, 1.0, 1.0};
            if (this.getSizeX() == 0.0) {
                dArray[0] = 0.0;
            }
            if (this.getSizeY() == 0.0) {
                dArray[1] = 0.0;
            }
            if (this.getSizeZ() == 0.0) {
                dArray[2] = 0.0;
            }
            return dArray;
        }
        return null;
    }

    final double[] getHotSpot(InteractionTarget interactionTarget) {
        double[] dArray = this.getHotSpotBodyCoordinates(interactionTarget);
        if (dArray != null) {
            this.sizeAndToSpaceFrame(dArray);
        }
        return dArray;
    }

    final void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        Group group = this.getTopGroup();
        switch (interactionTarget.getType()) {
            case 0: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray2 = this.getHotSpot(interactionTarget);
                    group.setXYZ(group.getX() + dArray[0] - dArray2[0], group.getY() + dArray[1] - dArray2[1], group.getZ() + dArray[2] - dArray2[2]);
                    break;
                }
                double[] dArray3 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = this.getHotSpotBodyCoordinates(interactionTarget);
                dArray4[0] = dArray4[0] * this.getSizeX();
                dArray4[1] = dArray4[1] * this.getSizeY();
                dArray4[2] = dArray4[2] * this.getSizeZ();
                if (this.transformation != null) {
                    this.transformation.direct(dArray4);
                }
                this.setXYZ(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1], dArray3[2] - dArray4[2]);
                break;
            }
            case 1: {
                if (interactionTarget.getAffectsGroup() && group != null) {
                    double[] dArray5 = new double[]{dArray[0], dArray[1], dArray[2]};
                    dArray5[0] = dArray5[0] - group.getX();
                    dArray5[1] = dArray5[1] - group.getY();
                    dArray5[2] = dArray5[2] - group.getZ();
                    if (group.transformation != null) {
                        group.transformation.inverse(dArray5);
                    }
                    double[] dArray6 = this.getHotSpotBodyCoordinates(interactionTarget);
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.getSizeX();
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.getSizeY();
                    dArray5[2] = dArray6[2] != 0.0 ? dArray5[2] / dArray6[2] : group.getSizeZ();
                    group.setSizeXYZ(dArray5);
                    break;
                }
                double[] dArray7 = new double[]{dArray[0], dArray[1], dArray[2]};
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.getX();
                dArray7[1] = dArray7[1] - this.getY();
                dArray7[2] = dArray7[2] - this.getZ();
                if (this.transformation != null) {
                    this.transformation.inverse(dArray7);
                }
                double[] dArray8 = this.getHotSpotBodyCoordinates(interactionTarget);
                int n = 0;
                while (n < 3) {
                    if (dArray8[n] != 0.0) {
                        int n2 = n;
                        dArray7[n2] = dArray7[n2] / dArray8[n];
                    }
                    ++n;
                }
                this.setSizeXYZ(dArray7);
            }
        }
    }

    private final void elementDirectTransformations(double[] dArray) {
        Element element = this;
        do {
            if (element.getSizeX() != 0.0) {
                dArray[0] = dArray[0] * element.getSizeX();
            }
            if (element.getSizeY() != 0.0) {
                dArray[1] = dArray[1] * element.getSizeY();
            }
            if (element.getSizeZ() != 0.0) {
                dArray[2] = dArray[2] * element.getSizeZ();
            }
            if (element.transformation != null) {
                element.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + element.getX();
            dArray[1] = dArray[1] + element.getY();
            dArray[2] = dArray[2] + element.getZ();
        } while ((element = element.group) != null && element.group != null);
    }

    private final void groupInverseTransformations(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Element element = this.group;
        while (element != null) {
            arrayList.add((Group)element);
            element = element.group;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.getX();
            dArray[1] = dArray[1] - element.getY();
            dArray[2] = dArray[2] - element.getZ();
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element.getSizeX() != 0.0) {
                dArray[0] = dArray[0] / element.getSizeX();
            }
            if (element.getSizeY() != 0.0) {
                dArray[1] = dArray[1] / element.getSizeY();
            }
            if (element.getSizeZ() != 0.0) {
                dArray[2] = dArray[2] / element.getSizeZ();
            }
            --n;
        }
    }

    final void invokeActions(InteractionEvent interactionEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((InteractionListener)iterator.next()).interactionPerformed(interactionEvent);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.setElementChanged(true);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setGroup(Group group) {
        this.group = group;
        this.setElementChanged(true);
    }

    public Group getGroup() {
        return this.group;
    }

    public org.opensourcephysics.display3d.core.Style getStyle() {
        return this.style;
    }

    public void setElementChanged(boolean bl) {
        this.elementChanged = bl;
        if (this.elementChanged && this.panel != null) {
            this.panel.repaint();
        }
    }

    public boolean isElementChanged() {
        return this.elementChanged;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.setElementChanged(true);
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    protected void transform(GL gL) {
        double[] dArray;
        if (this.group != null) {
            this.group.transform(gL);
        }
        if (this.transformation == null) {
            gL.glTranslated(this.getX(), this.getY(), this.getZ());
            return;
        }
        if (this.transformation instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)this.transformation;
            dArray = quaternion.getFlatMatrix(null);
        } else {
            Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)this.transformation;
            dArray = matrix3DTransformation.getFlatMatrix(null);
        }
        gL.glTranslated(this.getX(), this.getY(), this.getZ());
        gL.glMultMatrixd(dArray, 0);
    }

    public double[] toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.getX();
        dArray[1] = dArray[1] + this.getY();
        dArray[2] = dArray[2] + this.getZ();
        Group group = this.group;
        while (group != null) {
            dArray[0] = dArray[0] * group.getSizeX();
            dArray[1] = dArray[1] * group.getSizeY();
            dArray[2] = dArray[2] * group.getSizeZ();
            if (group.transformation != null) {
                group.transformation.direct(dArray);
            }
            dArray[0] = dArray[0] + group.getX();
            dArray[1] = dArray[1] + group.getY();
            dArray[2] = dArray[2] + group.getZ();
            group = group.group;
        }
        return dArray;
    }

    public double[] toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        do {
            arrayList.add(element);
        } while ((element = element.group) != null);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            element = (Element)arrayList.get(n);
            dArray[0] = dArray[0] - element.getX();
            dArray[1] = dArray[1] - element.getY();
            dArray[2] = dArray[2] - element.getZ();
            if (element.transformation != null) {
                element.transformation.inverse(dArray);
            }
            if (element != this) {
                if (element.getSizeX() != 0.0) {
                    dArray[0] = dArray[0] / element.getSizeX();
                }
                if (element.getSizeY() != 0.0) {
                    dArray[1] = dArray[1] / element.getSizeY();
                }
                if (element.getSizeZ() != 0.0) {
                    dArray[2] = dArray[2] / element.getSizeZ();
                }
            }
            --n;
        }
        return dArray;
    }

    final void sizeAndToSpaceFrame(double[] dArray) {
        dArray[0] = dArray[0] * this.getSizeX();
        dArray[1] = dArray[1] * this.getSizeY();
        dArray[2] = dArray[2] * this.getSizeZ();
        this.toSpaceFrame(dArray);
    }

    public DrawingPanel3D getDrawingPanel3D() {
        return this.panel;
    }

    public void setDrawingPanel3D(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
        if (this instanceof Group) {
            Iterator iterator = ((Group)this).getElements().iterator();
            while (iterator.hasNext()) {
                ((Element)iterator.next()).setDrawingPanel3D(drawingPanel3D);
            }
        }
    }

    public void preFillGL(GLAutoDrawable gLAutoDrawable) {
    }

    public void preLinesGL(GLAutoDrawable gLAutoDrawable) {
    }

    public abstract int getBlendPriority();

    public void loadUnmutableObjects(XMLControl xMLControl) {
        this.style = (org.opensourcephysics.display3d.core.Style)xMLControl.getObject("style");
        ((Style)this.style).setElement(this);
        this.elementChanged = true;
    }
}

