/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Camera;
import org.opensourcephysics.display3d.jogl.DrawingPanel3D;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.numerics.Vec3D;
import org.opensourcephysics.numerics.VectorMath;

public class Camera
implements org.opensourcephysics.display3d.core.Camera {
    private static final double ratioToScreen = 2.5;
    private static final double ratioToFocus = 2.0;
    private static final double[] vertical = new double[]{0.0, 0.0, 1.0};
    static final int CHANGE_ANY = 0;
    static final int CHANGE_MODE = 1;
    static final int CHANGE_POSITION = 2;
    static final int CHANGE_FOCUS = 3;
    static final int CHANGE_ROTATION = 4;
    static final int CHANGE_SCREEN = 5;
    static final int CHANGE_ANGLES = 6;
    private int projectionMode = 11;
    private double posX;
    private double posY;
    private double posZ;
    private double focusX;
    private double focusY;
    private double focusZ;
    private double distanceToScreen;
    private double rotationAngle = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double distanceToFocus;
    private double panelMaxSizeConstant;
    double cosAlpha = 1.0;
    double sinAlpha = 0.0;
    double cosBeta = 1.0;
    double sinBeta = 0.0;
    private double[] e1;
    private double[] e2;
    private double[] e3;
    private Projection projection = new Projection();
    private double fov = 45.0;
    private DrawingPanel3D panel;

    Camera(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    void setPanel(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    public void setProjectionMode(int n) {
        this.projectionMode = n;
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize() * 0.01;
        this.panel.cameraChanged(1);
    }

    public final int getProjectionMode() {
        return this.projectionMode;
    }

    public void reset() {
        double[] dArray = this.panel.getCenter();
        this.focusX = dArray[0];
        this.focusY = dArray[1];
        this.focusZ = dArray[2];
        this.panelMaxSizeConstant = this.panel.getMaximum3DSize();
        this.rotationAngle = 0.0;
        this.distanceToScreen = 2.5 * this.panelMaxSizeConstant;
        this.distanceToFocus = 2.0 * this.panelMaxSizeConstant;
        this.posX = dArray[0] + this.distanceToFocus;
        this.posY = dArray[1];
        this.posZ = dArray[2];
        this.alpha = 0.0;
        this.cosAlpha = 1.0;
        this.sinAlpha = 0.0;
        this.beta = 0.0;
        this.cosBeta = 1.0;
        this.sinBeta = 0.0;
        this.e1 = new double[]{-1.0, 0.0, 0.0};
        this.e2 = new double[]{0.0, 1.0, 0.0};
        this.e3 = new double[]{0.0, 0.0, 1.0};
        this.panelMaxSizeConstant *= 0.01;
        this.panel.cameraChanged(0);
    }

    public void setXYZ(double d, double d2, double d3) {
        this.posX = d;
        this.posY = d2;
        this.posZ = d3;
        this.updateCamera(2);
    }

    public void setXYZ(double[] dArray) {
        this.setXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double getX() {
        return this.posX;
    }

    public final double getY() {
        return this.posY;
    }

    public final double getZ() {
        return this.posZ;
    }

    public void setFocusXYZ(double d, double d2, double d3) {
        this.focusX = d;
        this.focusY = d2;
        this.focusZ = d3;
        this.updateCamera(3);
    }

    public void setFocusXYZ(double[] dArray) {
        this.setFocusXYZ(dArray[0], dArray[1], dArray[2]);
    }

    public final double getFocusX() {
        return this.focusX;
    }

    public final double getFocusY() {
        return this.focusY;
    }

    public final double getFocusZ() {
        return this.focusZ;
    }

    public void setRotation(double d) {
        this.rotationAngle = d;
        this.updateCamera(4);
    }

    public final double getRotation() {
        return this.rotationAngle;
    }

    public void setDistanceToScreen(double d) {
        this.distanceToScreen = d;
        this.updateCamera(5);
    }

    public final double getDistanceToScreen() {
        return this.distanceToScreen;
    }

    public void setAzimuth(double d) {
        this.alpha = d;
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.updateCamera(6);
    }

    public final double getAzimuth() {
        return this.alpha;
    }

    public void setAltitude(double d) {
        this.beta = d;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final double getAltitude() {
        return this.beta;
    }

    public void setAzimuthAndAltitude(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
        if (this.beta < -1.5707963267948966) {
            this.beta = -1.5707963267948966;
        } else if (this.beta > 1.5707963267948966) {
            this.beta = 1.5707963267948966;
        }
        this.cosAlpha = Math.cos(this.alpha);
        this.sinAlpha = Math.sin(this.alpha);
        this.cosBeta = Math.cos(this.beta);
        this.sinBeta = Math.sin(this.beta);
        this.updateCamera(6);
    }

    public final Transformation getTransformation() {
        return this.projection;
    }

    private void updateCamera(int n) {
        switch (n) {
            case 2: 
            case 3: {
                this.distanceToFocus = this.computeCameraVectors();
                this.alpha = Math.atan2(-this.e1[1], -this.e1[0]);
                this.beta = Math.atan2(-this.e1[2], Math.abs(this.e1[0]));
                this.cosAlpha = Math.cos(this.alpha);
                this.sinAlpha = Math.sin(this.alpha);
                this.cosBeta = Math.cos(this.beta);
                this.sinBeta = Math.sin(this.beta);
                break;
            }
            case 4: {
                this.computeCameraVectors();
                break;
            }
            case 6: {
                this.posX = this.focusX + this.distanceToFocus * this.cosBeta * this.cosAlpha;
                this.posY = this.focusY + this.distanceToFocus * this.cosBeta * this.sinAlpha;
                this.posZ = this.focusZ + this.distanceToFocus * this.sinBeta;
                this.computeCameraVectors();
                break;
            }
            case 5: {
                double d = this.panel.getScreenSize();
                double d2 = 1.37;
                this.fov = Math.toDegrees(2.0 * Math.atan(d2 * d / (2.0 * this.getDistanceToScreen())));
            }
        }
        this.panel.cameraChanged(n);
    }

    public double computeCameraVectors() {
        this.e1 = new double[]{this.focusX - this.posX, this.focusY - this.posY, this.focusZ - this.posZ};
        double d = VectorMath.magnitude(this.e1);
        int n = 0;
        while (n < this.e1.length) {
            int n2 = n++;
            this.e1[n2] = this.e1[n2] / d;
        }
        this.e2 = VectorMath.cross3D(this.e1, vertical);
        double d2 = VectorMath.magnitude(this.e2);
        int n3 = 0;
        while (n3 < this.e2.length) {
            int n4 = n3++;
            this.e2[n4] = this.e2[n4] / d2;
        }
        this.e3 = VectorMath.cross3D(this.e2, this.e1);
        d2 = VectorMath.magnitude(this.e3);
        n3 = 0;
        while (n3 < this.e3.length) {
            int n5 = n3++;
            this.e3[n5] = this.e3[n5] / d2;
        }
        return d;
    }

    boolean is3dMode() {
        switch (this.projectionMode) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    double[] projectSize(double[] dArray, double[] dArray2, double[] dArray3) {
        switch (this.projectionMode) {
            case 0: {
                dArray3[0] = dArray2[0];
                dArray3[1] = dArray2[1];
                return dArray3;
            }
            case 1: {
                dArray3[0] = dArray2[0];
                dArray3[1] = dArray2[2];
                return dArray3;
            }
            case 2: {
                dArray3[0] = dArray2[1];
                dArray3[1] = dArray2[2];
                return dArray3;
            }
            case 10: {
                dArray3[0] = Math.max(dArray2[0], dArray2[1]);
                dArray3[1] = dArray2[2];
                return dArray3;
            }
        }
        double d = (dArray[0] - this.posX) * this.e1[0] + (dArray[1] - this.posY) * this.e1[1] + (dArray[2] - this.posZ) * this.e1[2];
        if (Math.abs(d) < this.panelMaxSizeConstant) {
            d = this.panelMaxSizeConstant;
        }
        d = this.distanceToFocus / d;
        dArray3[0] = Math.max(dArray2[0], dArray2[1]) * d;
        dArray3[1] = dArray2[2] * d;
        return dArray3;
    }

    public static XML.ObjectLoader getLoader() {
        return new CameraLoader();
    }

    public void look(GLAutoDrawable gLAutoDrawable) {
        Vec3D vec3D = this.getPerspectivePosition();
        if (this.getProjectionMode() == 0) {
            GLTools.GLU.gluLookAt(vec3D.x, vec3D.y, vec3D.z, this.focusX, this.focusY, this.focusZ, 0.0, 1.0, 0.0);
        } else {
            GLTools.GLU.gluLookAt(vec3D.x, vec3D.y, vec3D.z, this.focusX, this.focusY, this.focusZ, 0.0, 0.0, 1.0);
        }
    }

    private Vec3D getPerspectivePosition() {
        Vec3D vec3D = new Vec3D(this.panel.getCenter());
        switch (this.getProjectionMode()) {
            case 10: 
            case 11: {
                vec3D.x = this.posX;
                vec3D.y = this.posY;
                vec3D.z = this.posZ;
                break;
            }
            case 0: {
                vec3D.z += this.distanceToFocus;
                break;
            }
            case 1: {
                vec3D.y -= this.distanceToFocus;
                break;
            }
            case 2: {
                vec3D.x += this.distanceToFocus;
            }
        }
        return vec3D;
    }

    public Vec3D getDirection() {
        Vec3D vec3D = new Vec3D();
        vec3D.subtract(new Vec3D(this.focusX, this.focusY, this.focusZ), this.getPerspectivePosition());
        return vec3D;
    }

    public Vec3D getPosition() {
        return new Vec3D(this.posX, this.posY, this.posZ);
    }

    public double getFoV() {
        return this.fov;
    }

    protected static class CameraLoader
    extends Camera.Loader {
        protected CameraLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new Camera(null);
        }
    }

    private class Projection
    implements Transformation {
        private Projection() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }

        public double[] direct(double[] dArray) {
            double d;
            switch (Camera.this.projectionMode) {
                case 0: {
                    dArray[0] = dArray[0] - Camera.this.focusX;
                    dArray[1] = dArray[1] - Camera.this.focusY;
                    dArray[2] = 1.0 - (dArray[2] - Camera.this.focusZ) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 1: {
                    double d2 = dArray[1];
                    dArray[0] = dArray[0] - Camera.this.focusX;
                    dArray[1] = dArray[2] - Camera.this.focusZ;
                    dArray[2] = 1.0 - (d2 - Camera.this.focusY) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 2: {
                    double d3 = dArray[0];
                    dArray[0] = dArray[1] - Camera.this.focusY;
                    dArray[1] = dArray[2] - Camera.this.focusZ;
                    dArray[2] = 1.0 - (d3 - Camera.this.focusX) / Camera.this.distanceToFocus;
                    return dArray;
                }
                case 10: {
                    dArray[0] = dArray[0] - Camera.this.posX;
                    dArray[1] = dArray[1] - Camera.this.posY;
                    dArray[2] = dArray[2] - Camera.this.posZ;
                    double d4 = VectorMath.dot(dArray, Camera.this.e1);
                    double d5 = VectorMath.dot(dArray, Camera.this.e2);
                    dArray[1] = VectorMath.dot(dArray, Camera.this.e3);
                    dArray[0] = d5;
                    dArray[2] = d4 / Camera.this.distanceToFocus;
                    return dArray;
                }
            }
            dArray[0] = dArray[0] - Camera.this.posX;
            dArray[1] = dArray[1] - Camera.this.posY;
            dArray[2] = dArray[2] - Camera.this.posZ;
            double d6 = d = VectorMath.dot(dArray, Camera.this.e1);
            if (Math.abs(d) < Camera.this.panelMaxSizeConstant) {
                d = Camera.this.panelMaxSizeConstant;
            }
            d = Camera.this.distanceToScreen / d;
            double d7 = VectorMath.dot(dArray, Camera.this.e2) * d;
            dArray[1] = VectorMath.dot(dArray, Camera.this.e3) * d;
            dArray[0] = d7;
            dArray[2] = d6 / Camera.this.distanceToFocus;
            return dArray;
        }

        public double[] inverse(double[] dArray) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

