/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.Color;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail,
GeometryUpdater {
    public static final int NO_MAXIMUM = -1;
    private int maximumPoints = -1;
    private int length;
    private boolean connected = true;
    private LineStripArray lines;
    private double[] points;
    private double[] nextPoint;
    private int[] stripVertexCounts;

    public ElementTrail() {
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.length = 0;
        this.points = new double[300];
        this.nextPoint = new double[3];
        this.getStyle().setDrawingFill(false);
        this.getStyle().setDrawingLines(true);
        this.getStyle().setLineColor(Color.black);
        this.init();
    }

    void init() {
        this.stripVertexCounts = new int[]{Math.max(2, this.length)};
        this.lines = new LineStripArray(this.points.length / 3, 129, this.stripVertexCounts);
        this.lines.setCapability(19);
        this.lines.setCapability(21);
        this.lines.setCapability(8);
        this.lines.setCapability(20);
        this.lines.setCapability(1);
        this.lines.setCoordRefDouble(this.points);
        this.setNode((Node)new Shape3D((Geometry)this.lines, this.getAppearance()));
    }

    public void addPoint(double d, double d2, double d3) {
        this.nextPoint[0] = d;
        this.nextPoint[1] = d2;
        this.nextPoint[2] = d3;
        if (this.length == this.maximumPoints * 2) {
            this.lines.updateData((GeometryUpdater)this);
        } else if (this.length * 3 == this.points.length) {
            int n = this.maximumPoints == -1 ? this.length * 3 * 2 : Math.min(this.length * 3 * 2, this.maximumPoints * 3 * 2);
            double[] dArray = new double[n];
            System.arraycopy(this.points, 0, dArray, 0, this.length * 3);
            this.points = dArray;
            this.init();
        } else {
            this.lines.updateData((GeometryUpdater)this);
        }
    }

    public void updateData(Geometry geometry) {
        if (this.length == this.maximumPoints * 2) {
            int n = 0;
            while (n < this.length - 2) {
                this.points[n * 3] = this.points[(n + 1) * 3];
                this.points[n * 3 + 1] = this.points[(n + 1) * 3 + 1];
                this.points[n * 3 + 2] = this.points[(n + 1) * 3 + 2];
                ++n;
            }
            --this.length;
        }
        this.points[this.length * 3] = this.nextPoint[0];
        this.points[this.length * 3 + 1] = this.nextPoint[1];
        this.points[this.length * 3 + 2] = this.nextPoint[2];
        ++this.length;
        this.stripVertexCounts[0] = Math.max(2, this.length);
        if (this.length < 2) {
            this.points[this.length * 3] = this.nextPoint[0];
            this.points[this.length * 3 + 1] = this.nextPoint[1];
            this.points[this.length * 3 + 2] = this.nextPoint[2];
        }
        ((LineStripArray)geometry).setStripVertexCounts(this.stripVertexCounts);
    }

    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2]);
    }

    public void setMaximumPoints(int n) {
        this.maximumPoints = n;
    }

    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void moveToPoint(double d, double d2, double d3) {
        boolean bl = this.connected;
        this.connected = false;
        this.addPoint(d, d2, d3);
        this.connected = bl;
    }

    public void clear() {
        this.length = 0;
        this.init();
    }
}

