/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import org.opensourcephysics.display3d.java3d.Element;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ElementImage
extends Element
implements org.opensourcephysics.display3d.core.ElementImage {
    private String imageFile;
    private Resource resource = null;
    private BufferedImage image = null;
    private double angle = 0.0;

    public ElementImage() {
        this.setSizeXYZ(0.0, 0.0, 0.0);
    }

    public void setImageFile(String string) {
        this.imageFile = string;
        if (string != null) {
            this.resource = ResourceLoader.getResource(string);
            if (this.resource != null) {
                this.image = this.resource.getBufferedImage();
                ImageComponent2D imageComponent2D = new ImageComponent2D(2, this.image);
                Raster raster = new Raster();
                raster.setType(1);
                raster.setImage(imageComponent2D);
                raster.setSize(this.image.getWidth(), this.image.getHeight());
                Shape3D shape3D = new Shape3D((Geometry)raster);
                shape3D.setAppearance(this.getAppearance());
                this.setNode((Node)shape3D);
            }
        }
    }

    public void setImage(Image image) {
        this.imageFile = null;
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
        Raster raster = new Raster();
        raster.setType(1);
        raster.setImage(imageComponent2D);
        raster.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setRotationAngle(double d) {
        this.angle = d;
    }

    public double getRotationAngle() {
        return this.angle;
    }
}

