/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.core.interaction.InteractionSource;
import org.opensourcephysics.numerics.Transformation;

public interface Element
extends InteractionSource {
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;

    public void setName(String var1);

    public String getName();

    public void setX(double var1);

    public double getX();

    public void setY(double var1);

    public double getY();

    public void setZ(double var1);

    public double getZ();

    public void setXYZ(double var1, double var3, double var5);

    public void setXYZ(double[] var1);

    public void setSizeX(double var1);

    public double getSizeX();

    public void setSizeY(double var1);

    public double getSizeY();

    public void setSizeZ(double var1);

    public double getSizeZ();

    public void setSizeXYZ(double var1, double var3, double var5);

    public void setSizeXYZ(double[] var1);

    public void setVisible(boolean var1);

    public boolean isVisible();

    public Style getStyle();

    public void setTransformation(Transformation var1);

    public Transformation getTransformation();

    public double[] toSpaceFrame(double[] var1);

    public double[] toBodyFrame(double[] var1) throws UnsupportedOperationException;

    public void loadUnmutableObjects(XMLControl var1);

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl xMLControl, Object object) {
            Element element = (Element)object;
            if (element.getName().length() > 0) {
                xMLControl.setValue("name", element.getName());
            }
            xMLControl.setValue("x", element.getX());
            xMLControl.setValue("y", element.getY());
            xMLControl.setValue("z", element.getZ());
            xMLControl.setValue("x size", element.getSizeX());
            xMLControl.setValue("y size", element.getSizeY());
            xMLControl.setValue("z size", element.getSizeZ());
            xMLControl.setValue("visible", element.isVisible());
            xMLControl.setValue("style", element.getStyle());
            xMLControl.setValue("transformation", element.getTransformation());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Element element = (Element)object;
            String string = xMLControl.getString("name");
            if (string != null) {
                element.setName(string);
            }
            element.setXYZ(xMLControl.getDouble("x"), xMLControl.getDouble("y"), xMLControl.getDouble("z"));
            element.setSizeXYZ(xMLControl.getDouble("x size"), xMLControl.getDouble("y size"), xMLControl.getDouble("z size"));
            element.setVisible(xMLControl.getBoolean("visible"));
            element.setTransformation((Transformation)xMLControl.getObject("transformation"));
            element.loadUnmutableObjects(xMLControl);
            return object;
        }
    }
}

