/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.ZExpansion;

public class ColorMapper {
    private static final int CUSTOM = -1;
    public static final int SPECTRUM = 0;
    public static final int GRAYSCALE = 1;
    public static final int DUALSHADE = 2;
    public static final int RED = 3;
    public static final int GREEN = 4;
    public static final int BLUE = 5;
    public static final int BLACK = 6;
    public static final int WIREFRAME = 7;
    public static final int NORENDER = 8;
    public static final int REDBLUE_SHADE = 9;
    private Color[] colors;
    private double floor;
    private double ceil;
    private Color floorColor = Color.darkGray;
    private Color ceilColor = Color.lightGray;
    private int numColors;
    private int paletteType;
    private JFrame legendFrame;
    protected ZExpansion zMap = null;

    public ColorMapper(int n, double d, double d2, int n2) {
        this.floor = d;
        this.ceil = d2;
        this.numColors = n;
        this.setPaletteType(n2);
    }

    void updateLegend(ZExpansion zExpansion) {
        if (this.legendFrame != null && this.legendFrame.isVisible() && this.legendFrame.isDisplayable()) {
            if (zExpansion == null) {
                zExpansion = this.zMap;
            }
            this.showLegend(zExpansion);
        }
    }

    public JFrame showLegend() {
        if (this.zMap != null) {
            return this.showLegend(this.zMap);
        }
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        GridPointData gridPointData = new GridPointData(this.numColors + 2, 1, 1);
        double[][][] dArray = gridPointData.getData();
        double d = (this.ceil - this.floor) / (double)this.numColors;
        double d2 = this.floor - d / 2.0;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            dArray[n][0][2] = d2;
            d2 += d;
            ++n;
        }
        gridPointData.setScale(this.floor - d, this.ceil + d, 0.0, 1.0);
        GridPlot gridPlot = new GridPlot(gridPointData);
        gridPlot.setShowGridLines(false);
        gridPlot.setAutoscaleZ(false, this.floor, this.ceil);
        gridPlot.setColorPalette(this.colors);
        gridPlot.update();
        interactivePanel.addDrawable(gridPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    JFrame showLegend(ZExpansion zExpansion) {
        if (zExpansion == null) {
            return this.showLegend();
        }
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(interactivePanel);
        int n = 256;
        if (this.paletteType == -1) {
            n = this.colors.length;
        }
        GridPointData gridPointData = new GridPointData(n + 2, 1, 1);
        double[][][] dArray = gridPointData.getData();
        double d = (this.ceil - this.floor) / (double)n;
        double d2 = this.floor - d / 2.0;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            dArray[n2][0][2] = zExpansion.evaluate(d2);
            d2 += d;
            ++n2;
        }
        gridPointData.setScale(this.floor - d, this.ceil + d, 0.0, 1.0);
        GridPlot gridPlot = new GridPlot(gridPointData);
        gridPlot.setShowGridLines(false);
        gridPlot.setAutoscaleZ(false, this.floor, this.ceil);
        if (this.paletteType == -1) {
            gridPlot.setColorPalette(this.colors);
        } else {
            gridPlot.setPaletteType(this.paletteType);
        }
        gridPlot.update();
        interactivePanel.addDrawable(gridPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setScale(double d, double d2) {
        this.floor = d;
        this.ceil = d2;
        if (this.zMap != null) {
            this.zMap.setMinMax(this.floor, this.ceil);
        }
    }

    public byte[] doubleToComponents(double d, byte[] byArray) {
        if (this.zMap != null) {
            d = this.zMap.evaluate(d);
        }
        Color color = this.doubleToColor(d);
        byArray[0] = (byte)color.getRed();
        byArray[1] = (byte)color.getGreen();
        byArray[2] = (byte)color.getBlue();
        return byArray;
    }

    public Color doubleToColor(double d) {
        if (this.zMap != null) {
            d = this.zMap.evaluate(d);
        }
        if ((float)this.floor - (float)d > Float.MIN_VALUE) {
            return this.floorColor;
        }
        if ((float)d - (float)this.ceil > Float.MIN_VALUE) {
            return this.ceilColor;
        }
        int n = (int)((double)this.colors.length * (d - this.floor) / (this.ceil - this.floor));
        n = Math.max(0, n);
        return this.colors[Math.min(n, this.colors.length - 1)];
    }

    public void setZMap(ZExpansion zExpansion) {
        this.zMap = zExpansion;
        if (this.zMap != null) {
            this.zMap.setMinMax(this.floor, this.ceil);
        }
    }

    public double getFloor() {
        return this.floor;
    }

    public Color getFloorColor() {
        return this.floorColor;
    }

    public double getCeil() {
        return this.ceil;
    }

    public Color getCeilColor() {
        return this.ceilColor;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.floorColor = color;
        this.ceilColor = color2;
    }

    protected int getPaletteType() {
        return this.paletteType;
    }

    protected void setColorPalette(Color[] colorArray) {
        this.floorColor = Color.darkGray;
        this.ceilColor = Color.lightGray;
        this.colors = colorArray;
        this.numColors = this.colors.length;
        this.paletteType = -1;
    }

    protected void setNumberOfColors(int n) {
        if (n == this.numColors) {
            return;
        }
        this.numColors = n;
        if (this.paletteType == -1) {
            Color[] colorArray = new Color[this.numColors];
            int n2 = 0;
            int n3 = Math.min(this.colors.length, this.numColors);
            while (n2 < n3) {
                colorArray[n2] = this.colors[n2];
                ++n2;
            }
            n2 = this.colors.length;
            while (n2 < this.numColors) {
                colorArray[n2] = this.colors[this.colors.length - 1];
                ++n2;
            }
            this.colors = colorArray;
        } else {
            this.setPaletteType(this.paletteType);
        }
    }

    protected void setPaletteType(int n) {
        this.paletteType = n;
        this.floorColor = Color.darkGray;
        this.ceilColor = Color.lightGray;
        if (this.paletteType == 1 || this.paletteType == 6) {
            this.floorColor = new Color(64, 64, 128);
            this.ceilColor = new Color(255, 191, 191);
        }
        this.colors = ColorMapper.getColorPalette(this.numColors, this.paletteType);
        this.numColors = Math.max(2, this.numColors);
    }

    public static Color[] getColorPalette(int n, int n2) {
        if (n < 2) {
            n = 2;
        }
        Color[] colorArray = new Color[n];
        int n3 = 0;
        while (n3 < n) {
            float f = (float)n3 / (float)(n - 1) * 0.8f;
            int n4 = 0;
            int n5 = 0;
            switch (n2) {
                case 9: {
                    n4 = Math.max(0, -n - 1 + n3 * 2) * 255 / (n - 1);
                    n5 = Math.max(0, n - 1 - n3 * 2) * 255 / (n - 1);
                    colorArray[n3] = new Color(n4, 0, n5);
                    break;
                }
                case 0: {
                    f = 0.8f - f;
                    colorArray[n3] = Color.getHSBColor(f, 1.0f, 1.0f);
                    break;
                }
                case 1: 
                case 6: {
                    colorArray[n3] = new Color(n3 * 255 / (n - 1), n3 * 255 / (n - 1), n3 * 255 / (n - 1));
                    break;
                }
                case 3: {
                    colorArray[n3] = new Color(n3 * 255 / (n - 1), 0, 0);
                    break;
                }
                case 4: {
                    colorArray[n3] = new Color(0, n3 * 255 / (n - 1), 0);
                    break;
                }
                case 5: {
                    colorArray[n3] = new Color(0, 0, n3 * 255 / (n - 1));
                    break;
                }
                default: {
                    f = (float)n3 / (float)(n - 1);
                    colorArray[n3] = Color.getHSBColor(0.8f * (1.0f - f), 1.0f, 0.2f + 1.6f * Math.abs(0.5f - f));
                }
            }
            ++n3;
        }
        return colorArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new ColorMapperLoader();
    }

    private static class ColorMapperLoader
    extends XMLLoader {
        private ColorMapperLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            ColorMapper colorMapper = (ColorMapper)object;
            xMLControl.setValue("palette type", colorMapper.paletteType);
            xMLControl.setValue("number of colors", colorMapper.numColors);
            xMLControl.setValue("floor", colorMapper.floor);
            xMLControl.setValue("ceiling", colorMapper.ceil);
            xMLControl.setValue("floor color", colorMapper.floorColor);
            xMLControl.setValue("ceiling color", colorMapper.ceilColor);
            if (colorMapper.paletteType == -1) {
                xMLControl.setValue("colors", colorMapper.colors);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new ColorMapper(100, -1.0, 1.0, 0);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            ColorMapper colorMapper = (ColorMapper)object;
            int n = xMLControl.getInt("palette type");
            int n2 = xMLControl.getInt("number of colors");
            double d = xMLControl.getDouble("floor");
            double d2 = xMLControl.getDouble("ceiling");
            if (n == -1) {
                object2 = (Color[])xMLControl.getObject("colors");
                colorMapper.setColorPalette((Color[])object2);
            } else {
                colorMapper.setPaletteType(n);
                colorMapper.setNumberOfColors(n2);
            }
            colorMapper.setScale(d, d2);
            object2 = (Color)xMLControl.getObject("floor color");
            Color color = (Color)xMLControl.getObject("ceiling color");
            colorMapper.setFloorCeilColor((Color)object2, color);
            return object;
        }
    }
}

