/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JMenu;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ControlMenu
extends ControlContainer {
    protected static final int MENU_ADDED = 5;
    protected JMenu menu;
    private String imageFile = null;
    private String labelString = "";
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.menu = new JMenu();
        return this.menu;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.add("action");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("mnemonic")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                if (this.labelString == null) {
                    this.labelString = "";
                }
                this.menu.setText(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.menu.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.menu.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                this.menu.setMnemonic(value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.menu.setText("");
                break;
            }
            case 1: {
                this.imageFile = null;
                this.menu.setIcon(null);
                break;
            }
            case 2: {
                this.menu.setHorizontalAlignment(0);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.menu.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }
}

