/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlMenuBar;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ControlDialog
extends ControlWindow {
    private static final int DIALOG_ADDED = 4;
    protected JDialog dialog;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        return this.createDialog(null);
    }

    public String getObjectClassname() {
        return "javax.swing.JDialog";
    }

    public Object getObject() {
        return this.dialog;
    }

    public void replaceVisual(Frame frame) {
        this.dialog.dispose();
        this.myVisual = this.createDialog(frame);
    }

    private Component createDialog(Frame frame) {
        this.startingup = true;
        this.dialog = frame != null ? new JDialog(frame) : new JDialog();
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.internalValue = new BooleanValue(true);
        this.setListeners();
        if (this.menubar != null) {
            this.dialog.setJMenuBar(this.menubar);
        }
        return this.dialog.getContentPane();
    }

    protected int getVisibleIndex() {
        return 13;
    }

    protected int getLocationIndex() {
        return 5;
    }

    protected int getSizeIndex() {
        return 14;
    }

    public Component getComponent() {
        return this.dialog;
    }

    public Container getContainer() {
        return this.dialog.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.dialog.getRootPane();
    }

    public void add(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        this.menubar = (JMenuBar)controlElement.getVisual();
        this.dialog.setJMenuBar(this.menubar);
        ((ControlMenuBar)controlElement).setControlWindow(this);
        this.adjustSize();
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    public void remove(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        this.menubar = null;
        this.dialog.setJMenuBar(null);
        this.getRootPane().validate();
        this.getRootPane().repaint();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("closable");
            infoList.add("modal");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("resizable")) {
            return "boolean";
        }
        if (string.equals("closable")) {
            return "boolean";
        }
        if (string.equals("modal")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.dialog.setTitle(String.valueOf(GUIUtils.parseTeX(value.getString())) + " " + string);
                    break;
                }
                this.dialog.setTitle(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                this.dialog.setResizable(value.getBoolean());
                break;
            }
            case 2: {
                if (value.getBoolean()) {
                    this.dialog.setDefaultCloseOperation(1);
                    break;
                }
                this.dialog.setDefaultCloseOperation(0);
                break;
            }
            case 3: {
                if (this.isUnderEjs) break;
                this.dialog.setModal(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                String string = this.getProperty("_ejs_window_");
                if (string != null) {
                    this.dialog.setTitle(string);
                    break;
                }
                this.dialog.setTitle("");
                break;
            }
            case 1: {
                this.dialog.setResizable(true);
                break;
            }
            case 2: {
                this.dialog.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.dialog.setModal(false);
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

