/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ControlCheckBox
extends ControlSwingElement {
    static final int VARIABLE = 4;
    static final int SELECTED = 5;
    protected AbstractButton checkbox;
    protected BooleanValue internalValue;
    protected boolean defaultState;
    protected boolean defaultStateSet;
    protected String imageFile = null;
    protected String selectedimageFile = null;
    protected String labelString = "";
    private static ArrayList infoList = null;

    protected int getVariableIndex() {
        return 4;
    }

    protected int getValueIndex() {
        return 5;
    }

    protected Component createVisual() {
        this.checkbox = new JCheckBox();
        this.defaultStateSet = false;
        this.defaultState = this.checkbox.isSelected();
        this.internalValue = new BooleanValue(this.defaultState);
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlCheckBox.this.setInternalValue(ControlCheckBox.this.checkbox.isSelected());
                if (ControlCheckBox.this.isUnderEjs) {
                    ControlCheckBox.this.setFieldListValueWithAlternative(ControlCheckBox.this.getVariableIndex(), ControlCheckBox.this.getValueIndex(), ControlCheckBox.this.internalValue);
                }
            }
        });
        return this.checkbox;
    }

    public void reset() {
        if (this.defaultStateSet) {
            this.checkbox.setSelected(this.defaultState);
            this.setInternalValue(this.defaultState);
        }
    }

    protected void setInternalValue(boolean bl) {
        this.internalValue.value = bl;
        this.variableChanged(this.getVariableIndex(), this.internalValue);
        this.invokeActions();
        if (this.internalValue.value) {
            this.invokeActions(20);
        } else {
            this.invokeActions(21);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("selectedimage");
            infoList.add("alignment");
            infoList.add("variable");
            infoList.add("selected");
            infoList.add("action");
            infoList.add("actionon");
            infoList.add("actionoff");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("selectedimage")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("variable")) {
            return "boolean";
        }
        if (string.equals("selected")) {
            return "boolean CONSTANT POSTPROCESS";
        }
        if (string.equals("action")) {
            return "Action  CONSTANT";
        }
        if (string.equals("actionon")) {
            return "Action  CONSTANT";
        }
        if (string.equals("actionoff")) {
            return "Action  CONSTANT";
        }
        if (string.equals("mnemonic")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                if (this.labelString == null) {
                    this.labelString = "";
                }
                this.checkbox.setText(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.checkbox.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                if (value.getString().equals(this.selectedimageFile)) {
                    return;
                }
                this.selectedimageFile = value.getString();
                this.checkbox.setSelectedIcon(this.getIcon(this.selectedimageFile));
                break;
            }
            case 3: {
                this.checkbox.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 4: {
                this.internalValue.value = value.getBoolean();
                this.checkbox.setSelected(this.internalValue.value);
                break;
            }
            case 5: {
                this.defaultStateSet = true;
                this.defaultState = value.getBoolean();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                this.addAction(20, value.getString());
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                this.addAction(21, value.getString());
                break;
            }
            case 9: {
                this.checkbox.setMnemonic(value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.checkbox.setText("");
                break;
            }
            case 1: {
                this.checkbox.setIcon(null);
                this.imageFile = null;
                break;
            }
            case 2: {
                this.checkbox.setSelectedIcon(null);
                this.selectedimageFile = null;
                break;
            }
            case 3: {
                this.checkbox.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.defaultStateSet = false;
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                break;
            }
            case 9: {
                this.checkbox.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 4: {
                return this.internalValue;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 10);
    }
}

