/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveTrace;

public class ControlTrace
extends ControlInteractiveElement
implements NeedsPreUpdate,
Resetable,
DataCollector {
    protected static final int TRACE_ADDED = 12;
    protected static final int INPUT_X = 12;
    protected static final int INPUT_Y = 13;
    protected static final int INPUT_Z = 14;
    protected static final int MY_STYLE = 26;
    private InteractiveTrace trace;
    private double x;
    private double y;
    private double z;
    private double[] xArray = null;
    private double[] yArray = null;
    private double[] zArray = null;
    private boolean isSet = false;
    private boolean isSetZ = false;
    private int[] myPosSpot;
    private int[] mySizeSpot;
    private int myFullPosition;
    private int myFullSize;
    private static ArrayList infoList = null;

    public ControlTrace() {
        this.enabledEjsEdit = true;
        int n = this.getPropertiesDisplacement();
        this.myPosSpot = new int[]{6 + n, 7 + n, 8 + n};
        this.mySizeSpot = new int[]{15 + n, 16 + n, 17 + n};
        this.myFullPosition = 40 + n;
        this.myFullSize = 41 + n;
    }

    protected int getPropertiesDisplacement() {
        return 0;
    }

    public final int[] getPosSpot() {
        return this.myPosSpot;
    }

    public final int[] getSizeSpot() {
        return this.mySizeSpot;
    }

    public final int getFullPositionSpot() {
        return this.myFullPosition;
    }

    public final int getFullSizeSpot() {
        return this.myFullSize;
    }

    protected void setName(String string) {
        this.trace.setName(string);
    }

    protected Drawable createDrawable() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.trace = new InteractiveTrace();
        this.trace.setAllowTable(true);
        return this.trace;
    }

    public void initialize() {
        this.trace.initialize();
    }

    public void reset() {
        this.trace.clear();
    }

    public void onExit() {
        this.trace.clear();
    }

    public void flush() {
        this.trace.flush();
    }

    public void preupdate() {
        if (this.isSetZ) {
            if (this.xArray == null) {
                if (this.yArray == null) {
                    if (this.zArray == null) {
                        this.trace.addPoint(this.x, this.y, this.z);
                    } else {
                        int n = 0;
                        int n2 = this.zArray.length;
                        while (n < n2) {
                            this.trace.addPoint(this.x, this.y, this.zArray[n]);
                            ++n;
                        }
                    }
                } else if (this.zArray == null) {
                    int n = 0;
                    int n3 = this.yArray.length;
                    while (n < n3) {
                        this.trace.addPoint(this.x, this.yArray[n], this.z);
                        ++n;
                    }
                } else {
                    int n = 0;
                    int n4 = Math.min(this.yArray.length, this.zArray.length);
                    while (n < n4) {
                        this.trace.addPoint(this.x, this.yArray[n], this.zArray[n]);
                        ++n;
                    }
                }
            } else if (this.yArray == null) {
                if (this.zArray == null) {
                    int n = 0;
                    int n5 = this.xArray.length;
                    while (n < n5) {
                        this.trace.addPoint(this.xArray[n], this.y, this.z);
                        ++n;
                    }
                } else {
                    int n = 0;
                    int n6 = Math.min(this.xArray.length, this.zArray.length);
                    while (n < n6) {
                        this.trace.addPoint(this.xArray[n], this.y, this.zArray[n]);
                        ++n;
                    }
                }
            } else if (this.zArray == null) {
                int n = 0;
                int n7 = Math.min(this.xArray.length, this.yArray.length);
                while (n < n7) {
                    this.trace.addPoint(this.xArray[n], this.yArray[n], this.z);
                    ++n;
                }
            } else {
                this.trace.addPoints(this.xArray, this.yArray, this.zArray);
            }
        } else if (this.isSet) {
            if (this.xArray == null) {
                if (this.yArray == null) {
                    this.trace.addPoint(this.x, this.y);
                } else {
                    int n = 0;
                    int n8 = this.yArray.length;
                    while (n < n8) {
                        this.trace.addPoint(this.x, this.yArray[n]);
                        ++n;
                    }
                }
            } else if (this.yArray == null) {
                this.trace.addPoint(this.x, this.y);
            } else {
                this.trace.addPoints(this.xArray, this.yArray);
            }
        }
        this.isSetZ = false;
        this.isSet = false;
    }

    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlTrace.this.trace.showTable(ControlTrace.this.getParent().getDrawingPanel());
            }
        });
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlTrace.this.trace.showDataTool();
            }
        });
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetManager")){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractiveTrace.showDatasetManagerTool(ControlTrace.this.getParent().getDrawingPanel());
            }
        });
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("maxpoints");
            infoList.add("skippoints");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("connected");
            infoList.add("markersize");
            infoList.add("positionx");
            infoList.add("positiony");
            infoList.add("positionz");
            infoList.add("memory");
            infoList.add("drivenby");
            infoList.add("memorycolor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("x")) {
            return "inputX";
        }
        if (string.equals("y")) {
            return "inputY";
        }
        if (string.equals("z")) {
            return "inputZ";
        }
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("maxpoints")) {
            return "maximumPoints";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("maxpoints")) {
            return "int PREVIOUS";
        }
        if (string.equals("skippoints")) {
            return "int";
        }
        if (string.equals("active")) {
            return "boolean";
        }
        if (string.equals("norepeat")) {
            return "boolean";
        }
        if (string.equals("connected")) {
            return "boolean";
        }
        if (string.equals("style")) {
            return "MarkerShape|int";
        }
        if (string.equals("markersize")) {
            return "int";
        }
        if (string.equals("positionx")) {
            return "int|double";
        }
        if (string.equals("positiony")) {
            return "int|double";
        }
        if (string.equals("positionz")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("memory")) {
            return "int";
        }
        if (string.equals("drivenby")) {
            return "DrivenBy|int";
        }
        if (string.equals("memorycolor")) {
            return "Color|Object";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("DrivenBy") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("show_all")) {
                return new IntegerValue(0);
            }
            if (string2.equals("as_added")) {
                return new IntegerValue(1);
            }
            if (string2.equals("x_order")) {
                return new IntegerValue(2);
            }
            if (string2.equals("y_order")) {
                return new IntegerValue(3);
            }
            if (string2.equals("z_order")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(string, string2);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("makershape")) {
            return super.setProperty("style", string2);
        }
        if (string.equals("linecolor")) {
            return super.setProperty("color", string2);
        }
        if (string.equals("markercolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 12: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                } else {
                    this.x = value.getDouble();
                    this.xArray = null;
                }
                this.isSet = true;
                break;
            }
            case 13: {
                if (value.getObject() instanceof double[]) {
                    this.yArray = (double[])value.getObject();
                } else {
                    this.y = value.getDouble();
                    this.yArray = null;
                }
                this.isSet = true;
                break;
            }
            case 14: {
                if (value.getObject() instanceof double[]) {
                    this.zArray = (double[])value.getObject();
                } else {
                    this.z = value.getDouble();
                    this.zArray = null;
                }
                this.isSetZ = true;
                break;
            }
            case 0: {
                this.trace.setMaximumPoints(value.getInteger());
                break;
            }
            case 1: {
                this.trace.setSkip(value.getInteger());
                break;
            }
            case 2: {
                this.trace.setActive(value.getBoolean());
                break;
            }
            case 3: {
                this.trace.setIgnoreEqualPoints(value.getBoolean());
                break;
            }
            case 4: {
                this.trace.setConnected(value.getBoolean());
                break;
            }
            case 5: {
                this.trace.setShapeSize(value.getInteger());
                break;
            }
            case 6: {
                super.setValue(0, value);
                break;
            }
            case 7: {
                super.setValue(1, value);
                break;
            }
            case 8: {
                super.setValue(2, value);
                break;
            }
            case 9: {
                this.trace.setMemorySets(value.getInteger());
                break;
            }
            case 10: {
                this.trace.setMemoryDrivenBy(value.getInteger());
                break;
            }
            case 11: {
                this.trace.setMemoryColor((Color)value.getObject());
                break;
            }
            case 26: {
                this.trace.setShapeType(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 12, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 12: {
                this.x = 0.0;
                this.xArray = null;
                break;
            }
            case 13: {
                this.y = 0.0;
                this.yArray = null;
                break;
            }
            case 14: {
                this.z = 0.0;
                this.zArray = null;
                break;
            }
            case 0: {
                this.trace.setMaximumPoints(0);
                break;
            }
            case 1: {
                this.trace.setSkip(0);
                break;
            }
            case 2: {
                this.trace.setActive(true);
                break;
            }
            case 3: {
                this.trace.setIgnoreEqualPoints(false);
                break;
            }
            case 4: {
                this.trace.setConnected(true);
                break;
            }
            case 5: {
                this.trace.setShapeSize(5);
                break;
            }
            case 6: {
                super.setDefaultValue(0);
                break;
            }
            case 7: {
                super.setDefaultValue(1);
                break;
            }
            case 8: {
                super.setDefaultValue(2);
                break;
            }
            case 9: {
                this.trace.setMemorySets(1);
                break;
            }
            case 10: {
                this.trace.setMemoryDrivenBy(0);
                break;
            }
            case 11: {
                this.trace.setMemoryColor(Color.BLACK);
                break;
            }
            case 26: {
                this.trace.setShapeType(0);
                break;
            }
            default: {
                super.setDefaultValue(n - 12);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 12: 
            case 13: 
            case 14: {
                return "0";
            }
            case 0: 
            case 1: {
                return "0";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "false";
            }
            case 4: {
                return "true";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return super.getDefaultValueString(0);
            }
            case 7: {
                return super.getDefaultValueString(1);
            }
            case 8: {
                return super.getDefaultValueString(2);
            }
            case 9: {
                return "1";
            }
            case 10: {
                return "SHOW_ALL";
            }
            case 11: {
                return "BLACK";
            }
            case 26: {
                return "NONE";
            }
        }
        return super.getDefaultValueString(n - 12);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: {
                return null;
            }
            case 6: {
                return super.getValue(0);
            }
            case 7: {
                return super.getValue(1);
            }
            case 8: {
                return super.getValue(2);
            }
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(n - 12);
    }
}

